/*:
* @target MZ
* @plugindesc RSTH_IH: サバイバルゲームシステムプラグイン
 * @author © 2025 ReSera_りせら（@MOBIUS1001）
 *
 * このソースコードは無断での転載、複製、改変、再配布、商用利用を固く禁じます。
 * 禁止事項の例：
 * - 本ファイルの全部または一部を許可なくコピー、再配布すること
 * - 本ファイルを改変して配布すること
 * - 商用目的での利用
*/


(() => {
    "use strict";

    // ログ出力制御フラグ（trueでログ出力、falseで抑制）
    //const RSTH_DEBUG_LOG = true;
    const RSTH_DEBUG_LOG = false;



    // 装備スロットを明示的に定義（装飾品を2つ持たせる）
    Game_Actor.prototype.equipSlots = function () {
        return [1, 2, 3, 4, 5, 5]; // 武器、盾、頭、身体、装飾品、装飾品
    };

    // スロットごとの装備品取得（装備可能チェック含む）
    Game_Actor.prototype.isEquipChangeOk = function (slotId) {
        return this.equipSlots()[slotId] !== 0;
    };

    Game_Actor.prototype.changeEquip = function (slotId, item) {
        if (!this.isEquipChangeOk(slotId)) return;
        //console.log("this.equips()[slotId]", this.equips()[slotId]);
        const oldItem = this.equips()[slotId];
        const sameSlotItem = this.equips().find((equip, index) =>
            index !== slotId &&
            equip &&
            item &&
            equip === item
        );

        // 同じアイテムがすでに別のスロットに装備されていた場合、交換せずそのまま新しいスロットにも装備
        if (item && sameSlotItem) {
            // 何もしない（同じ装備が既に別スロットにある場合でも、重複装備を許可）
        }

        if (this.tradeItemWithParty(item, oldItem)) {
            this._equips[slotId].setObject(item);
        }
    };

    // 背景定義
    window.RSTH_IH.Sprite_CharacterSelectBackground = class extends Sprite {
        constructor() {
            const w = Graphics.boxWidth;
            const h = Graphics.boxHeight;
            const bitmap = new Bitmap(w, h);
            super(bitmap);

            this._width = w;
            this._height = h;
            this._scrollX = 0;
            this._rotationAngle = 0;
            this._rotationAngle2 = 0;

            this._baseBitmap = new Bitmap(w, h);
            this._overlayBitmap = new Bitmap(w, h);
            this._noiseBitmap = new Bitmap(w, h);

            this._ripples = [];
            this._rippleSpawnInterval = 60;
            this._rippleTimer = 0;

            this._particles = [];
            this._geoShapes = [];

            this._scrollY = 0; // 4
            this._hueShift = 0; // 5
            this._auroraBands = []; // 7
            this._holoLines = []; //10
            this._colorSchemeIndex = 0; //16
            this._bubbles = []; //19

            this._colorSchemes = [ //16
                ["#1a0e0e", "#2f343eff"],
                ["#0e1a1a", "#2f3a3e"],
                ["#1a1a0e", "#3e2f3bff"]
            ];


            this._renderBase();
            this._renderOverlay();
            this._renderNoise();
            this.bitmap.blt(this._baseBitmap, 0, 0, w, h, 0, 0);
        }

        _renderBase() {
            const ctx = this._baseBitmap.context;
            const w = this._width;
            const h = this._height;

            ctx.clearRect(0, 0, w, h);

            const grad = ctx.createLinearGradient(0, 0, 0, h);
            grad.addColorStop(0, "#000033"); // 濃い紺色（上）
            grad.addColorStop(1, "#006e6eff"); // 薄い水色（下）

            ctx.fillStyle = grad;
            ctx.fillRect(0, 0, w, h);
        }


        _renderOverlay() {
            const ctx = this._overlayBitmap.context;
            const w = this._width;
            const h = this._height;

            ctx.clearRect(0, 0, w, h);
            ctx.strokeStyle = "rgba(255, 255, 255, 0.03)";
            ctx.lineWidth = 2;


            for (let i = -w; i < w * 2; i += 40) {
                ctx.beginPath();
                ctx.moveTo(i, this._scrollY);
                ctx.lineTo(i - h, h + this._scrollY);
                ctx.stroke();
            }
        }

        _renderNoise() {
            const ctx = this._noiseBitmap.context;
            const w = this._width;
            const h = this._height;

            for (let i = 0; i < 1500; i++) {
                const x = Math.random() * w;
                const y = Math.random() * h;
                const alpha = Math.random() * 0.1;
                ctx.fillStyle = `rgba(255,255,255,${alpha})`;
                ctx.fillRect(x, y, 1, 1);
            }
        }

        update() {
            super.update();

            this._scrollX = (this._scrollX + 0.5) % this._width;
            this._rotationAngle += 0.002;
            this._rotationAngle2 += 0.003;
            this._scrollY = (this._scrollY + 0.2) % this._height; //4
            this._hueShift = (this._hueShift + 0.2) % 360; //5

            this._updateRipples();
            this._updateParticles();
            //this._updateGeoShapes();
            this._updateAuroraBands(); //7
            this._updateHoloLines();   //10
            this._updateBubbles();     //19

            // カラースキーム切り替え
            if (Graphics.frameCount % 600 === 0) {
                this._colorSchemeIndex = (this._colorSchemeIndex + 1) % this._colorSchemes.length;
            }

            const b = this.bitmap;
            b.clear();
            b.blt(this._baseBitmap, 0, 0, this._width, this._height, 0, 0);
            b.blt(this._overlayBitmap, 0, 0, this._width, this._height, 0, 0);
            b.blt(this._noiseBitmap, 0, 0, this._width, this._height, 0, 0);

            this._renderDynamic(b);
        }

        _updateRipples() {
            this._rippleTimer++;
            if (this._rippleTimer >= this._rippleSpawnInterval) {
                this._rippleTimer = 0;
                const count = 3 + Math.floor(Math.random() * 2);
                for (let i = 0; i < count; i++) {
                    const x = Math.random() * this._width;
                    const y = Math.random() * this._height;
                    this._ripples.push({ x, y, frame: 0, life: 120 });
                }
            }
            for (const ripple of this._ripples) ripple.frame++;
            this._ripples = this._ripples.filter(r => r.frame < r.life);
        }

        _updateParticles() {
            if (Math.random() < 0.5) {
                this._particles.push({
                    x: this._width,
                    y: Math.random() * this._height,
                    alpha: 0.06 + Math.random() * 0.04
                });
            }
            for (const p of this._particles) {
                p.x -= 2;
                p.y += 1;
            }
            this._particles = this._particles.filter(p => p.x > -100);
        }

        _updateGeoShapes() {
            if (Math.random() < 0.02) {
                this._geoShapes.push({
                    x: Math.random() * this._width,
                    y: Math.random() * this._height,
                    scale: 0.5,
                    alpha: 0.08,
                    frame: 0,
                });
            }
            for (const g of this._geoShapes) {
                g.frame++;
                g.scale += 0.002;
                g.alpha -= 0.001;
            }

        }

        _updateAuroraBands() {
            if (Math.random() < 0.01) {
                this._auroraBands.push({
                    y: Math.random() * this._height,
                    alpha: 0.1 + Math.random() * 0.05,
                    speed: 0.2 + Math.random() * 0.2
                });
            }
            for (const band of this._auroraBands) {
                band.y += band.speed;
            }
            this._auroraBands = this._auroraBands.filter(b => b.y < this._height);
        }

        _updateHoloLines() {
            if (Math.random() < 0.02) {
                this._holoLines.push({
                    y: 0,
                    speed: 2 + Math.random() * 2,
                    alpha: 0.05 + Math.random() * 0.05
                });
            }
            for (const line of this._holoLines) {
                line.y += line.speed;
            }
            this._holoLines = this._holoLines.filter(l => l.y < this._height);
        }

        _updateBubbles() {
            if (Math.random() < 0.1) {
                this._bubbles.push({
                    x: Math.random() * this._width,
                    y: this._height + 10,
                    radius: 5 + Math.random() * 20,
                    speed: 0.5 + Math.random(),
                    alpha: 0.05 + Math.random() * 0.05
                });
            }
            for (const b of this._bubbles) {
                b.y -= b.speed;
            }
            this._bubbles = this._bubbles.filter(b => b.y + b.radius > 0);
        }

        _renderDynamic(bmp) {
            const ctx = bmp.context;
            // 20: Dot Grid
            this._renderDotGrid(ctx);
            // 幾何模様
            for (const g of this._geoShapes) {
                ctx.save();
                ctx.translate(g.x, g.y);
                ctx.scale(g.scale, g.scale);
                ctx.globalAlpha = g.alpha;
                ctx.strokeStyle = "rgba(255,255,255,0.5";
                ctx.lineWidth = 2;

                if (g.type === "hex") {
                    ctx.beginPath();
                    for (let i = 0; i < 6; i++) {
                        const angle = Math.PI / 3 * i;
                        const px = Math.cos(angle) * 30;
                        const py = Math.sin(angle) * 30;
                        if (i === 0) ctx.moveTo(px, py);
                        else ctx.lineTo(px, py);
                    }
                    ctx.closePath();
                    ctx.stroke();
                } else {
                    ctx.strokeRect(-20, -20, 40, 40);
                }

                ctx.restore();
                ctx.globalAlpha = 1.0;
            }

            // 波紋
            for (const ripple of this._ripples) {
                const progress = ripple.frame / ripple.life;
                const radius = 20 + progress * 100;
                const alpha = (1 - progress) * 0.08;

                ctx.beginPath();
                ctx.arc(ripple.x, ripple.y, radius, 0, Math.PI * 2);
                ctx.strokeStyle = `rgba(255, 255, 255, ${alpha})`;
                ctx.lineWidth = 2;
                ctx.stroke();
            }

            // 7: Aurora Bands
            for (const band of this._auroraBands) {
                ctx.fillStyle = `rgba(100, 200, 255, ${band.alpha})`;
                ctx.fillRect(0, band.y, this._width, 20);
            }

            // 10: Holo Lines
            for (const line of this._holoLines) {
                ctx.fillStyle = `rgba(255, 255, 255, ${line.alpha})`;
                ctx.fillRect(0, line.y, this._width, 2);
            }

            // 19: Bubbles
            for (const b of this._bubbles) {
                ctx.beginPath();
                ctx.arc(b.x, b.y, b.radius, 0, Math.PI * 2);
                ctx.fillStyle = `rgba(255, 255, 255, ${b.alpha})`;
                ctx.fill();
            }

            // 18: Vignette
            this._renderVignette(ctx);
        }

        _renderDotGrid(ctx) {
            ctx.fillStyle = "rgba(255,255,255,0.02)";
            const spacing = 50;
            for (let x = 0; x < this._width; x += spacing) {
                for (let y = 0; y < this._height; y += spacing) {
                    ctx.beginPath();
                    ctx.arc(x, y, 2, 0, Math.PI * 4);
                    ctx.fill();
                }
            }
        }

        _renderVignette(ctx) {
            const grad = ctx.createRadialGradient(
                this._width / 2, this._height / 2, this._width / 4,
                this._width / 2, this._height / 2, this._width / 2
            );
            grad.addColorStop(0, "rgba(0,0,0,0)");
            grad.addColorStop(1, "rgba(0,0,0,0.5)");

            ctx.fillStyle = grad;
            ctx.fillRect(0, 0, this._width, this._height);
        }

    };







})();