/*:
 * @target MZ
 * @plugindesc RSTH_IH: サバイバルゲームシステムプラグイン
 * @author © 2025 ReSera_りせら（@MOBIUS1001）
 *
 * このソースコードは無断での転載、複製、改変、再配布、商用利用を固く禁じます。
 * 禁止事項の例：
 * - 本ファイルの全部または一部を許可なくコピー、再配布すること
 * - 本ファイルを改変して配布すること
 * - 商用目的での利用
 */

(() => {

    "use strict";

    // ログ出力制御フラグ（trueでログ出力、falseで抑制）
    //const RSTH_DEBUG_LOG = true;
    const RSTH_DEBUG_LOG = false;

    //const SHOW_FPS = true;
    const SHOW_FPS = false;

    // 現在マップ上に配置されているブロックとブロックスプライトの一覧をコンソール表示
    window.RSTH_IH.getBlocks_and_Spriteslist = function (call) {
        if (!RSTH_DEBUG_LOG) return;
        console.log("[window.RSTH_IH.getBlocks_and_Spriteslist]現在マップ上に配置されているブロック一覧:", call);
        console.table(window.RSTH_IH.SurvivalBlockManager._blocks);

        console.log("[window.RSTH_IH.getBlocks_and_Spriteslist]現在マップ上に表示されているブロックスプライト一覧:", call);
        console.table(window.RSTH_IH.SurvivalBlockManager._sprites.map(sprite => ({
            x: sprite.block?.x,
            y: sprite.block?.y,
            tileId: sprite.block?.tileId,
            itemId: sprite.block?.itemId,
            growthStage: sprite.block?.growthStage,
            passable: sprite.block?.passable,
            _growthApplied: sprite.block?._growthApplied
        })));

        //console.log("[window.RSTH_IH.getBlocks_and_Spriteslist]現在マップ上に配置されているドロップアイテム一覧:", call);
        console.table(window.RSTH_IH.DropManager._drops);
    }

    // FPS表示
    if (SHOW_FPS) {
        (function () {
            const _Scene_Map_createAllWindows = Scene_Map.prototype.createAllWindows;
            Scene_Map.prototype.createAllWindows = function () {
                _Scene_Map_createAllWindows.call(this);
                this.createFpsDisplay();
            };

            Scene_Map.prototype.createFpsDisplay = function () {
                const sprite = new Sprite(new Bitmap(120, 24));
                sprite.x = Graphics.width - 130;
                sprite.y = 10;
                sprite.z = 9999;
                this._fpsDisplaySprite = sprite;
                this.addChild(sprite);

                this._fpsLastTime = performance.now();
                this._fpsFrameCount = 0;
                this._fpsCurrent = 0;
            };

            const _Scene_Map_update = Scene_Map.prototype.update;
            Scene_Map.prototype.update = function () {
                _Scene_Map_update.call(this);
                this.updateFpsDisplay();
            };

            Scene_Map.prototype.updateFpsDisplay = function () {
                this._fpsFrameCount++;
                const now = performance.now();
                if (now - this._fpsLastTime >= 200) {
                    const elapsed = now - this._fpsLastTime;
                    this._fpsCurrent = Math.round(this._fpsFrameCount * 1000 / elapsed);
                    this._fpsFrameCount = 0;
                    this._fpsLastTime = now;

                    const bmp = this._fpsDisplaySprite.bitmap;
                    bmp.clear();
                    bmp.fontSize = 20;
                    bmp.textColor = "#00ff00";
                    bmp.outlineColor = "#000000";
                    bmp.outlineWidth = 3;
                    bmp.drawText(`FPS: ${this._fpsCurrent}`, 0, 0, bmp.width, bmp.height, "right");
                }
            };
        })();
    }

    window.RSTH_IH.getAllSpritesInSceneDetailedLog = function () {
        const scene = SceneManager._scene;
        if (!scene) return [];

        const allSprites = [];

        function traverse(container, depth = 0, parentId = null) {
            if (!container) return;

            if (container instanceof Sprite) {
                allSprites.push({
                    sprite: container,
                    depth: depth,
                    parentSpriteId: parentId
                });
            }

            if (container.children && container.children.length > 0) {
                for (const child of container.children) {
                    traverse(child, depth + 1, container.spriteId ?? null);
                }
            }
        }

        traverse(scene);

        // ログ生成
        const logLines = [];
        logLines.push(`=== [スプライトツリーログファイル : ${new Date().toLocaleString()}] ===`);
        logLines.push(`総スプライト数: ${allSprites.length}`);
        logLines.push(``);

        allSprites.forEach((entry, i) => {
            const s = entry.sprite;
            const indent = "  ".repeat(entry.depth);
            const className = s.constructor?.name ?? "Unknown";
            const parentName = s.parent?.constructor?.name ?? "None";
            const bitmapUrl = s._bitmap?._url ?? (s.bitmap?._url ?? "N/A");
            const w = s.width ?? 0;
            const h = s.height ?? 0;
            const childCount = s.children?.length ?? 0;
            const destroyed = s.destroyed ?? s._destroyed ?? false;
            const visible = s.visible ?? true;
            const opacity = s.opacity ?? 255;
            const zIndex = s.z ?? s.zIndex ?? "N/A";
            const spriteId = s.spriteId ?? "N/A";

            const isDying = s._isDying ?? "N/A";
            const isDead = s._isDead ?? "N/A";

            logLines.push(`${indent}No.${i}`);
            logLines.push(`${indent}spriteId: ${spriteId}`);
            logLines.push(`${indent}Class: ${className}`);
            logLines.push(`${indent}Parent: ${parentName} (spriteId: ${entry.parentSpriteId ?? "N/A"})`);
            logLines.push(`${indent}Depth: ${entry.depth}`);
            logLines.push(`${indent}Position: (x: ${Math.round(s.x)}, y: ${Math.round(s.y)})`);
            logLines.push(`${indent}Size: (w: ${Math.round(w)}, h: ${Math.round(h)})`);
            logLines.push(`${indent}Bitmap: ${bitmapUrl}`);
            logLines.push(`${indent}Children: ${childCount}`);
            logLines.push(`${indent}Visible: ${visible}`);
            logLines.push(`${indent}Opacity: ${opacity}`);
            logLines.push(`${indent}Z: ${zIndex}`);
            logLines.push(`${indent}Destroyed: ${destroyed}`);
            logLines.push(`${indent}_isDying: ${isDying}`);
            logLines.push(`${indent}_isDead: ${isDead}`);
            logLines.push(`${indent}----------------------------------------`);
        });

        // ファイル保存
        const blob = new Blob([logLines.join('\n')], { type: "text/plain" });
        const url = URL.createObjectURL(blob);

        const a = document.createElement("a");
        a.href = url;
        a.download = "sprite_tree_log.txt";
        a.click();

        console.trace("スプライト取得元トレース");

        return allSprites;
    };











})();
