/*:
 * @target MZ
 * @plugindesc RSTH_IH: サバイバルゲームシステムプラグイン
 * @author © 2025 ReSera_りせら（@MOBIUS1001）
 *
 * このソースコードは無断での転載、複製、改変、再配布、商用利用を固く禁じます。
 * 禁止事項の例：
 * - 本ファイルの全部または一部を許可なくコピー、再配布すること
 * - 本ファイルを改変して配布すること
 * - 商用目的での利用
 */

(() => {

    "use strict";

    // ログ出力制御フラグ（trueでログ出力、falseで抑制）
    //const RSTH_DEBUG_LOG = true;
    const RSTH_DEBUG_LOG = false;

    // init処理
    const _RSTH_GameSystem_initialize = Game_System.prototype.initialize;
    Game_System.prototype.initialize = function () {
        _RSTH_GameSystem_initialize.call(this);
        this._shopStocks = {}; // 各商品IDをキーにした在庫管理


        window.RSTH_IH._mobManager = new window.RSTH_IH.MobManager();
        window.RSTH_IH._npcManager = new window.RSTH_IH.NpcManager();

        const maxInv = window.RSTH_IH.InventoryCols * window.RSTH_IH.InventoryRows;
        const maxHot = window.RSTH_IH.HotbarSlotCount;
        this._customInventoryItems = Array(maxInv).fill(null);
        this._customHotbarItems = Array(maxHot).fill(null);

        //block関連
        //this._growingTimers = [];
        //this.rsthLoadBlockDataFromDatabase();
    };

    Scene_Map.prototype._hitStopCount = 0;

    Scene_Map.prototype._rsth_regenCounter ||= 0;

    // 状態異常の処理テーブル（順番厳守）
    window.RSTH_IH.hpTickTable = [
        // 毒
        { id: 4, key: "_rsthState4FrameCounter", intv: 60, val: 5, heal: false, cfg: "gauge_ST1" },
        // 猛毒
        { id: 7, key: "_rsthState7FrameCounter", intv: 60, val: 50, heal: false, cfg: "gauge_ST1" },
        // 熱い！！
        { id: 5, key: "_rsthState5FrameCounter", intv: 20, val: 20, heal: false, cfg: "gauge_IG" },
        // state22の回復
        { id: 22, key: "_rsthState22FrameCounter", intv: 20, val: 10, heal: true },
        // state30の回復
        { id: 30, key: "_rsthState30FrameCounter", intv: 20, val: 10, heal: true },
        // state26の回復
        { id: 26, key: "_rsthState26FrameCounter", intv: 60, val: 50, heal: true },
    ];

    // blendColor定義
    window.RSTH_IH.blendTable = [
        // 麻痺
        { id: 11, cfg: "gauge_ST2", color: [64, 64, 255, 160] },
        // 猛毒
        { id: 7, cfg: "gauge_ST1", color: [64, 127, 32, 160] },
        // 毒
        { id: 4, cfg: "gauge_ST1", color: [128, 255, 64, 160] },
        // 混乱
        { id: 8, cfg: "gauge_ST1", color: [255, 255, 64, 160] },
        // 熱い！！
        { id: 5, cfg: "gauge_IG", color: [255, 64, 64, 160] },
    ];

    // start前演出
    Scene_Map.prototype.startBattleIntro = function () {
        const duration = 120;
        const sprite = new Sprite(new Bitmap(Graphics.width, Graphics.height));
        const bitmap = sprite.bitmap;

        const gw = Graphics.width;
        const gh = Graphics.height;
        const dy = gh / 2 - 96;

        // テキストスタイル
        bitmap.fontFace = "GameFont";
        bitmap.fontSize = 96;
        bitmap.outlineWidth = 8;
        bitmap.outlineColor = "black";
        bitmap.textColor = "red";

        const mapId = window.RSTH_IH._selectedMapId;

        let text1 = "";
        let text2 = "";
        if ([1, 2, 3, 5].includes(mapId)) text1 = "DEAD OR ALIVE";
        else text1 = "DEAD OR DESTROY";

        if (mapId === 1) text2 = "<< 5分間生き残れ >>";
        else if (mapId === 2) text2 = "<< 10分間生き残れ >>";
        else if ([3, 5].includes(mapId)) text2 = "<< 15分間生き残れ >>";
        else text2 = "<< 10分以内に魔王の影を討伐せよ >>";

        bitmap.drawText(text1, 0, dy, gw, 96, "center");
        bitmap.fontSize = 48;
        bitmap.drawText(text2, 0, dy + 128, gw, 48, "center");

        sprite.anchor.set(0.5, 0.5);
        sprite.x = gw / 2;
        sprite.y = gh / 2;
        sprite.scale.set(3.0, 3.0);
        sprite.opacity = 0;

        // 暗転用黒背景
        const blackBg = new ScreenSprite();
        blackBg.setBlack();
        blackBg.opacity = 0;
        this.addChild(blackBg);

        // 白いフラッシュ
        const whiteFlash = new ScreenSprite();
        whiteFlash.setWhite();
        whiteFlash.opacity = 0;
        this.addChild(whiteFlash);

        this._battleIntroSprite = sprite;
        this._battleIntroBlack = blackBg;
        this._battleIntroFlash = whiteFlash;
        this._battleIntroFrame = 0;

        this.addChild(sprite);

        // SE再生
        AudioManager.playSe({ name: "Attack3", volume: 20, pitch: 100, pan: 0 });

        this._updateBattleIntro = function () {
            const f = this._battleIntroFrame;

            // 黒背景フェードイン
            if (f < 20) {
                blackBg.opacity = f * 6;
            }

            // 白フラッシュ（1回）
            if (f === 5) whiteFlash.opacity = 255;
            if (f > 5 && f <= 15) whiteFlash.opacity -= 25;

            // テキスト表示と揺れ・拡大縮小
            if (f < duration) {
                sprite.opacity = Math.min(255, f * 8);
                const scale = 3.0 - f * 0.015;
                sprite.scale.set(scale + Math.random() * 0.02, scale + Math.random() * 0.02);
                sprite.x = gw / 2 + Math.random() * 6 - 3;
                sprite.y = gh / 2 + Math.random() * 6 - 3;

                // 色変化（段階的に赤→黄へ）
                if (f < 40) bitmap.textColor = "red";
                else if (f < 80) bitmap.textColor = "orange";
                else bitmap.textColor = "yellow";
            }
            else if (f < duration + 30) {
                sprite.opacity -= 10;
                blackBg.opacity -= 8;
            }
            else {
                this.removeChild(sprite);
                this.removeChild(blackBg);
                this.removeChild(whiteFlash);
                this._battleIntroSprite = null;
                this._battleIntroBlack = null;
                this._battleIntroFlash = null;
                this._updateBattleIntro = null;
                this._battleIntroPlaying = false;
            }

            this._battleIntroFrame++;
        };
    };



    // クエストのテキスト表示
    window.RSTH_IH.createQuestTextSprite = function (text, text2, line = 0) {
        // 表示用データだけ保存しておく
        window.RSTH_IH._questTextData = { text, text2, line, time: 10 * 60 }; // 10秒 (60fps換算)

        // すでにシーンマップ中なら表示する
        if (SceneManager._scene instanceof Scene_Map) {
            SceneManager._scene.createQuestTextSprites();
        }
    };

    Scene_Map.prototype.createQuestTextSprites = function () {
        const data = window.RSTH_IH._questTextData;
        if (!data) return;

        const { text, text2, line } = data;
        const w = 330, h = 32, margin = 6, fs = 20, x = 340;
        let y = (line === 1) ? 250 : 180;

        // 背景
        const bgSprite = new Sprite(new Bitmap(w, h * 2));
        bgSprite.bitmap.fillAll(line === 1 ? "#770032ff" : "#1f003bff");
        bgSprite.alpha = (line === 1) ? 0.6 : 0.3;
        bgSprite.x = Graphics.width - x;
        bgSprite.y = y;
        bgSprite.z = 100;

        this.addChild(bgSprite);

        // テキスト
        const sprite = new Sprite(new Bitmap(w - margin, h * 2));
        const bitmap = sprite.bitmap;
        bitmap.fontSize = fs;
        bitmap.textColor = "#ffffff";
        bitmap.outlineColor = "#000000";
        bitmap.outlineWidth = 4;
        bitmap.drawText(text, margin, 0, w - margin, h, "left");
        bitmap.drawText(text2, margin, h, w - margin, h, "left");
        sprite.x = Graphics.width - x;
        sprite.y = y;
        sprite.z = 101;

        this.addChild(sprite);

        // 保持
        this._questTextSprite = sprite;
        this._questTextBgSprite = bgSprite;
    };



    // クエスト発生処理
    window.RSTH_IH.spawnRandomQuest = function () {
        if (window.RSTH_IH.questSpawned) return;
        window.RSTH_IH.questSpawned = true;

        const quests = {
            lank1: [
                { id: 1, name: "Bigうんしょ出現！", lank: 1 },
                { id: 2, name: "強敵出現！", lank: 1 },
                { id: 3, name: "強敵出現！", lank: 1 },
                { id: 4, name: "傭兵が仲間になった！", lank: 1 },
                { id: 5, name: "商人とカートを護衛せよ！", lank: 1 },
                { id: 6, name: "限定Shopに遭遇！", lank: 1 },
                { id: 7, name: "レアトレジャー獲得！", lank: 1 },
            ],
            lank2: [
                { id: 1, name: "Bigうんしょ出現！", lank: 2 },
                { id: 2, name: "強敵出現！", lank: 2 },
                { id: 3, name: "強敵出現！", lank: 2 },
                { id: 4, name: "傭兵が仲間になった！", lank: 2 },
                { id: 5, name: "商人とカートを護衛せよ！", lank: 2 },
                { id: 6, name: "限定Shopに遭遇！", lank: 2 },
                { id: 7, name: "レアトレジャー獲得！", lank: 2 },
            ],
            lank3: [
                { id: 1, name: "強敵出現！", lank: 3 },
                { id: 2, name: "強敵出現！", lank: 3 },
                { id: 3, name: "強敵出現！", lank: 3 },
                { id: 4, name: "傭兵が仲間になった！", lank: 3 },
                { id: 5, name: "商人とカートを護衛せよ！", lank: 3 },
                { id: 6, name: "限定Shopに遭遇！", lank: 3 },
                { id: 7, name: "レアトレジャー獲得！", lank: 3 },
            ],
            lank4: [
                { id: 1, name: "強敵出現！", lank: 4 },
                { id: 2, name: "強敵出現！", lank: 4 },
                { id: 3, name: "傭兵が仲間になった！", lank: 4 },
                { id: 4, name: "限定Shopに遭遇！", lank: 4 },
                { id: 5, name: "レアトレジャー獲得！", lank: 4 },
            ],
            // レイド戦専用
            lankEX: [
                { id: 1, name: "強敵出現！", lank: "EX" },
                { id: 2, name: "強敵出現！", lank: "EX" },
                { id: 3, name: "強敵出現！", lank: "EX" },
                { id: 4, name: "強敵出現！", lank: "EX" },
                { id: 5, name: "強敵出現！", lank: "EX" },
                { id: 6, name: "傭兵が仲間になった！", lank: "EX" },
                { id: 7, name: "限定Shopに遭遇！", lank: "EX" },
                { id: 8, name: "レアトレジャー獲得！", lank: "EX" },
            ]
        };
        let quest = null;

        //console.log("window.RSTH_IH.AutoMobSpawnSet", window.RSTH_IH.AutoMobSpawnSet);

        if (window.RSTH_IH.AutoMobSpawnSet === 1) {
            //quest = quests.lank1[Math.floor(Math.random() * quests.lank1.length)];
            quest = quests.lank1[Math.floor(Math.random() * quests.lank1.length)];
            //console.log("quest", quest);
        }
        else if (window.RSTH_IH.AutoMobSpawnSet === 2) {
            if (window.RSTH_IH.TimeCount >= 240) {
                quest = quests.lank2[Math.floor(Math.random() * quests.lank2.length)];
            }
            else {
                quest = quests.lank1[Math.floor(Math.random() * quests.lank1.length)];
            }
        }
        else if (window.RSTH_IH.AutoMobSpawnSet === 3) {
            if (window.RSTH_IH.TimeCount >= 480) {
                quest = quests.lank3[Math.floor(Math.random() * quests.lank3.length)];
            }
            else if (window.RSTH_IH.TimeCount >= 240) {
                quest = quests.lank2[Math.floor(Math.random() * quests.lank2.length)];
            }
            else {
                quest = quests.lank1[Math.floor(Math.random() * quests.lank1.length)];
            }
        }
        else if (window.RSTH_IH.AutoMobSpawnSet === 4) {
            if (window.RSTH_IH.TimeCount >= 720) {
                quest = quests.lank4[Math.floor(Math.random() * quests.lank4.length)];
            }
            else if (window.RSTH_IH.TimeCount >= 480) {
                quest = quests.lank3[Math.floor(Math.random() * quests.lank3.length)];
            }
            else if (window.RSTH_IH.TimeCount >= 240) {
                quest = quests.lank2[Math.floor(Math.random() * quests.lank2.length)];
            }
            else {
                quest = quests.lank1[Math.floor(Math.random() * quests.lank1.length)];
            }
        }

        else if (window.RSTH_IH.AutoMobSpawnSet === 5) {
            if (window.RSTH_IH.TimeCount >= 540) {
                quest = quests.lank4[Math.floor(Math.random() * quests.lank4.length)];
            } else {
                quest = quests.lankEX[Math.floor(Math.random() * quests.lankEX.length)];
            }
        }
        //console.log("quest", quest);
        $gameSystem._currentQuest = quest;

        window.RSTH_IH.startQuest(quest?.id, quest?.lank);

        window.RSTH_IH.createQuestTextSprite("◇イベント:", `　${quest?.name}`);
    };

    // クエスト開始処理
    window.RSTH_IH.startQuest = function (id, lank) {
        if (!id || !lank) return;

        if (lank === 1) {
            // mob討伐
            if (id === 1) {
                window.RSTH_IH.spawnMobEvent(8);
                window.RSTH_IH.spawnMobEvent(8);
                window.RSTH_IH.spawnMobEvent(8);
                window.RSTH_IH.spawnMobEvent(8);
            }
            else if (id === 2) {
                window.RSTH_IH.spawnMobEvent(72);
            }
            else if (id === 3) {
                window.RSTH_IH.spawnMobEvent(76);
            }
            else if (id === 4) {
                window.RSTH_IH.spawnNpcEvent(2);
            }
            else if (id === 5) {
                if (window.RSTH_IH.AutoMobSpawnSet === 1) {
                    //function (startX, startY, goalX, goalY, marchantId, cartId, guardsId, guardsAmount = 1)
                    window.RSTH_IH.spawnNpcPassEvent(63, 38, 0, 27, 0, 5, 2, 2);
                }
                else if (window.RSTH_IH.AutoMobSpawnSet === 2) {
                    //function (startX, startY, goalX, goalY, marchantId, cartId, guardsId, guardsAmount = 1)
                    window.RSTH_IH.spawnNpcPassEvent(95, 44, 0, 41, 0, 5, 2, 3);
                }
                else if (window.RSTH_IH.AutoMobSpawnSet === 3) {
                    //function (startX, startY, goalX, goalY, marchantId, cartId, guardsId, guardsAmount = 1)
                    window.RSTH_IH.spawnNpcPassEvent(44, 94, 44, 0, 0, 5, 2, 3);
                }
                else if (window.RSTH_IH.AutoMobSpawnSet === 4) {
                    //function (startX, startY, goalX, goalY, marchantId, cartId, guardsId, guardsAmount = 1)
                    window.RSTH_IH.spawnNpcPassEvent(87, 95, 0, 0, 0, 5, 2, 3);
                }
            }
            else if (id === 6) {
                AudioManager.playSe({ name: "Saint2", pan: 0, pitch: 100, volume: 20 });

                if (window.RSTH_IH._selectedActorId === 1) {
                    window.RSTH_IH.BuyShop = window.RSTH_IH.ShopGoodsData.specialShop1;
                }
                else if (window.RSTH_IH._selectedActorId === 2) {
                    window.RSTH_IH.BuyShop = window.RSTH_IH.ShopGoodsData.specialShop2;
                }
                else if (window.RSTH_IH._selectedActorId === 3) {
                    window.RSTH_IH.BuyShop = window.RSTH_IH.ShopGoodsData.specialShop3;
                }
                window.RSTH_IH.shopCallFlag = 1;
                SceneManager.push(window.RSTH_IH.Scene_Shop);
            }
            else if (id === 7) {
                AudioManager.playSe({ name: "Open5", pan: 0, pitch: 100, volume: 20 });

                window.RSTH_IH.treasureCallFlag = 1;
                SceneManager.push(window.RSTH_IH.Scene_Treasure);
            }
        }
        else if (lank === 2) {
            // mob討伐
            if (id === 1) {
                window.RSTH_IH.spawnMobEvent(8);
                window.RSTH_IH.spawnMobEvent(8);
                window.RSTH_IH.spawnMobEvent(8);
                window.RSTH_IH.spawnMobEvent(8);
                window.RSTH_IH.spawnMobEvent(8);
                window.RSTH_IH.spawnMobEvent(8);
            }
            else if (id === 2) {
                window.RSTH_IH.spawnMobEvent(73);
            }
            else if (id === 3) {
                window.RSTH_IH.spawnMobEvent(74);
            }
            else if (id === 4) {
                window.RSTH_IH.spawnNpcEvent(3);
            }
            else if (id === 5) {
                if (window.RSTH_IH.AutoMobSpawnSet === 1) {
                    //function (startX, startY, goalX, goalY, marchantId, cartId, guardsId, guardsAmount = 1)
                    window.RSTH_IH.spawnNpcPassEvent(63, 38, 0, 27, 0, 5, 3, 2);
                }
                else if (window.RSTH_IH.AutoMobSpawnSet === 2) {
                    //function (startX, startY, goalX, goalY, marchantId, cartId, guardsId, guardsAmount = 1)
                    window.RSTH_IH.spawnNpcPassEvent(95, 44, 0, 41, 0, 5, 3, 2);
                }
                else if (window.RSTH_IH.AutoMobSpawnSet === 3) {
                    //function (startX, startY, goalX, goalY, marchantId, cartId, guardsId, guardsAmount = 1)
                    window.RSTH_IH.spawnNpcPassEvent(44, 94, 44, 0, 0, 5, 3, 2);
                }
                else if (window.RSTH_IH.AutoMobSpawnSet === 4) {
                    //function (startX, startY, goalX, goalY, marchantId, cartId, guardsId, guardsAmount = 1)
                    window.RSTH_IH.spawnNpcPassEvent(87, 95, 0, 0, 0, 5, 3, 3);
                }
            }
            else if (id === 6) {
                AudioManager.playSe({ name: "Saint2", pan: 0, pitch: 100, volume: 20 });

                if (window.RSTH_IH._selectedActorId === 1) {
                    window.RSTH_IH.BuyShop = window.RSTH_IH.ShopGoodsData.specialShop1;
                }
                else if (window.RSTH_IH._selectedActorId === 2) {
                    window.RSTH_IH.BuyShop = window.RSTH_IH.ShopGoodsData.specialShop2;
                }
                else if (window.RSTH_IH._selectedActorId === 3) {
                    window.RSTH_IH.BuyShop = window.RSTH_IH.ShopGoodsData.specialShop3;
                }
                window.RSTH_IH.shopCallFlag = 1;
                SceneManager.push(window.RSTH_IH.Scene_Shop);
            }
            else if (id === 7) {
                AudioManager.playSe({ name: "Open5", pan: 0, pitch: 100, volume: 20 });

                window.RSTH_IH.treasureCallFlag = 1;
                SceneManager.push(window.RSTH_IH.Scene_Treasure);
            }
        }
        else if (lank === 3) {
            // mob討伐
            if (id === 1) {
                window.RSTH_IH.spawnMobEvent(68);
            }
            else if (id === 2) {
                window.RSTH_IH.spawnMobEvent(69);
            }
            else if (id === 3) {
                window.RSTH_IH.spawnMobEvent(75);
            }
            else if (id === 4) {
                window.RSTH_IH.spawnNpcEvent(1);
            }
            else if (id === 5) {
                if (window.RSTH_IH.AutoMobSpawnSet === 1) {
                    //function (startX, startY, goalX, goalY, marchantId, cartId, guardsId, guardsAmount = 1)
                    window.RSTH_IH.spawnNpcPassEvent(63, 38, 0, 27, 0, 6, 1, 2);
                }
                else if (window.RSTH_IH.AutoMobSpawnSet === 2) {
                    //function (startX, startY, goalX, goalY, marchantId, cartId, guardsId, guardsAmount = 1)
                    window.RSTH_IH.spawnNpcPassEvent(95, 44, 0, 41, 0, 6, 1, 2);
                }
                else if (window.RSTH_IH.AutoMobSpawnSet === 3) {
                    //function (startX, startY, goalX, goalY, marchantId, cartId, guardsId, guardsAmount = 1)
                    window.RSTH_IH.spawnNpcPassEvent(44, 94, 44, 0, 0, 6, 1, 3);
                }
                else if (window.RSTH_IH.AutoMobSpawnSet === 4) {
                    //function (startX, startY, goalX, goalY, marchantId, cartId, guardsId, guardsAmount = 1)
                    window.RSTH_IH.spawnNpcPassEvent(87, 95, 0, 0, 0, 6, 1, 3);
                }
            }
            else if (id === 6) {
                AudioManager.playSe({ name: "Saint2", pan: 0, pitch: 100, volume: 20 });

                if (window.RSTH_IH._selectedActorId === 1) {
                    window.RSTH_IH.BuyShop = window.RSTH_IH.ShopGoodsData.specialShop1;
                }
                else if (window.RSTH_IH._selectedActorId === 2) {
                    window.RSTH_IH.BuyShop = window.RSTH_IH.ShopGoodsData.specialShop2;
                }
                else if (window.RSTH_IH._selectedActorId === 3) {
                    window.RSTH_IH.BuyShop = window.RSTH_IH.ShopGoodsData.specialShop3;
                }
                window.RSTH_IH.shopCallFlag = 1;
                SceneManager.push(window.RSTH_IH.Scene_Shop);
            }
            else if (id === 7) {
                AudioManager.playSe({ name: "Open5", pan: 0, pitch: 100, volume: 20 });

                window.RSTH_IH.treasureCallFlag = 1;
                SceneManager.push(window.RSTH_IH.Scene_Treasure);
            }
        }
        else if (lank === 4) {
            // mob討伐
            if (id === 1) {
                window.RSTH_IH.spawnMobEvent(83);
                window.RSTH_IH.spawnMobEvent(85);
            }
            else if (id === 2) {
                window.RSTH_IH.spawnMobEvent(84);
                window.RSTH_IH.spawnMobEvent(85);
            }
            else if (id === 3) {
                window.RSTH_IH.spawnNpcEvent(4);
                window.RSTH_IH.spawnNpcEvent(1);
                window.RSTH_IH.spawnNpcEvent(1);
            }
            else if (id === 4) {
                AudioManager.playSe({ name: "Saint2", pan: 0, pitch: 100, volume: 20 });

                if (window.RSTH_IH._selectedActorId === 1) {
                    window.RSTH_IH.BuyShop = window.RSTH_IH.ShopGoodsData.specialShop1;
                }
                else if (window.RSTH_IH._selectedActorId === 2) {
                    window.RSTH_IH.BuyShop = window.RSTH_IH.ShopGoodsData.specialShop2;
                }
                else if (window.RSTH_IH._selectedActorId === 3) {
                    window.RSTH_IH.BuyShop = window.RSTH_IH.ShopGoodsData.specialShop3;
                }
                window.RSTH_IH.shopCallFlag = 1;
                SceneManager.push(window.RSTH_IH.Scene_Shop);
            }
            else if (id === 5) {
                AudioManager.playSe({ name: "Open5", pan: 0, pitch: 100, volume: 20 });

                window.RSTH_IH.treasureCallFlag = 1;
                SceneManager.push(window.RSTH_IH.Scene_Treasure);
            }
        }
        else if (lank === "EX") {
            // mob討伐
            if (id === 1) {
                window.RSTH_IH.spawnMobEvent(73);
                window.RSTH_IH.spawnMobEvent(68);
                window.RSTH_IH.spawnMobEvent(75);
            }
            else if (id === 2) {
                window.RSTH_IH.spawnMobEvent(74);
                window.RSTH_IH.spawnMobEvent(69);
                window.RSTH_IH.spawnMobEvent(75);
            }
            else if (id === 3) {
                window.RSTH_IH.spawnMobEvent(75);
                window.RSTH_IH.spawnMobEvent(75);
                window.RSTH_IH.spawnMobEvent(75);
                window.RSTH_IH.spawnMobEvent(75);
                window.RSTH_IH.spawnMobEvent(75);
            }
            else if (id === 4) {
                window.RSTH_IH.spawnMobEvent(73);
                window.RSTH_IH.spawnMobEvent(73);
                window.RSTH_IH.spawnMobEvent(73);
                window.RSTH_IH.spawnMobEvent(73);
                window.RSTH_IH.spawnMobEvent(73);
            }
            else if (id === 5) {
                window.RSTH_IH.spawnMobEvent(68);
                window.RSTH_IH.spawnMobEvent(68);
                window.RSTH_IH.spawnMobEvent(68);
                window.RSTH_IH.spawnMobEvent(68);
                window.RSTH_IH.spawnMobEvent(68);
            }
            else if (id === 6) {
                window.RSTH_IH.spawnNpcEvent(1);
                window.RSTH_IH.spawnNpcEvent(1);
            }
            else if (id === 7) {
                AudioManager.playSe({ name: "Saint2", pan: 0, pitch: 100, volume: 20 });

                if (window.RSTH_IH._selectedActorId === 1) {
                    window.RSTH_IH.BuyShop = window.RSTH_IH.ShopGoodsData.specialShop1;
                }
                else if (window.RSTH_IH._selectedActorId === 2) {
                    window.RSTH_IH.BuyShop = window.RSTH_IH.ShopGoodsData.specialShop2;
                }
                else if (window.RSTH_IH._selectedActorId === 3) {
                    window.RSTH_IH.BuyShop = window.RSTH_IH.ShopGoodsData.specialShop3;
                }
                window.RSTH_IH.shopCallFlag = 1;
                SceneManager.push(window.RSTH_IH.Scene_Shop);
            }
            else if (id === 8) {
                AudioManager.playSe({ name: "Open5", pan: 0, pitch: 100, volume: 20 });

                window.RSTH_IH.treasureCallFlag = 1;
                SceneManager.push(window.RSTH_IH.Scene_Treasure);
            }
        }
    }

    window.RSTH_IH.spawnMobEvent = function (mobId) {
        let mob = null;

        AudioManager.playSe({ name: "Battle2", pan: 0, pitch: 100, volume: 20 });
        const sc = window.RSTH_IH.QuestMobSpawnCheck();
        const x = sc.x;
        const y = sc.y;

        mob = window.RSTH_IH.spawnMob(mobId, x, y);
        mob._aiMode = "chase";
        window.RSTH_IH.MobCount++;
    }

    window.RSTH_IH.spawnNpcEvent = function (npcId) {
        AudioManager.playSe({ name: "Bow2", pan: 0, pitch: 100, volume: 20 });

        let npc = null;
        const sc = window.RSTH_IH.QuestMobSpawnCheck();
        const x = sc.x;
        const y = sc.y;

        npc = window.RSTH_IH.spawnNpc(npcId, x, y);
        npc._aiMode = "follow";
    }

    window.RSTH_IH.spawnNpcPassEvent = function (startX, startY, goalX, goalY, marchantId, cartId, guardsId, guardsAmount = 1) {
        let npc = null;
        let cart = null;
        let guards = [];
        const tx = startX;
        const ty = startY;
        const gx = goalX;
        const gy = goalY;

        AudioManager.playSe({ name: "Move10", pan: 0, pitch: 100, volume: 20 });
        // 護衛対象の商人
        npc = window.RSTH_IH.spawnNpc(marchantId, tx, ty);
        npc._destX = gx;
        npc._destY = gy;
        npc._aiMode = "pass";

        // 護衛対象のカート
        cart = window.RSTH_IH.spawnNpc(cartId, tx, ty + 1);
        cart._target = npc;
        cart._aiMode = "cart";
        npc._cart = cart;
        cart.setEventGuards(npc);

        //console.log("guardsId", guardsId);
        for (let i = 0; i < guardsAmount; i++) {
            guards[i] = window.RSTH_IH.spawnNpc(guardsId, tx, ty - 1);
            guards[i]._cart = cart;
            guards[i]._aiMode = "guard";
            npc._guards.push(guards[i]);
            cart.setEventGuards(guards[i]);
        }


    }

    window.RSTH_IH.passEventSuccess = function (amount, amount2) {
        AudioManager.playSe({ name: "Saint5", pan: 0, pitch: 100, volume: 20 });
        const text = `☆ 商人とカートの護衛に成功した！`;
        window.RSTH_IH.LogWindowManager.addLog(text, 3);

        const party = $gameParty;
        party.gainGold(amount);
        const text2 = `☆ ${amount}Gを入手した！`;
        window.RSTH_IH.LogWindowManager.addLog(text2, 3);

        const unp = amount2;
        window.RSTH_IH.unshoP += unp;
        ConfigManager.unshoP = window.RSTH_IH.unshoP;
        ConfigManager.save();

        const text3 = `☆ ${amount2}のうんしょPを入手した！`;
        window.RSTH_IH.LogWindowManager.addLog(text3, 3);

    }

    window.RSTH_IH.spawnBossEvent = function () {
        if (!window.RSTH_IH._selectedMapId) return;


        if (window.RSTH_IH.AutoMobSpawnSet === 1) {
            if (window.RSTH_IH.TimeCount >= 240 && window.RSTH_IH.BossCount === 0) {
                // function (mobId, lx, ralx, ly, raly, rx, rarx, ry, rary)
                window.RSTH_IH.spawnBossEventCore(7, 0, 0, 25, 6, 63, 0, 36, 7);
            }
        }
        else if (window.RSTH_IH.AutoMobSpawnSet === 2) {
            if (window.RSTH_IH.TimeCount >= 240 && window.RSTH_IH.BossCount === 0) {
                // function (mobId, lx, ralx, ly, raly, rx, rarx, ry, rary)
                window.RSTH_IH.spawnBossEventCore(7, 0, 0, 29, 57, 95, 0, 39, 52);
            }
            else if (window.RSTH_IH.TimeCount >= 480 && window.RSTH_IH.BossCount === 1) {
                window.RSTH_IH.spawnBossEventCore(15, 0, 0, 29, 57, 95, 0, 39, 52);
            }
        }
        else if (window.RSTH_IH.AutoMobSpawnSet === 3) {
            if (window.RSTH_IH.TimeCount >= 240 && window.RSTH_IH.BossCount === 0) {
                // function (mobId, lx, ralx, ly, raly, rx, rarx, ry, rary)
                window.RSTH_IH.spawnBossEventCore(7, 45, 4, 48, 4, 42, 10, 2, 2);
            }
            else if (window.RSTH_IH.TimeCount >= 480 && window.RSTH_IH.BossCount === 1) {
                // function (mobId, lx, ralx, ly, raly, rx, rarx, ry, rary)
                window.RSTH_IH.spawnBossEventCore(15, 45, 4, 48, 4, 42, 10, 2, 2);
            }
            else if (window.RSTH_IH.TimeCount >= 780 && window.RSTH_IH.BossCount === 2) {
                // function (mobId, lx, ralx, ly, raly, rx, rarx, ry, rary)
                window.RSTH_IH.spawnBossEventCore(51, 45, 4, 48, 4, 42, 10, 2, 2);
            }
        }
        else if (window.RSTH_IH.AutoMobSpawnSet === 4) {
            if (window.RSTH_IH.TimeCount >= 120 && window.RSTH_IH.BossCount === 0) {
                // function (mobId, lx, ralx, ly, raly, rx, rarx, ry, rary)
                window.RSTH_IH.spawnBossEventCore(7, 0, 5, 0, 5, 84, 5, 88, 5);
            }
            else if (window.RSTH_IH.TimeCount >= 240 && window.RSTH_IH.BossCount === 1) {
                // function (mobId, lx, ralx, ly, raly, rx, rarx, ry, rary)
                window.RSTH_IH.spawnBossEventCore(15, 0, 5, 0, 5, 84, 5, 88, 5);
            }
            else if (window.RSTH_IH.TimeCount >= 480 && window.RSTH_IH.BossCount === 2) {
                // function (mobId, lx, ralx, ly, raly, rx, rarx, ry, rary)
                window.RSTH_IH.spawnBossEventCore(51, 0, 5, 0, 5, 84, 5, 88, 5);
            }
            else if (window.RSTH_IH.TimeCount >= 780 && window.RSTH_IH.BossCount === 3) {
                // function (mobId, lx, ralx, ly, raly, rx, rarx, ry, rary)
                window.RSTH_IH.spawnBossEventCore(59, 0, 5, 0, 5, 84, 5, 88, 5);
            }
        }
        else if (window.RSTH_IH.AutoMobSpawnSet === 5) {
            if (window.RSTH_IH.TimeCount >= 180 && window.RSTH_IH.BossCount === 0) {
                // function (mobId, lx, ralx, ly, raly, rx, rarx, ry, rary)
                window.RSTH_IH.spawnBossEventCore(51, 1, 8, 1, 2, 59, 5, 59, 5);
            }
            else if (window.RSTH_IH.TimeCount >= 240 && window.RSTH_IH.BossCount === 1) {
                // function (mobId, lx, ralx, ly, raly, rx, rarx, ry, rary)
                window.RSTH_IH.spawnBossEventCore(59, 1, 8, 1, 2, 59, 5, 59, 5);
            }
        }
    }

    window.RSTH_IH.spawnBossEventCore = function (mobId, lx, ralx, ly, raly, rx, rarx, ry, rary) {
        AudioManager.playSe({ name: "Darkness4", pan: 0, pitch: 100, volume: 20 });

        window.RSTH_IH.questSpawned = true;

        const rand = Math.random();
        const rand2 = Math.random();
        const area = rand < 0.5 ? "left" : "right";
        let x, y;
        let mob = null;

        if (area === "left") {
            x = Math.floor(rand * ralx) + lx;
            y = Math.floor(rand2 * raly) + ly;
        } else {
            x = Math.floor(rand * rarx) + rx;
            y = Math.floor(rand2 * rary) + ry;
        }

        let text = "";
        if (mobId === 7) text = "イテルスペ廃道のBOSS出現";
        else if (mobId === 15) text = "タルダモルス荒野のBOSS出現";
        else if (mobId === 51) text = "旧魔王城庭園のBOSS出現";
        else if (mobId === 59) text = "イグニス要塞前のBOSS出現";

        window.RSTH_IH.createQuestTextSprite("◇イベント:", `　${text}`, 1);

        mob = window.RSTH_IH.spawnMob(mobId, x, y);
        window.RSTH_IH.BossCount++;
        window.RSTH_IH.MobCount++;
        if (mob) mob._aiMode = "chase";

    }

    window.RSTH_IH.spawnBossRush = function () {
        if (!window.RSTH_IH._selectedMapId) return;
        if (window.RSTH_IH.BossRush) return;

        if (window.RSTH_IH.AutoMobSpawnSet === 3) {
            if (window.RSTH_IH.TimeCount >= 820) {
                //if (window.RSTH_IH.TimeCount >= 5) {
                window.RSTH_IH.spawnBossRushCore();
            }
        }
        else if (window.RSTH_IH.AutoMobSpawnSet === 4) {
            if (window.RSTH_IH.TimeCount >= 575) {
                window.RSTH_IH.spawnBossRushCore();
            }
        }
    }

    window.RSTH_IH.spawnBossRushCore = function () {
        AudioManager.playSe({ name: "Siren", pan: 0, pitch: 100, volume: 20 });

        window.RSTH_IH.questSpawned = true;
        window.RSTH_IH.BossRush = true;

        const text = "大量の強力な敵が接近中！";

        window.RSTH_IH.createQuestTextSprite("◆警報：", `　${text}`, 1);
    }

    Scene_Map.prototype.updateElapsedTimeAndResult = function () {
        // 経過時間が指定時間を超えたらリザルトシーンへ
        if (window.RSTH_IH.TimeCount === window.RSTH_IH._elapsedLimit) {
            const leader = $gameParty.leader();
            leader?.clearStates();
            window.RSTH_IH._mobManager.clearAllMobs();
            window.RSTH_IH._npcManager.clearAllNpcs();
            const scene = window.RSTH_IH._timerNum === 1
                ? window.RSTH_IH.Scene_BeforeResultTimeUP
                : window.RSTH_IH.Scene_BeforeResult;
            SceneManager.push(scene);
        }

        if (window.RSTH_IH._elapsedTimeEnabled) {
            window.RSTH_IH._timeFrameCounter ||= 0;
            window.RSTH_IH.TimeCount ||= 0;

            // 経過時間加算（1秒ごと）
            if (++window.RSTH_IH._timeFrameCounter >= 60) {
                window.RSTH_IH.TimeCount++;
                window.RSTH_IH._timeFrameCounter = 0;

                window.RSTH_IH.Window_CheckAchievement();

                // === クエスト発生処理 ===
                window.RSTH_IH.spawnBossEvent();
                window.RSTH_IH.spawnBossRush();
                const qtimer = window.RSTH_IH.TimeCount % 30;
                if (qtimer === 0 && !window.RSTH_IH.questSpawned) {
                    window.RSTH_IH.spawnRandomQuest();
                }
                window.RSTH_IH.questSpawned = false;
            }

        }
    };

    // stateによるHP増減の共通処理
    Scene_Map.prototype.updateHpTick = function (stateId, counterKey, interval, amount, isHeal) {
        const leader = $gameParty.leader();
        if (!leader?.hasState(stateId)) {
            this[counterKey] = 0;
            return;
        }
        this[counterKey] ||= 0;
        if (++this[counterKey] >= interval) {
            this[counterKey] = 0;
            if (isHeal) {
                leader.setHp(Math.min(leader.hp + amount, leader.mhp));
            } else {
                leader.gainHp(-amount);
                if (leader.hp < 0) leader.setHp(0);

                // 毒 or 猛毒のときSEを鳴らす
                if (stateId === 4 || stateId === 7) {
                    AudioManager.playSe({ name: "Poison", pan: 0, pitch: 100, volume: 10 });
                }
                else if (stateId === 5) {
                    AudioManager.playSe({ name: "Fire3", pan: 0, pitch: 100, volume: 5 });
                }
            }
        }
    };

    Scene_Map.prototype.updateLeader = function () {
        const leader = $gameParty.leader();
        if (!leader) return;

        // ステート解除（パワーアップ状態であれば）
        const removeStateTable = [11, 4, 7, 8, 5];
        for (const id of removeStateTable) {
            const cfgKey = {
                11: "gauge_ST2",
                4: "gauge_ST1",
                7: "gauge_ST1",
                8: "gauge_ST1",
                5: "gauge_IG"
            }[id];
            if (ConfigManager[cfgKey] === 1 && leader.hasState(id)) {
                leader.removeState(id);
            }
        }

        // blendColor設定
        const sprite = this._spriteset._characterSprites.find(s => s._character === $gamePlayer);
        let blendSet = false;
        for (const { id, cfg, color } of window.RSTH_IH.blendTable) {
            if (leader.hasState(id) && ConfigManager[cfg] !== 1) {
                sprite?.setBlendColor(color);
                blendSet = true;
                break;
            }
        }
        if (!blendSet) sprite?.setBlendColor([0, 0, 0, 0]);

        // 混乱（ランダム移動）
        if (leader.hasState(8) && ConfigManager["gauge_ST1"] !== 1) {
            this._rsthState8FrameCounter ||= 0;
            if (++this._rsthState8FrameCounter >= 6) {
                this._rsthState8FrameCounter = 0;
                $gamePlayer.moveStraight([2, 4, 6, 8][Math.randomInt(4)]);
            }
        } else {
            this._rsthState8FrameCounter = 0;
        }

        // HP増減処理（順番厳守）
        for (const { id, key, intv, val, heal, cfg } of window.RSTH_IH.hpTickTable) {
            if (!cfg || ConfigManager[cfg] !== 1) {
                this.updateHpTick(id, key, intv, val, heal);
            }
        }

        // gauge_RGによる回復
        if (ConfigManager["gauge_RG"] === 1) {
            this._rsthStateRGFrameCounter ||= 0;
            if (++this._rsthStateRGFrameCounter >= 30) {
                this._rsthStateRGFrameCounter = 0;
                leader.setHp(Math.min(leader.hp + 50, leader.mhp));
            }
        } else {
            this._rsthStateRGFrameCounter = 0;
        }

        // state28 自動付与解除
        let hasState28Armor = false;
        for (const equip of leader.equips()) {
            if (equip?.meta?.state === "28") {
                hasState28Armor = true;
                break;
            }
        }
        if (hasState28Armor && !leader.isStateAffected(28)) {
            leader.addState(28);
        } else if (!hasState28Armor && leader.isStateAffected(28)) {
            leader.removeState(28);
        }

        // state28 回復処理
        if (leader.hasState(28)) {
            this._rsth_regenCounter ||= 0;
            if (++this._rsth_regenCounter >= 30) {
                this._rsth_regenCounter = 0;
                leader.setHp(Math.min(leader.hp + 25, leader.mhp));
            }
        } else {
            this._rsth_regenCounter = 0;
        }

        // ポーション自動使用
        const hpper = (leader.hp / leader.mhp) * 100;
        if (hpper <= ConfigManager.autoPotionPercent && hpper > 0 && hpper !== 100) {
            window.RSTH_IH.UseAutoPotion();
        }
    };

    //update処理
    const _Scene_Map_update = Scene_Map.prototype.update;
    Scene_Map.prototype.update = function () {
        if (this._battleIntroPlaying && this._updateBattleIntro) {
            this._updateBattleIntro();
            return; // 他の更新を停止
        }

        _Scene_Map_update.call(this);



        this.getTreasureUpdate();

        this.updateElapsedTimeAndResult();

        this.updateLeader();


        const data = window.RSTH_IH._questTextData;
        if (data && --data.time <= 0) {
            this.removeChild(this._questTextSprite);
            this.removeChild(this._questTextBgSprite);
            this._questTextSprite = null;
            this._questTextBgSprite = null;
            window.RSTH_IH._questTextData = null;
        }



        //アチーブメント表示
        window.RSTH_IH.ACHIEVEMENT_NOTIFIER?.update();

        if (window.RSTH_IH._mobManager) {
            window.RSTH_IH._mobManager.updateAll();
        }

        if (window.RSTH_IH._npcManager) {
            window.RSTH_IH._npcManager.updateAll();
        }

        this.updateMousePointerSprite();
        this.RSTH_IH_updateToggleEquipmentWindow();

        const scene = SceneManager._scene;
        const hotbar = scene?._hotbarWindow;
        const map = window.RSTH_IH._cooldownMap;

        // マスター値を先に減算
        if (window.RSTH_IH._weaponCooldown > 0) window.RSTH_IH._weaponCooldown--;
        if (window.RSTH_IH._skillA_Cooldown > 0) window.RSTH_IH._skillA_Cooldown--;
        if (window.RSTH_IH._skillB_Cooldown > 0) window.RSTH_IH._skillB_Cooldown--;
        if (window.RSTH_IH._skillC_Cooldown > 0) window.RSTH_IH._skillC_Cooldown--;

        if (map) {
            let anyUpdated = false;

            for (const key in map) {
                const cd = map[key];

                switch (cd.skillType) {
                    case "A":
                        cd.remaining = window.RSTH_IH._skillA_Cooldown;
                        break;
                    case "B":
                        cd.remaining = window.RSTH_IH._skillB_Cooldown;
                        break;
                    case "C":
                        cd.remaining = window.RSTH_IH._skillC_Cooldown;
                        //console.log("cd.remaining ", cd.remaining);
                        break;
                }

                // もし残りが0未満になったら0に
                if (cd.remaining < 0) cd.remaining = 0;

                // 何か残りがまだあれば更新ありとする
                if (cd.remaining > 0) {
                    anyUpdated = true;
                }
            }

            if (anyUpdated && hotbar) {
                hotbar.refresh();
            }
        }


        window.RSTH_IH.onLeftButtonDown();

        window.RSTH_IH.updateWeaponHold();

        window.RSTH_IH.ProjectileManager.update();

        //block関連
        /*
        const mgr = window.RSTH_IH.SurvivalBlockManager;

        if (mgr && window.RSTH_IH.__needGrowthSpriteUpdate) {
            mgr.updateGrowthSprites();
            window.RSTH_IH.__needGrowthSpriteUpdate = false; // 🔁 消費後フラグを戻す
            window.RSTH_IH.__rsthNeedSpriteRefresh = true;   // ★ 成長後のタイル描画を強制更新
        }

        if (mgr && typeof mgr.updateSpriteRefreshQueue === "function") {
            mgr.updateSpriteRefreshQueue(); // ★ スプライト再描画予約を処理
        }

        if ($gameSystem.rsthupdateGrowthTimers) {
            $gameSystem.rsthupdateGrowthTimers();
        }
            
        if (Input.isTriggered('R')) {
            //console.log(`Input.isTriggered('R')`);
            window.RSTH_IH.doorRotation();
        }
            
        const px = $gamePlayer.x;
        const py = $gamePlayer.y;
        //mgr.update(px, py);
        */

        window.RSTH_IH.DropManager.update();

        // メッセージ中は独自カーソル非表示にする
        if (this._rsthCursorSprite) {
            this._rsthCursorSprite.visible = !$gameMessage.isBusy();
        }

        if (window.RSTH_IH.EnableAutoMobSpawn) {
            window.RSTH_IH.AutoMobSpawner.update();
        }

    };

    // シーンマップのスプライトレイヤー追加
    const _Scene_Map_createDisplayObjects = Scene_Map.prototype.createDisplayObjects;
    Scene_Map.prototype.createDisplayObjects = function () {
        _Scene_Map_createDisplayObjects.call(this);

        const tilemap = this._spriteset._tilemap;
        this._spriteset._rsthAnimationLayer = new Sprite();
        this._spriteset._rsthAnimationLayer.z = 5;
        tilemap.addChild(this._spriteset._rsthAnimationLayer);

        // ゴースト表示用
        this._rsthGhostSprite = new Sprite();
        this.addChild(this._rsthGhostSprite);

        this.createGhostTextSprite();
        this.createMousePointerSprite();

        document.body.style.cursor = 'none'; // マウスカーソル非表示

        this._rsthMobLayer = new Sprite();
        this.addChild(this._rsthMobLayer);

        this._rsthNpcLayer = new Sprite();
        this.addChild(this._rsthNpcLayer);
    };

})();