/*:
 * @target MZ
 * @plugindesc RSTH_IH: サバイバルゲームシステムプラグイン
 * @author © 2025 ReSera_りせら（@MOBIUS1001）
 *
 * このソースコードは無断での転載、複製、改変、再配布、商用利用を固く禁じます。
 * 禁止事項の例：
 * - 本ファイルの全部または一部を許可なくコピー、再配布すること
 * - 本ファイルを改変して配布すること
 * - 商用目的での利用
 */

(() => {

    "use strict";

    // ログ出力制御フラグ（trueでログ出力、falseで抑制）
    //const RSTH_DEBUG_LOG = true;
    const RSTH_DEBUG_LOG = false;

    window.RSTH_IH.Scene_Tutorial = class extends Scene_MenuBase {
        create() {
            this.createBackground();
            this.createTitle();
            super.createWindowLayer();
            this.createHintText();

            this.createSelectCommandWindow();
            this.createSimpleMessageWindow();

        }

        createBackground() {
            this._backgroundSprite = new window.RSTH_IH.Sprite_CharacterSelectBackground();
            this.addChild(this._backgroundSprite);
        }

        createTitle() {
            this._title = new window.RSTH_IH.Sprite_VerticalTitleText("Tutorial");
            this.addChild(this._title);
        }

        createHintText() {
            const bitmap = new Bitmap(900, 36);
            const x = 240;

            bitmap.fontSize = 24;
            bitmap.textColor = "#FFFFFF";
            bitmap.drawText("↑↓：項目選択", 0, 0, 300, 36, "left");
            bitmap.drawText("Esc：前の画面へ", x, 0, 300, 36, "left");

            this._HintSprite = new Sprite(bitmap);
            this._HintSprite.x = 120;
            this._HintSprite.y = 6;
            this._HintSprite.visible = true;

            this.addChild(this._HintSprite);
        }

        createSimpleMessageWindow() {
            const gw = Graphics.boxWidth;
            const gh = Graphics.boxHeight;

            const margin = 6;
            const hw = 42;

            const ww = gw - this._selectCommandWindow.width - 120 - margin * 2;
            const wh = gh - margin * 2 - hw;
            const wx = this._selectCommandWindow.width + 120 + margin * 2;
            const wy = margin + hw;
            const rect = new Rectangle(wx, wy, ww, wh);

            this._simpleMessageWindow = new window.RSTH_IH.Window_Tutorial(rect);
            this.addWindow(this._simpleMessageWindow);

        }

        createSelectCommandWindow() {
            const margin = 6;
            const hw = 42;

            const ww = 200;
            const wh = this.calcWindowHeight(18, true) + 22; // 18で固定
            const wx = 120 + margin;
            const wy = margin + hw;
            const rect = new Rectangle(wx, wy, ww, wh);

            this._selectCommandWindow = new window.RSTH_IH.Window_SelectCommand(rect);
            this.addWindow(this._selectCommandWindow);
        }

        updateTutorialContent() {
            const index = this._selectCommandWindow.index();
            if (this._lastTutorialIndex === index) return;
            this._lastTutorialIndex = index;

            const data = [
                {
                    text: "ゲームの流れ",
                    text2: "このゲームの基本的な流れは以下の通りです。\n マップを選択(A)、使用するキャラクターを選択(B)、\n キャラクターの初期装備を設定(C)し、各種オプションを設定、\n 戦闘画面で一定時間生き残るかレイドボスを倒す(D)、\n 勝利！（E)、アチーブメントを確認(F)、うんしょポイントでPowerUP!\n 別のマップを選択(A)・・・の繰り返しです。\n ゲームクリアの概念はありませんが、一応のクリア目標としては\n レイドボスを倒す、アチーブメントをすべて達成する等があります。",
                    image: "tuto_19"
                },
                {
                    text: "戦闘の流れ",
                    text2: "戦闘の流れとしては、迫りくる大量のMOBを倒すか逃げるかをして一定時間生存するか、\n 非常に強力なレイドボスを制限時間内に倒すという感じになります。\n MOBに対抗する手段はプレイヤーによる攻撃、MOBを倒してドロップしたお金を入手し、\n Shopやトレジャーで装備を整え、経験値を貯めてレベルアップ等があります。\n MOBには通常の敵MOB、ボス級の敵、レイドボス等がいます。\n 一定時間生存する条件のマップでは後半になるほど敵が強くなり、ボス級の敵が出現します。\n レイドボス討伐が条件のマップでは、序盤からレイドボスとボス級の敵が出現します。\n レイドボスやボス級の敵の下にはHPバーが表示されているので参考にしてください。",
                    image: "tuto_20"
                },
                {
                    text: "MAP選択",
                    text2: "プレイするマップを選択してください。\n A:選択できるマップリスト \n B:選択しているマップの情報 \n C:選択しているマップの全体図\n 各MAPをクリアする度に一定のうんしょポイントを入手できます。",
                    image: "tuto_01"
                },
                {
                    text: "キャラクター選択",
                    text2: "使用するキャラクターを選択してください。 \n A:選択できるキャラクターリスト \n B:選択しているキャラクターの情報 \n C:選択しているキャラクターの立ち絵",
                    image: "tuto_02"
                },
                {
                    text: "初期装備の設定",
                    text2: "選択したキャラクターの初期装備を設定できます。 \n A:コマンドリスト \n B:キャラクターの各種装備のリスト \n C:装備できるアイテムのリスト。\n 　全キャラクター共通の装備もあります。\n 　文字が灰色のアイテムは解放する必要があります。\n 　解放にはうんしょポイントが必要です。\n 　全キャラクター共通の装備を開放すると全キャラクターで使用できます。",
                    image: "tuto_03"
                },
                {
                    text: "PowerUP",
                    text2: "うんしょポイントを使用して各項目の強化ができます。\n 各項目を強化するには項目にカーソルを合わせてEnterキーを押下、\n ゲージを→←キー押下で増減させ、再度Enter押下すると\n 強化するかどうかの確認ウィンドウが出るので\n はいを選ぶと、現在のうんしょポイントから強化に必要なうんしょポイントを\n 差し引いて項目の強化が行われます。\n うんしょポイントが足りない場合は強化できません。\n なお、強化した項目は全キャラクターに適用されます。",
                    image: "tuto_18"
                },
                {
                    text: "Option",
                    text2: "各種設定をしてください。\n A:コマンドリスト \n B:戦闘画面で使用するBGM。→←キーで変更し、Enterで確定。 \n C:LvUP時のステータス加算方法を自動か手動を選択 \n D:ステータス自動加算の場合の各種ステータスの割り振りの優先度を設定 \n E:トレジャー獲得時の演出を普通か簡易かを選択 \n F:音量と常時ダッシュON,OFFの切り替え \n G:回復アイテムを自動で使用する際のHPの割合を設定",
                    image: "tuto_04"
                },
                {
                    text: "Achievements",
                    text2: "実績の達成状況を確認できます。\n A:実績のタイトルとその条件 \n B:実績を達成したかしていないかの表示 \n C:実績を達成した場合にもらえるうんしょポイント",
                    image: "tuto_05"
                },
                {
                    text: "戦闘画面1",
                    text2: "このゲームのメインコンテンツの戦闘画面で、プレイヤーとMOBが戦います。\n基本的にプレイヤーの攻撃は自動で行われ、スキルのみ手動で発動することになります。\n勝敗は一定時間生き残ることが基本ですが、レイドボスを制限時間内に倒す必要がある場合もあります。\n A:プレイヤーのLv、名前、HP等の情報 \n B:プレイヤーのキャラクター。↑↓←→、wasdキー押下で移動できます。 \n C:敵性MOB。プレイヤーを追いかけたり、定位置で待ち構えたりします。\n D:マウスポインタ。プレイヤーの攻撃方向はこのマウスポインタによって決定されます。\n E:状態異常アイコン。プレイヤーがバフ、デバフ、状態異常にかかると表示されます。",
                    image: "tuto_06"
                },
                {
                    text: "戦闘画面2",
                    text2: " F:経験値の貯まり具合を表示するバー。現在の経験値と次のレベルまでの経験値も表示。\n 　一定量の経験値を貯めることでプレイヤーのレベルが上がります。\n G:マップを縮小した全体図、マップ内に存在するMOB数、所持金等が表示されます。\n 　全体図にはプレイヤー、MOBの位置を示す点が表示されます。\n 　総MOB数が200を超えると最初のほうに出現したMOBから消えていきます。\n 　MOBが消えた分、そのMOBを倒して手に入るはずだった経験値やお金等が消えるということです。\n H:何かを入手したり状態異常になったりすると、ここにログが表示されます。\n I:戦闘を始めてから経過した時間です。10分耐久マップなら10分生き残る必要があります。",
                    image: "tuto_06"
                },
                {
                    text: "戦闘画面3",
                    text2: " J:Tキー押下でキャラクターの詳細ステータスの表示、\n 　Qキー押下でキャラクターが装備している防具を表示 \n 　Eキー押下でSHOPの呼び出し、Oキー押下でオプションの呼び出し、\n 　Lキー押下でチュートリアルの呼び出しができる。 \n K:スキルや武器、アイテムなどが表示されるホットバー。\n 　数字キー押下か[]キー、マウスホイールでカーソルを移動できる \n 　左から3つ目まではスキルで、対応する数字キー押下でスキルが発動する。 \n 　もしくはカーソルがスキルにある場合で左クリックをするとスキル発動。",
                    image: "tuto_07"
                },
                {
                    text: "戦闘画面4",
                    text2: " A:宝箱。マウスポインタが「・・・」の表示になったときに右クリックで開くことができる \n B:召喚陣。右クリックすると強力なMOBがその場に出現する。",
                    image: "tuto_08"
                },
                {
                    text: "戦闘画面5",
                    text2: " A:レイドボスのHPとタイマーのバー表示 \n B:レイドボス。総MOB数が200を超えても消えない。",
                    image: "tuto_09"
                },
                {
                    text: "Shop",
                    text2: "アイテムや武具を買うことができます。\n A:アイテムリスト \n B:所持金。1プレイ毎にリセットされ、PowerUPしていないと0から開始。 \n C:現在キャラクターが持っている、装備している武具 \n D:選択しているアイテムの情報 \n E:RPGツクールMVのパッケージのキャラクター。\n Cover Art Characters PackのDLCはこのキャラクターの為だけに買った",
                    image: "tuto_10"
                },
                {
                    text: "ステータスについて1",
                    text2: "プレイヤーの各種ステータスの表示。\n Atk:プレイヤーの攻撃力。ホットバーでスキルや武器にカーソルが合っている場合は\n 　そのAtkが表示に加算される。カーソルが合っていなくてもダメージ計算に影響しない。\n MAtk:現在未実装のステータス。\n Def:プレイヤーの防御力。MOBからの被ダメージを減少させる。\n 　クリティカル攻撃を受けた場合は減少されない。\n Mdef:現在未実装のステータス。",
                    image: "tuto_11"
                },
                {
                    text: "ステータスについて2",
                    text2: " Str:上昇するとAtkが上昇する。\n Vit:上昇するとDefとMaxHPが上昇する。\n Mag:現在未実装のステータス \n Dex:上昇するとHitとCriが上昇する。\n Agi:上昇するとEvaとCriEvaとAtkSpdが上昇する。\n Luk:上昇するとHit,Eva,Cri,CriEvaが上昇する。",
                    image: "tuto_11"
                },
                {
                    text: "ステータスについて3",
                    text2: " Hit:命中値。MOBに攻撃を当てる為に必要な数値。\n Eva:回避値。MOBからの攻撃を回避する為に必要な数値。\n Cri:クリティカル値。MOBにクリティカル攻撃をする為に必要な数値。 \n CriEva:クリティカル回避値。MOBからのクリティカル攻撃を回避する為に必要な数値。\n AtkSpd:攻撃速度。100に近くなるにつれてプレイヤーの攻撃が速くなる。\n 　AtkSpdが高いと武器やスキルのクールタイム(CT)が短くなる。\n 　クールタイム(CT)が短くなると武器やスキルの発動間隔が短くなる。\n 　一部スキルを除いて、AtkSpd100でクールタイムは0.5秒になる。←重要",
                    image: "tuto_11"
                },
                {
                    text: "ダメージ表示について",
                    text2: "ダメージの種類はAtkとDefによる計算結果の通常ダメージ(赤色)と、\n 防御力無視のクリティカルダメージ(黄色でプレイヤー側にのみ表示)があります。\n プレイヤーの被ダメージは即座に表示されますが、MOBの被ダメージは間を置いて表示されます。\n MOBの被ダメージ表示は、ダメージを受けてからダメージを受けずに間が開いた所までの合計値。\n ダメージが0となっている場合は、攻撃を回避されています。\n その場合はプレイヤーのHitもしくはCriを上昇させることで改善されるかもしれません。\n ダメージが1となっている場合は、敵のDefが高すぎるのでプレイヤーのAtkを上昇させるか\n Criを上昇させてクリティカル攻撃をするかで改善されるかもしれません。",
                    image: "tuto_20"
                },
                {
                    text: "スキルについて",
                    text2: "プレイヤーが数字キー押下、またはスキルにカーソルが合っている状態で\n画面上を左クリック押下で使用できます。\n スキルは攻撃用、自己バフ用、敵デバフ用、移動用等があります。\n スキルを使用するとそのスキルはクールタイム中となり、その間は再使用できません。\n スキルのクールタイムは一部例外を除き、プレイヤーのAtkSpdによって短縮できます。\n なお、別画面から戻った際に攻撃エフェクト(輪や光等)が消えてしまいますが\n 攻撃判定は消えないので問題ありません。",
                    image: "tuto_12"
                },
                {
                    text: "武器について1",
                    text2: "ホットバーに武器が存在していると、プレイヤーはその武器を自動で発動します。\n 発動間隔は武器ごとのクールタイムやプレイヤーのAtkSpdに影響されます。\n 武器には近接、遠距離A、遠距離B、特殊の4種類があります。\n 近接は発動する際にマウスポインタの方向に応じて攻撃範囲を表示し、その範囲内を攻撃します。\n 遠距離AとBはマウスポインタの方向に矢やナイフ等を発射して攻撃します。\n 特殊はプレイヤーの周囲を回転して攻撃します。",
                    image: "tuto_16"
                },
                {
                    text: "武器について2",
                    text2: " 武器はトレジャーやShop、MAP内の宝箱で入手可能。\n 武器を入手した場合は自動装備し、同じ武器の場合は武器Lvが上昇するが、\n 別の武器の場合は装備できない。※Shopで購入する際は注意。\n つまり遠距離Aに遠距離A武器の円月輪が装備されていると、\n 遠距離A武器のスターファイアは装備できない。\n \n なお、別画面から戻った際に遠距離の攻撃エフェクト(矢やナイフ等)が消えてしまいますが\n 攻撃判定は消えないので問題ありません。",
                    image: "tuto_16"
                },
                {
                    text: "アイテムについて",
                    text2: "ホットバーにアイテムが存在していると、プレイヤーのHPが減った時に自動で使用します。\n 自動で使用するHPの割合はOption画面で変更できます。\n Shopやトレジャー、初期装備の設定で入手できます。\n イメージとしては、HPは最大で受けられるダメージ量で、\n アイテムはそれを回復するHPタンクのような感じ。\n HPが200の場合で被ダメージ300だとプレイヤーは即退場させられるが、\n 被ダメージ190ならアイテムがある限り、自動回復の割合次第で\n プレイヤーが退場する可能性は少なくなる。",
                    image: "tuto_13"
                },
                {
                    text: "防具について",
                    text2: "プレイヤーが装備している防具の表示。\n 防具は左から盾、頭、身体、装飾品1、装飾品2。\n 防具はトレジャーかShop、マップ内の宝箱で入手可能で、\n Defが高い防具を種類ごとに自動装備し、外れた防具は自動で安値で売却される。\n HP自動回復効果があったりDef以外のステータスが上がる防具もある。",
                    image: "tuto_17"
                },
                {
                    text: "レベルアップについて",
                    text2: "一定量の経験値が貯まるとプレイヤーはレベルアップをします。\n PowerUP無し状態で最大100、PowerUPをすると最大150まで上昇可能。\n A:レベルアップをするとランダムで上昇するステータスを2つ選択できます。\n B:Aの各項目にカーソルを合わせた際に、上昇するステータスの予測値が表示されます。\n \n 毎回選ぶのがめんどくさい場合は、Optionで自動で上昇させることが可能。\n 上昇させるステータスの優先度も設定可能。\n ※Magのステータスは現在未実装なので上昇させても無意味。",
                    image: "tuto_14"
                },
                {
                    text: "トレジャーについて",
                    text2: "MOBを一定数討伐する度にトレジャーを獲得できます。\n トレジャーは確率で1個、3個、5個獲得できます。\n トレジャーで獲得できるものは、アイテム＞防具＞武器の順の確立で変わります。\n \n 毎回演出を見るのがめんどくさい場合は、Optionで簡易に設定して演出をスキップすることが可能。",
                    image: "tuto_15"
                },
            ];

            const tutorial = data[index];
            if (!tutorial) return;

            this._simpleMessageWindow.setText(tutorial.text);
            this._simpleMessageWindow.setText2(tutorial.text2);
            this.setTutorialImage(tutorial.image);
        }

        setTutorialImage(imageName) {
            this._tutorialImageSprite ||= new Sprite();
            if (!this._tutorialImageSprite.parent) {
                this._tutorialImageSprite.x = this._simpleMessageWindow.x + (this._simpleMessageWindow.width - 800) / 2;
                this._tutorialImageSprite.y = this._simpleMessageWindow.y + 60;
                this.addChild(this._tutorialImageSprite);
            }

            this._tutorialImageSprite.bitmap = ImageManager.loadPicture(imageName);
        }


        update() {
            super.update();
            this.updateTutorialContent();

            if (Input.isTriggered("ok") || Input.isTriggered("cancel") || Input.isTriggered("escape") || TouchInput.isTriggered()) {

                SoundManager.playCancel();
                SceneManager.pop();
                //SceneManager.goto(window.RSTH_IH.Scene_TitleCustom);
            }
        }
    }

    window.RSTH_IH.Window_Tutorial = class extends Window_Base {
        constructor(rect) {
            super(rect);
            this._text = "";
            this._text2 = "";
        }

        setText(text) {
            this._text = text;
            this.refresh();
            this.show();
        }

        setText2(text) {
            this._text2 = text;
            this.refresh();
            this.show();
        }

        update() {
            super.update();
        }

        isOkEnabled() {
            return true;
        }

        textWidthEx(text) {
            const tempTextState = { index: 0, text: text, x: 0, y: 0 };
            return this.drawTextEx(text, 0, this.contents.height + 100); // 仮の描画で幅取得
        }

        refresh() {
            this.contents.clear();

            // text（中央表示）
            const textWidth = this.textWidthEx(this._text);
            const x = (this.contentsWidth() - textWidth) / 2;
            this.drawTextEx(this._text, x, 6);

            // text2（左寄せで \n 区切り）
            const lines = this._text2.split("\n");
            let y = 506;
            for (const line of lines) {
                this.drawTextEx(line, 6, y);
                y += this.lineHeight();
            }
        }


    }

    window.RSTH_IH.Window_SelectCommand = class extends Window_Command {
        constructor(rect) {
            super(rect);
            this._flashCounter = 0;
            this.refresh();
        }

        activate() {
            if (!this.active) {
                super.activate();
                this.select(this.index() >= 0 ? this.index() : 0);
            }
        }

        makeCommandList() {
            this.addCommand("ゲームの流れ", "nagare");
            this.addCommand("戦闘の流れ", "bnagare");
            this.addCommand("MAP選択", "map");
            this.addCommand("キャラクター選択", "chara");
            this.addCommand("初期装備の設定", "equipment");
            this.addCommand("PowerUP", "powerup");
            this.addCommand("Option", "option");
            this.addCommand("Achievements", "achievements");
            this.addCommand("戦闘画面1", "battle1");
            this.addCommand("戦闘画面2", "battle2");
            this.addCommand("戦闘画面3", "battle3");
            this.addCommand("戦闘画面4", "battle4");
            this.addCommand("戦闘画面5", "battle4");
            this.addCommand("Shop", "shop");
            this.addCommand("ステータス1", "status1");
            this.addCommand("ステータス2", "status2");
            this.addCommand("ステータス3", "status3");
            this.addCommand("ダメージ表示", "damage");
            this.addCommand("スキル", "skill");
            this.addCommand("武器1", "weapon1");
            this.addCommand("武器2", "weapon2");
            this.addCommand("アイテム", "item");
            this.addCommand("防具", "armor");
            this.addCommand("レベルアップ", "lvup");
            this.addCommand("トレジャー", "treasure");
        }

        maxItems() {
            return this._list.length; // ← これを追加
        }

        select(index) {
            super.select(index);
            this.opacity = 255;
            this.contentsOpacity = 255;
            this._flashCounter = 10;
        }

        update() {
            super.update();
            if (this._flashCounter > 0) {
                this.opacity = 255;
                this._flashCounter--;
            }
        }

        isCursorMovable() {
            return this.active && this.isOpen();
        }

    };

})();