/*:
 * @target MZ
 * @plugindesc RSTH_IH: サバイバルゲームシステムプラグイン
 * @author © 2025 ReSera_りせら（@MOBIUS1001）
 *
 * このソースコードは無断での転載、複製、改変、再配布、商用利用を固く禁じます。
 * 禁止事項の例：
 * - 本ファイルの全部または一部を許可なくコピー、再配布すること
 * - 本ファイルを改変して配布すること
 * - 商用目的での利用
 */

(() => {

    "use strict";

    // ログ出力制御フラグ（trueでログ出力、falseで抑制）
    //const RSTH_DEBUG_LOG = true;
    const RSTH_DEBUG_LOG = false;

    window.RSTH_IH.Scene_Cregit = class extends Scene_MenuBase {
        start() {
            super.start();
            window.RSTH_IH._sceneInputLockFrames = 60;
        }

        create() {
            super.create();
            this.createBackground();
            this.createTitle();

            super.createWindowLayer();
            this.createCregitWindow();

            AudioManager.stopMe();

            const bgm = {
                name: "mozetama_13_Beyond_the_Horizon",
                volume: 20,
                pitch: 100,
                pan: 0
            };
            AudioManager.playBgm(bgm);

        }

        createTitle() {
            this._title = new window.RSTH_IH.Sprite_VerticalTitleText("Cregit");
            this.addChild(this._title);
        }

        createBackground() {
            this._backgroundSprite = new window.RSTH_IH.Sprite_CharacterSelectBackground();
            this.addChild(this._backgroundSprite);
        }

        createCregitWindow() {
            const rect = new Rectangle(120, 6, Graphics.width - 120, Graphics.height - 12);
            this._cregitWindow = new window.RSTH_IH.Window_Cregit(rect);
            this.addWindow(this._cregitWindow);
            this._cregitWindow.show();
        }

        update() {
            super.update();
            if (window.RSTH_IH._sceneInputLockFrames > 0) {
                window.RSTH_IH._sceneInputLockFrames--;
            }
            else if (Input.isTriggered("ok") || Input.isTriggered("cancel") || Input.isTriggered("escape") || TouchInput.isTriggered()) {
                SceneManager.goto(window.RSTH_IH.Scene_TitleCustom);
            }
        }
    };

    window.RSTH_IH.Window_Cregit = class extends Window_Base {
        initialize(rect) {
            super.initialize(rect);
            this.opacity = 0; // ウィンドウ枠なし
            this.backOpacity = 0; // 背景なし
            this.refresh();
        }

        standardFontSize() {
            return 16; // 任意のサイズ
        }

        lineHeight() {
            return 24; // 任意の行間
        }


        refresh() {
            this.contents.clear();
            this.contents.fontSize = 22;
            const y = 6;
            const x = 16;
            const x2 = 32;
            const x3 = 740;
            const x4 = x3 + 16;
            const x5 = x4 + 16;
            const lh = this.lineHeight();
            const cw = this.contentsWidth() / 2 - 32

            this.drawText("☆ゲーム制作者", 0, y, cw);
            this.drawText("ReSera_りせら", x, y + lh, cw);

            this.drawText("☆制作ソフト", 0, y + lh * 3, cw);
            this.drawText("RPGツクールMZ", x, y + lh * 4, cw);
            this.drawText("©Gotcha Gotcha Games Inc./YOJI OJIMA 2020", x2, y + lh * 5, cw);

            this.drawText("☆画像素材の一部元ネタ", 0, y + lh * 7, cw);
            this.drawText("謎構図", x, y + lh * 8, cw);
            this.drawText("白百合リリィ 様", x2, y + lh * 9, cw);

            this.drawText("☆BGM、SE素材1", 0, y + lh * 11, cw);
            this.drawText("Bunnyhop", x, y + lh * 12, cw);
            this.drawText("Kyatto 様", x2, y + lh * 13, cw);

            this.drawText("Cover_Story", x, y + lh * 15, cw);
            this.drawText("The_Reaper_named_Phoenix", x, y + lh * 16, cw);
            this.drawText("The_Reaper__named_Phoenix_GD_Remix_", x, y + lh * 17, cw);
            this.drawText("煉獄庭園 様", x2, y + lh * 18, cw);

            this.drawText("Ucchii0 - The identity【Free Ver】", x, y + lh * 20, cw);
            this.drawText("Ucchii0-うっちーぜろ- 様", x2, y + lh * 21, cw);

            this.drawText("たぬきちの冒険", x, y + lh * 23, cw);
            this.drawText("MAKOOTO 様", x2, y + lh * 24, cw);

            this.drawText("情動カタルシス", x, y + lh * 26, cw);
            this.drawText("まんぼう二等兵 様", x2, y + lh * 27, cw);

            this.drawText("【フリーBGM】 かわいい ポップ アップテンポ 明るい ライブ配信 作業用", x, y + lh * 29, cw);
            this.drawText("necobeam (ねこビーム) 様", x2, y + lh * 30, cw);

            this.drawText("☆BGM、SE素材2", x3, y, cw);
            this.drawText("レトロゲーム実機音源BGMセット", x4, y + lh, cw);
            this.drawText("レトロゲーム実機音源BGMセット２", x4, y + lh * 2, cw);
            this.drawText("(C)MML Hack-a-thon", x5, y + lh * 3, cw);

            this.drawText("LovelyComposer", x4, y + lh * 5, cw);
            this.drawText("(C) 2021-2023 1oogames, doc1oo", x5, y + lh * 6, cw);

            this.drawText("mozetama_07_Bang_Bang_Banbard", x4, y + lh * 8, cw);
            this.drawText("mozetama_09_Surface_Tension", x4, y + lh * 9, cw);
            this.drawText("mozetama_13_Beyond_the_Horizon", x4, y + lh * 10, cw);
            this.drawText("mozell 様", x5, y + lh * 11, cw);

            this.drawText("Battle-BloodyCrescent_loop", x4, y + lh * 13, cw);
            this.drawText("Battle-Dawn_loop", x4, y + lh * 14, cw);
            this.drawText("Battle-Furious-GUITAR_loop", x4, y + lh * 15, cw);
            this.drawText("Battle-Furious-SYNTH_loop", x4, y + lh * 16, cw);
            this.drawText("Battle-Grief_loop", x4, y + lh * 17, cw);
            this.drawText("Battle-LunaticDance_loop", x4, y + lh * 18, cw);
            this.drawText("Battle-SilverMoon_loop", x4, y + lh * 19, cw);
            this.drawText("Final-Battle01_loop", x4, y + lh * 20, cw);
            this.drawText("Under-the-Moonlight_loop", x4, y + lh * 21, cw);
            this.drawText("ユーフルカ 様", x5, y + lh * 22, cw);

            this.drawText("魔王魂 ループ  ファンタジー03", x4, y + lh * 24, cw);
            this.drawText("魔王魂 ループ  ファンタジー04", x4, y + lh * 25, cw);
            this.drawText("魔王魂 ループ BGM ネオロック09", x4, y + lh * 26, cw);
            this.drawText("魔王魂 ループ BGM ネオロック13", x4, y + lh * 27, cw);
            this.drawText("魔王魂 ループ BGM ネオロック66", x4, y + lh * 28, cw);
            this.drawText("魔王魂 ループ BGM ネオロック80", x4, y + lh * 29, cw);
            this.drawText("魔王魂 様", x5, y + lh * 30, cw);
        }
    };


})();