/*:
 * @target MZ
 * @plugindesc RSTH_IH: サバイバルゲームシステムプラグイン
 * @author © 2025 ReSera_りせら（@MOBIUS1001）
 *
 * このソースコードは無断での転載、複製、改変、再配布、商用利用を固く禁じます。
 * 禁止事項の例：
 * - 本ファイルの全部または一部を許可なくコピー、再配布すること
 * - 本ファイルを改変して配布すること
 * - 商用目的での利用
 */

(() => {

    "use strict";

    // ログ出力制御フラグ（trueでログ出力、falseで抑制）
    //const RSTH_DEBUG_LOG = true;
    const RSTH_DEBUG_LOG = false;

    window.RSTH_IH.Scene_SelectEquipment = class extends Scene_MenuBase {
        create() {
            this.createBackground();
            this.createTitle();
            super.createWindowLayer();

            this.createHelpWindow();
            this.createUnshoPWindow();
            this.createSelectCommandWindow();
            this.createSelectEquipmentWindow();
            this.createSelectItemsWindow();

            //this.createSelectOtomoWindow();
            //this.createOtomoInfo();

            //this._selectOtomoWindow.setInfoWindow(this._infoWindow);

            this.createConfirmReleaseWindow();


            this.createSimpleMessageWindow();
            this.createRemoveHintText();
            this.createHintText();

            this._selectItemsWindow.setConfirmWindow(this._confirmReleaseWindow);

            this.initEquipment();
        }

        createRemoveHintText() {
            const bitmap = new Bitmap(300, 36);
            bitmap.fontSize = 24;
            bitmap.textColor = "#FFFFFF";
            bitmap.drawText("E：装備を外す", 0, 0, 300, 36, "left");

            this._removeHintSprite = new Sprite(bitmap);
            this._removeHintSprite.x = this._unshoPWindow.x - 200;
            this._removeHintSprite.y = this._unshoPWindow.y;
            this._removeHintSprite.visible = false;

            this.addChild(this._removeHintSprite);
        }

        createHintText() {
            const bitmap = new Bitmap(900, 36);
            const x = 240;

            bitmap.fontSize = 24;
            bitmap.textColor = "#FFFFFF";
            bitmap.drawText("↑↓→←：項目選択", 0, 0, 300, 36, "left");
            bitmap.drawText("Enter：項目決定", x, 0, 300, 36, "left");
            bitmap.drawText("Esc：前の画面、項目へ", x * 2, 0, 300, 36, "left");

            this._HintSprite = new Sprite(bitmap);
            this._HintSprite.x = 120;
            this._HintSprite.y = this._unshoPWindow.y;
            this._HintSprite.visible = true;

            this.addChild(this._HintSprite);
        }

        createBackground() {
            this._backgroundSprite = new window.RSTH_IH.Sprite_CharacterSelectBackground();
            this.addChild(this._backgroundSprite);
        }

        createTitle() {
            //this._title = new window.RSTH_IH.Sprite_VerticalTitleText("Select Equipment");
            this._title = new window.RSTH_IH.Sprite_VerticalTitleText("Select Command");
            this.addChild(this._title);
        }

        createConfirmReleaseWindow() {
            const ww = 300;
            const wh = this.calcWindowHeight(3, true);
            const wx = (Graphics.boxWidth - ww) / 2;
            const wy = (Graphics.boxHeight - wh) / 2;
            const rect = new Rectangle(wx, wy, ww, wh);
            this._confirmReleaseWindow = new window.RSTH_IH.Window_ConfirmRelease(rect);
            this._confirmReleaseWindow.setHandler("yes", this.onConfirmYes.bind(this));
            this._confirmReleaseWindow.setHandler("no", this.onConfirmNo.bind(this));
            this._confirmReleaseWindow.openness = 0;
            this.addWindow(this._confirmReleaseWindow);
            this._confirmReleaseWindow.hide();
        }

        createSimpleMessageWindow() {
            const ww = 480;
            const wh = this.calcWindowHeight(1, true);
            const wx = (Graphics.boxWidth - ww) / 2;
            const wy = (Graphics.boxHeight - wh) / 2;
            const rect = new Rectangle(wx, wy, ww, wh);

            const windowClass = class extends Window_Selectable {
                initialize(rect) {
                    super.initialize(rect);
                    this._text = "";
                    this._handlers = {};
                    this.hide();
                }

                setText(text) {
                    this._text = text;
                    this.refresh();
                    this.show();
                    this.activate();
                }

                update() {
                    super.update();
                    this.processHandling();
                }

                isOkEnabled() {
                    return true;
                }

                textWidthEx(text) {
                    const tempTextState = { index: 0, text: text, x: 0, y: 0 };
                    return this.drawTextEx(text, 0, this.contents.height + 100); // 仮の描画で幅取得
                }

                processOk() {
                    this.callOkHandler();
                    this.deactivate();
                    this.hide();
                    SceneManager._scene._selectItemsWindow.activate();
                }

                processCancel() {
                    this.callCancelHandler();
                    this.deactivate();
                    this.hide();
                    SceneManager._scene._selectItemsWindow.activate();
                }

                refresh() {
                    this.contents.clear();
                    const textWidth = this.textWidthEx(this._text);
                    const x = (this.contentsWidth() - textWidth) / 2;
                    this.drawTextEx(this._text, x, 6);
                }

            };


            this._simpleMessageWindow = new windowClass(rect);
            this._simpleMessageWindow.setHandler("ok", () => { });
            this._simpleMessageWindow.setHandler("cancel", () => { });
            this.addWindow(this._simpleMessageWindow);

        }

        lvupEquipment(item) {
            //console.log("item", item);
            //console.log("item.id", item.id);
            //console.log("ConfigManager.Actor1_Weapon2", ConfigManager.Actor1_Weapon2);

            if (item.type === "Weapon") {
                // ConfigManager.Actor1_Weapon1
                if (item.id === 2) {
                    if (!ConfigManager.Actor1_Weapon1[1].released) return false;
                }
                else if (item.id === 3) {
                    if (!ConfigManager.Actor1_Weapon1[2].released) return false;
                }
                else if (item.id === 4) {
                    if (!ConfigManager.Actor1_Weapon1[3].released) return false;
                }
                else if (item.id === 5) {
                    if (!ConfigManager.Actor1_Weapon1[4].released) return false;
                }
                else if (item.id === 6) {
                    if (!ConfigManager.Actor1_Weapon1[5].released) return false;
                }
                else if (item.id === 7) {
                    if (!ConfigManager.Actor1_Weapon1[6].released) return false;
                }
                else if (item.id === 8) {
                    if (!ConfigManager.Actor1_Weapon1[7].released) return false;
                }
                else if (item.id === 9) {
                    if (!ConfigManager.Actor1_Weapon1[8].released) return false;
                }

                // ConfigManager.Actor1_Weapon2
                if (item.id === 14) {
                    if (!ConfigManager.Actor1_Weapon2[13].released) return false;
                }
                else if (item.id === 15) {
                    if (!ConfigManager.Actor1_Weapon2[14].released) return false;
                }
                else if (item.id === 16) {
                    if (!ConfigManager.Actor1_Weapon2[15].released) return false;
                }
                else if (item.id === 17) {
                    if (!ConfigManager.Actor1_Weapon2[16].released) return false;
                }
                else if (item.id === 18) {
                    if (!ConfigManager.Actor1_Weapon2[17].released) return false;
                }
                else if (item.id === 19) {
                    if (!ConfigManager.Actor1_Weapon2[18].released) return false;
                }
                else if (item.id === 20) {
                    if (!ConfigManager.Actor1_Weapon2[19].released) return false;
                }
                else if (item.id === 21) {
                    if (!ConfigManager.Actor1_Weapon2[20].released) return false;
                }

                // スターファイア
                if (item.id === 91) {
                    if (!ConfigManager.Actor1_Weapon2[90].released ||
                        !ConfigManager.Actor2_Weapon2[90].released ||
                        !ConfigManager.Actor3_Weapon2[90].released)
                        return false;
                }
                else if (item.id === 92) {
                    if (!ConfigManager.Actor1_Weapon2[91].released ||
                        !ConfigManager.Actor2_Weapon2[91].released ||
                        !ConfigManager.Actor3_Weapon2[91].released)
                        return false;
                }
                else if (item.id === 93) {
                    if (!ConfigManager.Actor1_Weapon2[92].released ||
                        !ConfigManager.Actor2_Weapon2[92].released ||
                        !ConfigManager.Actor3_Weapon2[92].released)
                        return false;
                }
                else if (item.id === 94) {
                    if (!ConfigManager.Actor1_Weapon2[93].released ||
                        !ConfigManager.Actor2_Weapon2[93].released ||
                        !ConfigManager.Actor3_Weapon2[93].released)
                        return false;
                }

                // ConfigManager.Actor1_Weapon3
                if (item.id === 67) {
                    if (!ConfigManager.Actor1_Weapon3[43].released) return false;
                }
                else if (item.id === 68) {
                    if (!ConfigManager.Actor1_Weapon3[67].released) return false;
                }
                else if (item.id === 69) {
                    if (!ConfigManager.Actor1_Weapon3[68].released) return false;
                }
                else if (item.id === 72) {
                    if (!ConfigManager.Actor1_Weapon3[69].released) return false;
                }
                // 紅葉
                if (item.id === 74) {
                    if (!ConfigManager.Actor1_Weapon3[73].released ||
                        !ConfigManager.Actor2_Weapon3[73].released ||
                        !ConfigManager.Actor3_Weapon3[73].released)
                        return false;
                }
                else if (item.id === 75) {
                    if (!ConfigManager.Actor1_Weapon3[74].released ||
                        !ConfigManager.Actor2_Weapon3[74].released ||
                        !ConfigManager.Actor3_Weapon3[74].released)
                        return false;
                }
                else if (item.id === 76) {
                    if (!ConfigManager.Actor1_Weapon3[75].released ||
                        !ConfigManager.Actor2_Weapon3[75].released ||
                        !ConfigManager.Actor3_Weapon3[75].released)
                        return false;
                }
                else if (item.id === 77) {
                    if (!ConfigManager.Actor1_Weapon3[76].released ||
                        !ConfigManager.Actor2_Weapon3[76].released ||
                        !ConfigManager.Actor3_Weapon3[76].released)
                        return false;
                }

                // ConfigManager.Actor1_Weapon4
                if (item.id === 59) {
                    if (!ConfigManager.Actor1_Weapon4[12].released) return false;
                }
                else if (item.id === 60) {
                    if (!ConfigManager.Actor1_Weapon4[59].released) return false;
                }
                else if (item.id === 61) {
                    if (!ConfigManager.Actor1_Weapon4[60].released) return false;
                }
                else if (item.id === 62) {
                    if (!ConfigManager.Actor1_Weapon4[61].released) return false;
                }


                // Actor2
                // ConfigManager.Actor2_Weapon1
                if (item.id === 23) {
                    if (!ConfigManager.Actor2_Weapon1[22].released) return false;
                }
                else if (item.id === 24) {
                    if (!ConfigManager.Actor2_Weapon1[23].released) return false;
                }
                else if (item.id === 25) {
                    if (!ConfigManager.Actor2_Weapon1[24].released) return false;
                }
                else if (item.id === 26) {
                    if (!ConfigManager.Actor2_Weapon1[25].released) return false;
                }
                else if (item.id === 27) {
                    if (!ConfigManager.Actor2_Weapon1[26].released) return false;
                }
                else if (item.id === 28) {
                    if (!ConfigManager.Actor2_Weapon1[27].released) return false;
                }
                else if (item.id === 29) {
                    if (!ConfigManager.Actor2_Weapon1[28].released) return false;
                }
                else if (item.id === 30) {
                    if (!ConfigManager.Actor2_Weapon1[29].released) return false;
                }

                // ConfigManager.Actor2_Weapon2
                if (item.id === 51) {
                    if (!ConfigManager.Actor2_Weapon2[50].released) return false;
                }
                else if (item.id === 52) {
                    if (!ConfigManager.Actor2_Weapon2[51].released) return false;
                }
                else if (item.id === 53) {
                    if (!ConfigManager.Actor2_Weapon2[52].released) return false;
                }
                else if (item.id === 54) {
                    if (!ConfigManager.Actor2_Weapon2[53].released) return false;
                }
                else if (item.id === 55) {
                    if (!ConfigManager.Actor2_Weapon2[54].released) return false;
                }
                else if (item.id === 56) {
                    if (!ConfigManager.Actor2_Weapon2[55].released) return false;
                }
                else if (item.id === 57) {
                    if (!ConfigManager.Actor2_Weapon2[56].released) return false;
                }
                else if (item.id === 58) {
                    if (!ConfigManager.Actor2_Weapon2[57].released) return false;
                }

                // ConfigManager.Actor2_Weapon3
                if (item.id === 39) {
                    if (!ConfigManager.Actor2_Weapon3[38].released) return false;
                }
                else if (item.id === 40) {
                    if (!ConfigManager.Actor2_Weapon3[39].released) return false;
                }
                else if (item.id === 41) {
                    if (!ConfigManager.Actor2_Weapon3[40].released) return false;
                }
                else if (item.id === 42) {
                    if (!ConfigManager.Actor2_Weapon3[41].released) return false;
                }

                // ConfigManager.Actor2_Weapon4
                if (item.id === 63) {
                    if (!ConfigManager.Actor2_Weapon4[33].released) return false;
                }
                else if (item.id === 64) {
                    if (!ConfigManager.Actor2_Weapon4[63].released) return false;
                }
                else if (item.id === 65) {
                    if (!ConfigManager.Actor2_Weapon4[64].released) return false;
                }
                else if (item.id === 66) {
                    if (!ConfigManager.Actor2_Weapon4[65].released) return false;
                }
            }

            // Actor3
            // ConfigManager.Actor3_Weapon1
            if (item.id === 101) {
                if (!ConfigManager.Actor3_Weapon1[100].released) return false;
            }
            else if (item.id === 102) {
                if (!ConfigManager.Actor3_Weapon1[101].released) return false;
            }
            else if (item.id === 103) {
                if (!ConfigManager.Actor3_Weapon1[102].released) return false;
            }
            else if (item.id === 104) {
                if (!ConfigManager.Actor3_Weapon1[103].released) return false;
            }
            else if (item.id === 105) {
                if (!ConfigManager.Actor3_Weapon1[104].released) return false;
            }
            else if (item.id === 106) {
                if (!ConfigManager.Actor3_Weapon1[105].released) return false;
            }
            else if (item.id === 107) {
                if (!ConfigManager.Actor3_Weapon1[106].released) return false;
            }
            else if (item.id === 108) {
                if (!ConfigManager.Actor3_Weapon1[107].released) return false;
            }

            // ConfigManager.Actor3_Weapon1
            if (item.id === 114) {
                if (!ConfigManager.Actor3_Weapon3[113].released) return false;
            }
            else if (item.id === 115) {
                if (!ConfigManager.Actor3_Weapon3[114].released) return false;
            }
            else if (item.id === 116) {
                if (!ConfigManager.Actor3_Weapon3[115].released) return false;
            }
            else if (item.id === 117) {
                if (!ConfigManager.Actor3_Weapon3[116].released) return false;
            }

            if (item.type === "Armor") {
                // ConfigManager.Actor1_Armor1
                if (item.id === 28) {
                    if (!ConfigManager.Actor1_Armor1[27].released) return false;
                }
                else if (item.id === 29) {
                    if (!ConfigManager.Actor1_Armor1[28].released) return false;
                }
                else if (item.id === 30) {
                    if (!ConfigManager.Actor1_Armor1[29].released) return false;
                }

                // ConfigManager.Actor1_Armor2
                if (item.id === 47) {
                    if (!ConfigManager.Actor1_Armor2[46].released) return false;
                }
                else if (item.id === 48) {
                    if (!ConfigManager.Actor1_Armor2[47].released) return false;
                }
                else if (item.id === 49) {
                    if (!ConfigManager.Actor1_Armor2[48].released) return false;
                }
                else if (item.id === 50) {
                    if (!ConfigManager.Actor1_Armor2[49].released) return false;
                }
                else if (item.id === 58) {
                    if (!ConfigManager.Actor1_Armor2[50].released) return false;
                }
                else if (item.id === 59) {
                    if (!ConfigManager.Actor1_Armor2[58].released) return false;
                }

                // ConfigManager.Actor1_Armor3
                if (item.id === 3) {
                    if (!ConfigManager.Actor1_Armor3[2].released) return false;
                }
                else if (item.id === 4) {
                    if (!ConfigManager.Actor1_Armor3[3].released) return false;
                }
                else if (item.id === 5) {
                    if (!ConfigManager.Actor1_Armor3[4].released) return false;
                }
                else if (item.id === 6) {
                    if (!ConfigManager.Actor1_Armor3[5].released) return false;
                }
                else if (item.id === 7) {
                    if (!ConfigManager.Actor1_Armor3[6].released) return false;
                }

                // ConfigManager.Actor1_Armor4
                if (item.id === 74) {
                    if (!ConfigManager.Actor1_Armor4[73].released) return false;
                }
                else if (item.id === 75) {
                    if (!ConfigManager.Actor1_Armor4[74].released) return false;
                }
                else if (item.id === 80) {
                    if (!ConfigManager.Actor1_Armor4[75].released) return false;
                }


                // ConfigManager.Actor2_Armor1
                if (item.id === 34) {
                    if (!ConfigManager.Actor2_Armor1[33].released) return false;
                }
                else if (item.id === 35) {
                    if (!ConfigManager.Actor2_Armor1[34].released) return false;
                }
                else if (item.id === 36) {
                    if (!ConfigManager.Actor2_Armor1[35].released) return false;
                }

                // ConfigManager.Actor2_Armor2
                if (item.id === 52) {
                    if (!ConfigManager.Actor2_Armor2[51].released) return false;
                }
                else if (item.id === 53) {
                    if (!ConfigManager.Actor2_Armor2[52].released) return false;
                }
                else if (item.id === 54) {
                    if (!ConfigManager.Actor2_Armor2[53].released) return false;
                }
                else if (item.id === 55) {
                    if (!ConfigManager.Actor2_Armor2[54].released) return false;
                }

                // ConfigManager.Actor2_Armor3
                if (item.id === 9) {
                    if (!ConfigManager.Actor2_Armor3[8].released) return false;
                }
                else if (item.id === 10) {
                    if (!ConfigManager.Actor2_Armor3[9].released) return false;
                }
                else if (item.id === 11) {
                    if (!ConfigManager.Actor2_Armor3[10].released) return false;
                }
                else if (item.id === 12) {
                    if (!ConfigManager.Actor2_Armor3[11].released) return false;
                }
                else if (item.id === 13) {
                    if (!ConfigManager.Actor2_Armor3[12].released) return false;
                }

                // ConfigManager.Actor2_Armor4
                if (item.id === 77) {
                    if (!ConfigManager.Actor2_Armor4[76].released) return false;
                }
                else if (item.id === 78) {
                    if (!ConfigManager.Actor2_Armor4[77].released) return false;
                }
                else if (item.id === 79) {
                    if (!ConfigManager.Actor2_Armor4[78].released) return false;
                }

                //Actor3
                // ConfigManager.Actor3_Armor2
                if (item.id === 57) {
                    if (!ConfigManager.Actor3_Armor2[56].released) return false;
                }
                else if (item.id === 60) {
                    if (!ConfigManager.Actor3_Armor2[57].released) return false;
                }
                else if (item.id === 61) {
                    if (!ConfigManager.Actor3_Armor2[60].released) return false;
                }
                else if (item.id === 62) {
                    if (!ConfigManager.Actor3_Armor2[61].released) return false;
                }
                else if (item.id === 63) {
                    if (!ConfigManager.Actor3_Armor2[62].released) return false;
                }

                // ConfigManager.Actor3_Armor4
                if (item.id === 82) {
                    if (!ConfigManager.Actor3_Armor4[81].released) return false;
                }
                else if (item.id === 83) {
                    if (!ConfigManager.Actor3_Armor4[82].released) return false;
                }
                else if (item.id === 84) {
                    if (!ConfigManager.Actor3_Armor4[83].released) return false;
                }
            }

            if (item.type === "Otomo") {
                // ConfigManager.Actor1_Otomo1
                if (item.id === 81) {
                    if (!ConfigManager.Actor1_Otomo1[80].released ||
                        !ConfigManager.Actor2_Otomo1[80].released ||
                        !ConfigManager.Actor3_Otomo1[80].released
                    )
                        return false;
                }
                else if (item.id === 82) {
                    if (!ConfigManager.Actor1_Otomo1[81].released ||
                        !ConfigManager.Actor2_Otomo1[81].released ||
                        !ConfigManager.Actor3_Otomo1[81].released
                    )
                        return false;
                }
                else if (item.id === 83) {
                    if (!ConfigManager.Actor1_Otomo1[82].released ||
                        !ConfigManager.Actor2_Otomo1[82].released ||
                        !ConfigManager.Actor3_Otomo1[82].released
                    )
                        return false;
                }
                else if (item.id === 84) {
                    if (!ConfigManager.Actor1_Otomo1[83].released ||
                        !ConfigManager.Actor2_Otomo1[83].released ||
                        !ConfigManager.Actor3_Otomo1[83].released
                    )
                        return false;
                }

                //ぽきゅゆり
                if (item.id === 86) {
                    if (!ConfigManager.Actor1_Otomo1[85].released ||
                        !ConfigManager.Actor2_Otomo1[85].released ||
                        !ConfigManager.Actor3_Otomo1[85].released
                    )
                        return false;
                }
                else if (item.id === 87) {
                    if (!ConfigManager.Actor1_Otomo1[86].released ||
                        !ConfigManager.Actor2_Otomo1[86].released ||
                        !ConfigManager.Actor3_Otomo1[86].released
                    )
                        return false;
                }
                else if (item.id === 88) {
                    if (!ConfigManager.Actor1_Otomo1[87].released ||
                        !ConfigManager.Actor2_Otomo1[87].released ||
                        !ConfigManager.Actor3_Otomo1[87].released
                    )
                        return false;
                }
                else if (item.id === 89) {
                    if (!ConfigManager.Actor1_Otomo1[88].released ||
                        !ConfigManager.Actor2_Otomo1[88].released ||
                        !ConfigManager.Actor3_Otomo1[88].released
                    )
                        return false;
                }
            }

            return true;
        }


        onConfirmYes() {
            const i = this._selectItemsWindow.index();
            if (i < 0) return;
            const cost = this._selectItemsWindow._items[i].cost;
            window.RSTH_IH.unshoP = ConfigManager.unshoP;
            //console.log("i", i);
            //console.log("this._selectItemsWindow._items[i]", this._selectItemsWindow._items[i]);
            //console.log("cost", cost);
            if (window.RSTH_IH.unshoP >= cost) {

                const targetName = this._selectItemsWindow._items[i].name;
                let foundKey = null;
                let foundId = null;

                for (const key in ConfigManager) {
                    const list = ConfigManager[key];
                    if (!list || typeof list !== "object") continue;

                    for (const id in list) {
                        const item = list[id];
                        if (item && item.name === targetName) {
                            foundKey = key;
                            foundId = Number(id);
                            //console.log("一致:", item);

                            break;
                        }
                    }

                    if (foundKey) break;
                }

                let cfoundKey = [];// 共通アイテム類のキー定義

                if (foundKey && foundId != null) {
                    const item = ConfigManager[foundKey][foundId];
                    if (item.type === "Weapon") {

                        if ([90, 91, 92, 93, 94].includes(item.id)) {
                            cfoundKey = ["Actor1_Weapon2", "Actor2_Weapon2", "Actor3_Weapon2"];
                        }
                        if ([73, 74, 75, 76, 77].includes(item.id)) {
                            cfoundKey = ["Actor1_Weapon3", "Actor2_Weapon3", "Actor3_Weapon3"];
                        }
                    }
                    if (item.type === "Item") {

                        if (item.id === 7) {
                            cfoundKey = ["Actor1_Item1", "Actor2_Item1", "Actor3_Item1"];
                        }

                        else if (item.id === 8) {
                            cfoundKey = ["Actor1_Item2", "Actor2_Item2", "Actor3_Item2"];
                        }

                        else if (item.id === 9) {
                            cfoundKey = ["Actor1_Item3", "Actor2_Item3", "Actor3_Item3"];

                        }

                    }
                    if (item.type === "Otomo") {

                        if ([80, 81, 82, 83, 84, 85, 86, 87, 88, 89].includes(item.id)) {
                            cfoundKey = ["Actor1_Otomo1", "Actor2_Otomo1", "Actor3_Otomo1"];
                        }

                    }

                    if (item.type === "Skill") {

                        if ([71, 78, 121].includes(item.id)) {
                            cfoundKey = ["Actor1_Skill1", "Actor2_Skill1", "Actor3_Skill1"];
                        }
                        if ([79, 96].includes(item.id)) {
                            cfoundKey = ["Actor1_Skill2", "Actor2_Skill2", "Actor3_Skill2"];
                        }
                        if ([95, 97, 98].includes(item.id)) {
                            cfoundKey = ["Actor1_Skill3", "Actor2_Skill3", "Actor3_Skill3"];
                        }
                    }

                    const lvupflag = this.lvupEquipment(item);

                    //console.log("foundKey", foundKey);
                    //console.log("foundKey.length", foundKey.length);
                    //console.log("foundId", foundId);

                    if (!lvupflag) {
                        this._confirmReleaseWindow.close();
                        this._simpleMessageWindow.setText("前の項目を先に解放して下さい");
                        this._simpleMessageWindow.activate();

                    }
                    else if (lvupflag) {
                        if (cfoundKey.length > 1) {
                            for (let i = 0; i < cfoundKey.length; i++) {
                                ConfigManager[cfoundKey[i]][foundId].released = true;
                            }
                        } else {
                            ConfigManager[foundKey][foundId].released = true;

                        }
                        //console.log("foundKey", foundKey);
                        //console.log("cfoundKey", cfoundKey);
                        //console.log("cfoundKey.length", cfoundKey.length);
                        window.RSTH_IH.unshoP = window.RSTH_IH.unshoP - cost;
                        ConfigManager.unshoP = window.RSTH_IH.unshoP;

                        ConfigManager.save();

                        this._selectItemsWindow.refresh();
                        this._unshoPWindow.refresh();
                        //console.log("ConfigManager[foundKey][foundId]", ConfigManager[foundKey][foundId]);
                        this._confirmReleaseWindow.close();
                        this._selectItemsWindow.activate();
                    }
                    else {
                        this._selectItemsWindow.refresh();
                        this._unshoPWindow.refresh();
                        this._confirmReleaseWindow.close();
                        this._selectItemsWindow.activate();
                    }

                }
            } else {
                this._confirmReleaseWindow.close();
                this._simpleMessageWindow.setText("うんしょポイントが足りません！");
                this._simpleMessageWindow.activate();
            }




        }

        onConfirmNo() {
            this._confirmReleaseWindow.close();
            this._selectItemsWindow.activate();
        }

        createHelpWindow() {
            const rect = this.helpWindowRect();
            this._helpWindow = new Window_Help(rect);
            this.addWindow(this._helpWindow);
            this._helpWindow.hide();

        }

        helpWindowRect() {
            const margin = 6;
            const wx = 120 + margin * 2 + 200;
            const wy = this.helpAreaTop() + margin;
            const ww = Graphics.boxWidth - wx - margin;
            const wh = this.helpAreaHeight() - margin;
            return new Rectangle(wx, wy, ww, wh);

        }


        createUnshoPWindow() {
            const ww = 480;
            const wh = this.calcWindowHeight(1, true);
            const wy = 6;
            const wx = Graphics.boxWidth - ww - 6;
            const rect = new Rectangle(wx, wy, ww, wh);

            this._unshoPWindow = new window.RSTH_IH.Window_UnshoP(rect);

            window.RSTH_IH.unshoP = ConfigManager.unshoP;

            this.addWindow(this._unshoPWindow);
            this._unshoPWindow.deactivate();
        }

        createSelectCommandWindow() {
            const margin = 6;
            const ww = 200;
            const wh = this.calcWindowHeight(5, true);
            const wx = 120 + margin;
            const wy = margin * 2 + this.calcWindowHeight(1, true) + 3;
            const rect = new Rectangle(wx, wy, ww, wh);

            this._selectEquipmentCommandWindow = new window.RSTH_IH.Window_SelectEquipmentCommand(rect);
            this._selectEquipmentCommandWindow.setHandler("map", this.commandMap.bind(this));
            this._selectEquipmentCommandWindow.setHandler("chara", this.commandChara.bind(this));
            this._selectEquipmentCommandWindow.setHandler("equipment", this.commandWeapon.bind(this));
            //this._selectEquipmentCommandWindow.setHandler("otomo", this.commandOtomo.bind(this));
            this._selectEquipmentCommandWindow.setHandler("powerup", this.commandPowerup.bind(this));
            this._selectEquipmentCommandWindow.setHandler("next", this.commandNext.bind(this));
            this.addChild(this._selectEquipmentCommandWindow);
            this._selectEquipmentCommandWindow.activate();
            this._selectEquipmentCommandWindow.select(0);

        }

        initEquipment() {
            //console.log("ConfigManager.InitEquipActor1Slots", ConfigManager.InitEquipActor1Slots);
            if (ConfigManager.InitEquipActor1Slots && window.RSTH_IH._selectedActorId === 1) {
                this._selectEquipmentWindow.setSlots(ConfigManager.InitEquipActor1Slots);
            }
            else if (ConfigManager.InitEquipActor2Slots && window.RSTH_IH._selectedActorId === 2) {
                this._selectEquipmentWindow.setSlots(ConfigManager.InitEquipActor2Slots);
            }
            else if (ConfigManager.InitEquipActor3Slots && window.RSTH_IH._selectedActorId === 3) {
                this._selectEquipmentWindow.setSlots(ConfigManager.InitEquipActor3Slots);
            }
            else {
                this._selectEquipmentWindow.setSlots([
                    { label: "近接：", value: "", count: null, type: "weapon1", itemtype: "" },
                    { label: "遠距離A：", value: "", count: null, type: "weapon2", itemtype: "" },
                    { label: "遠距離B：", value: "", count: null, type: "weapon3", itemtype: "" },
                    { label: "特殊：", value: "", count: null, type: "weapon4", itemtype: "" },
                    { label: "盾：", value: "", count: null, type: "armor1", itemtype: "" },
                    { label: "頭：", value: "", count: null, type: "armor2", itemtype: "" },
                    { label: "身体：", value: "", count: null, type: "armor3", itemtype: "" },
                    { label: "装飾品1：", value: "", count: null, type: "armor4", itemtype: "" },
                    { label: "装飾品2：", value: "", count: null, type: "armor4", itemtype: "" },
                    { label: "スキルA：", value: "", count: null, type: "skill1", itemtype: "" },
                    { label: "スキルB：", value: "", count: null, type: "skill2", itemtype: "" },
                    { label: "スキルC：", value: "", count: null, type: "skill3", itemtype: "" },
                    { label: "アイテムA：", value: "", count: null, type: "item1", itemtype: "" },
                    { label: "アイテムB：", value: "", count: null, type: "item2", itemtype: "" },
                    { label: "アイテムC：", value: "", count: null, type: "item3", itemtype: "" },
                    { label: "お供：", value: "", count: null, type: "otomo1", itemtype: "" },
                ]);

                const slots = this._selectEquipmentWindow._slots;

                // 初期装備
                // ActorId === 1
                if (window.RSTH_IH._selectedActorId === 1) {
                    let slot = null;
                    slot = slots.find(s => s.type === "weapon1");
                    if (slot) {
                        const data = ConfigManager.Actor1_Weapon1[1];
                        slot.id = data.id;
                        slot.value = data.name;
                        slot.itemtype = data.type;
                        slot.count = 1;
                    }
                    slot = slots.find(s => s.type === "weapon3");
                    if (slot) {
                        const data = ConfigManager.Actor1_Weapon3[43];
                        slot.id = data.id;
                        slot.value = data.name;
                        slot.itemtype = data.type;
                        slot.count = 1;
                    }
                    slot = slots.find(s => s.type === "skill1");
                    if (slot) {
                        const data = ConfigManager.Actor1_Skill1[44];
                        slot.id = data.id;
                        slot.value = data.name;
                        slot.itemtype = data.type;
                        slot.count = 1;
                    }
                    slot = slots.find(s => s.type === "skill2");
                    if (slot) {
                        const data = ConfigManager.Actor1_Skill2[45];
                        slot.id = data.id;
                        slot.value = data.name;
                        slot.itemtype = data.type;
                        slot.count = 1;
                    }
                    slot = slots.find(s => s.type === "skill3");
                    if (slot) {
                        const data = ConfigManager.Actor1_Skill3[46];
                        slot.id = data.id;
                        slot.value = data.name;
                        slot.itemtype = data.type;
                        slot.count = 1;
                    }
                    slot = slots.find(s => s.type === "armor1");
                    if (slot) {
                        const data = ConfigManager.Actor1_Armor1[27];
                        slot.id = data.id;
                        slot.value = data.name;
                        slot.itemtype = data.type;
                        slot.count = 1;
                    }
                    slot = slots.find(s => s.type === "armor2");
                    if (slot) {
                        const data = ConfigManager.Actor1_Armor2[47];
                        slot.id = data.id;
                        slot.value = data.name;
                        slot.itemtype = data.type;
                        slot.count = 1;
                    }
                    slot = slots.find(s => s.type === "armor3");
                    if (slot) {
                        const data = ConfigManager.Actor1_Armor3[3];
                        slot.id = data.id;
                        slot.value = data.name;
                        slot.itemtype = data.type;
                        slot.count = 1;
                    }
                    slot = slots.find(s => s.type === "item1");
                    if (slot) {
                        const data = ConfigManager.Actor1_Item1[7];
                        slot.id = data.id;
                        slot.value = data.name;
                        slot.itemtype = data.type;
                        slot.count = 10;
                    }

                    ConfigManager.InitEquipActor1Slots = this._selectEquipmentWindow._slots;
                    ConfigManager.save();
                }
                // ActorId === 2
                if (window.RSTH_IH._selectedActorId === 2) {
                    let slot = null;
                    slot = slots.find(s => s.type === "weapon1");
                    if (slot) {
                        const data = ConfigManager.Actor2_Weapon1[22];
                        slot.id = data.id;
                        slot.value = data.name;
                        slot.itemtype = data.type;
                        slot.count = 1;
                    }
                    slot = slots.find(s => s.type === "weapon3");
                    if (slot) {
                        const data = ConfigManager.Actor2_Weapon3[38];
                        slot.id = data.id;
                        slot.value = data.name;
                        slot.itemtype = data.type;
                        slot.count = 1;
                    }
                    slot = slots.find(s => s.type === "weapon4");
                    if (slot) {
                        const data = ConfigManager.Actor2_Weapon4[33];
                        slot.id = data.id;
                        slot.value = data.name;
                        slot.itemtype = data.type;
                        slot.count = 1;
                    }
                    slot = slots.find(s => s.type === "skill1");
                    if (slot) {
                        const data = ConfigManager.Actor2_Skill1[47];
                        slot.id = data.id;
                        slot.value = data.name;
                        slot.itemtype = data.type;
                        slot.count = 1;
                    }
                    slot = slots.find(s => s.type === "skill2");
                    if (slot) {
                        const data = ConfigManager.Actor2_Skill2[48];
                        slot.id = data.id;
                        slot.value = data.name;
                        slot.itemtype = data.type;
                        slot.count = 1;
                    }
                    slot = slots.find(s => s.type === "skill3");
                    if (slot) {
                        const data = ConfigManager.Actor2_Skill3[49];
                        slot.id = data.id;
                        slot.value = data.name;
                        slot.itemtype = data.type;
                        slot.count = 1;
                    }
                    slot = slots.find(s => s.type === "armor3");
                    if (slot) {
                        const data = ConfigManager.Actor2_Armor3[8];
                        slot.id = data.id;
                        slot.value = data.name;
                        slot.itemtype = data.type;
                        slot.count = 1;
                    }
                    slot = slots.find(s => s.type === "item1");
                    if (slot) {
                        const data = ConfigManager.Actor2_Item1[7];
                        slot.id = data.id;
                        slot.value = data.name;
                        slot.itemtype = data.type;
                        slot.count = 10;
                    }

                    ConfigManager.InitEquipActor2Slots = this._selectEquipmentWindow._slots;
                    ConfigManager.save();
                }

                if (window.RSTH_IH._selectedActorId === 3) {
                    let slot = null;
                    slot = slots.find(s => s.type === "weapon1");
                    if (slot) {
                        const data = ConfigManager.Actor3_Weapon1[100];
                        slot.id = data.id;
                        slot.value = data.name;
                        slot.itemtype = data.type;
                        slot.count = 1;
                    }
                    slot = slots.find(s => s.type === "weapon3");
                    if (slot) {
                        const data = ConfigManager.Actor3_Weapon3[113];
                        slot.id = data.id;
                        slot.value = data.name;
                        slot.itemtype = data.type;
                        slot.count = 1;
                    }
                    slot = slots.find(s => s.type === "skill1");
                    if (slot) {
                        const data = ConfigManager.Actor3_Skill1[118];
                        slot.id = data.id;
                        slot.value = data.name;
                        slot.itemtype = data.type;
                        slot.count = 1;
                    }
                    slot = slots.find(s => s.type === "skill2");
                    if (slot) {
                        const data = ConfigManager.Actor3_Skill2[119];
                        slot.id = data.id;
                        slot.value = data.name;
                        slot.itemtype = data.type;
                        slot.count = 1;
                    }
                    slot = slots.find(s => s.type === "skill3");
                    if (slot) {
                        const data = ConfigManager.Actor3_Skill3[120];
                        slot.id = data.id;
                        slot.value = data.name;
                        slot.itemtype = data.type;
                        slot.count = 1;
                    }
                    slot = slots.find(s => s.type === "item1");
                    if (slot) {
                        const data = ConfigManager.Actor3_Item1[7];
                        slot.id = data.id;
                        slot.value = data.name;
                        slot.itemtype = data.type;
                        slot.count = 10;
                    }

                    ConfigManager.InitEquipActor3Slots = this._selectEquipmentWindow._slots;
                    ConfigManager.save();
                }
                //console.log("this._selectEquipmentWindow._slots", this._selectEquipmentWindow._slots);
            }
        }

        commandWeapon() {
            this._selectEquipmentCommandWindow.deactivate();
            this._selectEquipmentWindow.refresh();
            this._selectEquipmentWindow.show();

            this._helpWindow.contents.clear();
            this._helpWindow.refresh();
            this._helpWindow.show();
            this._selectEquipmentWindow.activate();
        }

        createSelectOtomoWindow() {
            const margin = 6;
            const gw = Graphics.boxWidth;
            const gh = Graphics.boxHeight - this.helpAreaHeight();
            const wx = 120 + this._selectEquipmentCommandWindow.width + margin * 2;
            const wy = margin * 2 + this.calcWindowHeight(1, true);
            const ww = Math.round(gw - this._selectEquipmentCommandWindow.width - 120 - margin * 4) / 2;
            const wh = gh - margin * 2;
            const rect = new Rectangle(wx, wy, ww, wh);

            this._selectOtomoWindow = new window.RSTH_IH.Window_SelectOtomoWindow(rect);
            this._selectOtomoWindow.deactivate();
            this._selectOtomoWindow.hide();
            this.addWindow(this._selectOtomoWindow);

        }

        createOtomoInfo() {
            const margin = 6;
            const gw = Graphics.boxWidth;
            const gh = Graphics.boxHeight - this.helpAreaHeight();
            const ww = Math.round(gw - this._selectEquipmentCommandWindow.width - 120 - margin * 4) / 2;
            const wh = gh - margin * 2;
            const wx = gw - ww - margin;
            const wy = margin * 2 + this.calcWindowHeight(1, true);
            const rect = new Rectangle(wx, wy, ww, wh);

            this._infoWindow = new window.RSTH_IH.Window_OtomoInfo(rect);
            this.addWindow(this._infoWindow);
            this._infoWindow.deactivate();
            this._infoWindow.hide();

        }

        commandOtomo() {
            //this._infoWindow.setOtomoId();
            this._infoWindow.refresh();
            this._infoWindow.show();

            this._selectOtomoWindow.setOtomos();

            this._selectOtomoWindow.activate();
            this._selectOtomoWindow.refresh();
            this._selectOtomoWindow.show();

        }

        commandMap() {
            window.RSTH_IH.slideScene(this, window.RSTH_IH.Scene_SelectMap, "left", 30);
        }

        commandChara() {
            window.RSTH_IH.slideScene(this, window.RSTH_IH.Scene_SelectCharacter, "left", 30);
        }

        commandPowerup() {
            SceneManager.push(window.RSTH_IH.Scene_UnshoShop);
        }

        commandNext() {
            window.RSTH_IH._calledFromSelectMap = true;
            SceneManager.push(window.RSTH_IH.Scene_OptionsCustom);
        }


        createSelectEquipmentWindow() {
            const margin = 6;
            const gw = Graphics.boxWidth;
            const gh = Graphics.boxHeight - this.helpAreaHeight();
            const wx = 120 + this._selectEquipmentCommandWindow.width + margin * 2;
            const wy = margin * 2 + this.calcWindowHeight(1, true);
            const ww = Math.round(gw - this._selectEquipmentCommandWindow.width - 120 - margin * 4) / 2;
            const wh = gh - margin * 2 - this.calcWindowHeight(1, true);
            const rect = new Rectangle(wx, wy, ww, wh);

            this._selectEquipmentWindow = new window.RSTH_IH.Window_SelectEquipmentWindow(rect);

            this._selectEquipmentWindow.deactivate();
            this._selectEquipmentWindow.hide();
            this._selectEquipmentWindow.setHelpWindow(this._helpWindow);
            this._selectEquipmentWindow.setHandler("ok", this._selectEquipmentWindow.processOk.bind(this._selectEquipmentWindow));

            this.addWindow(this._selectEquipmentWindow);


        }

        createSelectItemsWindow() {
            const margin = 6;
            const gw = Graphics.boxWidth;
            const gh = Graphics.boxHeight - this.helpAreaHeight();
            const ww = Math.round(gw - this._selectEquipmentCommandWindow.width - 120 - margin * 4) / 2;
            const wh = gh - margin * 2 - this.calcWindowHeight(1, true);
            const wx = gw - ww - margin;
            const wy = margin * 2 + this.calcWindowHeight(1, true);
            const rect = new Rectangle(wx, wy, ww, wh);

            this._selectItemsWindow = new window.RSTH_IH.Window_SelectItemsWindow(rect);
            this._selectItemsWindow.deactivate();
            this._selectItemsWindow.hide();
            this._selectItemsWindow.setHelpWindow(this._helpWindow);
            this._selectItemsWindow.setHandler("ok", this._selectItemsWindow.processOk.bind(this._selectItemsWindow));

            this.addWindow(this._selectItemsWindow);

        }


        updateRemoveHintVisibility() {
            if (!this._removeHintSprite || !this._selectEquipmentWindow) return;
            this._removeHintSprite.visible = this._selectEquipmentWindow.active;
        }

        update() {
            super.update();
            this.updateRemoveHintVisibility();

            if (Input.isTriggered("cancel") || Input.isTriggered("escape")) {
                SoundManager.playCancel();
                if (this._selectEquipmentWindow.active) {
                    this._selectEquipmentWindow.hide();
                    this._helpWindow.hide();
                    this._helpWindow.contents.clear();
                    this._selectEquipmentWindow.deactivate();
                    this._selectEquipmentCommandWindow.activate();
                }
                else if (this._selectItemsWindow.active) {
                    this._selectItemsWindow.hide();
                    this._selectItemsWindow.deactivate();
                    this._helpWindow.contents.clear();
                    this._selectEquipmentWindow.activate();
                }
                /*
                else if (this._selectOtomoWindow.active) {
                    //SoundManager.playCancel();
                    this._infoWindow.hide();
                    this._selectOtomoWindow.hide();
                    this._selectOtomoWindow.deactivate();
                    this._selectEquipmentCommandWindow.activate();
                }
                */
                else if (this._selectEquipmentCommandWindow.active) {
                    SceneManager.pop();
                }
            }

            if (Input.isTriggered("e")) {
                const win = this._selectEquipmentWindow;
                if (win && win.active) {
                    const index = win.index();
                    const slot = win._slots?.[index];
                    if (slot) {
                        //console.log("slot,index", slot, index);
                        if (slot.id && slot.count > 0) {
                            slot.id = 0;
                            slot.value = "";
                            slot.itemtype = "";
                            slot.count = 0;

                            if (window.RSTH_IH._selectedActorId === 1) {
                                ConfigManager.InitEquipActor1Slots = win._slots;
                            }
                            else if (window.RSTH_IH._selectedActorId === 2) {
                                ConfigManager.InitEquipActor2Slots = win._slots;
                            }
                            else if (window.RSTH_IH._selectedActorId === 3) {
                                ConfigManager.InitEquipActor3Slots = win._slots;
                            }

                            //console.log("win._slots", win._slots);
                            //console.log("ConfigManager.InitEquipActor1Slots", ConfigManager.InitEquipActor1Slots);
                            win.refresh();
                            ConfigManager.save();
                        }
                    }
                }

            }
        }



    }

    window.RSTH_IH.Window_SelectEquipmentCommand = class extends Window_Command {
        constructor(rect) {
            super(rect);
            this._flashCounter = 0;
            this.refresh();
        }

        activate() {
            if (!this.active) {
                super.activate();
                this.select(this.index() >= 0 ? this.index() : 0);
            }
        }

        makeCommandList() {
            this.addCommand("出撃MAP選択", "map");
            this.addCommand("キャラクター選択", "chara");
            this.addCommand("初期装備の設定", "equipment");
            //this.addCommand("お供", "otomo");
            this.addCommand("PowerUP", "powerup");
            this.addCommand("次へ", "next");
        }

        maxItems() {
            return this._list.length; // ← これを追加
        }

        select(index) {
            super.select(index);
            this.opacity = 255;
            this.contentsOpacity = 255;
            this._flashCounter = 10;
        }

        update() {
            super.update();
            if (this._flashCounter > 0) {
                this.opacity = 255;
                this._flashCounter--;
            }
        }

        isCursorMovable() {
            return this.active && this.isOpen();
        }

    };

    window.RSTH_IH.Window_SelectEquipmentWindow = class extends Window_Selectable {
        constructor(rect) {
            super(rect);
            this._slots = [];
            this.refresh();
        }

        setSlots(slots) {
            this._slots = slots;
            this.refresh();
            this.select(0);
        }

        setHelpWindow(helpWindow) {
            this._helpWindow = helpWindow;
        }

        select(index) {
            super.select(index);
            //console.log("index", index);
            this.updateHelp();
        }

        updateHelp() {
            if (!this._helpWindow) return;

            const item = this._slots[this.index()];
            //console.log("item", item);
            if (!item) {
                this._helpWindow.setText("");
                return;
            }

            let baseData = null;

            // item.type の先頭部分で種類判別（例: "weapon1" → "weapon"）
            const typeBase = item.itemtype;
            //console.log("typeBase", typeBase);

            switch (typeBase) {
                case "Weapon":
                case "Skill":
                case "Otomo": // skill も $dataWeapons を使っている
                    baseData = $dataWeapons[item.id];
                    break;
                case "Armor":
                    baseData = $dataArmors[item.id];
                    break;
                case "Item":
                    baseData = $dataItems[item.id];
                    break;
            }

            const description = baseData?.description || "";
            this._helpWindow.setText(description);
            //console.log("description", description);
        }

        maxItems() {
            return this._slots.length;
        }

        itemHeight() {
            return this.lineHeight() + 4;
        }

        drawItem(index) {
            const slot = this._slots[index];
            if (!slot) return;

            const rect = this.itemRect(index);
            const vx = 132;

            this.changeTextColor(ColorManager.systemColor());
            this.drawText(slot.label, rect.x + 6, rect.y, 120, "left");

            this.changeTextColor(ColorManager.normalColor());
            this.drawText(slot.value, rect.x + vx, rect.y, rect.width - vx - 76, "left");

            this.changeTextColor(ColorManager.normalColor());
            let textcount = "x 0";
            if (slot.count !== null) textcount = `x ${slot.count}`;
            this.drawText(textcount, rect.width - 64, rect.y, 96, "left");
        }

        processOk() {
            const index = this.index();
            const slot = this._slots[index];
            let items = [];
            //console.log("slot", slot);

            if (slot) {
                //console.log("$dataArmors", $dataArmors);
                switch (slot.type) {
                    case "weapon1":
                        if (window.RSTH_IH._selectedActorId === 1) {
                            items = ConfigManager.Actor1_Weapon1;
                        }
                        else if (window.RSTH_IH._selectedActorId === 2) {
                            items = ConfigManager.Actor2_Weapon1;
                        }
                        else if (window.RSTH_IH._selectedActorId === 3) {
                            items = ConfigManager.Actor3_Weapon1;
                        }
                        //console.log("items", items);
                        break;
                    case "weapon2":
                        if (window.RSTH_IH._selectedActorId === 1) {
                            items = ConfigManager.Actor1_Weapon2;
                        }
                        else if (window.RSTH_IH._selectedActorId === 2) {
                            items = ConfigManager.Actor2_Weapon2;
                        }
                        else if (window.RSTH_IH._selectedActorId === 3) {
                            items = ConfigManager.Actor3_Weapon2;
                        }
                        break;
                    case "weapon3":
                        if (window.RSTH_IH._selectedActorId === 1) {
                            items = ConfigManager.Actor1_Weapon3;
                        }
                        else if (window.RSTH_IH._selectedActorId === 2) {
                            items = ConfigManager.Actor2_Weapon3;
                        }
                        else if (window.RSTH_IH._selectedActorId === 3) {
                            items = ConfigManager.Actor3_Weapon3;
                        }
                        break;
                    case "weapon4":
                        if (window.RSTH_IH._selectedActorId === 1) {
                            items = ConfigManager.Actor1_Weapon4;
                        }
                        else if (window.RSTH_IH._selectedActorId === 2) {
                            items = ConfigManager.Actor2_Weapon4;
                        }
                        else if (window.RSTH_IH._selectedActorId === 3) {
                            items = ConfigManager.Actor3_Weapon4;
                        }
                        break;
                    case "armor1":
                        if (window.RSTH_IH._selectedActorId === 1) {
                            items = ConfigManager.Actor1_Armor1;
                        }
                        else if (window.RSTH_IH._selectedActorId === 2) {
                            items = ConfigManager.Actor2_Armor1;
                        }
                        else if (window.RSTH_IH._selectedActorId === 3) {
                            items = ConfigManager.Actor3_Armor1;
                        }
                        break;
                    case "armor2":
                        if (window.RSTH_IH._selectedActorId === 1) {
                            items = ConfigManager.Actor1_Armor2;
                        }
                        else if (window.RSTH_IH._selectedActorId === 2) {
                            items = ConfigManager.Actor2_Armor2;
                        }
                        else if (window.RSTH_IH._selectedActorId === 3) {
                            items = ConfigManager.Actor3_Armor2;
                        }
                        break;
                    case "armor3":
                        if (window.RSTH_IH._selectedActorId === 1) {
                            items = ConfigManager.Actor1_Armor3;
                        }
                        else if (window.RSTH_IH._selectedActorId === 2) {
                            items = ConfigManager.Actor2_Armor3;
                        }
                        else if (window.RSTH_IH._selectedActorId === 3) {
                            items = ConfigManager.Actor3_Armor3;
                        }
                        break;
                    case "armor4":
                        if (window.RSTH_IH._selectedActorId === 1) {
                            items = ConfigManager.Actor1_Armor4;
                        }
                        else if (window.RSTH_IH._selectedActorId === 2) {
                            items = ConfigManager.Actor2_Armor4;
                        }
                        else if (window.RSTH_IH._selectedActorId === 3) {
                            items = ConfigManager.Actor3_Armor4;
                        }
                        break;
                    case "skill1":
                        if (window.RSTH_IH._selectedActorId === 1) {
                            items = ConfigManager.Actor1_Skill1;
                        }
                        else if (window.RSTH_IH._selectedActorId === 2) {
                            items = ConfigManager.Actor2_Skill1;
                        }
                        else if (window.RSTH_IH._selectedActorId === 3) {
                            items = ConfigManager.Actor3_Skill1;
                        }
                        break;
                    case "skill2":
                        if (window.RSTH_IH._selectedActorId === 1) {
                            items = ConfigManager.Actor1_Skill2;
                        }
                        else if (window.RSTH_IH._selectedActorId === 2) {
                            items = ConfigManager.Actor2_Skill2;
                        }
                        else if (window.RSTH_IH._selectedActorId === 3) {
                            items = ConfigManager.Actor3_Skill2;
                        }
                        break;
                    case "skill3":
                        if (window.RSTH_IH._selectedActorId === 1) {
                            items = ConfigManager.Actor1_Skill3;
                        }
                        else if (window.RSTH_IH._selectedActorId === 2) {
                            items = ConfigManager.Actor2_Skill3;
                        }
                        else if (window.RSTH_IH._selectedActorId === 3) {
                            items = ConfigManager.Actor3_Skill3;
                        }
                        break;
                    case "item1":
                        if (window.RSTH_IH._selectedActorId === 1) {
                            items = ConfigManager.Actor1_Item1;
                        }
                        else if (window.RSTH_IH._selectedActorId === 2) {
                            items = ConfigManager.Actor2_Item1;
                        }
                        else if (window.RSTH_IH._selectedActorId === 3) {
                            items = ConfigManager.Actor3_Item1;
                        }
                        break;
                    case "item2":
                        if (window.RSTH_IH._selectedActorId === 1) {
                            items = ConfigManager.Actor1_Item2;
                        }
                        else if (window.RSTH_IH._selectedActorId === 2) {
                            items = ConfigManager.Actor2_Item2;
                        }
                        else if (window.RSTH_IH._selectedActorId === 3) {
                            items = ConfigManager.Actor3_Item2;
                        }
                        break;
                    case "item3":
                        if (window.RSTH_IH._selectedActorId === 1) {
                            items = ConfigManager.Actor1_Item3;
                        }
                        else if (window.RSTH_IH._selectedActorId === 2) {
                            items = ConfigManager.Actor2_Item3;
                        }
                        else if (window.RSTH_IH._selectedActorId === 3) {
                            items = ConfigManager.Actor3_Item3;
                        }
                        break;

                    case "otomo1":
                        items = ConfigManager.Actor1_Otomo1;
                }
            }

            // Window_ConfirmRelease がアクティブ化されないように明示的に閉じる
            const scene = SceneManager._scene;
            if (scene._confirmReleaseWindow) {
                scene._confirmReleaseWindow.deactivate();
                scene._confirmReleaseWindow.close();
                scene._confirmReleaseWindow.hide();
            }

            Input.clear();          // キー入力状態リセット
            TouchInput.clear();     // タッチ／クリック状態リセット（必要なら）

            SceneManager._scene._selectItemsWindow.setItems(items);
            SceneManager._scene._selectItemsWindow.show();
            SceneManager._scene._selectItemsWindow.refresh();
            SceneManager._scene._selectItemsWindow.select(0);
            SceneManager._scene._selectItemsWindow.activate();
            SceneManager._scene._helpWindow.refresh();
            this.deactivate();
        }


        refresh() {
            this.contents.clear();
            for (let i = 0; i < this.maxItems(); i++) {
                this.drawItem(i);
            }
        }

    }

    window.RSTH_IH.Window_SelectItemsWindow = class extends Window_Selectable {
        constructor(rect) {
            super(rect);
            this._items = [];

            this.refresh();
        }

        setItems(items) {
            if (!Array.isArray(items)) items = [];

            //console.log("items", items);
            this._items = Object.values(items).filter(item => item && item.name);

            this.refresh();
            this.select(0);
            this._pendingHelpUpdate = true;
        }

        activate() {
            super.activate();
            this.updateHelp(); // ← 追加
        }

        setHelpWindow(helpWindow) {
            this._helpWindow = helpWindow;
        }

        select(index) {
            super.select(index);
            //console.log("index", index);
            this.updateHelp();
        }


        updateHelp() {
            if (!this._helpWindow) return;

            const item = this._items[this.index()];
            //console.log("item", item);
            if (!item) {
                this._helpWindow.setText("");
                return;
            }

            let baseData = null;

            // item.type の先頭部分で種類判別（例: "weapon1" → "weapon"）
            const typeBase = item.type;
            //console.log("typeBase", typeBase);

            switch (typeBase) {
                case "Weapon":
                case "Skill":
                case "Otomo": // skill も $dataWeapons を使っている
                    baseData = $dataWeapons[item.id];
                    break;
                case "Armor":
                    baseData = $dataArmors[item.id];
                    break;
                case "Item":
                    baseData = $dataItems[item.id];
                    break;
            }

            const description = baseData?.description || "";
            this._helpWindow.setText(description);
            //console.log("description", description);
        }

        update() {
            super.update();
            if (this._pendingHelpUpdate) {
                this._pendingHelpUpdate = false;
                this.updateHelp();
            }
        }


        maxItems() {
            return this._items.length;
        }

        itemHeight() {
            return this.lineHeight() + 4;
        }

        drawItem(index) {
            const item = this._items[index];
            if (!item) return;
            //console.log("item", item);

            const rect = this.itemRect(index);
            const vx = 132;

            // 🔽 released の状態に応じて色を変更
            if (item.released === false) {
                this.changeTextColor("rgba(124, 124, 124, 1)");
            } else {
                this.changeTextColor(ColorManager.normalColor());
            }
            this.drawText(item.name, rect.x + 6, rect.y, rect.width - 6, "left");

            const costIconX = rect.x + rect.width - 128;
            const costIconY = rect.y + (rect.height - 32) / 2;

            this.drawIconImage("reward_icon", costIconX, costIconY);

            this.changeTextColor(ColorManager.normalColor());
            this.drawText(`x ${item.cost}`, costIconX + 38, costIconY, 96, "left");
        }

        drawIconImage(filename, x, y) {
            const bitmap = this._bitmapCache?.[filename] || ImageManager.loadSystem(filename);
            const targetW = 32;
            const targetH = 32;
            if (bitmap.isReady()) {
                this.contents.blt(bitmap, 0, 0, bitmap.width, bitmap.height, x, y, targetW, targetH);
            } else {
                bitmap.addLoadListener(() => {
                    if (this.contents) {
                        this.contents.blt(bitmap, 0, 0, bitmap.width, bitmap.height, x, y, targetW, targetH);
                        this.refresh(); // 再描画を要求
                    }
                });
            }
        }

        itemRect(index) {
            const rect = super.itemRect(index);
            rect.y += this.lineHeight(); // ラベル行分下にずらす
            return rect;
        }

        setConfirmWindow(confirmWindow) {
            this._confirmWindow = confirmWindow;
        }

        processOk() {
            if (!this.active) return;

            const item = this._items[this.index()];
            if (!item || !SceneManager._scene) return;

            const scene = SceneManager._scene;
            const equipWindow = scene._selectEquipmentWindow;

            if (item.released) {
                const slotIndex = equipWindow.index();
                const slots = equipWindow._slots;
                //console.log("slots", slots);
                //console.log("ConfigManager.InitEquipActor1Slots", ConfigManager.InitEquipActor1Slots);

                if (slotIndex >= 0 && slots && slots[slotIndex]) {
                    const slot = slots[slotIndex];
                    //console.log("slots", slots);
                    //console.log("this._items", this._items);
                    // スロット情報を更新
                    slot.id = item.id;
                    slot.value = item.name;
                    if (item.type === "Item") {
                        slot.count = 10;
                    } else {
                        slot.count = 1;

                    }
                    slot.itemtype = item.type;
                    if (window.RSTH_IH._selectedActorId === 1) {
                        ConfigManager.InitEquipActor1Slots = slots;
                        window.RSTH_IH.EquipmentOtomoIdActor1 = slots[15].id;
                    }
                    else if (window.RSTH_IH._selectedActorId === 2) {
                        ConfigManager.InitEquipActor2Slots = slots;
                        window.RSTH_IH.EquipmentOtomoIdActor2 = slots[15].id;
                    }
                    else if (window.RSTH_IH._selectedActorId === 3) {
                        ConfigManager.InitEquipActor3Slots = slots;
                        window.RSTH_IH.EquipmentOtomoIdActor3 = slots[15].id;
                    }
                    ConfigManager.save();

                    //console.log("ConfigManager.InitEquipActor1Slots", ConfigManager.InitEquipActor1Slots);

                    equipWindow.refresh();
                    equipWindow.activate();
                    this.deactivate();
                    this.hide();
                    this.playOkSound();
                    return;
                }
            }

            // 通常の未解放アイテム選択時の処理
            if (!item.released && this._confirmWindow) {
                this._confirmWindow.show();
                this._confirmWindow.open();
                this._confirmWindow.activate();
                this.deactivate();
                this.playOkSound();
            }
        }




        processCancel() {
            SoundManager.playCancel();
            this.hide();
            this.deactivate();
            SceneManager._scene._selectEquipmentWindow.activate();
        }

        refresh() {
            this.contents.clear();

            this.updateHelp();

            // ラベル描画（上部に一度だけ）
            this.changeTextColor(ColorManager.systemColor());
            this.drawText("項目名", 6, 0, this.width / 2 - 12, "left");
            this.drawText("必要なうんしょP", this.width - 180, 0, 144, "right");

            // アイテム描画
            for (let i = 0; i < this.maxItems(); i++) {
                this.drawItem(i);
            }
        }

    }

    window.RSTH_IH.Window_ConfirmRelease = class extends Window_Command {
        constructor(rect) {
            super(rect);
            this._textLines = 1;
            this.select(0);
            this.activate();
            this.refresh();
        }

        makeCommandList() {
            this.addCommand("はい", "yes");
            this.addCommand("いいえ", "no");
        }

        drawAllItems() {
            this.contents.clear();
            const text = `この項目を開放しますか？`;
            const lineHeight = this.lineHeight();
            const labelY = 6;
            this.drawText(text, 0, labelY, this.contentsWidth(), "center");

            // コマンド描画
            for (let i = 0; i < this.maxItems(); i++) {
                const rect = this.itemRect(i);
                this.drawText(this.commandName(i), rect.x, rect.y, rect.width, "center");
            }
        }

        itemRect(index) {
            const rect = super.itemRect(index);
            const lineHeight = this.lineHeight();
            const offsetY = lineHeight + 12 + 6; // テキスト1行分 + マージン
            rect.y = offsetY + index * lineHeight;
            return rect;
        }

        update() {
            super.update();
            this.contentsOpacity = this.active ? 255 : 96;
        }

    };

    window.RSTH_IH.Window_SelectOtomoWindow = class extends Window_Selectable {
        constructor(rect) {
            super(rect);
            this._otomos = [];
            this.refresh();
        }

        setOtomos() {
            this._otomos = ConfigManager.OtomoList;
            //console.log("this._otomos", this._otomos);
            this.refresh();
            this.select(0);
        }

        setInfoWindow(infoWindow) {
            this._infoWindow = infoWindow;
        }


        select(index) {
            super.select(index);
            if (index < 0) return;
            const otomo = this._otomos[index];
            if (this._infoWindow && otomo) {
                this._infoWindow.setOtomoId(otomo.id);
            }
        }


        maxItems() {
            return this._otomos.length;
        }

        drawItem(index) {
            const otomo = this._otomos[index];
            if (!otomo) return;

            const rect = this.itemRect(index);

            this.changeTextColor(ColorManager.normalColor());
            this.drawText(otomo.name, rect.x + 6, rect.y, rect.width - 12, "left");

            const costIconX = rect.x + rect.width - 128;
            const costIconY = rect.y + (rect.height - 32) / 2;

            this.drawIconImage("reward_icon", costIconX, costIconY);

            this.changeTextColor(ColorManager.normalColor());
            this.drawText(`x ${otomo.cost}`, costIconX + 38, costIconY, 96, "left");

        }

        drawIconImage(filename, x, y) {
            const bitmap = this._bitmapCache?.[filename] || ImageManager.loadSystem(filename);
            const targetW = 32;
            const targetH = 32;
            if (bitmap.isReady()) {
                this.contents.blt(bitmap, 0, 0, bitmap.width, bitmap.height, x, y, targetW, targetH);
            } else {
                bitmap.addLoadListener(() => {
                    if (this.contents) {
                        this.contents.blt(bitmap, 0, 0, bitmap.width, bitmap.height, x, y, targetW, targetH);
                        this.refresh(); // 再描画を要求
                    }
                });
            }
        }

        itemRect(index) {
            const rect = super.itemRect(index);
            rect.y += this.lineHeight(); // ラベル行分下にずらす
            return rect;
        }

        processOk() {
            if (!this.active) return;
        }

        processCancel() {
            SoundManager.playCancel();
            SceneManager._scene._infoWindow.hide();
            this.hide();
            this.deactivate();
            SceneManager._scene._selectEquipmentCommandWindow.activate();
        }

        refresh() {
            this.contents.clear();

            this.changeTextColor(ColorManager.systemColor());
            this.drawText("お供名", 6, 0, this.width / 2 - 12, "left");
            this.drawText("必要なうんしょP", this.width - 180, 0, 144, "right");

            for (let i = 0; i < this.maxItems(); i++) {
                this.drawItem(i);
            }
        }
    }

    window.RSTH_IH.Window_OtomoInfo = class extends Window_Base {
        constructor(rect) {
            super(rect);
            this._otomoId = null;
        }

        setOtomoId(id) {
            if (this._otomoId !== id) {
                this._otomoId = id;
                this.refresh();
            }
        }

        refresh() {
            this.contents.clear();
            const otomo = $dataWeapons[this._otomoId];
            if (!otomo) return;

            //console.log("otomo", otomo);

            let y = 12;
            const lineHeight = this.lineHeight();

            const pd = 12;
            // 名前
            this.drawText(otomo.name, pd, y, this.contents.width, "left");
            y += lineHeight + 48;

            // プロフィール
            const rawProfile = otomo.description || "";
            const lines = rawProfile.replace(/\\n/g, "\n").split("\n");
            for (const line of lines) {
                this.drawText(line, pd, y, this.contents.width, "left");
                y += lineHeight;
            }
        }




    }


    // 初回だけお供のリスト作成
    window.RSTH_IH.makeInitOtomoList = function () {
        const otomos = $dataWeapons.filter(i => i && i.meta && i.meta.projectile === "EX");
        //console.log("otomos", otomos);
        let otomolist = [];
        for (const otomo of otomos) {
            otomolist.push({
                id: otomo.id,
                name: otomo.name,
                cost: otomo.meta?.unshoP ?? 0,
                released: false,
            });
        }
        //console.log("otomolist", otomolist);
        ConfigManager.OtomoList = otomolist;
        ConfigManager.save();
    }

    // 初期装備のリスト作成
    window.RSTH_IH.makeInitEquipmentList = function () {
        const types = ["Weapon", "Armor", "Skill", "Item", "Otomo"];
        const counts = { Weapon: 4, Armor: 4, Skill: 3, Item: 3, Otomo: 1 };

        const potionNames = {
            Item1: "低級ポーション",
            Item2: "中級ポーション",
            Item3: "上級ポーション"
        };

        const makeFilterMap = (actorId) => {
            const map = {};
            for (const type of types) {
                const max = counts[type];
                for (let i = 1; i <= max; i++) {
                    const key = `${type}${i}`;
                    if (type === "Weapon") {
                        if (i === 1) map[key] = item => item?.meta?.melee && item.meta.actor === `${actorId}`;
                        else if (i >= 2 && i <= 4) {
                            const projectileType = String.fromCharCode(64 + (i - 1)); // 2→B, 3→C, 4→D（A=65）
                            //console.log("projectileType", projectileType);
                            map[key] = item => item?.meta?.projectile === projectileType &&
                                (item.meta.actor === `${actorId}` || item.meta.actor === "EX");
                        }
                    } else if (type === "Armor") {
                        map[key] = item => item?.meta?.actor === `${actorId}` && item.etypeId === i + 1;
                    } else if (type === "Skill") {
                        const skillType = String.fromCharCode(64 + i); // A, B, C
                        map[key] = item => item?.meta?.skill === skillType &&
                            (item.meta.actor === `${actorId}` || item.meta.actor === "EX");
                    } else if (type === "Item") {
                        const name = potionNames[`${type}${i}`];
                        map[key] = item => item?.name === name;
                    } else if (type === "Otomo") {
                        map[key] = item => item?.meta?.projectile === "EX";
                    }
                }
            }
            //console.log("map", map);
            return map;
        };

        const assignEquipment = (actorId, filterMap) => {
            for (const type of types) {
                const max = counts[type];
                for (let i = 1; i <= max; i++) {
                    const key = `Actor${actorId}_${type}${i}`;
                    const filterFn = filterMap[`${type}${i}`];
                    if (!filterFn) continue;

                    let source = [];
                    if (type === "Weapon" || type === "Skill" || type === "Otomo") source = $dataWeapons;
                    if (type === "Armor") source = $dataArmors;
                    if (type === "Item") source = $dataItems;

                    const initequip = source.filter(filterFn);
                    const listdata = [];
                    for (const item of initequip) {
                        listdata[item.id] = {
                            id: item.id,
                            name: item.name,
                            cost: item.meta?.unshoP ?? 0,
                            type: type,
                            released: false
                        };
                    }

                    //console.log("listdata", listdata);
                    ConfigManager[key] = listdata;
                    //console.log(`ConfigManager[${key}]`, ConfigManager[key]);
                }
            }
        };

        // 3人分の装備を一括生成
        for (let actorId = 1; actorId <= 3; actorId++) {
            const filterMap = makeFilterMap(actorId);
            assignEquipment(actorId, filterMap);
        }

        //console.log("ConfigManager.Actor1_Items1", ConfigManager.Actor1_Item1);


        ConfigManager.save();
    };

    // 初期装備で最初からリリースされているもの
    window.RSTH_IH.makeInitEquipmentListreleased = function () {
        ConfigManager.Actor1_Weapon1[1].released = true;
        ConfigManager.Actor2_Weapon1[22].released = true;
        ConfigManager.Actor3_Weapon1[100].released = true;

        ConfigManager.Actor1_Weapon3[43].released = true;
        ConfigManager.Actor2_Weapon3[38].released = true;
        ConfigManager.Actor3_Weapon3[113].released = true;

        ConfigManager.Actor2_Weapon4[33].released = true;

        ConfigManager.Actor1_Skill1[44].released = true;
        ConfigManager.Actor1_Skill2[45].released = true;
        ConfigManager.Actor1_Skill3[46].released = true;

        ConfigManager.Actor2_Skill1[47].released = true;
        ConfigManager.Actor2_Skill2[48].released = true;
        ConfigManager.Actor2_Skill3[49].released = true;

        ConfigManager.Actor3_Skill1[118].released = true;
        ConfigManager.Actor3_Skill2[119].released = true;
        ConfigManager.Actor3_Skill3[120].released = true;

        //盾
        ConfigManager.Actor1_Armor1[27].released = true;
        //頭
        ConfigManager.Actor1_Armor2[46].released = true;
        ConfigManager.Actor1_Armor2[47].released = true;
        //身体
        ConfigManager.Actor1_Armor3[2].released = true;
        ConfigManager.Actor1_Armor3[3].released = true;
        ConfigManager.Actor2_Armor3[8].released = true;

        //アイテム
        ConfigManager.Actor1_Item1[7].released = true;
        ConfigManager.Actor2_Item1[7].released = true;
        ConfigManager.Actor3_Item1[7].released = true;

        // 初回作成完了フラグ
        ConfigManager.InitEquip = true;

        ConfigManager.save();
    }

    // マップで実際にアイテムを入手
    window.RSTH_IH.setInitEquipment = function () {
        let lists = [];
        if (window.RSTH_IH._selectedActorId === 1) {
            lists = ConfigManager.InitEquipActor1Slots;
            window.RSTH_IH.EquipmentOtomoIdActor1 = ConfigManager.InitEquipActor1Slots[15].id;
        }
        else if (window.RSTH_IH._selectedActorId === 2) {
            lists = ConfigManager.InitEquipActor2Slots;
            window.RSTH_IH.EquipmentOtomoIdActor2 = ConfigManager.InitEquipActor2Slots[15].id;
        }
        else if (window.RSTH_IH._selectedActorId === 3) {
            lists = ConfigManager.InitEquipActor3Slots;
            window.RSTH_IH.EquipmentOtomoIdActor3 = ConfigManager.InitEquipActor3Slots[15].id;
        }

        //console.log("lists", lists);
        for (let i = 0; i < lists.length; i++) {
            if (lists[i].count <= 0) continue;
            let item = null;
            if (lists[i].itemtype === "Weapon" && lists[i].count > 0) {
                item = $dataWeapons[lists[i].id];
            }
            else if (lists[i].itemtype === "Armor" && lists[i].count > 0) {
                item = $dataArmors[lists[i].id];
            }
            else if (lists[i].itemtype === "Skill" && lists[i].count > 0) {
                item = $dataWeapons[lists[i].id];
            }
            else if (lists[i].itemtype === "Item" && lists[i].count > 0) {
                item = $dataItems[lists[i].id];
            }
            else {
                continue;
            }

            //console.log("lists[i]", lists[i]);
            //console.log("item", item);
            $gameParty.gainItem(item, lists[i].count);
        }

        $gameParty.gainGold(3000);


    }



})();