/*:
 * @target MZ
 * @plugindesc RSTH_IH: サバイバルゲームシステムプラグイン
 * @author © 2025 ReSera_りせら（@MOBIUS1001）
 *
 * このソースコードは無断での転載、複製、改変、再配布、商用利用を固く禁じます。
 * 禁止事項の例：
 * - 本ファイルの全部または一部を許可なくコピー、再配布すること
 * - 本ファイルを改変して配布すること
 * - 商用目的での利用
 */

(() => {

    "use strict";

    // ログ出力制御フラグ（trueでログ出力、falseで抑制）
    //const RSTH_DEBUG_LOG = true;
    const RSTH_DEBUG_LOG = false;

    window.RSTH_IH.Scene_Achievements = class extends Scene_MenuBase {
        create() {
            super.create();
            this._bitmapCache = window.RSTH_IH._achievementBitmapCache; // ← 共通キャッシュを流用

            this.createTitle();
            this.createAchievementsWindow();
            this._achievementsWindow.setBitmapCache(this._bitmapCache);
        }


        createTitle() {
            this._title = new window.RSTH_IH.Sprite_VerticalTitleText("Achievements");
            this.addChild(this._title);
        }

        createBackground() {
            this._backgroundSprite = new window.RSTH_IH.Sprite_CharacterSelectBackground();
            this.addChild(this._backgroundSprite); // 最背面に追加
        }

        createAchievementsWindow() {
            const rect = new Rectangle(120, 6, Graphics.width - 132, Graphics.height - 24);
            this._achievementsWindow = new window.RSTH_IH.Window_Achievements(rect);
            this.addWindow(this._achievementsWindow);

        }


        isReady() {
            return super.isReady() && window.RSTH_IH.areAchievementImagesReady();
        }


        areImagesReady() {
            return this._preloadList.every(name => {
                const bitmap = ImageManager.loadSystem(name);
                return bitmap.isReady();
            });
        }

        update() {
            super.update();

            if (Input.isTriggered("ok") || Input.isTriggered("cancel") || Input.isTriggered("escape") || TouchInput.isTriggered()) {

                SoundManager.playCancel();
                SceneManager.goto(window.RSTH_IH.Scene_TitleCustom);
            }

        }
    }


    window.RSTH_IH.Window_Achievements = class extends Window_Selectable {
        constructor(rect) {
            super(rect);

            this._items = [];

            this.opacity = 0; // ウィンドウ枠なし
            this.backOpacity = 0; // 背景なし
            this.frameVisible = false;
            this.setBackgroundType(2);
            this.setItems();
            this.refresh();
            this.select(0);
            this.activate();
            //this.createBackgroundSprite();

        }

        setBitmapCache(cache) {
            this._bitmapCache = cache;
        }

        isCursorMovable() {
            return this.isOpenAndActive();
        }

        select(index) {
            super.select(index);
            this.ensureCursorVisible();
            this.scrollTo(0, this.topRow() * this.itemHeight()); // ←ここを追加
        }


        ensureCursorVisible() {
            const row = this.row();
            const scrollRows = Math.floor(this.innerHeight / this.itemHeight());

            if (row < this.topRow()) {
                this.setTopRow(row);
            } else if (row > this.topRow() + scrollRows - 1) {
                const newTop = row - scrollRows + 1;
                this.setTopRow(Math.floor(newTop));
            }
        }

        setTopRow(row) {
            super.setTopRow(Math.max(0, Math.floor(row)));
        }


        isCursorWrap() {
            return false;
        }

        cursorDown(wrap) {
            if (this.index() < this.maxItems() - 1) {
                this.select(this.index() + 1);
            }
        }

        cursorUp(wrap) {
            if (this.index() > 0) {
                this.select(this.index() - 1);
            }
        }

        row() {
            return this.index();
        }

        maxScrollY() {
            const rowHeight = this.itemHeight();
            const totalRows = this.maxItems();
            const visibleRows = Math.floor(this.innerHeight / rowHeight);
            return Math.max(0, rowHeight * (totalRows - visibleRows));
        }

        scrollTo(x, y) {
            const itemH = this.itemHeight();
            const maxY = this.maxScrollY();
            const snappedY = Math.floor(y / itemH) * itemH;
            super.scrollTo(x, Math.min(snappedY, maxY));
        }



        itemHeight() {
            return this.lineHeight() * 3;
        }

        createBackgroundSprite() {
            const bitmap = new Bitmap(this.width, this.height);
            bitmap.fillAll("#000000be");
            this._backgroundSprite = new Sprite(bitmap);
            this._backgroundSprite.alpha = 0.4;
            this.addChildToBack(this._backgroundSprite);
        }


        maxItems() {
            return this._items?.length ?? 0;
        }

        itemRect(index) {
            const rect = new Rectangle();
            rect.width = this.contentsWidth();
            rect.height = this.itemHeight();
            rect.x = 0;
            rect.y = index * rect.height - this.scrollY(); // ← スクロール補正
            return rect;
        }


        setItems() {
            if (this._items.length > 0) return;

            this._items = Object.entries(window.RSTH_IH.getAchievementsCheckBox()).map(([key, data]) => {
                return { key, ...data };
            });


            this.refresh();
        }


        drawItem(index) {
            const item = this._items[index];
            if (!item) return;

            const rect = this.itemRect(index);

            const padding = 12;
            const lineGap = 4;

            const iconSize = 48;
            const iconY = rect.y;

            // 達成状態アイコン
            const statusIconX = rect.x + padding;
            const statusIconY = rect.y + 4;
            const statusIconName = item.achieved ? "achv_done" : "achv_notyet";
            this.drawIconImage(statusIconName, statusIconX, statusIconY);

            // 左のアイコン
            this.drawIconImage("achv_icon", rect.x + padding + iconSize + 64, iconY);

            const textX = rect.x + statusIconX + iconSize + 180;
            const labelY = rect.y + 4;
            const conditionY = labelY + this.lineHeight() + lineGap;

            // タイトル
            this.changeTextColor(ColorManager.textColor(6));
            this.drawText(item.label, textX, labelY, rect.width - 64, "left");

            // 条件説明
            this.changeTextColor(ColorManager.normalColor());
            this.drawText(item.conditions, textX, conditionY, rect.width - 64, "left");

            // 報酬アイコン
            const rewardIconX = rect.x + rect.width - 64;
            const rewardIconY = rect.y + (rect.height - 48) / 2;

            this.drawIconImage("reward_icon", rewardIconX, rewardIconY);

            // value数値
            this.changeTextColor(ColorManager.normalColor());
            this.drawText(`${item.value}`, rewardIconX, rewardIconY + 32, 48, "center");

        }

        drawIconImage(filename, x, y) {
            const bitmap = this._bitmapCache?.[filename] || ImageManager.loadSystem(filename);
            if (bitmap.isReady()) {
                this.contents.blt(bitmap, 0, 0, bitmap.width, bitmap.height, x, y);
            } else {
                bitmap.addLoadListener(() => {
                    if (this.contents) {
                        this.contents.blt(bitmap, 0, 0, bitmap.width, bitmap.height, x, y);
                        this.refresh(); // 再描画を要求
                    }
                });
            }
        }

        refresh() {
            this.contents.clear();
            if (this.contents) {
                this.contents.clear();
                this.contentsBack.clear(); // ← 背景レイヤーを確実にクリア
                this.drawAllItems(); // ← これを初期化時にも明示的に呼ぶ
            }
            for (let i = 0; i < this.maxItems(); i++) {
                this.drawItem(i);
            }

        }


    }

    window.RSTH_IH.Window_CheckAchievement = function (boss = 0, dmg = 0, mkl = 0) {
        if (!(SceneManager._scene instanceof Scene_Map)) return;

        const leader = $gameParty.leader();
        if (!leader) return;
        if (RSTH_DEBUG_LOG) console.log("leader", leader);

        //FKL
        if (mkl > 0) {
            if (!ConfigManager["achi_FKL"]) {
                ConfigManager["achi_FKL"] = true;
                window.RSTH_IH.ACHIEVEMENT_NOTIFIER?.show(window.RSTH_IH.getAchievementsCheckBox().FKL.label);
                const value = Number(window.RSTH_IH.getAchievementsCheckBox().FKL.value);
                window.RSTH_IH.unshoP += value;
                ConfigManager.unshoP = window.RSTH_IH.unshoP;
                ConfigManager.save();
            }
        }

        //MKL1000
        if (mkl >= 1000) {
            if (!ConfigManager["achi_MKL1000"]) {
                ConfigManager["achi_MKL1000"] = true;
                window.RSTH_IH.ACHIEVEMENT_NOTIFIER?.show(window.RSTH_IH.getAchievementsCheckBox().MKL1000.label);
                const value = Number(window.RSTH_IH.getAchievementsCheckBox().MKL1000.value);
                window.RSTH_IH.unshoP += value;
                ConfigManager.unshoP = window.RSTH_IH.unshoP;
                ConfigManager.save();
            }
        }

        //MKL3000
        if (mkl >= 3000) {
            if (!ConfigManager["achi_MKL3000"]) {
                ConfigManager["achi_MKL3000"] = true;
                window.RSTH_IH.ACHIEVEMENT_NOTIFIER?.show(window.RSTH_IH.getAchievementsCheckBox().MKL3000.label);
                const value = Number(window.RSTH_IH.getAchievementsCheckBox().MKL3000.value);
                window.RSTH_IH.unshoP += value;
                ConfigManager.unshoP = window.RSTH_IH.unshoP;
                ConfigManager.save();
            }
        }

        //MKL5000
        if (mkl >= 5000) {
            if (!ConfigManager["achi_MKL5000"]) {
                ConfigManager["achi_MKL5000"] = true;
                window.RSTH_IH.ACHIEVEMENT_NOTIFIER?.show(window.RSTH_IH.getAchievementsCheckBox().MKL5000.label);
                const value = Number(window.RSTH_IH.getAchievementsCheckBox().MKL5000.value);
                window.RSTH_IH.unshoP += value;
                ConfigManager.unshoP = window.RSTH_IH.unshoP;
                ConfigManager.save();
            }
        }

        //HP300
        if (leader.mhp >= 300) {
            if (!ConfigManager["achi_HP300"]) {
                ConfigManager["achi_HP300"] = true;
                window.RSTH_IH.ACHIEVEMENT_NOTIFIER?.show(window.RSTH_IH.getAchievementsCheckBox().HP300.label);
                const value = Number(window.RSTH_IH.getAchievementsCheckBox().HP300.value);
                window.RSTH_IH.unshoP += value;
                ConfigManager.unshoP = window.RSTH_IH.unshoP;
                ConfigManager.save();
            }
        }
        //HP600
        if (leader.mhp >= 600) {
            if (!ConfigManager["achi_HP600"]) {
                ConfigManager["achi_HP600"] = true;
                window.RSTH_IH.ACHIEVEMENT_NOTIFIER?.show(window.RSTH_IH.getAchievementsCheckBox().HP600.label);
                const value = Number(window.RSTH_IH.getAchievementsCheckBox().HP600.value);
                window.RSTH_IH.unshoP += value;
                ConfigManager.unshoP = window.RSTH_IH.unshoP;
                ConfigManager.save();
            }
        }
        //str90
        if (leader.param(2) >= 90) {
            if (!ConfigManager["achi_Str90"]) {
                ConfigManager["achi_Str90"] = true;
                window.RSTH_IH.ACHIEVEMENT_NOTIFIER?.show(window.RSTH_IH.getAchievementsCheckBox().Str90.label);
                const value = Number(window.RSTH_IH.getAchievementsCheckBox().Str90.value);
                window.RSTH_IH.unshoP += value;
                ConfigManager.unshoP = window.RSTH_IH.unshoP;
                ConfigManager.save();
            }
        }
        //str200
        if (leader.param(2) >= 200) {
            if (!ConfigManager["achi_Str200"]) {
                ConfigManager["achi_Str200"] = true;
                window.RSTH_IH.ACHIEVEMENT_NOTIFIER?.show(window.RSTH_IH.getAchievementsCheckBox().Str200.label);
                const value = Number(window.RSTH_IH.getAchievementsCheckBox().Str200.value);
                window.RSTH_IH.unshoP += value;
                ConfigManager.unshoP = window.RSTH_IH.unshoP;
                ConfigManager.save();
            }
        }

        const vitplus = leader._paramPlus[3] ?? 0;
        const vit = leader.paramBase(3) + vitplus;
        //vit90
        if (vit >= 90) {
            if (!ConfigManager["achi_Vit90"]) {
                ConfigManager["achi_Vit90"] = true;
                window.RSTH_IH.ACHIEVEMENT_NOTIFIER?.show(window.RSTH_IH.getAchievementsCheckBox().Vit90.label);
                const value = Number(window.RSTH_IH.getAchievementsCheckBox().Vit90.value);
                window.RSTH_IH.unshoP += value;
                ConfigManager.unshoP = window.RSTH_IH.unshoP;
                ConfigManager.save();
            }
        }
        //vit200
        if (vit >= 200) {
            if (!ConfigManager["achi_Vit200"]) {
                ConfigManager["achi_Vit200"] = true;
                window.RSTH_IH.ACHIEVEMENT_NOTIFIER?.show(window.RSTH_IH.getAchievementsCheckBox().Vit200.label);
                const value = Number(window.RSTH_IH.getAchievementsCheckBox().Vit200.value);
                window.RSTH_IH.unshoP += value;
                ConfigManager.unshoP = window.RSTH_IH.unshoP;
                ConfigManager.save();
            }
        }
        //dex90
        if (leader.param(5) >= 90) {
            if (!ConfigManager["achi_Dex90"]) {
                ConfigManager["achi_Dex90"] = true;
                window.RSTH_IH.ACHIEVEMENT_NOTIFIER?.show(window.RSTH_IH.getAchievementsCheckBox().Dex90.label);
                const value = Number(window.RSTH_IH.getAchievementsCheckBox().Dex90.value);
                window.RSTH_IH.unshoP += value;
                ConfigManager.unshoP = window.RSTH_IH.unshoP;
                ConfigManager.save();
            }
        }
        //dex200
        if (leader.param(5) >= 200) {
            if (!ConfigManager["achi_Dex200"]) {
                ConfigManager["achi_Dex200"] = true;
                window.RSTH_IH.ACHIEVEMENT_NOTIFIER?.show(window.RSTH_IH.getAchievementsCheckBox().Dex200.label);
                const value = Number(window.RSTH_IH.getAchievementsCheckBox().Dex200.value);
                window.RSTH_IH.unshoP += value;
                ConfigManager.unshoP = window.RSTH_IH.unshoP;
                ConfigManager.save();
            }
        }
        //agi90
        if (leader.param(6) >= 90) {
            if (!ConfigManager["achi_Agi90"]) {
                ConfigManager["achi_Agi90"] = true;
                window.RSTH_IH.ACHIEVEMENT_NOTIFIER?.show(window.RSTH_IH.getAchievementsCheckBox().Agi90.label);
                const value = Number(window.RSTH_IH.getAchievementsCheckBox().Agi90.value);
                window.RSTH_IH.unshoP += value;
                ConfigManager.unshoP = window.RSTH_IH.unshoP;
                ConfigManager.save();
            }
        }
        //agi200
        if (leader.param(6) >= 200) {
            if (!ConfigManager["achi_Agi200"]) {
                ConfigManager["achi_Agi200"] = true;
                window.RSTH_IH.ACHIEVEMENT_NOTIFIER?.show(window.RSTH_IH.getAchievementsCheckBox().Agi200.label);
                const value = Number(window.RSTH_IH.getAchievementsCheckBox().Agi200.value);
                window.RSTH_IH.unshoP += value;
                ConfigManager.unshoP = window.RSTH_IH.unshoP;
                ConfigManager.save();
            }
        }
        //luk90
        if (leader.param(7) >= 90) {
            if (!ConfigManager["achi_Luk90"]) {
                ConfigManager["achi_Luk90"] = true;
                window.RSTH_IH.ACHIEVEMENT_NOTIFIER?.show(window.RSTH_IH.getAchievementsCheckBox().Luk90.label);
                const value = Number(window.RSTH_IH.getAchievementsCheckBox().Luk90.value);
                window.RSTH_IH.unshoP += value;
                ConfigManager.unshoP = window.RSTH_IH.unshoP;
                ConfigManager.save();
            }
        }
        //luk200
        if (leader.param(7) >= 200) {
            if (!ConfigManager["achi_Luk200"]) {
                ConfigManager["achi_Luk200"] = true;
                window.RSTH_IH.ACHIEVEMENT_NOTIFIER?.show(window.RSTH_IH.getAchievementsCheckBox().Luk200.label);
                const value = Number(window.RSTH_IH.getAchievementsCheckBox().Luk200.value);
                window.RSTH_IH.unshoP += value;
                ConfigManager.unshoP = window.RSTH_IH.unshoP;
                ConfigManager.save();
            }
        }
        //Lv99
        if (leader.level >= 99) {
            if (!ConfigManager["achi_Lv99"]) {
                ConfigManager["achi_Lv99"] = true;
                window.RSTH_IH.ACHIEVEMENT_NOTIFIER?.show(window.RSTH_IH.getAchievementsCheckBox().Lv99.label);
                const value = Number(window.RSTH_IH.getAchievementsCheckBox().Lv99.value);
                window.RSTH_IH.unshoP += value;
                ConfigManager.unshoP = window.RSTH_IH.unshoP;
                ConfigManager.save();
            }
        }
        //Lv150
        if (leader.level === 150) {
            if (!ConfigManager["achi_Lv150"]) {
                ConfigManager["achi_Lv150"] = true;
                window.RSTH_IH.ACHIEVEMENT_NOTIFIER?.show(window.RSTH_IH.getAchievementsCheckBox().Lv150.label);
                const value = Number(window.RSTH_IH.getAchievementsCheckBox().Lv150.value);
                window.RSTH_IH.unshoP += value;
                ConfigManager.unshoP = window.RSTH_IH.unshoP;
                ConfigManager.save();
            }
        }

        //SLv99,SLv150
        if (window.RSTH_IH._selectedActorId === 1) {
            if (leader.level >= 99) {
                if (!ConfigManager["achi_SLv99"]) {
                    ConfigManager["achi_SLv99"] = true;
                    window.RSTH_IH.ACHIEVEMENT_NOTIFIER?.show(window.RSTH_IH.getAchievementsCheckBox().SLv99.label);
                    const value = Number(window.RSTH_IH.getAchievementsCheckBox().SLv99.value);
                    window.RSTH_IH.unshoP += value;
                    ConfigManager.unshoP = window.RSTH_IH.unshoP;
                    ConfigManager.save();
                }
            }
            if (leader.level === 150) {
                if (!ConfigManager["achi_SLv150"]) {
                    ConfigManager["achi_SLv150"] = true;
                    window.RSTH_IH.ACHIEVEMENT_NOTIFIER?.show(window.RSTH_IH.getAchievementsCheckBox().SLv150.label);
                    const value = Number(window.RSTH_IH.getAchievementsCheckBox().SLv150.value);
                    window.RSTH_IH.unshoP += value;
                    ConfigManager.unshoP = window.RSTH_IH.unshoP;
                    ConfigManager.save();
                }
            }
        }

        //ULv99,ULv150
        if (window.RSTH_IH._selectedActorId === 2) {
            if (leader.level >= 99) {
                if (!ConfigManager["achi_ULv99"]) {
                    ConfigManager["achi_ULv99"] = true;
                    window.RSTH_IH.ACHIEVEMENT_NOTIFIER?.show(window.RSTH_IH.getAchievementsCheckBox().ULv99.label);
                    const value = Number(window.RSTH_IH.getAchievementsCheckBox().ULv99.value);
                    window.RSTH_IH.unshoP += value;
                    ConfigManager.unshoP = window.RSTH_IH.unshoP;
                    ConfigManager.save();
                }
            }
            if (leader.level === 150) {
                if (!ConfigManager["achi_ULv150"]) {
                    ConfigManager["achi_ULv150"] = true;
                    window.RSTH_IH.ACHIEVEMENT_NOTIFIER?.show(window.RSTH_IH.getAchievementsCheckBox().ULv150.label);
                    const value = Number(window.RSTH_IH.getAchievementsCheckBox().ULv150.value);
                    window.RSTH_IH.unshoP += value;
                    ConfigManager.unshoP = window.RSTH_IH.unshoP;
                    ConfigManager.save();
                }
            }
        }

        //PLv99,PLv150
        if (window.RSTH_IH._selectedActorId === 3) {
            if (leader.level >= 99) {
                if (!ConfigManager["achi_PLv99"]) {
                    ConfigManager["achi_PLv99"] = true;
                    window.RSTH_IH.ACHIEVEMENT_NOTIFIER?.show(window.RSTH_IH.getAchievementsCheckBox().PLv99.label);
                    const value = Number(window.RSTH_IH.getAchievementsCheckBox().PLv99.value);
                    window.RSTH_IH.unshoP += value;
                    ConfigManager.unshoP = window.RSTH_IH.unshoP;
                    ConfigManager.save();
                }
            }
            if (leader.level === 150) {
                if (!ConfigManager["achi_PLv150"]) {
                    ConfigManager["achi_PLv150"] = true;
                    window.RSTH_IH.ACHIEVEMENT_NOTIFIER?.show(window.RSTH_IH.getAchievementsCheckBox().PLv150.label);
                    const value = Number(window.RSTH_IH.getAchievementsCheckBox().PLv150.value);
                    window.RSTH_IH.unshoP += value;
                    ConfigManager.unshoP = window.RSTH_IH.unshoP;
                    ConfigManager.save();
                }
            }
        }

        //Boss1

        //console.log("[Window_CheckAchievement]boss", boss);
        if (boss === "1") {
            //console.log("boss1");
            if (!ConfigManager["achi_Boss1"]) {
                ConfigManager["achi_Boss1"] = true;
                //console.log(`ConfigManager["achi_Boss1"]`, ConfigManager["achi_Boss1"]);
                window.RSTH_IH.ACHIEVEMENT_NOTIFIER?.show(window.RSTH_IH.getAchievementsCheckBox().Boss1.label);
                const value = Number(window.RSTH_IH.getAchievementsCheckBox().Boss1.value);
                window.RSTH_IH.unshoP += value;
                ConfigManager.unshoP = window.RSTH_IH.unshoP;
                ConfigManager.save();
            }

        }
        //Boss2
        if (boss === "2") {
            if (!ConfigManager["achi_Boss2"]) {
                ConfigManager["achi_Boss2"] = true;
                window.RSTH_IH.ACHIEVEMENT_NOTIFIER?.show(window.RSTH_IH.getAchievementsCheckBox().Boss2.label);
                const value = Number(window.RSTH_IH.getAchievementsCheckBox().Boss2.value);
                window.RSTH_IH.unshoP += value;
                ConfigManager.unshoP = window.RSTH_IH.unshoP;
                ConfigManager.save();
            }

        }
        //Boss3
        if (boss === "3") {
            if (!ConfigManager["achi_Boss3"]) {
                ConfigManager["achi_Boss3"] = true;
                window.RSTH_IH.ACHIEVEMENT_NOTIFIER?.show(window.RSTH_IH.getAchievementsCheckBox().Boss3.label);
                const value = Number(window.RSTH_IH.getAchievementsCheckBox().Boss3.value);
                window.RSTH_IH.unshoP += value;
                ConfigManager.unshoP = window.RSTH_IH.unshoP;
                ConfigManager.save();
            }

        }
        //Boss4
        if (boss === "4") {
            if (!ConfigManager["achi_Boss4"]) {
                ConfigManager["achi_Boss4"] = true;
                window.RSTH_IH.ACHIEVEMENT_NOTIFIER?.show(window.RSTH_IH.getAchievementsCheckBox().Boss4.label);
                const value = Number(window.RSTH_IH.getAchievementsCheckBox().Boss4.value);
                window.RSTH_IH.unshoP += value;
                ConfigManager.unshoP = window.RSTH_IH.unshoP;
                ConfigManager.save();
            }

        }
        //Boss5
        if (boss === "5") {
            if (!ConfigManager["achi_Boss5"]) {
                ConfigManager["achi_Boss5"] = true;
                window.RSTH_IH.ACHIEVEMENT_NOTIFIER?.show(window.RSTH_IH.getAchievementsCheckBox().Boss5.label);
                const value = Number(window.RSTH_IH.getAchievementsCheckBox().Boss5.value);
                window.RSTH_IH.unshoP += value;
                ConfigManager.unshoP = window.RSTH_IH.unshoP;
                ConfigManager.save();
            }

        }
        //Boss5_5min
        if (boss === "5" && window.RSTH_IH.TimeCount <= 300 && window.RSTH_IH._selectedActorId === 2) {
            if (!ConfigManager["achi_Boss5_5min"]) {
                ConfigManager["achi_Boss5_5min"] = true;
                window.RSTH_IH.ACHIEVEMENT_NOTIFIER?.show(window.RSTH_IH.getAchievementsCheckBox().Boss5_5min.label);
                const value = Number(window.RSTH_IH.getAchievementsCheckBox().Boss5_5min.value);
                window.RSTH_IH.unshoP += value;
                ConfigManager.unshoP = window.RSTH_IH.unshoP;
                ConfigManager.save();
            }

        }
        //Dmg200
        if (dmg >= 200) {
            if (!ConfigManager["achi_Dmg200"]) {
                ConfigManager["achi_Dmg200"] = true;
                window.RSTH_IH.ACHIEVEMENT_NOTIFIER?.show(window.RSTH_IH.getAchievementsCheckBox().Dmg200.label);
                const value = Number(window.RSTH_IH.getAchievementsCheckBox().Dmg200.value);
                window.RSTH_IH.unshoP += value;
                ConfigManager.unshoP = window.RSTH_IH.unshoP;
                ConfigManager.save();
            }
        }
        //Dmg500
        if (dmg >= 500) {
            if (!ConfigManager["achi_Dmg500"]) {
                ConfigManager["achi_Dmg500"] = true;
                window.RSTH_IH.ACHIEVEMENT_NOTIFIER?.show(window.RSTH_IH.getAchievementsCheckBox().Dmg500.label);
                const value = Number(window.RSTH_IH.getAchievementsCheckBox().Dmg500.value);
                window.RSTH_IH.unshoP += value;
                ConfigManager.unshoP = window.RSTH_IH.unshoP;
                ConfigManager.save();
            }
        }
    }

    window.RSTH_IH.AchievementNotifier = class {
        constructor() {
            this._dx = 440;
            this._queue = [];
            this._sprites = [];
            this._duration = 180; // 3秒（60fps換算）
            this._container = new Sprite(); // 親スプライト
            SceneManager._scene.addChild(this._container);
        }

        show(text) {
            AudioManager.playSe({ name: "Chime2", pan: 0, pitch: 100, volume: 20 });

            const sprite = new Sprite(new Bitmap(this._dx, 64));
            const bitmap = sprite.bitmap;
            bitmap.fontSize = 20;

            sprite.setFrame(0, 0, this._dx, 64);
            sprite.bitmap.fillRect(0, 0, this._dx, 64, "rgba(63, 26, 61, 0.5)");

            const iconName = "achv_icon";
            const iconWidth = 64;
            const iconHeight = 64;
            const icon = ImageManager.loadSystem(iconName);

            icon.addLoadListener(() => {
                if (bitmap) {
                    const scaleW = iconWidth / icon.width;
                    const scaleH = iconHeight / icon.height;
                    const temp = new Sprite(icon);
                    temp.scale.x = scaleW;
                    temp.scale.y = scaleH;
                    temp.x = 6;
                    temp.y = -3;
                    sprite.addChild(temp);

                    const textX = iconWidth + 16;
                    bitmap.drawText(text, textX, 0, 300, 64, "left");
                }
            });

            sprite.x = Graphics.width - this._dx;
            sprite.y = Graphics.height - 280 - (this._sprites.length * 72);
            sprite.opacity = 255;

            this._container.addChild(sprite);
            this._sprites.push({ sprite, count: this._duration });
        }

        update() {
            this._sprites = this._sprites.filter(obj => {
                obj.count--;
                if (obj.count <= 0) {
                    this._container.removeChild(obj.sprite);
                    return false;
                }
                return true;
            });

            for (let i = 0; i < this._sprites.length; i++) {
                const s = this._sprites[i].sprite;
                s.y = Graphics.height - 280 - (i * 72);
            }
        }
    };












})();