/*:
 * @target MZ
 * @plugindesc RSTH_IH: サバイバルゲームシステムプラグイン
 * @author © 2025 ReSera_りせら（@MOBIUS1001）
 *
 * このソースコードは無断での転載、複製、改変、再配布、商用利用を固く禁じます。
 * 禁止事項の例：
 * - 本ファイルの全部または一部を許可なくコピー、再配布すること
 * - 本ファイルを改変して配布すること
 * - 商用目的での利用
 */

(() => {

    "use strict";

    // ログ出力制御フラグ（trueでログ出力、falseで抑制）
    //const RSTH_DEBUG_LOG = true;
    const RSTH_DEBUG_LOG = false;

    window.RSTH_IH.Scene_BeforeResult = class extends Scene_MenuBase {
        start() {
            super.start();
            window.RSTH_IH._sceneInputLockFrames = 60;

        }

        create() {
            super.create();
            AudioManager.stopBgm();
            AudioManager.playMe($gameSystem.victoryMe());

            // うんしょポイント獲得
            window.RSTH_IH.unshoP += Number(window.RSTH_IH.getUnshoP);
            ConfigManager.unshoP = window.RSTH_IH.unshoP;
            ConfigManager.save();

            const gw = Graphics.boxWidth;
            const gh = Graphics.boxHeight;
            const sw = 1600;
            const sh = 900;

            // Bitmapロード
            const bitmap = ImageManager.loadTitle1("survived");

            // Sprite作成
            const sprite = new Sprite(bitmap);

            // 位置調整
            sprite.x = (gw - sw) / 2;
            sprite.y = 0;

            // シーンに追加
            this.addChild(sprite);
        }


        update() {
            super.update();
            if (window.RSTH_IH._sceneInputLockFrames > 0) {
                window.RSTH_IH._sceneInputLockFrames--;
            }
            else if (Input.isTriggered("ok") || Input.isTriggered("cancel") || Input.isTriggered("escape") || TouchInput.isTriggered()) {

                window.RSTH_IH.slideScene(this, window.RSTH_IH.Scene_Result, "left", 30);
                //SceneManager.goto(window.RSTH_IH.Scene_Result);
            }

        }
    };

    window.RSTH_IH.Scene_BeforeResultTimeUP = class extends Scene_MenuBase {
        start() {
            super.start();
            window.RSTH_IH._sceneInputLockFrames = 60;

        }

        create() {
            super.create();
            AudioManager.stopBgm();
            AudioManager.playMe($gameSystem.victoryMe());

            const gw = Graphics.boxWidth;
            const gh = Graphics.boxHeight;
            const sw = 1600;
            const sh = 900;

            // Bitmapロード
            const bitmap = ImageManager.loadTitle1("timeup");

            // Sprite作成
            const sprite = new Sprite(bitmap);

            // 位置調整
            sprite.x = (gw - sw) / 2;
            sprite.y = 0;

            // シーンに追加
            this.addChild(sprite);
        }

        update() {
            super.update();
            if (window.RSTH_IH._sceneInputLockFrames > 0) {
                window.RSTH_IH._sceneInputLockFrames--;
            }
            else if (Input.isTriggered("ok") || Input.isTriggered("cancel") || Input.isTriggered("escape") || TouchInput.isTriggered()) {

                window.RSTH_IH.slideScene(this, window.RSTH_IH.Scene_Result, "left", 30);
                //SceneManager.goto(window.RSTH_IH.Scene_Result);
            }
        }
    };

    window.RSTH_IH.Scene_BeforeResultDestroyed = class extends Scene_MenuBase {
        start() {
            super.start();
            window.RSTH_IH._sceneInputLockFrames = 60;

        }

        create() {
            super.create();
            AudioManager.stopBgm();
            AudioManager.playMe($gameSystem.victoryMe());

            // うんしょポイント獲得
            window.RSTH_IH.unshoP += Number(window.RSTH_IH.getUnshoP);
            ConfigManager.unshoP = window.RSTH_IH.unshoP;
            ConfigManager.save();

            const gw = Graphics.boxWidth;
            const gh = Graphics.boxHeight;
            const sw = 1600;
            const sh = 900;

            // Bitmapロード
            const bitmap = ImageManager.loadTitle1("Destroyed");

            // Sprite作成
            const sprite = new Sprite(bitmap);

            // 位置調整
            sprite.x = (gw - sw) / 2;
            sprite.y = 0;

            // シーンに追加
            this.addChild(sprite);
        }

        update() {
            super.update();
            if (window.RSTH_IH._sceneInputLockFrames > 0) {
                window.RSTH_IH._sceneInputLockFrames--;
            }
            else if (Input.isTriggered("ok") || Input.isTriggered("cancel") || Input.isTriggered("escape") || TouchInput.isTriggered()) {

                window.RSTH_IH.slideScene(this, window.RSTH_IH.Scene_Result, "left", 30);
                //SceneManager.goto(window.RSTH_IH.Scene_Result);
            }
        }
    };

    window.RSTH_IH.Scene_Result = class extends Scene_MenuBase {
        start() {
            super.start();
            window.RSTH_IH._sceneInputLockFrames = 60;
        }

        create() {
            super.create();
            this.createTitle();
            this.createPortraitLayer();
            this.createResultWindow();

            AudioManager.stopMe();

            const bgm = {
                name: "mozetama_13_Beyond_the_Horizon",
                volume: 20,
                pitch: 100,
                pan: 0
            };
            AudioManager.playBgm(bgm);

        }

        createPortraitLayer() {
            this._portraitLayer = new Sprite();
            this.addChild(this._portraitLayer);

            this._portraitSprite = new window.RSTH_IH.Sprite_Portrait();
            this._portraitLayer.addChild(this._portraitSprite);

            const leader = $gameParty.leader();
            const actor = $dataActors[leader._actorId];
            const picName = actor?.meta.pic;
            this._portraitSprite.setPicture(picName);

        }


        createTitle() {
            this._title = new window.RSTH_IH.Sprite_VerticalTitleText("Result");
            this.addChild(this._title);
        }

        createBackground() {
            this._backgroundSprite = new Sprite();
            this._backgroundSprite.bitmap = ImageManager.loadTitle1("Night");
            this.addChild(this._backgroundSprite);

            // 読み込み後にスケール調整
            this._backgroundSprite.bitmap.addLoadListener(() => {
                const bw = this._backgroundSprite.bitmap.width;
                const bh = this._backgroundSprite.bitmap.height;

                // ✅ 縦のサイズを基準にスケール
                const scale = Graphics.height / bh;

                this._backgroundSprite.scale.x = scale;
                this._backgroundSprite.scale.y = scale;

                // ✅ 横の中央揃え
                const newWidth = bw * scale;
                this._backgroundSprite.x = (Graphics.width - newWidth) / 2;
                this._backgroundSprite.y = 0; // 上は固定

                // ✅ デバッグ表示（必要なら）
                // console.log(`Background scale: ${scale}, new width: ${newWidth}`);
            });
        }


        createResultWindow() {
            const rect = new Rectangle(120, 6, Graphics.width - 120, Graphics.height - 12);
            this._resultWindow = new window.RSTH_IH.Window_Result(rect);
            this.addChild(this._resultWindow);
        }

        update() {
            super.update();
            if (window.RSTH_IH._sceneInputLockFrames > 0) {
                window.RSTH_IH._sceneInputLockFrames--;
            }
            else if (Input.isTriggered("ok") || Input.isTriggered("cancel") || Input.isTriggered("escape") || TouchInput.isTriggered()) {
                SceneManager.goto(window.RSTH_IH.Scene_TitleCustom);
            }
        }
    };

    window.RSTH_IH.Window_Result = class extends Window_Base {
        initialize(rect) {
            super.initialize(rect);
            this.opacity = 0; // ウィンドウ枠なし
            this.backOpacity = 0; // 背景なし
            this.refresh();
        }

        standardFontSize() {
            return 16; // 任意のサイズ
        }

        lineHeight() {
            return 28; // 任意の行間
        }


        refresh() {
            this.contents.clear();
            const actor = $gameParty.leader();
            let y = 12;
            let x = 180;
            const mapname = window.RSTH_IH.MapName;
            const hit = window.RSTH_IH.calculateHit(actor.param(5), actor.param(7));
            const eva = window.RSTH_IH.calculateEva(actor.param(6), actor.param(7));
            const cri = window.RSTH_IH.calculateCritical(actor.param(5), actor.param(7));
            const crieva = window.RSTH_IH.calculateCriticalEva(actor.param(6), actor.param(7));
            const aspd = window.RSTH_IH.calculateAtkSpd(actor.param(6));
            const vitplus = actor._paramPlus[3] ?? 0;
            const vit = actor.paramBase(3) + vitplus;
            const unp = window.RSTH_IH.getUnshoP;
            //console.log("ConfigManager.unshoP", ConfigManager.unshoP);

            this.drawText(`MAP: ${mapname}`, 0, y, this.contentsWidth());
            y += this.lineHeight();
            //this.drawText(`獲得したうんしょポイント: ${unp}`, 0, y, this.contentsWidth());
            //y += this.lineHeight();
            this.drawText(`現在のうんしょポイント: ${window.RSTH_IH.unshoP}`, 0, y, this.contentsWidth());
            y += this.lineHeight() * 2;
            this.drawText(`Name: ${actor.name()}`, 0, y, this.contentsWidth());
            y += this.lineHeight();

            this.drawText(`Lv.${actor.level}`, 0, y, this.contentsWidth());
            y += this.lineHeight();
            this.drawText(`HP: ${actor.hp}/${actor.mhp}`, 0, y, this.contentsWidth());
            y += this.lineHeight();
            this.drawText(`SP: ${actor.mp}/${actor.mmp}`, 0, y, this.contentsWidth());
            y += this.lineHeight();

            this.drawText(`Def: ${actor.param(3)}`, 0, y, this.contentsWidth());
            y += this.lineHeight();
            this.drawText(`Str: ${actor.param(2)}`, 0, y, this.contentsWidth());
            this.drawText(`Hit: ${hit}`, x, y, this.contentsWidth());
            y += this.lineHeight();
            this.drawText(`Vit: ${vit}`, 0, y, this.contentsWidth());
            this.drawText(`Eva: ${eva}`, x, y, this.contentsWidth());
            y += this.lineHeight();
            this.drawText(`Dex: ${actor.param(5)}`, 0, y, this.contentsWidth());
            this.drawText(`Cri: ${cri}`, x, y, this.contentsWidth());
            y += this.lineHeight();
            this.drawText(`Agi: ${actor.param(6)}`, 0, y, this.contentsWidth());
            this.drawText(`CriEva: ${crieva}`, x, y, this.contentsWidth());
            y += this.lineHeight();
            this.drawText(`Luk: ${actor.param(7)}`, 0, y, this.contentsWidth());
            this.drawText(`Aspd: ${aspd}`, x, y, this.contentsWidth());
            y += this.lineHeight() * 2;

            this.drawText(`所持アイテム等:`, 0, y, this.contentsWidth());
            y += this.lineHeight();

            let y2 = y;
            const hw = 480;
            const equipedArmors = actor.equips();
            //console.log("equipedArmors", equipedArmors);
            equipedArmors.forEach((etypeId, index) => {
                if (etypeId) {
                    if (index === 1) {
                        this.drawText(`盾：${etypeId.name}`, hw + 16, y2, hw);
                        y2 += this.lineHeight();
                    }
                    else if (index === 2) {
                        this.drawText(`頭：${etypeId.name}`, hw + 16, y2, hw);
                        y2 += this.lineHeight();
                    }
                    else if (index === 3) {
                        this.drawText(`身体：${etypeId.name}`, hw + 16, y2, hw);
                        y2 += this.lineHeight();
                    }
                    else if (index === 4) {
                        this.drawText(`装飾品1：${etypeId.name}`, hw + 16, y2, hw);
                        y2 += this.lineHeight();
                    }
                    else if (index === 5) {
                        this.drawText(`装飾品2：${etypeId.name}`, hw + 16, y2, hw);
                        y2 += this.lineHeight();
                    }
                }

            });

            const hotbar = $gameSystem._customHotbarItems || [];
            //console.log("hotbar", hotbar);
            hotbar.forEach((slot, index) => {
                if (slot) {
                    let slotcount = slot.count;
                    let item = null;
                    if (slot.type === "weapon") item = $dataWeapons[slot.id];
                    else if (slot.type === "armor") item = $dataArmors[slot.id];
                    else if (slot.type === "item") item = $dataItems[slot.id];
                    else item = $dataItems[slot.id];

                    if (slotcount === 1) {
                        this.drawText(`Slot ${index + 1}: ${item.name}`, 0, y, hw);
                    } else {
                        this.drawText(`Slot ${index + 1}: ${item.name} x ${slot.count}`, 0, y, hw);
                    }
                    y += this.lineHeight();
                }
            });

            let otext = "";
            if (window.RSTH_IH._selectedActorId === 1) {
                if (window.RSTH_IH.EquipmentOtomoIdActor1) {
                    otext = $dataWeapons[window.RSTH_IH.EquipmentOtomoIdActor1].name;
                }
            }
            else if (window.RSTH_IH._selectedActorId === 2) {
                if (window.RSTH_IH.EquipmentOtomoIdActor2) {
                    otext = $dataWeapons[window.RSTH_IH.EquipmentOtomoIdActor2].name;
                }
            }
            else if (window.RSTH_IH._selectedActorId === 3) {
                if (window.RSTH_IH.EquipmentOtomoIdActor3) {
                    otext = $dataWeapons[window.RSTH_IH.EquipmentOtomoIdActor3].name;
                }
            }
            if (otext) {
                this.drawText(`お供: ${otext}`, 0, y, this.contentsWidth());
            }

            y += this.lineHeight() * 2;
            this.drawText(`Zeny: ${$gameParty.gold()}`, 0, y, this.contentsWidth());
            y += this.lineHeight();
            this.drawText(`Mob討伐数: ${window.RSTH_IH.KilledMobCount}`, 0, y, this.contentsWidth());
        }
    };


})();