/*:
 * @target MZ
 * @plugindesc RSTH_IH: サバイバルゲームシステムプラグイン
 * @author © 2025 ReSera_りせら（@MOBIUS1001）
 *
 * このソースコードは無断での転載、複製、改変、再配布、商用利用を固く禁じます。
 * 禁止事項の例：
 * - 本ファイルの全部または一部を許可なくコピー、再配布すること
 * - 本ファイルを改変して配布すること
 * - 商用目的での利用
 */

(() => {
    "use strict";

    window.RSTH_IH.Window_Treasure = class extends Window_Base {
        constructor(rect) {
            super(rect);
            this.setBackgroundType(0);
            this.opacity = 255;
            this.contents.paintOpacity = 255;
            this._padding = 6;
            this._lineHeight = 48;
            this._lines = [];
            this._item = null;
            this.setTreasure();
        }

        setTreasure() {
            const group = (function () {
                if (window.RSTH_IH.treasureCallFlag === 1) return $gameSystem._i_ev1;

                const r = Math.random();
                if (r < 0.1) return $gameSystem._w_lv1;
                else if (r < 0.3) return $gameSystem._a_lv1;
                else if (r < 0.31) return $gameSystem._i_ex;
                //else if (r < 0.99) return $gameSystem._i_ex;
                else return $gameSystem._i_lv1;
            })();
            const treasure = group[Math.floor(Math.random() * group.length)];
            this.setText(treasure);
        }

        setText(item) {
            if (!item) return;

            this._item = item;

            const name = item.name || "???";
            const type = window.RSTH_IH.getEtypeIdName(item);
            const desc = item.description || "";

            this._lines = [
                name,
                "",
                `種別：${type}`
            ];
            /*
                        if (item.etypeId != null) {
                            if (item.params[0] !== 0) this._lines.push(`MaxHP：${item.params[0]}`);
                            if (item.params[1] !== 0) this._lines.push(`MaxMP：${item.params[1]}`);
                            if (item.params[2] !== 0) this._lines.push(`Atk：${item.params[2]}`);
                            if (item.params[3] !== 0) this._lines.push(`Def：${item.params[3]}`);
                            if (item.params[4] !== 0) this._lines.push(`MAtk：${item.params[4]}`);
                            if (item.params[5] !== 0) this._lines.push(`Dex：${item.params[5]}`);
                            if (item.params[6] !== 0) this._lines.push(`Agi：${item.params[6]}`);
                            if (item.params[7] !== 0) this._lines.push(`Luk：${item.params[7]}`);
                        }
            */
            // ✅ \n を改行文字として分割し、各行を push
            const descLines = desc.split(/\\n/); // バックスラッシュ n を改行として分割
            this._lines.push(...descLines);

            this.refresh();
        }


        refresh() {
            const gw = Graphics.boxWidth;
            const width = gw / 5;
            const iconBoxHeight = 48;

            this.contents.clear();
            this.contents.fontSize = 24;
            this.contents.textColor = "#ffffff";
            this.contents.outlineColor = "#000000";
            this.contents.outlineWidth = 3;

            // アイテムアイコンを中央上に描画
            if (this._item && this._item.iconIndex > 0) {
                const iconX = Math.floor((width - ImageManager.iconWidth) / 2);
                const iconY = 96;
                this.drawIcon(this._item.iconIndex, iconX, iconY);
            }

            // テキスト描画
            for (let i = 0; i < this._lines.length; i++) {
                const line = this._lines[i];
                const y = this.padding + iconBoxHeight + i * this._lineHeight;
                this.drawText(line, 12, y + 196, width - 36, this.lineHeight, "left");
            }
        }
    };


    window.RSTH_IH.TreasureTable = function (system) {
        //console.log("window.RSTH_IH.SetTreasure", window.RSTH_IH.SetTreasure);
        if (window.RSTH_IH.SetTreasure === 1) {
            const w_lv1 = $dataWeapons.filter(w => w && w.meta && (w.meta.treasure === "1" || w.meta.treasure === "WEX"));
            const a_lv1 = $dataArmors.filter(a => a && a.meta && a.meta.treasure === "1");
            const i_lv1 = $dataItems.filter(i => i && i.meta && i.meta.treasure === "1");
            const i_ex = $dataItems.filter(i => i && i.meta && i.meta.treasure === "ex");
            system._w_lv1 = w_lv1;
            system._a_lv1 = a_lv1;
            system._i_lv1 = i_lv1;
            system._i_ex = i_ex;
        } else if (window.RSTH_IH.SetTreasure === 2) {
            const w_lv1U = $dataWeapons.filter(w => w && w.meta && (w.meta.treasure === "2" || w.meta.treasure === "WEX"));
            const a_lv1U = $dataArmors.filter(a => a && a.meta && a.meta.treasure === "2");
            const i_lv1U = $dataItems.filter(i => i && i.meta && i.meta.treasure === "1");
            const i_ex = $dataItems.filter(i => i && i.meta && i.meta.treasure === "ex");
            system._w_lv1 = w_lv1U;
            system._a_lv1 = a_lv1U;
            system._i_lv1 = i_lv1U;
            system._i_ex = i_ex;
        } else if (window.RSTH_IH.SetTreasure === 3) {
            const w_lv1U = $dataWeapons.filter(w => w && w.meta && (w.meta.treasure === "3" || w.meta.treasure === "WEX"));
            const a_lv1U = $dataArmors.filter(a => a && a.meta && a.meta.treasure === "3");
            const i_lv1U = $dataItems.filter(i => i && i.meta && i.meta.treasure === "1");
            const i_ex = $dataItems.filter(i => i && i.meta && i.meta.treasure === "ex");
            system._w_lv1 = w_lv1U;
            system._a_lv1 = a_lv1U;
            system._i_lv1 = i_lv1U;
            system._i_ex = i_ex;
        }

        const i_ev1 = $dataItems.filter(i => i && i.meta && i.meta.treasure === "ex");
        system._i_ev1 = i_ev1;
    }

    window.RSTH_IH.TreasureEasy = function () {
        let tresureAmount = 1;
        let random = Math.random();
        if (random < 0.05) tresureAmount = 5;
        else if (random < 0.3) tresureAmount = 3;

        let treasure = [];
        let tr = null;
        for (let i = 0; i < tresureAmount; i++) {
            const group = (function () {
                const r = Math.random();
                if (r < 0.1) return $gameSystem._w_lv1;
                else if (r < 0.3) return $gameSystem._a_lv1;
                else if (r < 0.31) return $gameSystem._i_ex;
                //else if (r < 0.99) return $gameSystem._i_ex;
                else return $gameSystem._i_lv1;
            })();
            tr = group[Math.floor(Math.random() * group.length)];
            treasure.push(tr);
            //console.log("tresureAmount", tresureAmount);
            //console.log("tr", tr);
            //console.log("treasure", treasure);
        }
        //console.log("total_treasure", treasure);
        $gameSystem._pendingTreasureItems = treasure;

        window.RSTH_IH.logTreasure();
        if ($gameSystem._pendingTreasureItems?.length) {
            for (const item of $gameSystem._pendingTreasureItems) {

                //console.log("item", item);
                $gameParty.gainItem(item, 1);
            }
            $gameSystem._pendingTreasureItems = null;
        }
    }

    window.RSTH_IH.Scene_Treasure = class extends Scene_MenuBase {
        create() {
            super.create();
            this._title = window.RSTH_IH.createTitleText("トレジャー！！！！");
            this.addChild(this._title);

            let tresureAmount = 1;
            let random = Math.random();
            if (random < 0.05 || window.RSTH_IH.treasureCallFlag === 1) tresureAmount = 5;
            else if (random < 0.3) tresureAmount = 3;

            const gw = Graphics.boxWidth;
            const gh = Graphics.boxHeight;
            const width = gw / 5;
            const height = gh - 128;
            const margin = 4;
            const x = (gw - width) / 2 + margin;
            const y = 128;

            this._treasureWindows = [];

            const positions = [0]; // 中央
            if (tresureAmount >= 3) positions.push(-1, 1); // 左右に追加
            if (tresureAmount === 5) positions.push(-2, 2); // さらに外側に追加

            for (let i = 0; i < positions.length; i++) {
                const offset = positions[i];
                const rect = new Rectangle(x + offset * width, y, width, height);
                const win = new window.RSTH_IH.Window_Treasure(rect);
                this._treasureWindows.push(win);
                this.addChild(win);
            }

        }

        update() {
            super.update();
            if (TouchInput.isTriggered()) {
                $gameSystem._pendingTreasureItems = this._treasureWindows.map(w => w._item).filter(i => i);

                window.RSTH_IH.logTreasure();
                window.RSTH_IH.treasureCallFlag = 0;
                SceneManager.pop();
            }
        }

    }

    Scene_Map.prototype.start = function () {
        Scene_Base.prototype.start.call(this);
        if ($gameSystem._pendingTreasureItems?.length) {
            for (const item of $gameSystem._pendingTreasureItems) {
                $gameParty.gainItem(item, 1);
            }
            $gameSystem._pendingTreasureItems = null;
        }
    };

    const _RSTH_treasure_GameSystem_initialize = Game_System.prototype.initialize;
    Game_System.prototype.initialize = function () {
        _RSTH_treasure_GameSystem_initialize.call(this);
        window.RSTH_IH.TreasureTable(this);
    }

})();