/*:
 * @target MZ
 * @plugindesc RSTH_IH: サバイバルゲームシステムプラグイン
 * @author © 2025 ReSera_りせら（@MOBIUS1001）
 *
 * このソースコードは無断での転載、複製、改変、再配布、商用利用を固く禁じます。
 * 禁止事項の例：
 * - 本ファイルの全部または一部を許可なくコピー、再配布すること
 * - 本ファイルを改変して配布すること
 * - 商用目的での利用
 */

(() => {
    "use strict";

    // ログ出力制御フラグ（trueでログ出力、falseで抑制）
    //const RSTH_DEBUG_LOG = true;
    const RSTH_DEBUG_LOG = false;

    // ダメージ計算
    window.RSTH_IH.damage_calculation = function (item, mob, npc, from = "actor", target = "mob", bowatk = 0) {
        if (!mob) return 0;

        const player = $gameParty.leader();
        let a = null;
        let d = null;
        let ahit = 0;
        let deva = 0;
        let hitrate = 0;
        let dmg = 0;
        let aatk = 0;
        let ddef = 0;
        let pw = 0;
        let df = 0;
        let acri = 0;
        let dcrieva = 0;
        let crirate = 0;
        let variance = 0; // ダメージ分散 %
        let maxvariance = 6; // 最大ダメージ分散 + 1 %
        let criflag = 0;
        let hitflag = false;
        const isSkill = item?.hasOwnProperty("stypeId"); // itemがskillかどうか
        let hasAtkup = false; // AtkUPステート所持かどうか

        //console.log("from", from);

        if (from === "actor") {
            a = player;
            ahit = window.RSTH_IH.calculateHit(a.param(5), a.param(7));
            acri = window.RSTH_IH.calculateCritical(a.param(5), a.param(7));
            aatk = a.param(2);
            d = mob;
            deva = window.RSTH_IH.calculateEva(d._agi, d._luk);
            ddef = d._def;
            dcrieva = window.RSTH_IH.calculateCriticalEva(d._agi, d._luk);
            hasAtkup = a.hasState(14);
            //console.log("a", a);
            //console.log("d", d);
        } else if (from === "mob") {
            a = mob;
            ahit = window.RSTH_IH.calculateHit(a._dex, a._luk);
            aatk = a._atk;
            acri = window.RSTH_IH.calculateCritical(a._dex, a._luk);
            //console.log("a", a);
            if (npc) {
                d = npc;
                // console.log("a", a);
                //console.log("d", d);
                deva = window.RSTH_IH.calculateEva(d._agi, d._luk);
                ddef = d._def;
                dcrieva = window.RSTH_IH.calculateCriticalEva(d._agi, d._luk);
            } else {
                d = $gameParty.leader();
                //console.log("a", a);
                //console.log("d", d);
                deva = window.RSTH_IH.calculateEva(d.param(6), d.param(7));
                ddef = d.def;
                dcrieva = window.RSTH_IH.calculateCriticalEva(d.param(6), d.param(7));
            }
            //console.log("d", d);
            // console.log("ddef", ddef);
            hasAtkup = a.hasState(14);
        } else if (from === "npc") {
            a = npc;
            ahit = window.RSTH_IH.calculateHit(a._dex, a._luk);
            aatk = a._atk;
            acri = window.RSTH_IH.calculateCritical(a._dex, a._luk);

            // console.log("[npc]a", a, `ahit = ${ahit} aatk = ${aatk} acri = ${acri}`);
            //  console.log(`[npc]a a._dex = ${a._dex}  a._luk = ${a._luk}`);
            d = mob;
            deva = window.RSTH_IH.calculateEva(d._agi, d._luk);
            ddef = d._def;
            dcrieva = window.RSTH_IH.calculateCriticalEva(d._agi, d._luk);

            // console.log("[mob]d", d);
            // console.log("ddef", ddef);
            hasAtkup = a.hasState(14);
        }

        // 攻撃側の攻撃力計算
        pw += aatk;
        if (item) {
            const isHpDamage = isSkill && (item.damage.type === 1 || item.damage.type === 5);
            const isArrow = !isSkill && item.meta?.arrow;
            const isBowOnly = !isSkill && item.id === 70;
            const hasParamAtk = !isSkill && item.params?.[2];

            if (isHpDamage) {
                maxvariance = item.damage.variance;
                pw += Number(item.damage.formula);
            } else if (isArrow) {
                pw += Number(item.meta.atk || 0);
                pw += Number(bowatk);
            } else if (isBowOnly) {
                pw += Number(bowatk);
            } else if (hasParamAtk) {
                pw += item.params[2];
            }
        }

        //console.log("pw", pw);

        if (hasAtkup) pw = Math.round(pw * 1.25); // AtkUpステートがある場合

        hitrate = window.RSTH_IH.calculateHitRate(ahit, deva) / 100;
        crirate = window.RSTH_IH.calculateCriticalRate(acri, dcrieva) / 100;

        const rdm = Math.random();
        variance = Math.floor(rdm * maxvariance); // 先に1回だけ実行

        //攻撃の命中判定とダメージ決定
        if (rdm < crirate) {
            criflag = 1;
            pw *= 1.2;
            dmg = Math.round(pw);
            dmg = Math.round(dmg * (100 + variance) / 100);
            if (dmg < 1) dmg = 1;
        } else if (rdm < hitrate) {
            hitflag = true;
            df += ddef;
            dmg = Math.round(pw - df);
            dmg = Math.round(dmg * (100 + variance) / 100);
            if (dmg < 1) dmg = 1;
        }

        //  console.log("dmg", dmg);

        const isDrain = isSkill && item.damage.type === 5;
        const isCrit = criflag === 1;
        const isHit = hitflag === true;

        let gainzeny = 0;
        let addstate = 0;
        if (item && item.meta) {
            if (item.meta.zeny) gainzeny = Number(item.meta.zeny);
            if (item.meta.addstate) addstate = Number(item.meta.addstate);
        }
        if (from === "actor") {
            if (isHit || isCrit) {
                //console.log("dmg", dmg);
                mob.takeDamage(dmg, isCrit ? 1 : 0);
                //console.log("mob", mob);
                window.RSTH_IH.Window_CheckAchievement(0, dmg);

                if (isDrain) {
                    $gameParty.leader().gainHp(dmg);
                    window.RSTH_IH.showPlayerDamagePopup(-dmg, criflag);
                }

                if (gainzeny > 0) {
                    const party = $gameParty;
                    if (party) {
                        party.gainGold(gainzeny);
                    }
                }
                if (addstate > 0) {
                    mob.addState(addstate);
                }
            }
        } else if (from === "mob") {
            if (npc) {
                if (isHit || isCrit) {
                    //console.log("dmg", dmg);
                    npc.takeDamage(dmg, isCrit ? 1 : 0);
                    //console.log("npc", npc);

                    if (addstate > 0) {
                        npc.addState(addstate);
                    }
                    //console.log("npc", npc);
                }
            } else {
                if (isHit || isCrit) {

                    if ($gameParty.leader() && $gameParty.leader().hasState(19)) {
                        dmg = Math.round(dmg / 2);
                    }

                    if ($gameParty.leader() && $gameParty.leader().hasState(21)) {
                        if (dmg <= 20) dmg = 0;
                    }

                    if (dmg > 0) {
                        $gameParty.leader().gainHp(-dmg);
                        window.RSTH_IH.showPlayerDamagePopup(dmg, isCrit ? criflag : undefined);
                        $gamePlayer.startShake();

                        //プレイヤーのヒットストップ
                        if (ConfigManager["gauge_HS"] !== 1) {
                            if ($gameParty.leader().hasState(25) === false &&
                                $gameParty.leader().hasState(29) === false) {
                                $gamePlayer.startHitStop(isCrit ? 30 : 10);
                            }
                        }
                    }

                    if (isDrain && mob._maxhp > mob._hp) {
                        const hpdiff = mob._maxhp - mob.hp;
                        if (dmg >= hpdiff) dmg -= hpdiff;
                        if (dmg > 0) mob.takeDamage(-dmg, criflag);
                    }

                    const seId = isCrit ? 10 : 14;
                    AudioManager.playSe($dataSystem.sounds[seId]);

                    const chara = $gameParty.leader();
                    const hpper = chara.hp / chara.mhp * 100;
                    if (hpper <= ConfigManager.autoPotionPercent) {
                        if (hpper !== 100 || hpper > 0) {
                            window.RSTH_IH.UseAutoPotion();
                        } else { }
                    }

                } else {
                    window.RSTH_IH.showPlayerDamagePopup("miss");
                }
            }
        } else if (from === "npc") {
            if (isHit || isCrit) {
                //console.log("dmg", dmg);
                mob.takeDamage(dmg, isCrit ? 1 : 0);
                //console.log("npc", npc);

                if (addstate > 0) {
                    mob.addState(addstate);
                }
                //console.log("npc", npc);
            }
        }

        if (RSTH_DEBUG_LOG) {
            console.log("a", a, "d", d);
            console.log("isCrit", isCrit, "isHit", isHit);
            console.log("mob", mob);
            console.log("variance", variance);
            console.log("maxvariance", maxvariance);
            console.log("from", from, "ahit", ahit, "deva", deva, "hitrate", hitrate, "aatk", aatk, "ddef", ddef);
            console.log("pw ", pw, "df", df);
            console.log("acri", acri, "dcrieva", dcrieva, "crirate", crirate);
            console.log("dmg ", dmg);
        }

        return dmg;

    }

    // クールタイム計算
    window.RSTH_IH.atkCooltime = function (item) {
        if (!item) return 60;
        const dataItem = window.RSTH_IH.getGameItem(item);
        if (!dataItem.meta) return 60;
        const baseCT = Number(dataItem.meta.cooltime);
        if (dataItem.meta.fixedCT) return baseCT;
        const player = $gameParty.leader();
        const aspd = window.RSTH_IH.calculateAtkSpd(player.agi);
        const minct = 30;
        let atkCT = Math.round(baseCT - baseCT * (aspd / 100));
        if (atkCT < minct) atkCT = minct;
        if (!atkCT) return 60;
        return atkCT;
    }

    // スキル使用 mob npc専用
    window.RSTH_IH.executeSkill = function (target, source, skill, from = "mob") {
        if (!target) return;

        // console.log("target", target);
        //console.log("source", source);

        const player = $gamePlayer;
        const actor = $gameParty.leader();
        const sx = source._x;
        const sy = source._y;
        const tx = target._x;
        const ty = target._y;

        // 属性を取得
        const meta = skill.meta || {};
        const isProjectile = meta.projectile || false;
        const isBoomerang = meta.boomerang || false;
        const range = Number(meta.range || 0);
        //console.log("addstate", addstate);

        // 向き更新（オプション）
        if (from === "mob") {
            source._direction = source.calculateDirectionToPlayer?.() ?? source._direction;
        }
        else if (from === "npc") {
            source._direction = source.calculateDirectionToTarget(target) ?? source._direction;
        }

        source._sprite?.updatePattern?.(source._pattern, source._direction);
        source._sprite?.startRedFlash?.();


        if (isProjectile) {
            // 弾を発射（itemIdは矢など）
            const item = $dataItems[meta.itemId || 40]; // fallback: itemId=40
            const bowatk = skill.damage?.value ?? source._atk;
            if (from === "mob") {
                window.RSTH_IH.ProjectileManager.createArrow(sx, sy, tx, ty, item, bowatk, "mob", source);

            }
            else if (from === "npc") {
                window.RSTH_IH.ProjectileManager.createArrow(sx, sy, tx, ty, item, bowatk, "npc", source);

            }
        }
        else if (isBoomerang) {
            // ブーメラン投擲
            const power = skill.damage?.value ?? source._atk;
            const maxDist = Number(meta.maxDist || 6);

            if (from === "mob") {
                window.RSTH_IH.ProjectileManager.createBoomerang(skill, sx, sy, tx, ty, power, maxDist, "mob", source);

            }
            else if (from === "npc") {
                window.RSTH_IH.ProjectileManager.createBoomerang(skill, sx, sy, tx, ty, power, maxDist, "npc", source);

            }

        }
        else if (meta.selfBuff) {
            // 自身にステート付与（例: <selfBuff:3> でステートID3）
            const stateId = Number(meta.selfBuff);
            if (stateId) {
                //console.log("stateId", stateId);
                source.addState?.(stateId);
            }
        }
        else if (meta.addstate) {
            const stateId = Number(meta.addstate);

            // powerupによるステート抵抗
            // 麻痺
            if (stateId === 11 && ConfigManager["gauge_ST2"] === 1) {
                return;
            }
            // 毒
            if (stateId === 4 && ConfigManager["gauge_ST1"] === 1) {
                return;
            }
            // 猛毒
            if (stateId === 7 && ConfigManager["gauge_ST1"] === 1) {
                return;
            }
            // 混乱
            if (stateId === 8 && ConfigManager["gauge_ST1"] === 1) {
                return;
            }
            // 熱い！！
            if (stateId === 5 && ConfigManager["gauge_IG"] === 1) {
                return;
            }

            if (target._actorId) {
                actor.addState(stateId);
            } else {
                target.addState(stateId);

            }
        }
        else {
            // 通常スキル攻撃（近接系）
            if (source._type === "mob") {

                if (target._type) {
                    const npc = window.RSTH_IH._npcManager.getNpcAt(tx, ty);
                    // function (item, mob, npc, from = "actor", target = "mob", bowatk = 0)
                    const dmg = window.RSTH_IH.damage_calculation(skill, source, target, "mob", "npc");
                    //console.log("[npc]dmg", dmg);
                    npc.showDamagePopup(dmg);

                } else {
                    window.RSTH_IH.damage_calculation(skill, source, null, "mob", "actor");

                }

            }
            else if (source._type === "npc") {
                const mob = window.RSTH_IH._mobManager.getMobAt(tx, ty);
                // function (item, mob, npc, from = "actor", target = "mob", bowatk = 0)
                const dmg = window.RSTH_IH.damage_calculation(skill, target, source, "npc", "mob");

                // console.log("[mob]dmg", dmg);
                mob.showDamagePopup(dmg);
            }
        }

    };

    window.RSTH_IH.updateStateEffectTimers = function () {
        const actor = $gameParty.leader();
        if (!actor) return;
        if ($gameMessage.isBusy()) return; // 会話中は減らさない

        const times = actor._stateEffectTimes || {};
        const removed = [];

        for (const stateId of actor._states) {
            if (!(stateId in times)) continue;

            times[stateId]--;
            if (times[stateId] <= 0) {
                removed.push(stateId);
            }
        }

        removed.forEach(stateId => {
            actor.removeState(stateId);
            delete times[stateId];
            const state = $dataStates[stateId];
            //console.log(`[updateStateEffectTimers] ${state.name} の効果が切れた`);
        });
    };

    Game_Actor.prototype.hasState = function (stateId) {
        return this._states.includes(stateId);
    };

    const _Game_Battler_addState = Game_Battler.prototype.addState;
    Game_Battler.prototype.addState = function (stateId) {
        _Game_Battler_addState.call(this, stateId);

        const state = $dataStates[stateId];
        if (!this._stateEffectTimes) this._stateEffectTimes = {};

        const effectTime = Number(state.meta.et || 0);
        if (effectTime > 0) {
            this._stateEffectTimes[stateId] = effectTime;
            //console.log(`[addState] ステート${state.name} に制限時間 ${effectTime} フレーム設定`);
        }
    };

    const _Game_Player_update = Game_Player.prototype.update;
    Game_Player.prototype.update = function (sceneActive) {
        _Game_Player_update.call(this, sceneActive);

        this.updateStateMoveSpeed();
        window.RSTH_IH.updateStateEffectTimers();
    };

    Game_Player.prototype.updateStateMoveSpeed = function () {
        const actor = $gameParty.leader();
        if (!actor) return;

        let addSpd = 0;

        actor.states().forEach(state => {
            const spdMeta = Number(state.meta?.spd || 0);
            addSpd += spdMeta;
        });

        // デフォルト移動速度 + ステート分加算
        const baseSpeed = 4;  // デフォルト移動速度
        this._moveSpeed = baseSpeed + addSpd;

        if (window.RSTH_IH?.DEBUG_LOG) {
            //console.log(`[updateStateMoveSpeed] ステート補正 +${addSpd}, 合計:${this._moveSpeed}`);
        }
    };

    const _Game_Actor_die = Game_Actor.prototype.die;
    Game_Actor.prototype.die = function () {
        if (this.isActor() && this.actorId() === $gameParty.leader().actorId()) {
            if (window.RSTH_IH.reviveFlag) {
                this._hp = this.mhp; // HP全回復（必要なら1でも可）
                window.RSTH_IH.reviveFlag = false;
                $gameScreen.startFlash([255, 255, 255, 160], 60);
                window.RSTH_IH.LogWindowManager.addLog("自動復活！！！", 1);
                $gameParty.leader().removeState(6);
                return; // 死亡をキャンセル
            }
        }
        _Game_Actor_die.call(this);
    };

    // ダメージポップアップ
    window.RSTH_IH.Sprite_DamagePopup = class extends Sprite {
        constructor(amount, cri = 0) {
            super();
            this.anchor.set(0.5, 0.0);
            this._frameCount = 0;
            this._lifespan = 90;
            this._vx = 0.3 + Math.random() * 0.4;
            this._vy = -1 - Math.random() * 0.5;
            this._gravity = 0.05;
            this.z = 20;
            this._isRSTH_Temporary = true;

            // ✅ 初期位置をもっと上にずらす
            this.y -= 64; // 必要な分だけ上に。-32なら32px上に

            const number = amount === "miss" ? "MISS" :
                (amount < 0 ? `+${Math.abs(amount)}` : `${amount}`);

            this._digitSprites = [];
            this.createNumberSprites(number, cri);
        }


        createNumberSprites(number, cri) {
            let sheet;

            if (cri === 1) {
                sheet = ImageManager.loadSystem("NumberDigits_Yellow");
            } else if (number.startsWith('+')) {
                sheet = ImageManager.loadSystem("NumberDigits_Green");
            } else {
                sheet = ImageManager.loadSystem("NumberDigits_Red");
            }

            const digitWidth = 32;   // 1桁の幅を実画像に合わせる
            const digitHeight = 32;
            const missWidth = 64;    // MISS の幅

            const missMode = (number === "MISS");

            let x = 0;

            for (let i = 0; i < number.length; i++) {
                const char = number[i];
                const sprite = new Sprite(sheet);

                if (missMode) {
                    // 0〜9(10) + + (11) + - (12) → MISS は13番目なら X=12*digitWidth
                    sprite.setFrame(12 * digitWidth, 0, missWidth, digitHeight);
                    // MISS は1回だけ出すのでループbreak
                    this.addChild(sprite);
                    this._digitSprites.push(sprite);
                    break;
                } else {
                    let index = 0;
                    if (char === '+') {
                        index = 10; // + の位置
                    } else if (char === '-') {
                        index = 11; // - の位置
                    } else {
                        index = Number(char);
                    }
                    if (isNaN(index)) continue;

                    sprite.setFrame(index * digitWidth, 0, digitWidth, digitHeight);
                    sprite.x = x;
                    sprite.y = 0;

                    this.addChild(sprite);
                    this._digitSprites.push(sprite);

                    x += digitWidth; // 次の桁の位置にずらす
                }
            }
        }


        update() {
            super.update();
            this._frameCount++;

            this.x += this._vx;
            this.y += this._vy;
            this._vy += this._gravity;

            const fadeStart = 40;
            if (this._frameCount > fadeStart) {
                this.opacity -= 255 / (this._lifespan - fadeStart);
            }

            if (this._frameCount >= this._lifespan) {
                if (this.parent) {
                    this.parent.removeChild(this);
                }
                // 念のためにTilemapにも探索して除去
                if (this.parent && this.parent.children.includes(this)) {
                    this.parent.removeChild(this);
                }
            }
        }


    };


    // プレイヤー側ポップアップ
    window.RSTH_IH.showPlayerDamagePopup = function (amount, cri = 0) {
        const sprite = window.RSTH_IH.getPlayerSprite();
        if (!sprite) return;

        if (!window.RSTH_IH.DmgPopup) return;
        const popup = new window.RSTH_IH.Sprite_DamagePopup(amount, cri);
        popup.x = -16;
        popup.y = -32;
        sprite.addChild(popup);
    };

    window.RSTH_IH.getPlayerSprite = function () {
        const spriteset = SceneManager._scene._spriteset;
        if (!spriteset) return null;

        const charSprites = spriteset._characterSprites;
        for (const sprite of charSprites) {
            if (sprite._character === $gamePlayer) {
                return sprite;
            }
        }
        return null;
    };

    // Sprite_Character のメソッドを拡張する
    // プレイヤースプライトの HP/MP バーを表示する
    const _Sprite_Character_initialize = Sprite_Character.prototype.initialize;
    Sprite_Character.prototype.initialize = function (character) {
        _Sprite_Character_initialize.call(this, character);

        if (character === $gamePlayer) {
            this._hpMpBarSprite = new Sprite(new Bitmap(60, 16));
            this.addChild(this._hpMpBarSprite);
            this._lastHp = -1;
            this._lastMp = -1;
        }
    };

    const _Sprite_Character_update = Sprite_Character.prototype.update;
    Sprite_Character.prototype.update = function () {
        _Sprite_Character_update.call(this);

        if (this._character === $gamePlayer) {
            this.updateHpMpBar();
        }
    };

    Sprite_Character.prototype.updateHpMpBar = function () {
        const actor = $gameParty.leader();
        if (!actor || !this._hpMpBarSprite) return;

        // 変化なしなら更新不要
        if (this._lastHp === actor.hp && this._lastMp === actor.mp) return;

        this._lastHp = actor.hp;
        this._lastMp = actor.mp;

        const bitmap = this._hpMpBarSprite.bitmap;
        bitmap.clear();

        const maxWidth = 60;
        const hpRate = actor.hpRate();
        const mpRate = actor.mpRate();

        // 背景
        bitmap.fillRect(0, 0, maxWidth, 8, "#000000");
        bitmap.fillRect(0, 8, maxWidth, 8, "#000000");

        // HPバー
        bitmap.gradientFillRect(0, 0, Math.floor(maxWidth * hpRate), 8,
            ColorManager.hpGaugeColor1(), ColorManager.hpGaugeColor2());

        // MPバー
        bitmap.gradientFillRect(0, 8, Math.floor(maxWidth * mpRate), 8,
            ColorManager.mpGaugeColor1(), ColorManager.mpGaugeColor2());
    };

    const _updatePosition = Sprite_Character.prototype.updatePosition;
    Sprite_Character.prototype.updatePosition = function () {
        _updatePosition.call(this);

        if (this._character === $gamePlayer) {
            if (!this._shakePower) this._shakePower = 0;
            if (!this._shakeX) this._shakeX = 0;
            if (!this._shakeY) this._shakeY = 0;

            if (this._shakePower > 0) {
                this._shakeX = (Math.random() - 0.5) * this._shakePower;
                this._shakeY = (Math.random() - 0.5) * this._shakePower;
                this._shakePower -= 1;
            } else {
                this._shakeX = 0;
                this._shakeY = 0;
            }

            this.x += this._shakeX;
            this.y += this._shakeY;
        }

        if (this._character === $gamePlayer && this._hpMpBarSprite) {
            // スプライトの真下にバー表示
            this._hpMpBarSprite.x = -30;
            this._hpMpBarSprite.y = this.patternHeight() / 2 - 20;
        }
    };

    const _Sprite_Character_destroy = Sprite_Character.prototype.destroy;
    Sprite_Character.prototype.destroy = function () {
        if (this._hpMpBarSprite?.bitmap) {
            this._hpMpBarSprite.bitmap.destroy();
        }
        _Sprite_Character_destroy.call(this);
    };

    // プレイヤー用の startShake を追加
    Game_Player.prototype.startShake = function () {
        const spriteset = SceneManager._scene._spriteset;
        const playerSprite = spriteset.findCharacterSprite(this);
        if (playerSprite) {
            playerSprite._shakePower = 12;
        }
    };

    // Sprite_Character 取得用
    Spriteset_Map.prototype.findCharacterSprite = function (character) {
        return this._characterSprites.find(sprite => sprite._character === character);
    };

    window.RSTH_IH.calculateHit = function (dex, luk) {
        const hit = 75 + dex * 3 + luk;
        return hit;
    }

    window.RSTH_IH.calculateEva = function (agi, luk) {
        const eva = agi * 3 + luk;
        return eva;
    }

    window.RSTH_IH.calculateHitRate = function (a_hit, b_eva) {
        let hitrate = a_hit - b_eva;
        if (hitrate < 0) hitrate = 0;
        if (hitrate > 100) hitrate = 100;
        return hitrate;
    }

    window.RSTH_IH.calculateAtkSpd = function (agi) {
        const atkspd = Math.round(agi / 200 * 100);
        return atkspd;
    }

    window.RSTH_IH.calculateCritical = function (dex, luk) {
        const cri = Math.round(dex / 2 + luk);
        return cri;
    }

    window.RSTH_IH.calculateCriticalEva = function (agi, luk) {
        const crieva = Math.round(agi / 2 + luk);
        return crieva;
    }

    window.RSTH_IH.calculateCriticalRate = function (a_cri, b_crieva) {
        let crirate = Math.round(a_cri - b_crieva);
        if (crirate < 0) crirate = 0;
        if (crirate > 100) crirate = 100;
        return crirate;
    }

    window.RSTH_IH.calculateCastTime = function (time, dex) {
        const casttime = Math.round(time - (time * dex / 150));
        return casttime;
    }

    window.RSTH_IH.showSkillNamePopup = function (target, skill) {
        if (!target || !skill) return;
        const sprite = target.sprite?.();
        if (!sprite) return;

        const popup = new window.RSTH_IH.Sprite_SkillNamePopup(skill.name);
        popup.anchor.set(0.5, 3.5); // 中央揃えで下端を基準に
        popup.x = sprite.width / 2; // スプライト中央
        popup.y = -4;               // スプライト上に少し余白（-64だと上すぎる場合がある）

        sprite.addChild(popup);
    };


    window.RSTH_IH.Sprite_SkillNamePopup = class extends Sprite {
        constructor(text) {
            // 仮の幅と高さで初期化（後で再生成）
            super(new Bitmap(1, 1));
            this._frameCount = 0;
            this._lifespan = 90;

            // テキスト測定用に仮のBitmapでサイズ計測
            const tempBitmap = new Bitmap(1, 1);
            tempBitmap.fontSize = 14;
            const textWidth = tempBitmap.measureTextWidth(text) + 24;
            const textHeight = 32;

            // 本物のBitmapを設定し直す
            this.bitmap = new Bitmap(textWidth, textHeight);
            this.bitmap.fontSize = 14;

            // 背景の黒い矩形
            this.bitmap.fillRect(0, 0, textWidth, textHeight, "rgba(0, 0, 0, 0.6)");

            // テキスト描画（中央寄せ）
            this.bitmap.textColor = "white";
            this.bitmap.outlineColor = "black";
            this.bitmap.outlineWidth = 4;
            this.bitmap.drawText(text, 0, 0, textWidth, textHeight, "center");
        }

        update() {
            super.update();
            this._frameCount++;
            if (this._frameCount >= this._lifespan) {
                if (this.parent) this.parent.removeChild(this);
            }
        }
    }

    window.RSTH_IH.Sprite_CastBar = class extends Sprite {
        constructor(width = 60, height = 12) {
            super(new Bitmap(width, height));
            this._maxTime = 1;
            this._currentTime = 0;
            this._barColor = "Red";
            this._bgColor = "black";
            this.refresh();
        }

        setup(maxTime) {
            this._maxTime = maxTime;
            this._currentTime = maxTime;
            this.refresh();
        }

        updateProgress(currentTime) {
            this._currentTime = currentTime;
            //console.log("Cast progress:", this._currentTime, "/", this._maxTime);

            this.refresh();
        }

        refresh() {
            const bmp = this.bitmap;
            bmp.clear();
            const w = bmp.width;
            const h = bmp.height;
            const rate = Math.max(0, this._currentTime / this._maxTime);
            bmp.fillRect(0, 0, w, h, this._bgColor);
            bmp.fillRect(0, 0, w * rate, h, this._barColor);
        }
    }

    const _Game_Player_canMove = Game_Player.prototype.canMove;
    Game_Player.prototype.canMove = function () {
        if ($gameParty.leader() && $gameParty.leader().hasState(11)) {
            return false; // ステート11なら操作禁止
        }
        return _Game_Player_canMove.call(this);
    };









    /*
    // 独自パラメータの追加
    Game_Actor.prototype.initIndependentParams = function () {
        this._independentParams = {};
        this._independentParams[window.RSTH_IH.PARAM_HIT] = 0;
        this._independentParams[window.RSTH_IH.PARAM_EVA] = 0;
        this._independentParams[window.RSTH_IH.PARAM_CRI] = 0;
        this._independentParams[window.RSTH_IH.PARAM_CRIEVA] = 0;
        this._independentParams[window.RSTH_IH.PARAM_ATKSPD] = 0;
    };
 
    const _Game_Actor_setup = Game_Actor.prototype.setup;
    Game_Actor.prototype.setup = function (actorId) {
        _Game_Actor_setup.call(this, actorId);
        this.initIndependentParams();
    };
 
    const _Game_BattlerBase_param = Game_BattlerBase.prototype.param;
    Game_BattlerBase.prototype.param = function (paramId) {
        if (paramId >= 10 && paramId <= 14) {
            return this.independentParam(paramId);
        }
        return _Game_BattlerBase_param.call(this, paramId);
    };
 
    Game_BattlerBase.prototype.independentParam = function (paramId) {
        return (this._independentParams?.[paramId]) ?? 0;
    };
 
    Game_BattlerBase.prototype.addIndependentParam = function (paramId, value) {
        this._independentParams ??= {};
        this._independentParams[paramId] ??= 0;
        this._independentParams[paramId] += value;
    };
 
    window.RSTH_IH.paramNameToId = function (name) {
        switch (name) {
            case "Hit": return window.RSTH_IH.PARAM_HIT;
            case "Eva": return window.RSTH_IH.PARAM_EVA;
            case "Cri": return window.RSTH_IH.PARAM_CRI;
            case "CriEva": return window.RSTH_IH.PARAM_CRIEVA;
            case "AtkSpd": return window.RSTH_IH.PARAM_ATKSPD;
            default: return -1;
        }
    }
    */

})();