/*:
 * @target MZ
 * @plugindesc RSTH_IH: サバイバルゲームシステムプラグイン
 * @author © 2025 ReSera_りせら（@MOBIUS1001）
 *
 * このソースコードは無断での転載、複製、改変、再配布、商用利用を固く禁じます。
 * 禁止事項の例：
 * - 本ファイルの全部または一部を許可なくコピー、再配布すること
 * - 本ファイルを改変して配布すること
 * - 商用目的での利用
 */

(() => {
    "use strict";

    // ログ出力制御フラグ（trueでログ出力、falseで抑制）
    //const RSTH_DEBUG_LOG = true;
    const RSTH_DEBUG_LOG = false;

    window.RSTH_IH.ProjectileManager = {
        _projectiles: [],

        createArrow: function (startX, startY, targetX, targetY, item, bowatk, sourceType = "player", mob = null) {
            const dx = targetX - startX;
            const dy = targetY - startY;
            const len = Math.sqrt(dx * dx + dy * dy);
            const dirX = dx / len;
            const dirY = dy / len;

            const arrowItem = $dataItems[item.id];
            //console.log("arrowItem", arrowItem);
            const range = Number(arrowItem.meta?.range) || 0;
            const shape = arrowItem.meta?.shape || "box";

            //console.log("range ", range);
            //console.log("shape  ", shape);

            const projectile = {
                type: "arrow",
                x: startX,
                y: startY,
                dirX: dirX,
                dirY: dirY,
                speed: 0.2,
                accel: 0.1,
                maxSpeed: 1,
                arrowItem: arrowItem,
                arrowItemId: item.id,
                bowatk: bowatk,
                sprite: this.createArrowSprite(startX, startY, dirX, dirY),
                sourceType: sourceType,
                mob: mob,
                range: range,
                shape: shape,
                alreadyHit: new Set(),
                _preserveOnReload: true,
                lifeTime: 60
            };

            //console.log("projectile ", projectile);
            $gameTemp._rsthProjectiles ||= [];
            $gameTemp._rsthProjectiles.push(projectile);
        },


        createArrowSprite: function (mapX, mapY, dirX, dirY) {
            const scene = SceneManager._scene;
            if (!(scene instanceof Scene_Map)) return null;

            const spriteset = scene._spriteset;
            const tilemap = spriteset._tilemap;

            if (!this._arrowBitmap) {
                this._arrowBitmap = ImageManager.loadSystem("Arrow");
            }

            const sprite = new Sprite(this._arrowBitmap);
            sprite.anchor.set(0.5);
            sprite.rotation = Math.atan2(dirY, dirX) + Math.PI / 2;
            sprite.z = 10;

            tilemap.addChild(sprite);
            return sprite;
        },


        createOrbitingProjectile: function (weapon, radius, speed, duration, power, totalCount = 1, index = 0, sourceType = "player") {
            const meta = weapon?.meta || {};
            const range = Number(meta.range) || 0;
            const shape = meta.shape || "box";

            const baseAngle = (index / totalCount) * 2 * Math.PI; // ここは固定

            const projectile = {
                type: "orbit",
                centerX: $gamePlayer._realX,
                centerY: $gamePlayer._realY,
                radius: radius,
                angle: baseAngle, // 初期値
                baseAngle: baseAngle, //  固定角度を保持
                orbitSpeed: speed,
                orbitFrames: 0, //  経過フレーム
                remainingFrames: duration,
                power: power,
                weapon: weapon,
                sourceType: sourceType,
                alreadyHit: new Set(),
                range: range,
                shape: shape,
                _preserveOnReload: true,
            };

            // ball発射用タイマー（ballメタが存在する場合のみ）
            if (meta?.ball) {
                const ballWeaponId = Number(meta.ball);
                const ballWeapon = $dataWeapons[ballWeaponId];
                if (ballWeapon) {
                    projectile._ballWeapon = ballWeapon;
                    projectile._ballCooldown = Number(ballWeapon.meta.cooltime) || 60;
                    projectile._ballTimer = 0;
                }
            }

            switch (weapon.id) {
                case 12: case 59: case 60: case 61: case 62:
                    projectile.sprite = this.createOrbitSprite();
                    break;

                case 33: case 63: case 64: case 65: case 66:
                    projectile.sprite = this.createOrbitSpriteAW();
                    break;
            }


            $gameTemp._rsthProjectiles ||= [];
            $gameTemp._rsthProjectiles.push(projectile);
        },

        createOrbitSprite: function () {
            const scene = SceneManager._scene;
            if (!(scene instanceof Scene_Map)) return null;

            const spriteset = scene._spriteset;
            const tilemap = spriteset._tilemap;

            if (!this._orbitBitmap) {
                this._orbitBitmap = ImageManager.loadSystem("orbit");
            }

            const sprite = new Sprite(this._orbitBitmap);
            sprite.anchor.set(0.5);
            sprite.z = 10;

            tilemap.addChild(sprite);
            return sprite;
        },


        createOrbitSpriteAW: function () {
            const scene = SceneManager._scene;
            if (!(scene instanceof Scene_Map)) return null;

            const spriteset = scene._spriteset;
            const tilemap = spriteset._tilemap;

            if (!this._orbitAWBitmap) {
                this._orbitAWBitmap = ImageManager.loadSystem("aw");
            }

            const sprite = new Sprite(this._orbitAWBitmap);
            sprite.anchor.set(0.5);
            sprite.z = 10;

            tilemap.addChild(sprite);
            return sprite;
        },


        createOtomoProjectile: function (weapon, radius, speed, duration, power, totalCount = 1, index = 0, sourceType = "player") {
            const meta = weapon?.meta || {};
            const range = Number(meta.range) || 0;
            const shape = meta.shape || "box";

            const baseAngle = (index / totalCount) * 2 * Math.PI; // ここは固定

            const projectile = {
                type: "otomo",
                centerX: $gamePlayer._realX,
                centerY: $gamePlayer._realY,
                radius: radius,
                angle: baseAngle, // 初期値
                baseAngle: baseAngle, //  固定角度を保持
                otomoSpeed: speed,
                otomoFrames: 0, //  経過フレーム
                remainingFrames: duration,
                power: power,
                weapon: weapon,
                sourceType: sourceType,
                alreadyHit: new Set(),
                range: range,
                shape: shape,
                _preserveOnReload: true,
            };

            // ball発射用タイマー（ballメタが存在する場合のみ）
            if (meta?.ball) {
                const ballWeaponId = Number(meta.ball);
                const ballWeapon = $dataWeapons[ballWeaponId];
                if (ballWeapon) {
                    projectile._ballWeapon = ballWeapon;
                    projectile._ballCooldown = Number(ballWeapon.meta.cooltime) || 60;
                    projectile._ballTimer = 0;
                }
            }

            switch (weapon.id) {
                case 80: case 81: case 82: case 83: case 84:
                    projectile.sprite = this.createOtomoSprite();
                    break;
                case 85: case 86: case 87: case 88: case 89:
                    projectile.sprite = this.createOtomoSpriteP();
                    break;
                case 111:
                    projectile.sprite = this.createOtomoSpriteBP();
                    break;
            }

            $gameTemp._rsthProjectiles ||= [];
            $gameTemp._rsthProjectiles.push(projectile);
        },

        createOtomoSprite: function () {
            const scene = SceneManager._scene;
            if (!(scene instanceof Scene_Map)) return null;

            const spriteset = scene._spriteset;
            const tilemap = spriteset._tilemap;

            if (!this._otomoManyBitmap) {
                this._otomoManyBitmap = ImageManager.loadSystem("many");
            }

            const sprite = new Sprite(this._otomoManyBitmap);
            sprite.anchor.set(0.5);
            sprite.z = 10;

            tilemap.addChild(sprite);
            return sprite;
        },

        createOtomoSpriteP: function () {
            const scene = SceneManager._scene;
            if (!(scene instanceof Scene_Map)) return null;

            const spriteset = scene._spriteset;
            const tilemap = spriteset._tilemap;

            if (!this._otomoPokyuBitmap) {
                this._otomoPokyuBitmap = ImageManager.loadSystem("pokyu");
            }

            const sprite = new Sprite(this._otomoPokyuBitmap);
            sprite.anchor.set(0.5);
            sprite.z = 10;

            tilemap.addChild(sprite);
            return sprite;
        },

        createOtomoSpriteBP: function () {
            const scene = SceneManager._scene;
            if (!(scene instanceof Scene_Map)) return null;

            const spriteset = scene._spriteset;
            const tilemap = spriteset._tilemap;

            if (!this._otomoBPokyuBitmap) {
                this._otomoBPokyuBitmap = ImageManager.loadSystem("bpokyu");
            }

            const sprite = new Sprite(this._otomoBPokyuBitmap);
            sprite.anchor.set(0.5);
            sprite.z = 10;

            tilemap.addChild(sprite);
            return sprite;
        },


        createBoomerang: function (weapon, startX, startY, targetX, targetY, power, maxDistance, sourceType = "player", mob = null) {
            const dx = targetX - startX;
            const dy = targetY - startY;
            const len = Math.sqrt(dx * dx + dy * dy);
            const dirX = dx / len;
            const dirY = dy / len;

            const meta = weapon?.meta || {};
            const range = Number(meta.range) || 0;
            const shape = meta.shape || "box";

            const projectile = {
                type: "boomerang",
                x: startX,
                y: startY,
                dirX: dirX,
                dirY: dirY,
                speed: 0.6,
                distance: 0,
                maxDistance: maxDistance,
                returning: false,
                power: power,
                weapon: weapon,
                sourceType: sourceType,
                mob: mob,
                alreadyHit: { forward: new Set(), return: new Set() },
                alreadyHitPlayer: false,
                range: range,
                shape: shape,
                _preserveOnReload: true,
            };

            switch (weapon.id) {
                // 円月輪
                case 13: case 14: case 15: case 16: case 17:
                case 18: case 19: case 20: case 21:
                    projectile.sprite = this.createBoomerangSprite();
                    break;
                // 天使の輪
                case 50: case 51: case 52: case 53: case 54:
                case 55: case 56: case 57: case 58:
                    projectile.sprite = this.createBoomerangSpriteAH();
                    break;
            }


            $gameTemp._rsthProjectiles ||= [];
            $gameTemp._rsthProjectiles.push(projectile);
        },


        createBoomerangSprite: function () {
            const scene = SceneManager._scene;
            if (!(scene instanceof Scene_Map)) return null;

            const spriteset = scene._spriteset;
            const tilemap = spriteset._tilemap;

            if (!this._boomerangBitmap) {
                this._boomerangBitmap = ImageManager.loadSystem("boomerang");
            }

            const sprite = new Sprite(this._boomerangBitmap);
            sprite.anchor.set(1);
            sprite.z = 10;

            tilemap.addChild(sprite);
            return sprite;
        },

        createBoomerangSpriteAH: function () {
            const scene = SceneManager._scene;
            if (!(scene instanceof Scene_Map)) return null;

            const spriteset = scene._spriteset;
            const tilemap = spriteset._tilemap;

            if (!this._boomerangAHBitmap) {
                this._boomerangAHBitmap = ImageManager.loadSystem("ah");
            }

            const sprite = new Sprite(this._boomerangAHBitmap);
            sprite.anchor.set(1);
            sprite.z = 10;

            tilemap.addChild(sprite);
            return sprite;
        },


        autoBoomerang: function (slot, px, py, mouseX, mouseY, projectiles) {
            if (!slot || window.RSTH_IH._boomerangCooldown > 0) return;

            const weapon = $dataWeapons[slot.id];
            if (!weapon || !weapon.meta?.boomerang) return;

            const id = weapon.id;
            const count = slot.count || 1;

            // 既存boomerang数をカウント（対象idだけに限定）
            let existingCount = 0;
            for (let i = 0; i < projectiles.length; i++) {
                const p = projectiles[i];
                if (p && p.type === "boomerang" && p.weapon?.id === id) {
                    existingCount++;
                }
            }

            const needToCreate = count - existingCount;
            if (needToCreate <= 0) return;

            const power = weapon.params[2] || 5;
            const maxDistance = Number(weapon.meta?.maxdistance) || 8;

            for (let i = 0; i < needToCreate; i++) {
                window.RSTH_IH.ProjectileManager.createBoomerang(
                    weapon,
                    px, py,
                    mouseX, mouseY,
                    power,
                    maxDistance
                );
            }

            const cooltime = Number(window.RSTH_IH.atkCooltime(weapon)) || 45;
            window.RSTH_IH._boomerangCooldown = cooltime;

            if (RSTH_DEBUG_LOG) {
                console.log(`[Boomerang] 自動発射 ${needToCreate}本 → クールタイム ${cooltime}`);
            }
        },


        createKnife: function (weapon, startX, startY, targetX, targetY, power, maxDistance, sourceType = "player", mob = null) {
            const px0 = startX ?? $gamePlayer.x + 0.5;
            const py0 = startY ?? $gamePlayer.y + 0.5;
            const dx = targetX - px0;
            const dy = targetY - py0;
            const len = Math.sqrt(dx * dx + dy * dy) || 1; // ゼロ除算防止

            const dirX = dx / len;
            const dirY = dy / len;

            // オフセット計算
            const offsetRange = 0.5;
            let px = px0;
            let py = py0;
            const offset = (Math.random() - 0.5) * 2 * offsetRange;
            if (Math.abs(dirX) > Math.abs(dirY)) {
                py += offset;
            } else {
                px += offset;
            }

            const meta = weapon?.meta || {};
            const range = Number(meta.range) || 0;
            const shape = meta.shape || "box";

            const projectile = {
                type: "knife",
                x: px,
                y: py,
                dirX,
                dirY,
                speed: 0.5,
                distance: 0,
                maxDistance,
                power,
                weapon,
                sourceType,
                mob,
                alreadyHit: { forward: new Set(), return: new Set() },
                alreadyHitPlayer: false,
                range,
                shape,
                _preserveOnReload: true,
            };

            // sprite選択（高速分岐）
            switch (weapon.id) {
                case 43: case 67: case 68: case 69: case 72:
                    projectile.sprite = this.createKnifeSprite(px, py, dirX, dirY);
                    break;
                case 38: case 39: case 40: case 41: case 42:
                    projectile.sprite = this.createKnifeSpriteIC(px, py, dirX, dirY);
                    break;
                case 70: case 112:
                    projectile.sprite = this.createKnifeSpriteMMS(px, py, dirX, dirY);
                    break;
            }

            $gameTemp._rsthProjectiles ||= [];
            $gameTemp._rsthProjectiles.push(projectile);
        }
        ,

        createKnifeSprite: function (mapX, mapY, dirX, dirY) {
            const scene = SceneManager._scene;
            if (!(scene instanceof Scene_Map)) return null;

            const spriteset = scene._spriteset;
            const tilemap = spriteset._tilemap;

            // 画像キャッシュ（なければロード）
            if (!this._knifeBitmap) {
                this._knifeBitmap = ImageManager.loadSystem("knife");
            }

            const sprite = new Sprite(this._knifeBitmap);
            sprite.anchor.set(0.5); // ← 中心揃えに変更

            // 回転処理
            const angle = Math.atan2(dirY, dirX);
            sprite.rotation = angle + Math.PI / 2;  // 元画像が上向きなら補正

            sprite.z = 10;

            tilemap.addChild(sprite);
            return sprite;
        },

        createKnifeSpriteIC: function (mapX, mapY, dirX, dirY) {
            const scene = SceneManager._scene;
            if (!(scene instanceof Scene_Map)) return null;

            const spriteset = scene._spriteset;
            const tilemap = spriteset._tilemap;

            // 画像キャッシュ（なければロード）
            if (!this._knifeICBitmap) {
                this._knifeICBitmap = ImageManager.loadSystem("Arrow");
            }

            const sprite = new Sprite(this._knifeICBitmap);

            sprite.anchor.set(0.5); // ← 中心揃えに変更

            // 回転処理
            const angle = Math.atan2(dirY, dirX);
            sprite.rotation = angle + Math.PI / 2;  // 元画像が上向きなら補正

            sprite.z = 10;

            tilemap.addChild(sprite);
            return sprite;
        },


        createKnifeSpriteMM: function (mapX, mapY, dirX, dirY) {
            const scene = SceneManager._scene;
            if (!(scene instanceof Scene_Map)) return null;

            const spriteset = scene._spriteset;
            const tilemap = spriteset._tilemap;

            // 画像キャッシュ（なければロード）
            if (!this._knifeMMBitmap) {
                this._knifeMMBitmap = ImageManager.loadSystem("momiji");
            }

            const sprite = new Sprite(this._knifeMMBitmap);
            sprite.anchor.set(0.5); // ← 中心揃えに変更

            // 回転処理
            const angle = Math.atan2(dirY, dirX);
            sprite.rotation = angle + Math.PI / 2;  // 元画像が上向きなら補正

            sprite.z = 10;

            tilemap.addChild(sprite);
            return sprite;
        },

        createKnifeSpriteMMS: function (mapX, mapY, dirX, dirY) {
            const scene = SceneManager._scene;
            if (!(scene instanceof Scene_Map)) return null;

            const spriteset = scene._spriteset;
            const tilemap = spriteset._tilemap;

            // 画像キャッシュ（なければロード）
            if (!this._knifeMMSBitmap) {
                this._knifeMMSBitmap = ImageManager.loadSystem("momiji_split");
            }

            const sprite = new Sprite(this._knifeMMSBitmap);
            sprite.anchor.set(0.5); // ← 中心揃えに変更

            // 回転処理
            const angle = Math.atan2(dirY, dirX);
            sprite.rotation = angle + Math.PI / 2;  // 元画像が上向きなら補正

            sprite.z = 10;

            tilemap.addChild(sprite);
            return sprite;
        },

        createKnifeSpriteSF: function (mapX, mapY, dirX, dirY) {
            const scene = SceneManager._scene;
            if (!(scene instanceof Scene_Map)) return null;

            const spriteset = scene._spriteset;
            const tilemap = spriteset._tilemap;

            // 画像キャッシュ（なければロード）
            if (!this._knifeSFBitmap) {
                this._knifeSFBitmap = ImageManager.loadSystem("starfire");
            }

            const sprite = new Sprite(this._knifeSFBitmap);
            sprite.anchor.set(0.5); // ← 中心揃えに変更

            // 回転処理
            const angle = Math.atan2(dirY, dirX);
            sprite.rotation = angle + Math.PI / 2;  // 元画像が上向きなら補正

            sprite.z = 10;

            tilemap.addChild(sprite);
            return sprite;
        },

        autoKnife: function (slot, px, py, mouseX, mouseY) {
            if (window.RSTH_IH._knifeCooldown > 0 || !slot) return;

            const weapon = $dataWeapons[slot.id];
            if (!weapon) return;
            const meta = weapon.meta;
            if (!meta?.knife && !meta?.split) return;

            const power = weapon.params[2] || 5;
            const createFunc = window.RSTH_IH.ProjectileManager;
            const id = weapon.id;
            const tmo = 6;

            let amount = 1;
            let delay = 0;

            if ([43, 67, 68, 69, 72].includes(id)) {
                switch (id) {
                    // KNIFE
                    case 67: amount = 2; break;
                    case 68: amount = 3; break;
                    case 69: amount = 4; break;
                    case 72: amount = 5; break;
                    case 43: amount = 1; break;
                }
                for (let i = 0; i < amount; i++) {
                    if (amount >= 2) {
                        setTimeout(() => {
                            createFunc.createKnife(weapon, px, py, mouseX, mouseY, power, 15);
                        }, i * tmo);
                    } else {
                        createFunc.createKnife(weapon, px, py, mouseX, mouseY, power, 15);
                    }
                }
            }
            else if ([38, 39, 40, 41, 42].includes(id)) {
                switch (id) {
                    case 39: amount = 2; break;
                    case 40: amount = 3; break;
                    case 41: amount = 4; break;
                    case 42: amount = 5; break;
                    case 38: amount = 1; break;
                }
                for (let i = 0; i < amount; i++) {
                    if (amount >= 2) {
                        setTimeout(() => {
                            createFunc.createKnife(weapon, px, py, mouseX, mouseY, power, 20);
                        }, i * tmo);
                    } else {
                        createFunc.createKnife(weapon, px, py, mouseX, mouseY, power, 20);
                    }
                }
            }
            else if ([73, 74, 75, 76, 77].includes(id)) {
                createFunc.createSplit(weapon, px, py, mouseX, mouseY, power, 20);
            }
            else {
                return; // 不明なID → 無処理
            }

            const cooltime = Number(window.RSTH_IH.atkCooltime(weapon)) || 30;
            window.RSTH_IH._knifeCooldown = cooltime;
        },


        createRS: function (weapon, startX, startY, targetX, targetY, power, maxDistance, sourceType = "player", mob = null) {

            let px = startX ?? $gamePlayer.x + 0.5;
            let py = startY ?? $gamePlayer.y + 0.5;

            const dx = targetX - px;
            const dy = targetY - py;
            const len = Math.sqrt(dx * dx + dy * dy);
            const dirX = dx / len;
            const dirY = dy / len;

            // 🔽 方向に応じて軸をランダムにずらす
            const offsetRange = 0.5; // 1タイルの20%程度のズレ
            if (Math.abs(dirX) > Math.abs(dirY)) {
                // 横方向が強い → 縦をずらす
                py += (Math.random() - 0.5) * 2 * offsetRange;
            } else {
                // 縦方向が強い → 横をずらす
                px += (Math.random() - 0.5) * 2 * offsetRange;
            }

            const meta = weapon?.meta || {};
            const range = Number(meta.range) || 0;
            const shape = meta.shape || "box";

            const projectile = {
                type: "random",
                x: px,
                y: py,
                dirX: dirX,
                dirY: dirY,
                speed: 0.6,
                distance: 0,
                maxDistance: maxDistance,
                power: power,
                weapon: weapon,
                sourceType: sourceType,
                mob: mob,
                alreadyHit: { forward: new Set(), return: new Set() },
                alreadyHitPlayer: false,
                range: range,
                shape: shape,
                _preserveOnReload: true,
            };

            if (weapon.id === 78) {
                projectile.sprite = this.createKnifeSpriteRS(px, py, dirX, dirY);
            }
            else if (weapon.id === 118) {
                projectile.sprite = this.createKnifeSpriteSX(px, py, dirX, dirY);
            }
            else if (weapon.id === 121) {
                projectile.sprite = this.createKnifeSpriteWAS(px, py, dirX, dirY);
            }
            $gameTemp._rsthProjectiles ||= [];
            $gameTemp._rsthProjectiles.push(projectile);


        },

        createKnifeSpriteRS: function (mapX, mapY, dirX, dirY) {
            const scene = SceneManager._scene;
            if (!(scene instanceof Scene_Map)) return null;

            const spriteset = scene._spriteset;
            if (!spriteset) return;
            if (!spriteset._tilemap) return;
            const tilemap = spriteset._tilemap;

            // 画像キャッシュ（なければロード）
            if (!this._knifeBitmapRS) {
                this._knifeBitmapRS = ImageManager.loadSystem("randomsword");
            }

            const sprite = new Sprite(this._knifeBitmapRS);
            sprite.anchor.set(0.5);
            sprite.rotation = Math.atan2(dirY, dirX) + Math.PI / 2;
            sprite.z = 10;

            tilemap.addChild(sprite);
            return sprite;
        },


        createKnifeSpriteSX: function (mapX, mapY, dirX, dirY) {
            const scene = SceneManager._scene;
            if (!(scene instanceof Scene_Map)) return null;

            const spriteset = scene._spriteset;
            if (!spriteset) return;
            if (!spriteset._tilemap) return;
            const tilemap = spriteset._tilemap;

            if (!this._knifeBitmapSX) {
                this._knifeBitmapSX = ImageManager.loadSystem("masou");
            }

            const sprite = new Sprite(this._knifeBitmapSX);
            sprite.anchor.set(0.5);
            sprite.rotation = Math.atan2(dirY, dirX) + Math.PI / 2;
            sprite.z = 10;

            tilemap.addChild(sprite);
            return sprite;
        },


        createKnifeSpriteWAS: function (mapX, mapY, dirX, dirY) {
            const scene = SceneManager._scene;
            if (!(scene instanceof Scene_Map)) return null;

            const spriteset = scene._spriteset;
            if (!spriteset) return;
            if (!spriteset._tilemap) return;
            const tilemap = spriteset._tilemap;

            if (!this._knifeBitmapWAS) {
                this._knifeBitmapWAS = ImageManager.loadSystem("washoi");
            }

            const sprite = new Sprite(this._knifeBitmapWAS);
            sprite.anchor.set(0.5);
            sprite.rotation = Math.atan2(dirY, dirX) + Math.PI / 2;
            sprite.z = 10;

            tilemap.addChild(sprite);
            return sprite;
        },


        createBananaSpread: function (weapon, power, maxDistance, sourceType = "player", mob = null) {
            let px = $gamePlayer.x;
            let py = $gamePlayer.y;
            if (mob) {
                //console.log("mob", mob);
                px = mob._x;
                py = mob._y;
            }

            const directions = [
                { angle: 0 },
                { angle: Math.PI / 4 },
                { angle: Math.PI / 2 },
                { angle: 3 * Math.PI / 4 },
                { angle: Math.PI },
                { angle: 5 * Math.PI / 4 },
                { angle: 3 * Math.PI / 2 },
                { angle: 7 * Math.PI / 4 },
            ];

            const meta = weapon?.meta || {};
            const range = Number(meta.range) || 0;
            const shape = meta.shape || "box";

            for (const dir of directions) {
                const projectile = {
                    type: "banana",
                    centerX: px,
                    centerY: py,
                    orbitAngle: dir.angle,
                    orbitRadius: 0.1,        // 初期半径
                    radiusSpeed: 0.1,       // 広がり速度（調整可）
                    distance: 0,
                    maxDistance: maxDistance,
                    power: power,
                    weapon: weapon,
                    sourceType: sourceType,
                    mob: mob,
                    alreadyHit: new Set(),
                    range: range,
                    shape: shape,
                    _preserveOnReload: true,
                };

                const bananaSpriteMap = {
                    44: { func: this.createBananaSprite44, speed: 0.2 },
                    47: { func: this.createBananaSprite, speed: 0.1 },
                    71: { func: this.createBananaSprite71, speed: 0.2 },
                    99: { func: this.createBananaSprite99, speed: 0.2 },
                };

                const banana = bananaSpriteMap[weapon.id];
                if (banana) {
                    projectile.orbitSpeed = banana.speed;
                    projectile.sprite = banana.func.call(this, px, py, 0, 0);
                } else {
                    projectile.orbitSpeed = 0.1;
                    projectile.sprite = this.createBananaSprite(px, py, 0, 0);
                }

                $gameTemp._rsthProjectiles ||= [];
                $gameTemp._rsthProjectiles.push(projectile);
                //console.log("$gameTemp._rsthProjectiles", $gameTemp._rsthProjectiles);
            }
        },


        createBananaSprite: function (mapX, mapY, dirX, dirY) {
            const scene = SceneManager._scene;
            if (!(scene instanceof Scene_Map)) return null;

            const spriteset = scene._spriteset;
            const tilemap = spriteset._tilemap;

            if (!this._bananaBitmap) {
                this._bananaBitmap = ImageManager.loadSystem("ah");
            }

            const sprite = new Sprite(this._bananaBitmap);
            sprite.anchor.set(0.5);
            sprite.rotation = Math.atan2(dirY, dirX) + Math.PI / 2;
            sprite.z = 10;
            tilemap.addChild(sprite);
            return sprite;
        },

        createBananaSprite44: function (mapX, mapY, dirX, dirY) {
            const scene = SceneManager._scene;
            if (!(scene instanceof Scene_Map)) return null;

            const spriteset = scene._spriteset;
            const tilemap = spriteset._tilemap;

            if (!this._bananaBitmap44) {
                this._bananaBitmap44 = ImageManager.loadSystem("fire");
            }

            const sprite = new Sprite(this._bananaBitmap44);
            sprite.anchor.set(0.5);
            sprite.rotation = Math.atan2(dirY, dirX) + Math.PI / 2;
            sprite.z = 10;
            tilemap.addChild(sprite);
            return sprite;
        },

        createBananaSprite71: function (mapX, mapY, dirX, dirY) {
            const scene = SceneManager._scene;
            if (!(scene instanceof Scene_Map)) return null;

            const spriteset = scene._spriteset;
            const tilemap = spriteset._tilemap;

            if (!this._bananaBitmap71) {
                this._bananaBitmap71 = ImageManager.loadSystem("gravity");
            }

            const sprite = new Sprite(this._bananaBitmap71);
            sprite.anchor.set(0.5);
            sprite.rotation = Math.atan2(dirY, dirX) + Math.PI / 2;
            sprite.z = 10;
            tilemap.addChild(sprite);
            return sprite;
        },

        createBananaSprite99: function (mapX, mapY, dirX, dirY) {
            const scene = SceneManager._scene;
            if (!(scene instanceof Scene_Map)) return null;

            const spriteset = scene._spriteset;
            const tilemap = spriteset._tilemap;

            if (!this._bananaBitmap99) {
                this._bananaBitmap99 = ImageManager.loadSystem("DI");
            }

            const sprite = new Sprite(this._bananaBitmap99);
            sprite.anchor.set(0.5);
            sprite.rotation = Math.atan2(dirY, dirX) + Math.PI / 2;
            sprite.z = 10;
            tilemap.addChild(sprite);
            return sprite;
        },


        createSplit: function (weapon, startX, startY, targetX, targetY, power, maxDistance, sourceType = "player", mob = null) {

            let px = startX ?? $gamePlayer.x + 0.5;
            let py = startY ?? $gamePlayer.y + 0.5;

            const dx = targetX - px;
            const dy = targetY - py;
            const len = Math.sqrt(dx * dx + dy * dy);
            const dirX = dx / len;
            const dirY = dy / len;

            // 🔽 方向に応じて軸をランダムにずらす
            const offsetRange = 0.5; // 1タイルの20%程度のズレ
            if (Math.abs(dirX) > Math.abs(dirY)) {
                // 横方向が強い → 縦をずらす
                py += (Math.random() - 0.5) * 2 * offsetRange;
            } else {
                // 縦方向が強い → 横をずらす
                px += (Math.random() - 0.5) * 2 * offsetRange;
            }

            const meta = weapon?.meta || {};
            const range = Number(meta.range) || 0;
            const shape = meta.shape || "box";

            const projectile = {
                type: "split",
                x: px,
                y: py,
                dirX: dirX,
                dirY: dirY,
                speed: 0.3,
                distance: 0,
                maxDistance: maxDistance,
                power: power,
                weapon: weapon,
                sourceType: sourceType,
                mob: mob,
                alreadyHit: { forward: new Set(), return: new Set() },
                alreadyHitPlayer: false,
                range: range,
                shape: shape,
                _preserveOnReload: true,
            };

            switch (weapon.id) {
                case 73: case 74: case 75: case 76: case 77:
                    projectile.sprite = this.createKnifeSpriteMM(px, py, dirX, dirY);
                    break;
            }


            projectile.destroy = () => {
                const index = $gameTemp._rsthProjectiles.indexOf(projectile);
                if (index >= 0) $gameTemp._rsthProjectiles.splice(index, 1);

                // 🔽 スプライトも削除
                if (projectile.sprite && projectile.sprite.parent) {
                    projectile.sprite.parent.removeChild(projectile.sprite);
                }
            };


            $gameTemp._rsthProjectiles ||= [];
            $gameTemp._rsthProjectiles.push(projectile);

        },

        autoOrbit: function (projectiles, slot) {
            if (!slot) return;

            const weapon = $dataWeapons[slot.id];
            if (!weapon || !weapon.meta?.orbit) return;

            const id = weapon.id;

            // 出現数定義
            const countMap = new Map([
                [12, 1], [33, 1],
                [59, 2], [63, 2],
                [60, 3], [64, 3],
                [61, 4], [65, 4],
                [62, 5], [66, 5],
            ]);
            const count = countMap.get(id) || 0;
            if (count <= 0) return;

            // === 他の武器のorbit projectileを完全に削除 ===
            for (let i = projectiles.length - 1; i >= 0; i--) {
                const p = projectiles[i];
                if (!p) continue;
                if (p.type === "orbit" && p.weapon && p.weapon.id !== id) {
                    if (p.destroy) p.destroy(); // スプライト等の破棄がある場合
                    projectiles.splice(i, 1);
                }
            }

            // === 現在の武器IDの orbit projectile 数をカウント ===
            let existCount = 0;
            for (const p of projectiles) {
                if (!p) continue;
                if (p.type === "orbit" && p.weapon?.id === id) {
                    existCount++;
                }
            }

            const needToCreate = count - existCount;
            if (needToCreate <= 0) return;

            const orbitDuration = Number(weapon.meta.orbit) || 180;
            const power = weapon.params[2] || 5;

            let angleType = 4;
            let radius = 0.3;
            if ([33, 63, 64, 65, 66].includes(id)) {
                angleType = 3;
                radius = 0.2;
            }

            for (let i = 0; i < needToCreate; i++) {
                window.RSTH_IH.ProjectileManager.createOrbitingProjectile(
                    weapon,
                    angleType,
                    radius,
                    orbitDuration,
                    power,
                    count,
                    existCount + i
                );
            }


        }
        ,

        orbitBall: function (projectiles, slot, mouseX, mouseY) {
            if (!slot) return;
            for (const p of projectiles) {
                if (!p) continue;
                const weapon = $dataWeapons[slot.id];
                if (!weapon || !weapon.meta?.orbit) return;

                const id = weapon.id;
                if (p.type !== "orbit" || p.weapon?.id !== id) continue;
                if (!p._ballWeapon) continue;

                p._ballTimer ||= 0;
                p._ballCooldown ||= 60;
                p._ballTimer++;
                //console.log("p._ballTimer ", p._ballTimer);

                const px = p.centerX + Math.cos(p.angle) * p.radius;
                const py = p.centerY + Math.sin(p.angle) * p.radius;

                if (p._ballTimer >= p._ballCooldown) {
                    p._ballTimer = 0;

                    if ([38, 39, 40, 41, 42].includes(p._ballWeapon.id)) {
                        const weapon = $dataWeapons[p._ballWeapon.id];
                        const power = weapon.params[2] || 5;
                        let amount = 1;
                        if (weapon.id === 39) amount = 2;
                        else if (weapon.id === 40) amount = 3;
                        else if (weapon.id === 41) amount = 4;
                        else if (weapon.id === 42) amount = 5;
                        for (let i = 0; i < amount; i++) {
                            window.RSTH_IH.ProjectileManager.createKnife(
                                weapon,
                                px, py,
                                mouseX, mouseY,
                                power,
                                20
                            );
                        }
                    }

                    // 投げナイフ
                    else if ([43, 67, 68, 69, 72].includes(p._ballWeapon.id)) {
                        const weapon = $dataWeapons[p._ballWeapon.id];
                        const power = weapon.params[2] || 5;
                        let amount = 1;
                        if (weapon.id === 67) amount = 2;
                        else if (weapon.id === 68) amount = 3;
                        else if (weapon.id === 69) amount = 4;
                        else if (weapon.id === 72) amount = 5;
                        for (let i = 0; i < amount; i++) {
                            window.RSTH_IH.ProjectileManager.createKnife(
                                weapon,
                                px, py,
                                mouseX, mouseY,
                                power,
                                15
                            );
                        }
                    }

                    // エネルギー弾
                    else if ([112].includes(p._ballWeapon.id)) {
                        const weapon = $dataWeapons[p._ballWeapon.id];
                        const power = weapon.params[2] || 5;
                        let amount = 1;
                        for (let i = 0; i < amount; i++) {
                            window.RSTH_IH.ProjectileManager.createKnife(
                                weapon,
                                px, py,
                                mouseX, mouseY,
                                power,
                                15
                            );
                        }
                    }
                }
            }
        },

        createShotgun: function (weapon, startX, startY, targetX, targetY, power, maxDistance, sourceType = "player", mob = null) {

            let px = startX ?? $gamePlayer.x + 0.5;
            let py = startY ?? $gamePlayer.y + 0.5;

            const dx = targetX - px;
            const dy = targetY - py;
            const len = Math.sqrt(dx * dx + dy * dy);
            const dirX = dx / len;
            const dirY = dy / len;

            // 🔽 方向に応じて軸をランダムにずらす
            const offsetRange = 0.5; // 1タイルの20%程度のズレ
            if (Math.abs(dirX) > Math.abs(dirY)) {
                // 横方向が強い → 縦をずらす
                py += (Math.random() - 0.5) * 2 * offsetRange;
            } else {
                // 縦方向が強い → 横をずらす
                px += (Math.random() - 0.5) * 2 * offsetRange;
            }

            const meta = weapon?.meta || {};
            const range = Number(meta.range) || 0;
            const shape = meta.shape || "box";

            const projectile = {
                type: "shotgun",
                x: px,
                y: py,
                dirX: dirX,
                dirY: dirY,
                speed: 0.5,
                distance: 0,
                maxDistance: maxDistance,
                power: power,
                weapon: weapon,
                sourceType: sourceType,
                mob: mob,
                alreadyHit: { forward: new Set(), return: new Set() },
                alreadyHitPlayer: false,
                range: range,
                shape: shape,
                _preserveOnReload: true,
            };

            switch (weapon.id) {
                case 90: case 91: case 92: case 93: case 94:
                    projectile.sprite = this.createKnifeSpriteSF(px, py, dirX, dirY);
                    break;
            }

            $gameTemp._rsthProjectiles ||= [];
            $gameTemp._rsthProjectiles.push(projectile);
        },

        autoShotgun: function (slot, px, py, baseRad) {
            if (window.RSTH_IH._boomerangCooldown > 0) {
                return;
            }
            if (!slot) return;
            const weapon = $dataWeapons[slot.id];
            if (!weapon) return;

            if (!weapon.meta?.shotgun) return;

            const power = weapon.params[2] || 5;

            // 所持数分発射
            if ([90, 91, 92, 93, 94].includes(weapon.id)) {
                const amount = weapon.meta.shotgun;

                for (let i = 0; i < amount; i++) {
                    const spread = Math.PI / 2; // 90度 = π/2ラジアン
                    const step = amount > 1 ? spread / (amount - 1) : 0;
                    const rad = baseRad - spread / 2 + step * i;

                    const dist = 10; // 十分先の仮目標点
                    const targetX = px + Math.cos(rad) * dist;
                    const targetY = py + Math.sin(rad) * dist;

                    window.RSTH_IH.ProjectileManager.createShotgun(
                        weapon,
                        px, py,
                        targetX, targetY,
                        power,
                        8
                    );
                }
            }
            // クールタイム設定
            const cooltime = Number(window.RSTH_IH.atkCooltime(weapon)) || 30;
            window.RSTH_IH._boomerangCooldown = cooltime;

            //console.log(`[Knife] weapon.id`, weapon.id);
        },

        createShidan: function (weapon, startX, startY, targetX, targetY, power, maxDistance, sourceType = "player", mob = null) {

            let px = startX ?? $gamePlayer.x + 0.5;
            let py = startY ?? $gamePlayer.y + 0.5;

            const dx = targetX - px;
            const dy = targetY - py;
            const len = Math.sqrt(dx * dx + dy * dy);
            const dirX = dx / len;
            const dirY = dy / len;

            // 🔽 方向に応じて軸をランダムにずらす
            const offsetRange = 0.5; // 1タイルの20%程度のズレ
            if (Math.abs(dirX) > Math.abs(dirY)) {
                // 横方向が強い → 縦をずらす
                py += (Math.random() - 0.5) * 2 * offsetRange;
            } else {
                // 縦方向が強い → 横をずらす
                px += (Math.random() - 0.5) * 2 * offsetRange;
            }

            const meta = weapon?.meta || {};
            const range = Number(meta.range) || 0;
            const shape = meta.shape || "box";

            const projectile = {
                type: "shidan",
                x: px,
                y: py,
                dirX: dirX,
                dirY: dirY,
                speed: 0.5,
                distance: 0,
                maxDistance: maxDistance,
                power: power,
                weapon: weapon,
                sourceType: sourceType,
                mob: mob,
                alreadyHit: { forward: new Set(), return: new Set() },
                alreadyHitPlayer: false,
                range: range,
                shape: shape,
                _preserveOnReload: true,
            };

            switch (weapon.id) {
                case 113: case 114: case 115: case 116: case 117:
                    projectile.sprite = this.createKnifeSpriteMMS(px, py, dirX, dirY);
                    break;
            }
            $gameTemp._rsthProjectiles ||= [];
            $gameTemp._rsthProjectiles.push(projectile);
        },

        autoShidan: function (slot, px, py, baseRad) {
            if (window.RSTH_IH._knifeCooldown > 0) {
                return;
            }
            if (!slot) return;
            const weapon = $dataWeapons[slot.id];
            if (!weapon) return;

            if (!weapon.meta?.shidan) return;

            const power = weapon.params[2] || 5;

            // 所持数分発射
            if ([113, 114, 115, 116, 117].includes(weapon.id)) {
                const amount = weapon.meta.shidan;

                for (let i = 0; i < amount; i++) {
                    const spread = Math.PI / 2; // 90度 = π/2ラジアン
                    const step = amount > 1 ? spread / (amount - 1) : 0;
                    const rad = baseRad - spread / 2 + step * i;

                    const dist = 10; // 十分先の仮目標点
                    const targetX = px + Math.cos(rad) * dist;
                    const targetY = py + Math.sin(rad) * dist;

                    window.RSTH_IH.ProjectileManager.createShidan(
                        weapon,
                        px, py,
                        targetX, targetY,
                        power,
                        8
                    );
                }
            }
            // クールタイム設定
            const cooltime = Number(window.RSTH_IH.atkCooltime(weapon)) || 30;
            window.RSTH_IH._knifeCooldown = cooltime;

        },


        autoOtomo: function (projectiles, otomoSlot) {
            if (!otomoSlot) return;
            const weapon = $dataWeapons[otomoSlot];
            if (!weapon || !weapon.meta?.otomo) return;

            const id = weapon.id;

            // 出現数定義
            const countMap = new Map([
                [80, 1], [81, 1], [82, 1], [83, 1], [84, 2],
                [85, 1], [86, 1], [87, 1], [88, 2], [89, 3],
                [111, 2],
            ]);
            const count = countMap.get(id) || 0;
            if (count <= 0) return;

            // === 他の武器のotomo projectileを完全に削除 ===
            for (let i = projectiles.length - 1; i >= 0; i--) {
                const p = projectiles[i];
                if (!p) continue;
                if (p.type === "otomo" && p.weapon && p.weapon.id !== id) {
                    if (p.destroy) p.destroy(); // スプライト等の破棄がある場合
                    projectiles.splice(i, 1);
                }
            }

            // === 現在の武器IDの otomo projectile 数をカウント ===
            let existCount = 0;
            for (const p of projectiles) {
                if (!p) continue;
                if (p.type === "otomo" && p.weapon?.id === id) {
                    existCount++;
                }
            }

            const needToCreate = count - existCount;
            if (needToCreate <= 0) return;

            const otomoDuration = Number(weapon.meta.otomo) || 180;
            const power = weapon.params[2] || 5;


            let angleType = 4;
            let radius = 0.3;
            if ([80, 81, 82, 85, 86, 87, 88, 89].includes(id)) {
                angleType = 5;
                radius = -0.05;
            }
            else if ([83, 84, 111].includes(id)) {
                angleType = 5;
                radius = -0.1;
            }

            for (let i = 0; i < needToCreate; i++) {
                window.RSTH_IH.ProjectileManager.createOtomoProjectile(
                    weapon,
                    angleType,
                    radius,
                    otomoDuration,
                    power,
                    count,
                    existCount + i
                );
            }
        }
        ,

        otomoBall: function (projectiles, otomoSlot, mouseX, mouseY) {
            if (!otomoSlot) return;
            for (const p of projectiles) {
                if (!p) continue;
                const weapon = $dataWeapons[otomoSlot];
                if (!weapon || !weapon.meta?.otomo) return;

                const id = weapon.id;
                if (p.type !== "otomo" || p.weapon?.id !== id) continue;
                if (!p._ballWeapon) continue;

                p._ballTimer ||= 0;
                p._ballCooldown ||= 60;
                p._ballTimer++;

                const px = p.centerX + Math.cos(p.angle) * p.radius;
                const py = p.centerY + Math.sin(p.angle) * p.radius;

                if (p._ballTimer >= p._ballCooldown) {
                    p._ballTimer = 0;

                    if ([38, 39, 40, 41, 42].includes(p._ballWeapon.id)) {
                        const weapon = $dataWeapons[p._ballWeapon.id];
                        const power = weapon.params[2] || 5;
                        let amount = 1;
                        if (weapon.id === 39) amount = 2;
                        else if (weapon.id === 40) amount = 3;
                        else if (weapon.id === 41) amount = 4;
                        else if (weapon.id === 42) amount = 5;
                        for (let i = 0; i < amount; i++) {
                            window.RSTH_IH.ProjectileManager.createKnife(
                                weapon,
                                px, py,
                                mouseX, mouseY,
                                power,
                                20
                            );
                        }
                    }

                    // 投げナイフ
                    else if ([43, 67, 68, 69, 72].includes(p._ballWeapon.id)) {
                        const weapon = $dataWeapons[p._ballWeapon.id];
                        const power = weapon.params[2] || 5;
                        let amount = 1;
                        if (weapon.id === 67) amount = 2;
                        else if (weapon.id === 68) amount = 3;
                        else if (weapon.id === 69) amount = 4;
                        else if (weapon.id === 72) amount = 5;
                        for (let i = 0; i < amount; i++) {
                            window.RSTH_IH.ProjectileManager.createKnife(
                                weapon,
                                px, py,
                                mouseX, mouseY,
                                power,
                                15
                            );
                        }
                    }

                    // エネルギー弾
                    else if ([112].includes(p._ballWeapon.id)) {
                        const weapon = $dataWeapons[p._ballWeapon.id];
                        const power = weapon.params[2] || 5;
                        let amount = 1;
                        for (let i = 0; i < amount; i++) {
                            window.RSTH_IH.ProjectileManager.createKnife(
                                weapon,
                                px, py,
                                mouseX, mouseY,
                                power,
                                15
                            );
                        }
                    }
                }
            }
        },

        splitBall: function () {
            const projectiles = $gameTemp._rsthProjectiles || [];
            const toRemove = [];

            for (const p of projectiles) {
                //console.log("p", p);
                if (!p) continue;
                if (p.type !== "split") continue;

                const weapon = p.weapon;
                if (!weapon || !weapon.meta?.split) continue;

                if (!p._splitDone) {
                    p._splitTimer ||= 0;
                    p._splitTimer++;

                    // 🔽 分裂タイミング判定
                    const delay = Number(weapon.meta.splitDelay) || 30;
                    if (p._splitTimer >= delay) {
                        const count = Number(weapon.meta.split) || 3;
                        const speed = Number(weapon.meta.splitSpeed) || 0.3;
                        const childId = Number(weapon.meta.splitWeaponId) || weapon.id;

                        for (let i = 0; i < count; i++) {
                            const deg = (360 / count) * i;
                            const rad = deg * Math.PI / 180;
                            const vx = Math.cos(rad) * speed;
                            const vy = Math.sin(rad) * speed;

                            const targetX = p.x + vx * 10; // 十分先にすることで方向指定に利用
                            const targetY = p.y + vy * 10;

                            // 🔽 子弾の生成（例：ナイフ）
                            if ([70].includes(childId)) {
                                const childWeapon = $dataWeapons[childId];
                                const power = weapon.params[2] || 5; // 親のAtk使用
                                let newP = null;
                                if (p.mob) {
                                    //console.log("p.mob ", p.mob);
                                    //console.log("power ", power);
                                    newP = window.RSTH_IH.ProjectileManager.createKnife(
                                        childWeapon,
                                        p.x, p.y,
                                        targetX, targetY,
                                        power,
                                        12, "mob", p.mob
                                    )
                                }
                                else {
                                    newP = window.RSTH_IH.ProjectileManager.createKnife(
                                        childWeapon,
                                        p.x, p.y,
                                        targetX, targetY,
                                        power,
                                        12
                                    )
                                }
                                $gameTemp._rsthProjectiles.push(newP);
                            }
                        }


                        // 🔽 分裂処理済みにして破棄処理
                        p._splitDone = true;
                        if (p.destroy) p.destroy(); // 親弾破棄
                    }
                }
            }
        }
        ,

        // 手動呼び出し
        shotSR: function () {
            const hot = $gameSystem._customHotbarItems || [];
            const slot = hot[0];
            if (!slot) return;
            const weapon = $dataWeapons[slot.id];
            if (!weapon) return;

            const id = weapon.id;
            const weaponConfig = {
                78: { range: 12, amount: 20 },
                118: { range: 8, amount: 15 },
                121: { range: 10, amount: 15 },
            };

            const config = weaponConfig[id];
            if (!config) return;

            const range = config.range;
            const amount = config.amount;
            const power = weapon.params[2] || 5;
            const baseX = $gamePlayer.x;
            const baseY = $gamePlayer.y;

            const shootBurst = () => {
                for (let i = 0; i < amount; i++) {
                    const offsetX = Math.floor(Math.random() * range * 2 + 1) - range;
                    const offsetY = Math.floor(Math.random() * range * 2 + 1) - range;
                    const targetX = baseX + offsetX + 0.5;
                    const targetY = baseY + offsetY + 0.5;
                    const spawnX = targetX + 5;
                    const spawnY = targetY - 5;

                    window.RSTH_IH.ProjectileManager.createRS(
                        weapon,
                        spawnX, spawnY,
                        targetX, targetY,
                        power,
                        10
                    );
                }
            };

            const shootBurstWAS = () => {
                for (let i = 0; i < amount; i++) {
                    const offsetX = Math.floor(Math.random() * range * 2 + 1) - range;
                    const offsetY = Math.floor(Math.random() * range * 2 + 1) - range;
                    const targetX = baseX + offsetX + 0.5;
                    const targetY = baseY + offsetY + 0.5;
                    const spawnX = targetX;
                    const spawnY = targetY + 5;
                    window.RSTH_IH.ProjectileManager.createRS(
                        weapon,
                        spawnX, spawnY,
                        targetX, targetY,
                        power,
                        10
                    );
                }
            };

            // 4回繰り返し（0ms, 300ms, 600ms, 900ms）
            for (let i = 0; i < 4; i++) {
                if (id === 121) {
                    setTimeout(shootBurstWAS, i * 300);
                } else {
                    setTimeout(shootBurst, i * 300);
                }
            }
        }
        ,

        applyAreaDamage: function (p, mx, my, npcManager, mobManager, hitSetKey = null) {
            const range = p.range;
            const isCircle = p.shape === "circle";
            const knockback = Number(p.weapon?.meta?.knockback || p.arrowItem?.meta?.knockback) || 0;
            const weapon = p.weapon || p.arrowItem;

            const cacheKey = `${range}_${isCircle ? "circle" : "square"}`;
            let offsets = window.RSTH_IH.ProjectileManager._cachedOffsets[cacheKey];

            if (!offsets) {
                offsets = [];
                for (let dx = -range; dx <= range; dx++) {
                    for (let dy = -range; dy <= range; dy++) {
                        if (isCircle && (Math.abs(dx) + Math.abs(dy) > range)) continue;
                        offsets.push([dx, dy]);
                    }
                }
                window.RSTH_IH.ProjectileManager._cachedOffsets[cacheKey] = offsets;
            }

            const hitSet = (p.alreadyHit instanceof Set)
                ? p.alreadyHit
                : (hitSetKey && p.alreadyHit?.[hitSetKey]);

            for (const [dx, dy] of offsets) {
                const tx = mx + dx;
                const ty = my + dy;

                if (p.sourceType === "player") {
                    const mob = mobManager.getMobAt(tx, ty);
                    if (mob && hitSet && !hitSet.has(mob._id)) {
                        window.RSTH_IH.applyKnockback(mob, mx, my, knockback, mobManager);
                        mob.queueHit(weapon, knockback, mx, my, null);
                        hitSet.add(mob._id);
                    }
                } else if (p.sourceType === "mob") {
                    if (!$gamePlayer) continue;
                    const npc = npcManager.getNpcAt(tx, ty);
                    if ($gamePlayer.x === tx && $gamePlayer.y === ty && hitSet && !hitSet.has("player")) {
                        window.RSTH_IH.applyKnockbackToPlayer(p.mob, knockback);
                        window.RSTH_IH.damage_calculation(weapon, p.mob, null, "mob", "actor", p.bowatk);
                        hitSet.add("player");
                    }
                    if (npc && hitSet && !hitSet.has(npc._id)) {
                        window.RSTH_IH.applyKnockback(npc, mx, my, knockback, npcManager);
                        npc.queueHit(weapon, knockback, mx, my, p.mob);
                        hitSet.add(npc._id);
                    }
                }
                else if (p.sourceType === "npc") {
                    const mob = mobManager.getMobAt(tx, ty);
                    //console.log("[p.sourceType === npc p", p);
                    if (mob && hitSet && !hitSet.has(mob._id)) {
                        window.RSTH_IH.applyKnockback(mob, mx, my, knockback, mobManager);
                        mob.queueHit(weapon, knockback, mx, my, p.mob);
                        hitSet.add(mob._id);
                    }
                }
            }
        }

        ,

        updateProjectileSprite: function (p, toRemove) {
            if (p.sprite?.parent) {
                const tw = $gameMap.tileWidth();
                const th = $gameMap.tileHeight();
                const dx = $gameMap.displayX();
                const dy = $gameMap.displayY();
                p.sprite.x = Math.round((p.x - dx) * tw + tw / 2);
                p.sprite.y = Math.round((p.y - dy) * th + th / 2);
            } else {
                toRemove.push(p);
            }
        }
        ,

        update: function () {
            const toRemove = new Set();
            const mobManager = window.RSTH_IH._mobManager;
            const npcManager = window.RSTH_IH._npcManager;
            const blockManager = window.RSTH_IH.SurvivalBlockManager;
            const hot = $gameSystem._customHotbarItems || [];
            const projectiles = $gameTemp._rsthProjectiles || [];

            const tw = $gameMap.tileWidth();
            const dx = $gameMap.displayX();
            const dy = $gameMap.displayY();
            const px = $gamePlayer.x + 0.5;
            const py = $gamePlayer.y + 0.5;
            const mouseX = dx + TouchInput.x / tw;
            const mouseY = dy + TouchInput.y / tw;
            const dxMouse = mouseX - px;
            const dyMouse = mouseY - py;
            const baseRad = Math.atan2(dyMouse, dxMouse);

            const actorId = window.RSTH_IH._selectedActorId;
            const otomoSlot = actorId === 1 ? window.RSTH_IH.EquipmentOtomoIdActor1
                : actorId === 2 ? window.RSTH_IH.EquipmentOtomoIdActor2
                    : actorId === 3 ? window.RSTH_IH.EquipmentOtomoIdActor3
                        : null;

            this.autoOrbit(projectiles, hot[5]);
            this.orbitBall(projectiles, hot[5], mouseX, mouseY);
            this.autoOtomo(projectiles, otomoSlot);
            this.otomoBall(projectiles, otomoSlot, mouseX, mouseY);

            const leader = $gameParty.leader();
            if (!(leader && leader.hasState(11))) {
                window.RSTH_IH._boomerangCooldown = Math.max(0, (window.RSTH_IH._boomerangCooldown || 0) - 1);
                window.RSTH_IH._knifeCooldown = Math.max(0, (window.RSTH_IH._knifeCooldown || 0) - 1);

                this.autoKnife(hot[6], px, py, mouseX, mouseY);
                this.splitBall();
                this.autoShidan(hot[6], px, py, baseRad);
                this.autoBoomerang(hot[4], px, py, mouseX, mouseY, projectiles);
                this.autoShotgun(hot[4], px, py, baseRad);
                window.RSTH_IH.autoUseMeleeWeapon();
            }

            const playerX = $gamePlayer.x;
            const playerY = $gamePlayer.y;
            const applyAreaDamage = window.RSTH_IH.ProjectileManager.applyAreaDamage;

            const knifeHandler = function (p) {
                p.x += p.dirX * p.speed;
                p.y += p.dirY * p.speed;
                p.distance += p.speed;

                if (p.distance >= p.maxDistance) return toRemove.add(p);

                const mx = Math.round(p.x);
                const my = Math.round(p.y);
                if (!window.RSTH_IH.isPassableForAttack(mx, my)) return toRemove.add(p);
                applyAreaDamage(p, mx, my, npcManager, mobManager, "forward");
            };


            const projectileHandlers = {
                arrow(p) {
                    p.speed = Math.min(p.speed + p.accel, p.maxSpeed);
                    p.x += p.dirX * p.speed;
                    p.y += p.dirY * p.speed;
                    const mx = Math.round(p.x);
                    const my = Math.round(p.y);

                    if (!window.RSTH_IH.isPassableForAttack(mx, my)) return toRemove.add(p);
                    applyAreaDamage(p, mx, my, npcManager, mobManager, null);
                    if (--p.lifeTime <= 0 || p.x < 0 || p.y < 0 || p.x >= $gameMap.width() || p.y >= $gameMap.height()) toRemove.add(p);
                },

                orbit(p) {
                    const previousAngle = p.angle;
                    p.angle += p.orbitSpeed;
                    if ((previousAngle | 0) !== (p.angle | 0)) p.alreadyHit.clear();

                    p.centerX = playerX;
                    p.centerY = playerY;
                    p.x = p.centerX + p.radius * Math.cos(p.angle);
                    p.y = p.centerY + p.radius * Math.sin(p.angle);

                    const mx = Math.round(p.x);
                    const my = Math.round(p.y);
                    applyAreaDamage(p, mx, my, npcManager, mobManager, null);

                    if (--p.remainingFrames <= 0) toRemove.add(p);
                },

                otomo(p) {
                    const previousAngle = p.angle;
                    p.angle += p.otomoSpeed;
                    if ((previousAngle | 0) !== (p.angle | 0)) p.alreadyHit.clear();

                    p.centerX = playerX;
                    p.centerY = playerY;
                    p.x = p.centerX + p.radius * Math.cos(p.angle);
                    p.y = p.centerY + p.radius * Math.sin(p.angle);

                    const mx = Math.round(p.x);
                    const my = Math.round(p.y);
                    applyAreaDamage(p, mx, my, npcManager, mobManager, null);

                    if (--p.remainingFrames <= 0) toRemove.add(p);
                },

                boomerang(p) {
                    //console.log("p", p);
                    if (!p.returning) {
                        p.x += p.dirX * p.speed;
                        p.y += p.dirY * p.speed;
                        p.distance += p.speed;
                        if (p.distance >= p.maxDistance) p.returning = true;
                    } else {
                        let dx = null;
                        let dy = null;
                        if (p.sourceType === "mob" || p.sourceType === "npc") {
                            dx = p.mob._x - p.x;
                            dy = p.mob._y - p.y;
                        }
                        else {
                            dx = playerX - p.x;
                            dy = playerY - p.y;
                        }
                        const len = Math.hypot(dx, dy);
                        if (len < 0.3) return toRemove.add(p);
                        p.dirX = dx / len;
                        p.dirY = dy / len;
                        p.x += p.dirX * p.speed;
                        p.y += p.dirY * p.speed;
                    }

                    const mx = Math.round(p.x);
                    const my = Math.round(p.y);
                    if (!window.RSTH_IH.isPassableForAttack(mx, my)) return toRemove.add(p);

                    const hitSetKey = p.returning ? "return" : "forward";
                    applyAreaDamage(p, mx, my, npcManager, mobManager, hitSetKey);
                },

                knife: knifeHandler,
                split: knifeHandler,
                shotgun: knifeHandler,
                shidan: knifeHandler,

                random(p) {
                    p.x += p.dirX * p.speed;
                    p.y += p.dirY * p.speed;
                    p.distance += p.speed;
                    if (p.distance >= p.maxDistance) return toRemove.add(p);
                    const mx = Math.round(p.x);
                    const my = Math.round(p.y);
                    applyAreaDamage(p, mx, my, npcManager, mobManager, "forward");
                },

                banana(p) {
                    p.orbitAngle += p.orbitSpeed;
                    p.orbitRadius += p.radiusSpeed;
                    p.distance += p.radiusSpeed;

                    p.x = p.centerX + Math.cos(p.orbitAngle) * p.orbitRadius;
                    p.y = p.centerY + Math.sin(p.orbitAngle) * p.orbitRadius;

                    if (p.distance >= p.maxDistance) return toRemove.add(p);
                    const mx = Math.round(p.x);
                    const my = Math.round(p.y);
                    applyAreaDamage(p, mx, my, npcManager, mobManager, null);
                }
            };

            for (const p of projectiles) {
                if (!p) continue;
                //console.log("p", p);
                const handler = projectileHandlers[p.type];
                if (handler) handler(p);
                this.updateProjectileSprite(p, toRemove);
            }

            for (const p of toRemove) {
                if (p.sprite?.parent) p.sprite.parent.removeChild(p.sprite);

                const expired = (p.lifeTime != null && p.lifeTime <= 0) ||
                    (p.remainingFrames != null && p.remainingFrames <= 0);

                if (!p._preserveOnReload || expired) {
                    // skip, will be handled below
                }
            }

            if ($gameTemp._rsthProjectiles?.length) {
                $gameTemp._rsthProjectiles = $gameTemp._rsthProjectiles.filter(p => !toRemove.has(p));
            }
        }

    };


    window.RSTH_IH.ProjectileManager._cachedOffsets = window.RSTH_IH.ProjectileManager._cachedOffsets || {};

    const _RSTH_Projectile_Scene_Map_updateMain = Scene_Map.prototype.updateMain;
    Scene_Map.prototype.updateMain = function () {
        _RSTH_Projectile_Scene_Map_updateMain.call(this);

        if (!this._projectilesRestored && $gameTemp._rsthProjectiles?.length) {
            const tilemap = this._spriteset?._tilemap;
            const manager = window.RSTH_IH.ProjectileManager;
            if (tilemap) {
                const spriteMap = {
                    arrow: (p) => manager.createArrowSprite(p.x, p.y, p.dirX, p.dirY),
                    boomerang: (p) => {
                        const id = p.weapon?.id;
                        if ([13, 14, 15, 16, 17].includes(id)) return manager.createBoomerangSprite();
                        if ([49, 50, 51, 52, 53].includes(id)) return manager.createBoomerangSpriteAH();
                        return manager.createBoomerangSprite();
                    },
                    orbit: (p) => {
                        const id = p.weapon?.id;
                        if ([12, 59, 60, 61, 62].includes(id)) return manager.createOrbitSprite();
                        if ([33, 63, 64, 65, 66].includes(id)) return manager.createOrbitSpriteAW();
                        return manager.createOrbitSprite();
                    },
                    otomo: (p) => {
                        const id = p.weapon?.id;
                        if ([80, 81, 82, 83, 84].includes(id)) return manager.createOtomoSprite();
                        if ([85, 86, 87, 88, 89].includes(id)) return manager.createOtomoSpriteP();
                        if ([111].includes(id)) return manager.createOtomoSpriteBP();
                        return manager.createOtomoSprite();
                    },
                    knife: (p) => {
                        const id = p.weapon?.id;
                        if ([43, 67, 68, 69, 72].includes(id)) return manager.createKnifeSprite();
                        if ([38, 39, 40, 41, 42].includes(id)) return manager.createKnifeSpriteIC();
                        if ([70, 112].includes(id)) return manager.createKnifeSpriteMMS();
                        return manager.createKnifeSprite();
                    },
                    split: (p) => manager.createKnifeSpriteMM(),
                    shotgun: (p) => {
                        const id = p.weapon?.id;
                        if ([90, 91, 92, 93, 94].includes(id)) return manager.createKnifeSpriteSF();
                        return manager.createKnifeSprite();
                    },
                    shidan: (p) => {
                        const id = p.weapon?.id;
                        if ([113, 114, 115, 116, 117].includes(id)) return manager.createKnifeSpriteMMS();
                        return manager.createKnifeSprite();
                    },
                    banana: (p) => {
                        const id = p.weapon?.id;
                        if (id === 44) return manager.createBananaSprite44();
                        if (id === 47) return manager.createBananaSprite();
                        if (id === 71) return manager.createBananaSprite71();
                        if (id === 99) return manager.createBananaSprite99();
                        return manager.createBananaSprite();
                    },
                    random: (p) => {
                        const id = p.weapon?.id;
                        if (id === 78) return manager.createKnifeSpriteRS();
                        if (id === 118) return manager.createKnifeSpriteSX();
                        if (id === 121) return manager.createKnifeSpriteSX();
                        return manager.createKnifeSpriteRS();
                    }
                };

                for (const p of $gameTemp._rsthProjectiles) {
                    if (!p || (p.sprite && p.sprite.parent) || !p.type || p.x == null || p.y == null) continue;
                    const createFunc = spriteMap[p.type];
                    const sprite = createFunc ? createFunc(p) : null;

                    if (sprite) {
                        tilemap.addChild(sprite);
                        sprite.z = 10;
                        p.sprite = sprite;
                        p._preserveOnReload = true;
                    }
                }

                this._projectilesRestored = true;
            }
        }
    };






    window.RSTH_IH.removeProjectile = function (sprite) {
        if (!sprite || !sprite.parent) return;

        sprite.parent.removeChild(sprite);
        // projectile情報も削除
        $gameTemp._rsthProjectiles = $gameTemp._rsthProjectiles.filter(p => p.sprite !== sprite);
    };

    window.RSTH_IH.applyKnockback = function (target, centerX, centerY, knockback, mobManager) {
        if (knockback <= 0) return;
        if (target._nokb) return;

        //console.log("target", target);
        //console.log("mobManager", mobManager);

        const offsetX = target.x() - centerX;
        const offsetY = target.y() - centerY;
        const length = Math.sqrt(offsetX * offsetX + offsetY * offsetY) || 0.0001;

        const normX = Math.round(offsetX / length);
        const normY = Math.round(offsetY / length);

        for (let i = 0; i < knockback; i++) {
            const nextX = target.x() + normX;
            const nextY = target.y() + normY;

            const dir = (normX === 1) ? 6 : (normX === -1) ? 4 : (normY === 1) ? 2 : (normY === -1) ? 8 : 0;

            if (mobManager.canMoveToSimple(nextX, nextY, target._id, dir)) {
                target._x = nextX;
                target._y = nextY;
                target._realX = nextX;
                target._realY = nextY;
            } else {
                break;
            }
        }
    }



})();