/*:
 * @target MZ
 * @plugindesc RSTH_IH: サバイバルゲームシステムプラグイン
 * @author © 2025 ReSera_りせら（@MOBIUS1001）
 *
 * このソースコードは無断での転載、複製、改変、再配布、商用利用を固く禁じます。
 * 禁止事項の例：
 * - 本ファイルの全部または一部を許可なくコピー、再配布すること
 * - 本ファイルを改変して配布すること
 * - 商用目的での利用
 */


(() => {
    "use strict";

    // ログ出力制御フラグ（trueでログ出力、falseで抑制）
    //const RSTH_DEBUG_LOG = true;
    const RSTH_DEBUG_LOG = false;

    // ▼ アイテム使用処理
    window.RSTH_IH.useInventoryItem = function (item, source = "inventory", slotIndex = null, targetPos = null) {

        const leader = $gameParty.leader();
        if (leader && leader.hasState(11)) return;

        const scene = SceneManager._scene;
        const inv = scene?._inventoryWindow;
        const hotbar = scene?._hotbarWindow;
        if (!item) return;
        //console.log("item", item);
        const dataItem = window.RSTH_IH.getGameItem(item);
        if (!dataItem) return;

        const actor = $gameParty.leader();

        if (RSTH_DEBUG_LOG) console.log(`[useInventoryItem]item.type: ${item.type}`);

        /*
        // ▼ ブロックなら設置処理
        if (item.type === "block") {
            const tileId = Number(item.tileId || 0);

            const tileX = targetPos?.x;
            const tileY = targetPos?.y;

            if (tileId > 0) {
                if (RSTH_DEBUG_LOG) console.log(`[useInventoryItem]item`, item);
                const gameItem = window.RSTH_IH.getGameItem(item);

                if (RSTH_DEBUG_LOG) console.log(`[useInventoryItem]gameItem`, gameItem);
                // tileOffsets1をJSONとしてパース
                let tileOffsets = [];
                try {
                    tileOffsets = gameItem._tileOffsets1Parsed || [];
                    if (RSTH_DEBUG_LOG) console.warn(`[SurvivalBlockManager][place]tileOffsets`, tileOffsets);
                } catch (e) {
                    if (RSTH_DEBUG_LOG) console.warn(`[SurvivalBlockManager][place]tileOffsets1 parse error`, e);
                    return; // パースエラー時は設置しない
                }

                if (RSTH_DEBUG_LOG) console.warn(`[SurvivalBlockManager][place]tileOffsets`, tileOffsets);

                // ブロックが未設置の場合のみ設置
                if (window.RSTH_IH.canPlaceBlockAt(tileX, tileY, gameItem)) {
                    const itemId = item.id;
                    if (RSTH_DEBUG_LOG) console.log(`[useInventoryItem]ブロック設置: (${tileX}, ${tileY}) → tileId ${tileId}, itemId ${itemId}`);

                    // ブロック設置

                    if (window.RSTH_IH.DirectedDoor > 0) {
                        window.RSTH_IH.SurvivalBlockManager.place(tileX, tileY, window.RSTH_IH.DirectedDoor);
                    } else {
                        window.RSTH_IH.SurvivalBlockManager.place(tileX, tileY, itemId);

                    }


                    // ブロックがチェストの場合
                    if (gameItem.meta.blockType === "chest") {
                        if (RSTH_DEBUG_LOG) console.warn(`[useInventoryItem]chest`);
                        try {
                            const chestsize = JSON.parse(gameItem.meta.chestsize || "[1,1]");
                            if (Array.isArray(chestsize)) {
                                window.RSTH_IH.ChestManager.addChest(tileX, tileY, chestsize[0], chestsize[1]);
                            }
                        } catch (e) {
                            if (RSTH_DEBUG_LOG) console.warn("[useInventoryItem]gameItem.meta.chestsizeメタタグのパース失敗", gameItem.meta.chestsize, e);
                        }

                        if (RSTH_DEBUG_LOG) console.warn(`[useInventoryItem]window.RSTH_IH.ChestManager._chests`, window.RSTH_IH.ChestManager._chests);
                    }

                    // その座標にあるすべてのブロックを取得
                    const placedBlocks = window.RSTH_IH.SurvivalBlockManager.getAll(tileX, tileY);

                    // blockType が "plant" のブロックのみに処理
                    for (const block of placedBlocks) {
                        const item = $dataItems[block.itemId];
                        const blockType = item?.meta?.blockType || "";
                        const growthTime = Number(item?.meta?.growthTime || 0);

                        if (growthTime > 0 && blockType === window.RSTH_IH.GrowBlock) {
                            block.growthTime = growthTime;
                            $gameSystem.rsthstartGrowthTimer(block.x, block.y, growthTime);
                            if (RSTH_DEBUG_LOG) console.log(`[useInventoryItem] 成長タイマー登録: (${block.x},${block.y}) growthTime=${growthTime}`);
                        }
                    }



                    // ▼ アイテム1個消費処理
                    const list = (source === "inventory")
                        ? scene?._inventoryWindow?.items
                        : scene?._hotbarWindow?.items;

                    const index = slotIndex ?? list?.findIndex(slot =>
                        slot && slot.id === item.id && slot.type === item.type
                    );

                    if (index >= 0 && list?.[index]) {
                        const slot = list[index];

                        if (slot.count > 1) {
                            slot.count--;
                        } else {
                            list[index] = null;
                        }

                        // ▼ 表示更新
                        if (source === "inventory") {
                            $gameSystem._customInventoryItems = list;
                            scene?._inventoryWindow?.refresh();
                        } else if (source === "hotbar") {
                            $gameSystem._customHotbarItems = list;
                            scene?._hotbarWindow?.setItems(list);
                        }
                    }

                    return;
                } else {
                    if (RSTH_DEBUG_LOG) console.log(`[useInventoryItem]設置不可: (${tileX}, ${tileY}) にはすでにブロックが存在`);
                    return;
                }
            }
        }


        if (item.type === "tool") {
            const gameItem = window.RSTH_IH.getGameItem(item);
            if (window.RSTH_IH.isToolWeapon(gameItem)) {
                const mapX = $gameMap.canvasToMapX(TouchInput.x);
                const mapY = $gameMap.canvasToMapY(TouchInput.y);


                if (RSTH_DEBUG_LOG) console.log(`[useInventoryItem][tool]mapX ${mapX} mapY ${mapY}`);

                const block = window.RSTH_IH.SurvivalBlockManager.get(mapX, mapY);

                if (!block) {
                    if (RSTH_DEBUG_LOG) console.log(`[useInventoryItem][tool]block is null or undifined`);
                    return;
                }

                if (RSTH_DEBUG_LOG) console.log(`[useInventoryItem][tool]block?`, block);


                const originX = block.originX ?? block.x;
                const originY = block.originY ?? block.y;
                const originBlock = window.RSTH_IH.SurvivalBlockManager.get(originX, originY);
                if (!originBlock) return;

                const effective = window.RSTH_IH.getEffectiveBlocks(gameItem);
                if (!effective.includes(originBlock.blockType)) return;

                // 安全に origin から破壊
                window.RSTH_IH.SurvivalBlockManager.break(originX, originY);

                //SoundManager.playEnemyCollapse();
                return;
            }
        }
        */
        // 武器か防具なら装備処理（アイテム使用ではなく）
        if (DataManager.isArmor(dataItem) || DataManager.isWeapon(dataItem)) {
            if (DataManager.isWeapon(dataItem) && !window.RSTH_IH.EnableWeaponEquip) return; // ← 武器装備をできなくした場合はreturnする
            const list = (source === "inventory")
                ? $gameSystem._customInventoryItems
                : $gameSystem._customHotbarItems;

            if (typeof slotIndex !== "number") return;
            const index = slotIndex;
            if (index < 0) return;

            const slot = list[index];
            if (!slot) return;

            const actor = $gameParty.leader();
            if (!actor.canEquip(dataItem)) return;

            // 装備スロットの候補をすべて取得（装飾品スロットが複数ある前提）
            const slotCandidates = actor.equipSlots()
                .map((etypeId, i) => ({ etypeId, index: i }))
                .filter(obj => obj.etypeId === dataItem.etypeId);

            // 空きスロット優先
            let slotId = slotCandidates.find(obj => !actor.equips()[obj.index])?.index;

            // どこにも装備されていないが空きスロットも無い → 最初のスロットに上書き装備
            slotId ||= slotCandidates[0]?.index;
            if (slotId === undefined) return; // 装備可能スロットが存在しない

            const removed = actor.equips()[slotId]; // 現在の武具（古い武具）
            if (removed === dataItem) {
                if (RSTH_DEBUG_LOG) console.log("[useInventoryItem][isArmor] すでに同じ武具が装備されている");
                scene.updateInventoryAndHotbar();
                return;
            }
            window.RSTH_IH.__Vanilla_GainItem(dataItem, 1, true);   //gamepartyに新しい武具を追加
            if (slot.count > 1) { slot.count--; } else { list[index] = null; }  // スロットから古い防具を消費
            actor.changeEquip(slotId, dataItem, 1); //新しい武具を装備する→gamepartyに古い武具が追加→スロットに古い武具が入る
            window.RSTH_IH.__Vanilla_GainItem(dataItem, -1, true);   //gamepartyから新しい武具を削除


            // 反映
            if (source === "inventory") {
                $gameSystem._customInventoryItems = list;
                SceneManager._scene._inventoryWindow?.setItems(list);
                SceneManager._scene._inventoryWindow?.refresh();
            } else {
                $gameSystem._customHotbarItems = list;
                SceneManager._scene._hotbarWindow?.setItems(list);
                SceneManager._scene._hotbarWindow?.refresh();
            }

            SceneManager._scene._equipmentWindow?.refresh();
            SoundManager.playEquip();
            return;
        }

        if (source === "hotbar") {
            const list = hotbar?.items;
            const index = slotIndex;
            if (index < 0) return;

            const slot = list[index];

            if (!slot) return; // ★ null 安全チェック
            window.RSTH_IH.__Vanilla_GainItem(dataItem, 1, false);

            if (actor.canUse(dataItem)) {
                const action = new Game_Action(actor);
                action.setItemObject(dataItem);
                const targets = action.makeTargets();
                for (const target of targets) action.apply(target);
                window.RSTH_IH.__Vanilla_GainItem(dataItem, -1, false);

                if (RSTH_DEBUG_LOG) console.log(`[useInventoryItem][hotbar]<<<<<<<<<hotbar slot.count>>>>>>>>${slot.count}`);
                if (slot.count > 1) {
                    slot.count--;
                } else {
                    list[index] = null;
                }

                hotbar?.refresh();
                inv?.refresh();
                if (RSTH_DEBUG_LOG) console.log(`[useInventoryItem][hotbar]<<<<<<<<<hotbar slot.count??>>>>>>>>${slot.count}`);
            }

            return;
        }

        if (source === "inventory") {
            const list = inv?.items;
            const index = slotIndex ?? list?.findIndex(slot => slot && slot.id === item.id && slot.type === item.type);
            if (index < 0) return;

            const slot = list[index];
            if (!slot) return; // ★ null 安全チェック

            // 修正：gainItemせずに条件を手動チェック
            if ($gameParty.canInput() && actor.meetsUsableItemConditions(dataItem)) {
                const action = new Game_Action(actor);
                action.setItemObject(dataItem);
                const targets = action.makeTargets();
                for (const target of targets) action.apply(target);

                if (slot.count > 1) {
                    slot.count--;
                } else {
                    list[index] = null;
                }

                scene.updateInventoryAndHotbar();
            }

            return;
        }
    }

    // 武器使用処理
    window.RSTH_IH.useWeapon = function (item, slotIndex = null, x, y) {
        if (!$gameParty.leader() || $gameParty.leader().hasState(11)) return;
        if (!item || typeof slotIndex !== "number" || slotIndex < 0) return;

        const slot = $gameSystem._customHotbarItems?.[slotIndex];
        if (!slot) return;

        const dataItem = window.RSTH_IH.getGameItem(item);
        if (!dataItem || !DataManager.isWeapon(dataItem)) return;

        const mobManager = window.RSTH_IH._mobManager;
        const meta = dataItem.meta || {};
        const id = dataItem.id;

        // 特殊武器種別別処理
        if (id === 119) {
            window.RSTH_IH.ShunpoMove(x, y);
            return;
        }
        if (dataItem.wtypeId === 7) {
            let arrowItem = $gameSystem._customInventoryItems.find(i => i && $dataItems[i.id]?.meta?.arrow !== undefined)
                || $gameSystem._customHotbarItems.find(i => i && $dataItems[i.id]?.meta?.arrow !== undefined);

            SceneManager._scene._inventoryWindow?.refresh();
            SceneManager._scene._hotbarWindow?.refresh();

            if (!arrowItem || arrowItem.count <= 0) return;

            arrowItem.count--;
            if (arrowItem.count <= 0) {
                const invIndex = $gameSystem._customInventoryItems.indexOf(arrowItem);
                const hotIndex = $gameSystem._customHotbarItems.indexOf(arrowItem);
                if (invIndex >= 0) $gameSystem._customInventoryItems[invIndex] = null;
                else if (hotIndex >= 0) $gameSystem._customHotbarItems[hotIndex] = null;
            }

            const bowatk = dataItem.params[2];
            window.RSTH_IH.ProjectileManager.createArrow($gamePlayer.x, $gamePlayer.y, x, y, arrowItem, bowatk);
            return;
        }

        if (meta.orbit || meta.boomerang || meta.knife || meta.melee) return;

        if (meta.banana) {
            const power = dataItem.params[2] || 5;
            window.RSTH_IH.ProjectileManager.createBananaSpread(dataItem, power, 20);
            return;
        }

        if (meta.random) {
            window.RSTH_IH.ProjectileManager.shotSR();
            return;
        }

        const range = parseInt(meta.areaAttack || meta.range) || 1;
        const shape = meta.shape ?? "box";
        const isCircle = shape === "circle";
        const tw = $gameMap.tileWidth();
        const th = $gameMap.tileHeight();
        const spriteset = SceneManager._scene._spriteset;
        const areaTiles = [];

        const baseX = meta.areaAttack ? $gamePlayer.x : x;
        const baseY = meta.areaAttack ? $gamePlayer.y : y;

        for (let dx = -range; dx <= range; dx++) {
            for (let dy = -range; dy <= range; dy++) {
                const tx = baseX + dx;
                const ty = baseY + dy;
                if (isCircle && (Math.abs(dx) + Math.abs(dy) > range)) continue;

                if (!meta.nochecktile && !window.RSTH_IH.isTileReachable($gamePlayer.x, $gamePlayer.y, tx, ty)) continue;

                areaTiles.push({ x: tx, y: ty });

                const mob = mobManager.getMobAt(tx, ty);
                if (mob) {
                    const knockback = Number(meta.knockback) || 0;
                    window.RSTH_IH.applyKnockback(mob, $gamePlayer.x, $gamePlayer.y, knockback, mobManager);
                    mob.queueHit(dataItem, knockback, $gamePlayer.x, $gamePlayer.y);
                }
            }
        }

        if (areaTiles.length > 0 && spriteset?._rsthEffectLayer) {
            const effectSprite = window.RSTH_IH.createWeaponAreaEffectSprite(areaTiles);
            spriteset._rsthEffectLayer.addChild(effectSprite);
        }

        if (meta.areaAttack) {
            $gameScreen.startFlash([0, 0, 255, 255], 12);
        }
    };


    window.RSTH_IH.useSkillState = function (item) {
        if (!item) return;

        const leader = $gameParty.leader();
        if (leader && leader.hasState(11)) return;

        const dataItem = window.RSTH_IH.getGameItem(item);
        if (!dataItem) return;

        const actor = $gameParty.leader();
        if (!actor) return;

        if (DataManager.isWeapon(dataItem)) {
            const stateId = Number(dataItem.meta?.state);
            const stateName = $dataStates[stateId]?.name || "???";
            if (stateId > 0) {
                // powerupによるステート抵抗
                // 麻痺
                if (stateId === 11 && ConfigManager["gauge_ST2"] === 1) {
                    return;
                }
                // 毒
                if (stateId === 4 && ConfigManager["gauge_ST1"] === 1) {
                    return;
                }
                // 混乱
                if (stateId === 8 && ConfigManager["gauge_ST1"] === 1) {
                    return;
                }
                // 熱い！！
                if (stateId === 5 && ConfigManager["gauge_IG"] === 1) {
                    return;
                }

                if (stateId === 20) {
                    if (actor.hasState(20)) {
                        actor.removeState(20);
                    } else {
                        actor.addState(stateId);
                    }
                } else {
                    actor.addState(stateId);
                }
                //console.log(`[useSkillState] ${stateName} を ${actor.name()} に付与`);
                window.RSTH_IH.LogWindowManager?.addLog(`${actor.name()} に ${stateName} を付与！`);
            } else {
                //console.log(`[useSkillState] <state:ID> メタタグが存在しないか無効です`);
            }
        } else {
            //console.log(`[useSkillState] 武器ではありません`);
        }
    };



    // マップ上にアニメーションを表示する処理
    Game_Temp.prototype.RSTH_requestMapAnimation = function (mapX, mapY, animationId, mirror = false) {
        if (!$dataAnimations[animationId]) return;

        const scene = SceneManager._scene;
        if (!scene || !scene._spriteset) return;

        const tw = $gameMap.tileWidth();
        const th = $gameMap.tileHeight();
        const dx = $gameMap.displayX();
        const dy = $gameMap.displayY();

        const screenX = Math.round((mapX - dx) * tw + tw / 2);
        const screenY = Math.round((mapY - dy) * th + th);

        const dummySprite = new Sprite();
        dummySprite.x = screenX;
        dummySprite.y = screenY;

        // ✅ レイヤーが未作成なら作成
        if (!scene._spriteset._rsthAnimationLayer) {
            scene._spriteset._rsthAnimationLayer = new Sprite();
            scene._spriteset._rsthAnimationLayer.z = 5;
            scene._spriteset._tilemap.addChild(scene._spriteset._rsthAnimationLayer);
        }

        scene._spriteset._rsthAnimationLayer.addChild(dummySprite);

        const spriteAnimation = new Sprite_Animation();
        spriteAnimation.setup([dummySprite], $dataAnimations[animationId], mirror, 0);
        scene._spriteset._effectsContainer.addChild(spriteAnimation);

        spriteAnimation._afterEndCallback = function () {
            if (dummySprite.parent) dummySprite.parent.removeChild(dummySprite);
        };
    };

    window.RSTH_IH.getWeaponRange = function (dataItem) {
        if (!dataItem || !dataItem.meta) return 1;  // デフォルト1マス
        const range = Number(dataItem.meta.range);
        return isNaN(range) ? 1 : range;
    }

    window.RSTH_IH.isTileReachable = function (sx, sy, ex, ey) {
        const dx = Math.abs(ex - sx);
        const dy = Math.abs(ey - sy);
        const sxSign = (sx < ex) ? 1 : -1;
        const sySign = (sy < ey) ? 1 : -1;
        let err = dx - dy;

        while (true) {
            if (!window.RSTH_IH.isPassableForAttack(sx, sy)) {
                return false; // 遮蔽あり
            }
            if (sx === ex && sy === ey) break;

            const e2 = 2 * err;
            if (e2 > -dy) { err -= dy; sx += sxSign; }
            if (e2 < dx) { err += dx; sy += sySign; }
        }
        return true;
    }

    window.RSTH_IH.isPassableForAttack = function (x, y) {
        // 地形タグが1なら遮蔽なしとみなす（優先）
        if ($gameMap.terrainTag(x, y) === 1) {
            if (RSTH_DEBUG_LOG) console.log(`[isPassableForAttack] 地形タグ1により通過許可 (${x},${y})`);
            return true;
        }

        // ① MZ標準のマップチップが遮蔽なら攻撃も遮断
        if (!$gameMap.checkPassage(x, y, 0x0f)) {
            if (RSTH_DEBUG_LOG) console.warn(`[isPassableForAttack] MZ地形による遮断 (${x},${y})`);
            return false;
        }

        /*
        // ② SurvivalBlockの最上位ブロックでチェック
        const blocks = window.RSTH_IH.SurvivalBlockManager.getAll(x, y);
        if (blocks && blocks.length > 0) {
            const topBlock = blocks[blocks.length - 1];
            if (topBlock.passable === undefined) {
                if (RSTH_DEBUG_LOG) console.warn("[isPassableForAttack] passable が undefined のブロック:", topBlock);
                return false;
            }
            if (!topBlock.passable) {
                if (RSTH_DEBUG_LOG) console.warn(`[isPassableForAttack] ブロックにより遮断:`, topBlock);
                return false;
            }
        }
        */

        // ③ 通過可能
        return true;
    };




    // アイテム取得時の自動防具装備
    window.RSTH_IH.tryAutoEquipArmor = function (item, amount) {
        const item2 = item.item ?? null;
        let dataItem = $dataArmors[item.id];
        if (item2) dataItem = $dataArmors[item.item.id];

        //console.log(`[tryAutoEquipArmor] item`, item);
        //console.log(`[tryAutoEquipArmor] dataItem`, dataItem);

        if (!DataManager.isArmor(dataItem)) return false;

        const actor = $gameParty.leader();
        if (!actor) return false;

        const equips = actor.equips();
        const slotCandidates = actor.equipSlots()
            .map((etypeId, i) => ({ etypeId, index: i }))
            .filter(obj => obj.etypeId === dataItem.etypeId);

        if (slotCandidates.length === 0) return false;

        let remaining = Math.max(1, amount ?? 1);
        let equippedCount = 0;

        // 空きスロット優先
        for (const candidate of slotCandidates) {
            if (remaining <= 0) break;

            if (!equips[candidate.index]) {
                window.RSTH_IH.__Vanilla_GainItem(dataItem, 1, true);
                actor._equips[candidate.index].setObject(dataItem);
                actor.refresh();
                window.RSTH_IH.__Vanilla_GainItem(dataItem, -1, true);

                // state付与
                if (dataItem.meta && dataItem.meta.state) {
                    const stateId = Number(dataItem.meta.state);
                    const stateName = $dataStates[stateId]?.name || "???";
                    if (stateId > 0) {
                        actor.addState(stateId);
                        window.RSTH_IH.LogWindowManager?.addLog(`${actor.name()} に ${stateName} を付与！`);
                    }
                }

                equippedCount++;
                remaining--;

                SceneManager._scene._equipmentWindow?.refresh();
                SoundManager.playEquip();
                window.RSTH_IH.logEquipedArmor(dataItem);

                //console.log(`[tryAutoEquipArmor] 空きスロットに装備: ${dataItem.name} スロット${candidate.index}`);
            }
        }

        // 上書き候補
        for (const candidate of slotCandidates) {
            if (remaining <= 0) break;

            const currentArmor = equips[candidate.index];
            if (!currentArmor) continue;

            const newDef = dataItem.params[3] || 0;
            const oldDef = currentArmor.params[3] || 0;

            if (newDef > oldDef) {
                window.RSTH_IH.__Vanilla_GainItem(dataItem, 1, true);
                actor._equips[candidate.index].setObject(dataItem);
                actor.refresh();
                window.RSTH_IH.__Vanilla_GainItem(dataItem, -1, true);

                // state付与
                if (dataItem.meta && dataItem.meta.state) {
                    const stateId = Number(dataItem.meta.state);
                    const stateName = $dataStates[stateId]?.name || "???";
                    if (stateId > 0) {
                        actor.addState(stateId);
                        window.RSTH_IH.LogWindowManager?.addLog(`${actor.name()} に ${stateName} を付与！`);
                    }
                }

                equippedCount++;
                remaining--;

                SceneManager._scene._equipmentWindow?.refresh();
                SoundManager.playEquip();
                window.RSTH_IH.logEquipedArmor(dataItem);

                // 外れた防具を売却
                const refund = Math.floor((currentArmor.price || 0) / 5);
                if (refund > 0) {
                    $gameParty.gainGold(refund);
                    //console.log(`[tryAutoEquipArmor] 外れた防具を売却: ${currentArmor.name}, +${refund}G`);
                    window.RSTH_IH.logSelledArmor(currentArmor);
                }

                //console.log(`[tryAutoEquipArmor] 上書き装備: ${dataItem.name} スロット${candidate.index}`);
            }
        }

        // 余った分を売却
        if (remaining > 0) {
            //console.log("remaining", remaining);
            const refund = Math.floor((dataItem.price || 0) / 5);
            if (refund > 0) {
                const totalRefund = refund * remaining;
                $gameParty.gainGold(totalRefund);
                //console.log(`[tryAutoEquipArmor] 空きなし / 上書き不可 → ${dataItem.name} x${remaining} を売却, +${totalRefund}G`);
                window.RSTH_IH.logSelledArmor(dataItem, remaining);
            }
        }
        return true;
    };



    // 1. 近接武器の8方向マスクテーブル
    window.RSTH_IH._swordMasks = {
        up: [
            { dx: 0, dy: -1 }, { dx: -1, dy: -1 }, { dx: 1, dy: -1 },
        ],
        down: [
            { dx: 0, dy: 1 }, { dx: -1, dy: 1 }, { dx: 1, dy: 1 },
        ],
        left: [
            { dx: -1, dy: 0 }, { dx: -1, dy: -1 }, { dx: -1, dy: 1 },
        ],
        right: [
            { dx: 1, dy: 0 }, { dx: 1, dy: -1 }, { dx: 1, dy: 1 },
        ],
        upLeft: [
            { dx: -1, dy: 0 }, { dx: -1, dy: -1 }, { dx: 0, dy: -1 },
        ],
        upRight: [
            { dx: 1, dy: 0 }, { dx: 1, dy: -1 }, { dx: 0, dy: -1 },
        ],
        downLeft: [
            { dx: -1, dy: 0 }, { dx: -1, dy: 1 }, { dx: 0, dy: 1 },
        ],
        downRight: [
            { dx: 1, dy: 0 }, { dx: 1, dy: 1 }, { dx: 0, dy: 1 },
        ],
    };

    window.RSTH_IH._swordMasks2 = {
        up: [
            { dx: 0, dy: -1 }, { dx: -1, dy: -1 }, { dx: 1, dy: -1 },
            { dx: 0, dy: -2 }, { dx: -1, dy: -2 }, { dx: 1, dy: -2 },
        ],
        down: [
            { dx: 0, dy: 1 }, { dx: -1, dy: 1 }, { dx: 1, dy: 1 },
            { dx: 0, dy: 2 }, { dx: -1, dy: 2 }, { dx: 1, dy: 2 },
        ],
        left: [
            { dx: -1, dy: 0 }, { dx: -1, dy: -1 }, { dx: -1, dy: 1 },
            { dx: -2, dy: 0 }, { dx: -2, dy: -1 }, { dx: -2, dy: 1 },
        ],
        right: [
            { dx: 1, dy: 0 }, { dx: 1, dy: -1 }, { dx: 1, dy: 1 },
            { dx: 2, dy: 0 }, { dx: 2, dy: -1 }, { dx: 2, dy: 1 },
        ],
        upLeft: [
            { dx: -1, dy: 0 }, { dx: -1, dy: -1 }, { dx: 0, dy: -1 },
            { dx: -2, dy: 0 }, { dx: 0, dy: -2 },
        ],
        upRight: [
            { dx: 1, dy: 0 }, { dx: 1, dy: -1 }, { dx: 0, dy: -1 },
            { dx: 2, dy: 0 }, { dx: 0, dy: -2 },
        ],
        downLeft: [
            { dx: -1, dy: 0 }, { dx: -1, dy: 1 }, { dx: 0, dy: 1 },
            { dx: -2, dy: 0 }, { dx: 0, dy: 2 },
        ],
        downRight: [
            { dx: 1, dy: 0 }, { dx: 1, dy: 1 }, { dx: 0, dy: 1 },
            { dx: 2, dy: 0 }, { dx: 0, dy: 2 },
        ],
    };

    window.RSTH_IH._swordMasks3 = {
        up: [{ dx: 0, dy: -3 }, { dx: -1, dy: -2 }, { dx: 0, dy: -2 }, { dx: 1, dy: -2 }, { dx: -2, dy: -1 }, { dx: -1, dy: -1 }, { dx: 0, dy: -1 }, { dx: 1, dy: -1 }, { dx: 2, dy: -1 }],
        down: [{ dx: -2, dy: 1 }, { dx: -1, dy: 1 }, { dx: 0, dy: 1 }, { dx: 1, dy: 1 }, { dx: 2, dy: 1 }, { dx: -1, dy: 2 }, { dx: 0, dy: 2 }, { dx: 1, dy: 2 }, { dx: 0, dy: 3 }],
        left: [{ dx: -1, dy: -2 }, { dx: -2, dy: -1 }, { dx: -1, dy: -1 }, { dx: -3, dy: 0 }, { dx: -2, dy: 0 }, { dx: -1, dy: 0 }, { dx: -2, dy: 1 }, { dx: -1, dy: 1 }, { dx: -1, dy: 2 }],
        right: [{ dx: 1, dy: -2 }, { dx: 1, dy: -1 }, { dx: 2, dy: -1 }, { dx: 1, dy: 0 }, { dx: 2, dy: 0 }, { dx: 3, dy: 0 }, { dx: 1, dy: 1 }, { dx: 2, dy: 1 }, { dx: 1, dy: 2 }],
        upLeft: [{ dx: 0, dy: -3 }, { dx: -1, dy: -2 }, { dx: 0, dy: -2 }, { dx: -2, dy: -1 }, { dx: -1, dy: -1 }, { dx: 0, dy: -1 }, { dx: -3, dy: 0 }, { dx: -2, dy: 0 }, { dx: -1, dy: 0 }],
        upRight: [{ dx: 0, dy: -3 }, { dx: 0, dy: -2 }, { dx: 1, dy: -2 }, { dx: 0, dy: -1 }, { dx: 1, dy: -1 }, { dx: 2, dy: -1 }, { dx: 1, dy: 0 }, { dx: 2, dy: 0 }, { dx: 3, dy: 0 }],
        downLeft: [{ dx: -3, dy: 0 }, { dx: -2, dy: 0 }, { dx: -1, dy: 0 }, { dx: -2, dy: 1 }, { dx: -1, dy: 1 }, { dx: 0, dy: 1 }, { dx: -1, dy: 2 }, { dx: 0, dy: 2 }, { dx: 0, dy: 3 }],
        downRight: [{ dx: 1, dy: 0 }, { dx: 2, dy: 0 }, { dx: 3, dy: 0 }, { dx: 0, dy: 1 }, { dx: 1, dy: 1 }, { dx: 2, dy: 1 }, { dx: 0, dy: 2 }, { dx: 1, dy: 2 }, { dx: 0, dy: 3 }],
    };

    window.RSTH_IH._swordMasks4 = {
        up: [{ dx: 0, dy: -4 }, { dx: -1, dy: -3 }, { dx: 0, dy: -3 }, { dx: 1, dy: -3 }, { dx: -2, dy: -2 }, { dx: -1, dy: -2 }, { dx: 0, dy: -2 }, { dx: 1, dy: -2 }, { dx: 2, dy: -2 }, { dx: -3, dy: -1 }, { dx: -2, dy: -1 }, { dx: -1, dy: -1 }, { dx: 0, dy: -1 }, { dx: 1, dy: -1 }, { dx: 2, dy: -1 }, { dx: 3, dy: -1 }, { dx: -4, dy: 0 }, { dx: -3, dy: 0 }, { dx: -2, dy: 0 }, { dx: -1, dy: 0 }, { dx: 1, dy: 0 }, { dx: 2, dy: 0 }, { dx: 3, dy: 0 }, { dx: 4, dy: 0 }],
        down: [{ dx: -4, dy: 0 }, { dx: -3, dy: 0 }, { dx: -2, dy: 0 }, { dx: -1, dy: 0 }, { dx: 1, dy: 0 }, { dx: 2, dy: 0 }, { dx: 3, dy: 0 }, { dx: 4, dy: 0 }, { dx: -3, dy: 1 }, { dx: -2, dy: 1 }, { dx: -1, dy: 1 }, { dx: 0, dy: 1 }, { dx: 1, dy: 1 }, { dx: 2, dy: 1 }, { dx: 3, dy: 1 }, { dx: -2, dy: 2 }, { dx: -1, dy: 2 }, { dx: 0, dy: 2 }, { dx: 1, dy: 2 }, { dx: 2, dy: 2 }, { dx: -1, dy: 3 }, { dx: 0, dy: 3 }, { dx: 1, dy: 3 }, { dx: 0, dy: 4 }],
        left: [{ dx: 0, dy: -4 }, { dx: -1, dy: -3 }, { dx: 0, dy: -3 }, { dx: -2, dy: -2 }, { dx: -1, dy: -2 }, { dx: 0, dy: -2 }, { dx: -3, dy: -1 }, { dx: -2, dy: -1 }, { dx: -1, dy: -1 }, { dx: 0, dy: -1 }, { dx: -4, dy: 0 }, { dx: -3, dy: 0 }, { dx: -2, dy: 0 }, { dx: -1, dy: 0 }, { dx: -3, dy: 1 }, { dx: -2, dy: 1 }, { dx: -1, dy: 1 }, { dx: 0, dy: 1 }, { dx: -2, dy: 2 }, { dx: -1, dy: 2 }, { dx: 0, dy: 2 }, { dx: -1, dy: 3 }, { dx: 0, dy: 3 }, { dx: 0, dy: 4 }],
        right: [{ dx: 0, dy: -4 }, { dx: 0, dy: -3 }, { dx: 1, dy: -3 }, { dx: 0, dy: -2 }, { dx: 1, dy: -2 }, { dx: 2, dy: -2 }, { dx: 0, dy: -1 }, { dx: 1, dy: -1 }, { dx: 2, dy: -1 }, { dx: 3, dy: -1 }, { dx: 1, dy: 0 }, { dx: 2, dy: 0 }, { dx: 3, dy: 0 }, { dx: 4, dy: 0 }, { dx: 0, dy: 1 }, { dx: 1, dy: 1 }, { dx: 2, dy: 1 }, { dx: 3, dy: 1 }, { dx: 0, dy: 2 }, { dx: 1, dy: 2 }, { dx: 2, dy: 2 }, { dx: 0, dy: 3 }, { dx: 1, dy: 3 }, { dx: 0, dy: 4 }],
        upLeft: [{ dx: 0, dy: -4 }, { dx: -1, dy: -3 }, { dx: 0, dy: -3 }, { dx: 1, dy: -3 }, { dx: -2, dy: -2 }, { dx: -1, dy: -2 }, { dx: 0, dy: -2 }, { dx: 1, dy: -2 }, { dx: 2, dy: -2 }, { dx: -3, dy: -1 }, { dx: -2, dy: -1 }, { dx: -1, dy: -1 }, { dx: 0, dy: -1 }, { dx: 1, dy: -1 }, { dx: -4, dy: 0 }, { dx: -3, dy: 0 }, { dx: -2, dy: 0 }, { dx: -1, dy: 0 }, { dx: -3, dy: 1 }, { dx: -2, dy: 1 }, { dx: -1, dy: 1 }, { dx: -2, dy: 2 }],
        upRight: [{ dx: 0, dy: -4 }, { dx: -1, dy: -3 }, { dx: 0, dy: -3 }, { dx: 1, dy: -3 }, { dx: -2, dy: -2 }, { dx: -1, dy: -2 }, { dx: 0, dy: -2 }, { dx: 1, dy: -2 }, { dx: 2, dy: -2 }, { dx: -1, dy: -1 }, { dx: 0, dy: -1 }, { dx: 1, dy: -1 }, { dx: 2, dy: -1 }, { dx: 3, dy: -1 }, { dx: 1, dy: 0 }, { dx: 2, dy: 0 }, { dx: 3, dy: 0 }, { dx: 4, dy: 0 }, { dx: 1, dy: 1 }, { dx: 2, dy: 1 }, { dx: 3, dy: 1 }, { dx: 2, dy: 2 }],
        downLeft: [{ dx: -2, dy: -2 }, { dx: -3, dy: -1 }, { dx: -2, dy: -1 }, { dx: -1, dy: -1 }, { dx: -4, dy: 0 }, { dx: -3, dy: 0 }, { dx: -2, dy: 0 }, { dx: -1, dy: 0 }, { dx: -3, dy: 1 }, { dx: -2, dy: 1 }, { dx: -1, dy: 1 }, { dx: 0, dy: 1 }, { dx: 1, dy: 1 }, { dx: -2, dy: 2 }, { dx: -1, dy: 2 }, { dx: 0, dy: 2 }, { dx: 1, dy: 2 }, { dx: 2, dy: 2 }, { dx: -1, dy: 3 }, { dx: 0, dy: 3 }, { dx: 1, dy: 3 }, { dx: 0, dy: 4 }],
        downRight: [{ dx: 2, dy: -2 }, { dx: 1, dy: -1 }, { dx: 2, dy: -1 }, { dx: 3, dy: -1 }, { dx: 1, dy: 0 }, { dx: 2, dy: 0 }, { dx: 3, dy: 0 }, { dx: 4, dy: 0 }, { dx: -1, dy: 1 }, { dx: 0, dy: 1 }, { dx: 1, dy: 1 }, { dx: 2, dy: 1 }, { dx: 3, dy: 1 }, { dx: -2, dy: 2 }, { dx: -1, dy: 2 }, { dx: 0, dy: 2 }, { dx: 1, dy: 2 }, { dx: 2, dy: 2 }, { dx: -1, dy: 3 }, { dx: 0, dy: 3 }, { dx: 1, dy: 3 }, { dx: 0, dy: 4 }],
    };

    window.RSTH_IH._swordMasks5 = {
        up:
            [{ dx: 0, dy: -4 }, { dx: -1, dy: -3 }, { dx: 0, dy: -3 }, { dx: 1, dy: -3 }, { dx: -2, dy: -2 }, { dx: -1, dy: -2 }, { dx: 0, dy: -2 }, { dx: 1, dy: -2 }, { dx: 2, dy: -2 }, { dx: -3, dy: -1 }, { dx: -2, dy: -1 }, { dx: -1, dy: -1 }, { dx: 0, dy: -1 }, { dx: 1, dy: -1 }, { dx: 2, dy: -1 }, { dx: 3, dy: -1 }, { dx: -4, dy: 0 }, { dx: -3, dy: 0 }, { dx: -2, dy: 0 }, { dx: -1, dy: 0 }, { dx: 1, dy: 0 }, { dx: 2, dy: 0 }, { dx: 3, dy: 0 }, { dx: 4, dy: 0 }, { dx: -3, dy: 1 }, { dx: -2, dy: 1 }, { dx: -1, dy: 1 }, { dx: 1, dy: 1 }, { dx: 2, dy: 1 }, { dx: 3, dy: 1 }, { dx: -2, dy: 2 }, { dx: 2, dy: 2 }],
        down:
            [{ dx: -2, dy: -2 }, { dx: 2, dy: -2 }, { dx: -3, dy: -1 }, { dx: -2, dy: -1 }, { dx: -1, dy: -1 }, { dx: 1, dy: -1 }, { dx: 2, dy: -1 }, { dx: 3, dy: -1 }, { dx: -4, dy: 0 }, { dx: -3, dy: 0 }, { dx: -2, dy: 0 }, { dx: -1, dy: 0 }, { dx: 1, dy: 0 }, { dx: 2, dy: 0 }, { dx: 3, dy: 0 }, { dx: 4, dy: 0 }, { dx: -3, dy: 1 }, { dx: -2, dy: 1 }, { dx: -1, dy: 1 }, { dx: 0, dy: 1 }, { dx: 1, dy: 1 }, { dx: 2, dy: 1 }, { dx: 3, dy: 1 }, { dx: -2, dy: 2 }, { dx: -1, dy: 2 }, { dx: 0, dy: 2 }, { dx: 1, dy: 2 }, { dx: 2, dy: 2 }, { dx: -1, dy: 3 }, { dx: 0, dy: 3 }, { dx: 1, dy: 3 }, { dx: 0, dy: 4 }],
        left:
            [{ dx: 0, dy: -4 }, { dx: -1, dy: -3 }, { dx: 0, dy: -3 }, { dx: 1, dy: -3 }, { dx: -2, dy: -2 }, { dx: -1, dy: -2 }, { dx: 0, dy: -2 }, { dx: 1, dy: -2 }, { dx: 2, dy: -2 }, { dx: -3, dy: -1 }, { dx: -2, dy: -1 }, { dx: -1, dy: -1 }, { dx: 0, dy: -1 }, { dx: 1, dy: -1 }, { dx: -4, dy: 0 }, { dx: -3, dy: 0 }, { dx: -2, dy: 0 }, { dx: -1, dy: 0 }, { dx: -3, dy: 1 }, { dx: -2, dy: 1 }, { dx: -1, dy: 1 }, { dx: 0, dy: 1 }, { dx: 1, dy: 1 }, { dx: -2, dy: 2 }, { dx: -1, dy: 2 }, { dx: 0, dy: 2 }, { dx: 1, dy: 2 }, { dx: 2, dy: 2 }, { dx: -1, dy: 3 }, { dx: 0, dy: 3 }, { dx: 1, dy: 3 }, { dx: 0, dy: 4 }],
        right:
            [{ dx: 0, dy: -4 }, { dx: -1, dy: -3 }, { dx: 0, dy: -3 }, { dx: 1, dy: -3 }, { dx: -2, dy: -2 }, { dx: -1, dy: -2 }, { dx: 0, dy: -2 }, { dx: 1, dy: -2 }, { dx: 2, dy: -2 }, { dx: -1, dy: -1 }, { dx: 0, dy: -1 }, { dx: 1, dy: -1 }, { dx: 2, dy: -1 }, { dx: 3, dy: -1 }, { dx: 1, dy: 0 }, { dx: 2, dy: 0 }, { dx: 3, dy: 0 }, { dx: 4, dy: 0 }, { dx: -1, dy: 1 }, { dx: 0, dy: 1 }, { dx: 1, dy: 1 }, { dx: 2, dy: 1 }, { dx: 3, dy: 1 }, { dx: -2, dy: 2 }, { dx: -1, dy: 2 }, { dx: 0, dy: 2 }, { dx: 1, dy: 2 }, { dx: 2, dy: 2 }, { dx: -1, dy: 3 }, { dx: 0, dy: 3 }, { dx: 1, dy: 3 }, { dx: 0, dy: 4 }],
        upLeft:
            [{ dx: 0, dy: -4 }, { dx: -1, dy: -3 }, { dx: 0, dy: -3 }, { dx: 1, dy: -3 }, { dx: -2, dy: -2 }, { dx: -1, dy: -2 }, { dx: 0, dy: -2 }, { dx: 1, dy: -2 }, { dx: 2, dy: -2 }, { dx: -3, dy: -1 }, { dx: -2, dy: -1 }, { dx: -1, dy: -1 }, { dx: 0, dy: -1 }, { dx: 1, dy: -1 }, { dx: 2, dy: -1 }, { dx: 3, dy: -1 }, { dx: -4, dy: 0 }, { dx: -3, dy: 0 }, { dx: -2, dy: 0 }, { dx: -1, dy: 0 }, { dx: 1, dy: 0 }, { dx: 2, dy: 0 }, { dx: 3, dy: 0 }, { dx: 4, dy: 0 }, { dx: -3, dy: 1 }, { dx: -2, dy: 1 }, { dx: -1, dy: 1 }, { dx: 0, dy: 1 }, { dx: -2, dy: 2 }, { dx: -1, dy: 2 }, { dx: 0, dy: 2 }, { dx: -1, dy: 3 }, { dx: 0, dy: 3 }, { dx: 0, dy: 4 }],
        upRight:
            [{ dx: 0, dy: -4 }, { dx: -1, dy: -3 }, { dx: 0, dy: -3 }, { dx: 1, dy: -3 }, { dx: -2, dy: -2 }, { dx: -1, dy: -2 }, { dx: 0, dy: -2 }, { dx: 1, dy: -2 }, { dx: 2, dy: -2 }, { dx: -3, dy: -1 }, { dx: -2, dy: -1 }, { dx: -1, dy: -1 }, { dx: 0, dy: -1 }, { dx: 1, dy: -1 }, { dx: 2, dy: -1 }, { dx: 3, dy: -1 }, { dx: -4, dy: 0 }, { dx: -3, dy: 0 }, { dx: -2, dy: 0 }, { dx: -1, dy: 0 }, { dx: 1, dy: 0 }, { dx: 2, dy: 0 }, { dx: 3, dy: 0 }, { dx: 4, dy: 0 }, { dx: 0, dy: 1 }, { dx: 1, dy: 1 }, { dx: 2, dy: 1 }, { dx: 3, dy: 1 }, { dx: 0, dy: 2 }, { dx: 1, dy: 2 }, { dx: 2, dy: 2 }, { dx: 0, dy: 3 }, { dx: 1, dy: 3 }, { dx: 0, dy: 4 }],
        downLeft:
            [{ dx: 0, dy: -4 }, { dx: -1, dy: -3 }, { dx: 0, dy: -3 }, { dx: -2, dy: -2 }, { dx: -1, dy: -2 }, { dx: 0, dy: -2 }, { dx: -3, dy: -1 }, { dx: -2, dy: -1 }, { dx: -1, dy: -1 }, { dx: 0, dy: -1 }, { dx: -4, dy: 0 }, { dx: -3, dy: 0 }, { dx: -2, dy: 0 }, { dx: -1, dy: 0 }, { dx: 1, dy: 0 }, { dx: 2, dy: 0 }, { dx: 3, dy: 0 }, { dx: 4, dy: 0 }, { dx: -3, dy: 1 }, { dx: -2, dy: 1 }, { dx: -1, dy: 1 }, { dx: 0, dy: 1 }, { dx: 1, dy: 1 }, { dx: 2, dy: 1 }, { dx: 3, dy: 1 }, { dx: -2, dy: 2 }, { dx: -1, dy: 2 }, { dx: 0, dy: 2 }, { dx: 1, dy: 2 }, { dx: 2, dy: 2 }, { dx: -1, dy: 3 }, { dx: 0, dy: 3 }, { dx: 1, dy: 3 }, { dx: 0, dy: 4 }],
        downRight:
            [{ dx: 0, dy: -4 }, { dx: 0, dy: -3 }, { dx: 1, dy: -3 }, { dx: 0, dy: -2 }, { dx: 1, dy: -2 }, { dx: 2, dy: -2 }, { dx: 0, dy: -1 }, { dx: 1, dy: -1 }, { dx: 2, dy: -1 }, { dx: 3, dy: -1 }, { dx: -4, dy: 0 }, { dx: -3, dy: 0 }, { dx: -2, dy: 0 }, { dx: -1, dy: 0 }, { dx: 1, dy: 0 }, { dx: 2, dy: 0 }, { dx: 3, dy: 0 }, { dx: 4, dy: 0 }, { dx: -3, dy: 1 }, { dx: -2, dy: 1 }, { dx: -1, dy: 1 }, { dx: 0, dy: 1 }, { dx: 1, dy: 1 }, { dx: 2, dy: 1 }, { dx: 3, dy: 1 }, { dx: -2, dy: 2 }, { dx: -1, dy: 2 }, { dx: 0, dy: 2 }, { dx: 1, dy: 2 }, { dx: 2, dy: 2 }, { dx: -1, dy: 3 }, { dx: 0, dy: 3 }, { dx: 1, dy: 3 }, { dx: 0, dy: 4 }],
    };

    window.RSTH_IH._swordMasks6 = {
        up:
            [{ dx: 0, dy: -4 }, { dx: -1, dy: -3 }, { dx: 0, dy: -3 }, { dx: 1, dy: -3 }, { dx: -2, dy: -2 }, { dx: -1, dy: -2 }, { dx: 0, dy: -2 }, { dx: 1, dy: -2 }, { dx: 2, dy: -2 }, { dx: -3, dy: -1 }, { dx: -2, dy: -1 }, { dx: -1, dy: -1 }, { dx: 0, dy: -1 }, { dx: 1, dy: -1 }, { dx: 2, dy: -1 }, { dx: 3, dy: -1 }, { dx: -4, dy: 0 }, { dx: -3, dy: 0 }, { dx: -2, dy: 0 }, { dx: -1, dy: 0 }, { dx: 1, dy: 0 }, { dx: 2, dy: 0 }, { dx: 3, dy: 0 }, { dx: 4, dy: 0 }, { dx: -3, dy: 1 }, { dx: -2, dy: 1 }, { dx: -1, dy: 1 }, { dx: 0, dy: 1 }, { dx: 1, dy: 1 }, { dx: 2, dy: 1 }, { dx: 3, dy: 1 }, { dx: -2, dy: 2 }, { dx: -1, dy: 2 }, { dx: 0, dy: 2 }, { dx: 1, dy: 2 }, { dx: 2, dy: 2 }, { dx: -1, dy: 3 }, { dx: 0, dy: 3 }, { dx: 1, dy: 3 }, { dx: 0, dy: 4 }],
        down:
            [{ dx: 0, dy: -4 }, { dx: -1, dy: -3 }, { dx: 0, dy: -3 }, { dx: 1, dy: -3 }, { dx: -2, dy: -2 }, { dx: -1, dy: -2 }, { dx: 0, dy: -2 }, { dx: 1, dy: -2 }, { dx: 2, dy: -2 }, { dx: -3, dy: -1 }, { dx: -2, dy: -1 }, { dx: -1, dy: -1 }, { dx: 0, dy: -1 }, { dx: 1, dy: -1 }, { dx: 2, dy: -1 }, { dx: 3, dy: -1 }, { dx: -4, dy: 0 }, { dx: -3, dy: 0 }, { dx: -2, dy: 0 }, { dx: -1, dy: 0 }, { dx: 1, dy: 0 }, { dx: 2, dy: 0 }, { dx: 3, dy: 0 }, { dx: 4, dy: 0 }, { dx: -3, dy: 1 }, { dx: -2, dy: 1 }, { dx: -1, dy: 1 }, { dx: 0, dy: 1 }, { dx: 1, dy: 1 }, { dx: 2, dy: 1 }, { dx: 3, dy: 1 }, { dx: -2, dy: 2 }, { dx: -1, dy: 2 }, { dx: 0, dy: 2 }, { dx: 1, dy: 2 }, { dx: 2, dy: 2 }, { dx: -1, dy: 3 }, { dx: 0, dy: 3 }, { dx: 1, dy: 3 }, { dx: 0, dy: 4 }],
        left:
            [{ dx: 0, dy: -4 }, { dx: -1, dy: -3 }, { dx: 0, dy: -3 }, { dx: 1, dy: -3 }, { dx: -2, dy: -2 }, { dx: -1, dy: -2 }, { dx: 0, dy: -2 }, { dx: 1, dy: -2 }, { dx: 2, dy: -2 }, { dx: -3, dy: -1 }, { dx: -2, dy: -1 }, { dx: -1, dy: -1 }, { dx: 0, dy: -1 }, { dx: 1, dy: -1 }, { dx: 2, dy: -1 }, { dx: 3, dy: -1 }, { dx: -4, dy: 0 }, { dx: -3, dy: 0 }, { dx: -2, dy: 0 }, { dx: -1, dy: 0 }, { dx: 1, dy: 0 }, { dx: 2, dy: 0 }, { dx: 3, dy: 0 }, { dx: 4, dy: 0 }, { dx: -3, dy: 1 }, { dx: -2, dy: 1 }, { dx: -1, dy: 1 }, { dx: 0, dy: 1 }, { dx: 1, dy: 1 }, { dx: 2, dy: 1 }, { dx: 3, dy: 1 }, { dx: -2, dy: 2 }, { dx: -1, dy: 2 }, { dx: 0, dy: 2 }, { dx: 1, dy: 2 }, { dx: 2, dy: 2 }, { dx: -1, dy: 3 }, { dx: 0, dy: 3 }, { dx: 1, dy: 3 }, { dx: 0, dy: 4 }],
        right:
            [{ dx: 0, dy: -4 }, { dx: -1, dy: -3 }, { dx: 0, dy: -3 }, { dx: 1, dy: -3 }, { dx: -2, dy: -2 }, { dx: -1, dy: -2 }, { dx: 0, dy: -2 }, { dx: 1, dy: -2 }, { dx: 2, dy: -2 }, { dx: -3, dy: -1 }, { dx: -2, dy: -1 }, { dx: -1, dy: -1 }, { dx: 0, dy: -1 }, { dx: 1, dy: -1 }, { dx: 2, dy: -1 }, { dx: 3, dy: -1 }, { dx: -4, dy: 0 }, { dx: -3, dy: 0 }, { dx: -2, dy: 0 }, { dx: -1, dy: 0 }, { dx: 1, dy: 0 }, { dx: 2, dy: 0 }, { dx: 3, dy: 0 }, { dx: 4, dy: 0 }, { dx: -3, dy: 1 }, { dx: -2, dy: 1 }, { dx: -1, dy: 1 }, { dx: 0, dy: 1 }, { dx: 1, dy: 1 }, { dx: 2, dy: 1 }, { dx: 3, dy: 1 }, { dx: -2, dy: 2 }, { dx: -1, dy: 2 }, { dx: 0, dy: 2 }, { dx: 1, dy: 2 }, { dx: 2, dy: 2 }, { dx: -1, dy: 3 }, { dx: 0, dy: 3 }, { dx: 1, dy: 3 }, { dx: 0, dy: 4 }],
        upLeft:
            [{ dx: 0, dy: -4 }, { dx: -1, dy: -3 }, { dx: 0, dy: -3 }, { dx: 1, dy: -3 }, { dx: -2, dy: -2 }, { dx: -1, dy: -2 }, { dx: 0, dy: -2 }, { dx: 1, dy: -2 }, { dx: 2, dy: -2 }, { dx: -3, dy: -1 }, { dx: -2, dy: -1 }, { dx: -1, dy: -1 }, { dx: 0, dy: -1 }, { dx: 1, dy: -1 }, { dx: 2, dy: -1 }, { dx: 3, dy: -1 }, { dx: -4, dy: 0 }, { dx: -3, dy: 0 }, { dx: -2, dy: 0 }, { dx: -1, dy: 0 }, { dx: 1, dy: 0 }, { dx: 2, dy: 0 }, { dx: 3, dy: 0 }, { dx: 4, dy: 0 }, { dx: -3, dy: 1 }, { dx: -2, dy: 1 }, { dx: -1, dy: 1 }, { dx: 0, dy: 1 }, { dx: 1, dy: 1 }, { dx: 2, dy: 1 }, { dx: 3, dy: 1 }, { dx: -2, dy: 2 }, { dx: -1, dy: 2 }, { dx: 0, dy: 2 }, { dx: 1, dy: 2 }, { dx: 2, dy: 2 }, { dx: -1, dy: 3 }, { dx: 0, dy: 3 }, { dx: 1, dy: 3 }, { dx: 0, dy: 4 }],
        upRight:
            [{ dx: 0, dy: -4 }, { dx: -1, dy: -3 }, { dx: 0, dy: -3 }, { dx: 1, dy: -3 }, { dx: -2, dy: -2 }, { dx: -1, dy: -2 }, { dx: 0, dy: -2 }, { dx: 1, dy: -2 }, { dx: 2, dy: -2 }, { dx: -3, dy: -1 }, { dx: -2, dy: -1 }, { dx: -1, dy: -1 }, { dx: 0, dy: -1 }, { dx: 1, dy: -1 }, { dx: 2, dy: -1 }, { dx: 3, dy: -1 }, { dx: -4, dy: 0 }, { dx: -3, dy: 0 }, { dx: -2, dy: 0 }, { dx: -1, dy: 0 }, { dx: 1, dy: 0 }, { dx: 2, dy: 0 }, { dx: 3, dy: 0 }, { dx: 4, dy: 0 }, { dx: -3, dy: 1 }, { dx: -2, dy: 1 }, { dx: -1, dy: 1 }, { dx: 0, dy: 1 }, { dx: 1, dy: 1 }, { dx: 2, dy: 1 }, { dx: 3, dy: 1 }, { dx: -2, dy: 2 }, { dx: -1, dy: 2 }, { dx: 0, dy: 2 }, { dx: 1, dy: 2 }, { dx: 2, dy: 2 }, { dx: -1, dy: 3 }, { dx: 0, dy: 3 }, { dx: 1, dy: 3 }, { dx: 0, dy: 4 }],
        downLeft:
            [{ dx: 0, dy: -4 }, { dx: -1, dy: -3 }, { dx: 0, dy: -3 }, { dx: 1, dy: -3 }, { dx: -2, dy: -2 }, { dx: -1, dy: -2 }, { dx: 0, dy: -2 }, { dx: 1, dy: -2 }, { dx: 2, dy: -2 }, { dx: -3, dy: -1 }, { dx: -2, dy: -1 }, { dx: -1, dy: -1 }, { dx: 0, dy: -1 }, { dx: 1, dy: -1 }, { dx: 2, dy: -1 }, { dx: 3, dy: -1 }, { dx: -4, dy: 0 }, { dx: -3, dy: 0 }, { dx: -2, dy: 0 }, { dx: -1, dy: 0 }, { dx: 1, dy: 0 }, { dx: 2, dy: 0 }, { dx: 3, dy: 0 }, { dx: 4, dy: 0 }, { dx: -3, dy: 1 }, { dx: -2, dy: 1 }, { dx: -1, dy: 1 }, { dx: 0, dy: 1 }, { dx: 1, dy: 1 }, { dx: 2, dy: 1 }, { dx: 3, dy: 1 }, { dx: -2, dy: 2 }, { dx: -1, dy: 2 }, { dx: 0, dy: 2 }, { dx: 1, dy: 2 }, { dx: 2, dy: 2 }, { dx: -1, dy: 3 }, { dx: 0, dy: 3 }, { dx: 1, dy: 3 }, { dx: 0, dy: 4 }],
        downRight:
            [{ dx: 0, dy: -4 }, { dx: -1, dy: -3 }, { dx: 0, dy: -3 }, { dx: 1, dy: -3 }, { dx: -2, dy: -2 }, { dx: -1, dy: -2 }, { dx: 0, dy: -2 }, { dx: 1, dy: -2 }, { dx: 2, dy: -2 }, { dx: -3, dy: -1 }, { dx: -2, dy: -1 }, { dx: -1, dy: -1 }, { dx: 0, dy: -1 }, { dx: 1, dy: -1 }, { dx: 2, dy: -1 }, { dx: 3, dy: -1 }, { dx: -4, dy: 0 }, { dx: -3, dy: 0 }, { dx: -2, dy: 0 }, { dx: -1, dy: 0 }, { dx: 1, dy: 0 }, { dx: 2, dy: 0 }, { dx: 3, dy: 0 }, { dx: 4, dy: 0 }, { dx: -3, dy: 1 }, { dx: -2, dy: 1 }, { dx: -1, dy: 1 }, { dx: 0, dy: 1 }, { dx: 1, dy: 1 }, { dx: 2, dy: 1 }, { dx: 3, dy: 1 }, { dx: -2, dy: 2 }, { dx: -1, dy: 2 }, { dx: 0, dy: 2 }, { dx: 1, dy: 2 }, { dx: 2, dy: 2 }, { dx: -1, dy: 3 }, { dx: 0, dy: 3 }, { dx: 1, dy: 3 }, { dx: 0, dy: 4 }],
    };

    // 2. 方向キー取得関数
    window.RSTH_IH.getDirectionKeyByMouse = function (px, py, mouseX, mouseY) {
        const dx = mouseX - px;
        const dy = mouseY - py;
        const angle = Math.atan2(dy, dx);
        const degree = angle * (180 / Math.PI);

        if (degree >= -22.5 && degree < 22.5) return "right";
        if (degree >= 22.5 && degree < 67.5) return "downRight";
        if (degree >= 67.5 && degree < 112.5) return "down";
        if (degree >= 112.5 && degree < 157.5) return "downLeft";
        if (degree >= 157.5 || degree < -157.5) return "left";
        if (degree >= -157.5 && degree < -112.5) return "upLeft";
        if (degree >= -112.5 && degree < -67.5) return "up";
        if (degree >= -67.5 && degree < -22.5) return "upRight";

        return "right"; // fallback
    };

    // 3. 近接武器 自動攻撃処理（update内で呼び出し）
    window.RSTH_IH.autoUseMeleeWeapon = function () {

        window.RSTH_IH._meleeCooldown = window.RSTH_IH._meleeCooldown || 0;
        window.RSTH_IH._meleeCooldown = Math.max(0, window.RSTH_IH._meleeCooldown - 1);

        if (window.RSTH_IH._meleeCooldown > 0) return;

        const leader = $gameParty.leader();
        if (leader && leader.hasState(11)) return;

        const hot = $gameSystem._customHotbarItems || [];
        const slot = hot[3] // 近接限定スロット

        if (!slot) return;
        if (slot.type !== "weapon") return;

        const weapon = $dataWeapons[slot.id];
        const meta = weapon.meta || {};

        if (!weapon) return;
        if (meta.projectile) return;// projectile系除外
        if (!meta.melee) return; // meleeがない除外

        const px = $gamePlayer.x + 0.5;
        const py = $gamePlayer.y + 0.5;
        const tw = $gameMap.tileWidth();
        const th = $gameMap.tileHeight();
        const dx = $gameMap.displayX();
        const dy = $gameMap.displayY();
        const mouseX = dx + TouchInput.x / tw;
        const mouseY = dy + TouchInput.y / th;

        const range = window.RSTH_IH.getWeaponRange(weapon);
        const dirKey = window.RSTH_IH.getDirectionKeyByMouse(px, py, mouseX, mouseY);
        const maskTable = {
            1: window.RSTH_IH._swordMasks,
            2: window.RSTH_IH._swordMasks2,
            3: window.RSTH_IH._swordMasks3,
            4: window.RSTH_IH._swordMasks4,
            5: window.RSTH_IH._swordMasks5,
            6: window.RSTH_IH._swordMasks6,
        };
        let mask = (maskTable[range] || {})[dirKey] || [];


        // アニメーション
        window.RSTH_IH.showAttackRange(dirKey, mask, 15);

        // 当たり判定
        let amount = Number(weapon.meta.melee) || 1;

        for (let i = 0; i < amount; i++) {
            for (const offset of mask) {
                const bx = Math.round($gamePlayer.x + offset.dx);
                const by = Math.round($gamePlayer.y + offset.dy);

                const mob = window.RSTH_IH._mobManager.getMobAt(bx, by);
                if (!mob) continue;

                if (!window.RSTH_IH.isTileReachable($gamePlayer.x, $gamePlayer.y, bx, by)) continue;

                const knockback = Number(meta.knockback) || 0;
                window.RSTH_IH.applyKnockback(mob, $gamePlayer.x, $gamePlayer.y, knockback, window.RSTH_IH._mobManager);

                mob.queueHit(weapon, knockback, $gamePlayer.x, $gamePlayer.y);
            }
        }

        // クールタイム設定
        const cooltime = Number(window.RSTH_IH.atkCooltime(weapon)) || 30;
        window.RSTH_IH._meleeCooldown = cooltime;
    };

    window.RSTH_IH.showAttackRange = function (dirKey, mask, duration = 15) {
        const tw = $gameMap.tileWidth();
        const th = $gameMap.tileHeight();
        const dx = $gameMap.displayX();
        const dy = $gameMap.displayY();
        const px = $gamePlayer.x;
        const py = $gamePlayer.y;

        const sprites = [];

        for (const offset of mask) {
            const tx = px + offset.dx;
            const ty = py + offset.dy;

            const sprite = new Sprite();
            sprite.bitmap = new Bitmap(tw, th);
            sprite.bitmap.fillRect(0, 0, tw, th, 'rgba(43, 39, 255, 0.3)');
            sprite.x = Math.round((tx - dx) * tw);
            sprite.y = Math.round((ty - dy) * th);
            sprite.z = 20;

            SceneManager._scene._spriteset._tilemap.addChild(sprite);
            sprites.push(sprite);
        }

        const waitMs = duration * (1000 / 60);
        setTimeout(() => {
            for (const sprite of sprites) {
                if (sprite.parent) sprite.parent.removeChild(sprite);
            }
        }, waitMs);
    };

    // 瞬歩の移動処理
    window.RSTH_IH.ShunpoMove = function (x, y) {
        //console.log(`shunpo x:${x} y:${y}`);

        const centerX = $gamePlayer.x;
        const centerY = $gamePlayer.y;
        const offsetX = x - centerX;
        const offsetY = y - centerY;
        const length = Math.sqrt(offsetX * offsetX + offsetY * offsetY) || 0.0001;

        const normX = Math.round(offsetX / length);
        const normY = Math.round(offsetY / length);

        const dir = (normX === 1) ? 6 : (normX === -1) ? 4 : (normY === 1) ? 2 : (normY === -1) ? 8 : 0;
        // 🔽 マップ範囲と通行の両方をチェック
        if ($gameMap.isValid(x, y) &&
            $gameMap.isPassable(x, y, dir)) {
            //console.log("$gameMap.isValid(x, y)", $gameMap.isValid(x, y), "$gameMap.isPassable(x, y)", $gameMap.isPassable(x, y));
            $gamePlayer._x = x;
            $gamePlayer._y = y;
            $gamePlayer._realX = x;
            $gamePlayer._realY = y;
        } else {
            return;
        }
    };






})();