/*:
 * @target MZ
 * @plugindesc RSTH_IH: サバイバルゲームシステムプラグイン
 * @author © 2025 ReSera_りせら（@MOBIUS1001）
 *
 * このソースコードは無断での転載、複製、改変、再配布、商用利用を固く禁じます。
 * 禁止事項の例：
 * - 本ファイルの全部または一部を許可なくコピー、再配布すること
 * - 本ファイルを改変して配布すること
 * - 商用目的での利用
 */


(() => {
    "use strict";

    // ログ出力制御フラグ（trueでログ出力、falseで抑制）
    //const RSTH_DEBUG_LOG = true;
    const RSTH_DEBUG_LOG = false;


    // インベントリに外部からアイテムを追加する場合
    window.RSTH_IH.gainItemToInventory = function (item, amount = 1) {
        if (!item || amount <= 0) return 0;

        if (RSTH_DEBUG_LOG) console.log(`[gainItemToInventory] item`, item);
        const inv = $gameSystem._customInventoryItems || [];
        const type = window.RSTH_IH.getItemType(item);
        if (RSTH_DEBUG_LOG) console.log(`[gainItemToInventory] type`, type);
        let remaining = amount;
        let maxStack = ["weapon", "armor", "tool"].includes(type) ? 1 : window.RSTH_IH.StackSize;

        //console.log("item", item);

        // ① 既存スロットに加算できるかチェック
        for (let i = 0; i < inv.length; i++) {
            const slot = inv[i];
            if (slot && slot.id === item.id && slot.type === type && slot.count < maxStack) {
                const space = window.RSTH_IH.StackSize - slot.count;
                const toAdd = Math.min(space, remaining);
                slot.count += toAdd;
                remaining -= toAdd;
                if (remaining <= 0) break;
            }
        }

        // ② 空きスロットに新規格納（ポーションなどが初めて追加されるとき）
        const maxSlots = window.RSTH_IH.InventoryCols * window.RSTH_IH.InventoryRows;
        for (let i = 0; i < maxSlots && remaining > 0; i++) {
            if (!inv[i]) {
                const toAdd = Math.min(maxStack, remaining);
                if (!inv[i]) {
                    inv[i] = {
                        id: item.id,
                        type,
                        iconIndex: item.iconIndex,
                        name: item.name,
                        count: toAdd
                    };

                    // ブロックアイテムであれば、追加メタ情報を付加
                    if (inv[i].type === "block") {
                        const meta = $gameSystem.rsthgetBlockMetaByItemId(item.id);

                        if (RSTH_DEBUG_LOG) console.warn(`[gainItemToInventory] item.id`, item.id);
                        if (meta) {
                            inv[i].blockName = String(item.blockName || "");
                            inv[i].tileId = isNaN(Number(meta.tileId)) ? 0 : Number(meta.tileId);
                            inv[i].size = (meta.size && Array.isArray(meta.size)) ? meta.size : [1, 1];
                            inv[i].tileset = meta.tileset || "IconSet";

                            // tileOffsets1 の安全な代入
                            try {
                                inv[i].tileOffsets1 = Array.isArray(meta.tileOffsets1) ? meta.tileOffsets1 : item._tileOffsets1Parsed || [];
                            } catch (e) {
                                if (RSTH_DEBUG_LOG) console.error("[gainItemToInventory] tileOffsets1 parse error:", e, meta.tileOffsets1);
                                inv[i].tileOffsets1 = [];
                            }

                            // tileOffsets2 の安全な代入
                            try {
                                inv[i].tileOffsets2 = Array.isArray(meta.tileOffsets2) ? meta.tileOffsets2 : item._tileOffsets2Parsed || [];
                            } catch (e) {
                                if (RSTH_DEBUG_LOG) console.error("[gainItemToInventory] tileOffsets2 parse error:", e, meta.tileOffsets2);
                                inv[i].tileOffsets2 = [];
                            }

                            inv[i].growthTime = meta.growthTime;
                            inv[i].dropItems1 = meta.dropItems1;
                            inv[i].dropItems2 = meta.dropItems2;
                        }
                    }
                }

                if (RSTH_DEBUG_LOG) console.warn(`[gainItemToInventory] inv[${i}]`, inv[i]);

                remaining -= toAdd;
            }
        }

        // ③ システムに反映
        $gameSystem._customInventoryItems = inv;

        // ④ シーンに表示中なら再反映
        const win = SceneManager._scene?._inventoryWindow;
        if (win) {
            win.setItems(inv);
        }

        return remaining;
    }

    // ホットバーに外部からアイテムを追加する処理（RSTH仕様）
    window.RSTH_IH.gainItemToHotbar = function (item, amount = 1) {
        if (RSTH_DEBUG_LOG) console.log("[gainItemToHotbar]呼び出し");
        if (!item || amount <= 0) return 0;

        const hotbar = $gameSystem._customHotbarItems || [];
        const type = window.RSTH_IH.getItemType(item);
        let remaining = amount;
        let maxStack = ["weapon", "armor", "tool"].includes(type) ? 1 : window.RSTH_IH.StackSize;

        //console.log("[gainItemToHotbar]item", item);
        //console.log("[gainItemToHotbar]hotbar", hotbar);


        // ① 既存スロットに加算できるかチェック
        for (let i = 0; i < hotbar.length; i++) {
            const slot = hotbar[i];
            if (slot && slot.id === item.id && slot.type === type && slot.count < maxStack) {
                const space = window.RSTH_IH.StackSize - slot.count;
                const toAdd = Math.min(space, remaining);
                slot.count += toAdd;
                remaining -= toAdd;
                if (remaining <= 0) break;
            }
        }

        // ② 空きスロットに新規格納（ポーションなどが初めて追加されるとき）
        for (let i = 0; i < window.RSTH_IH.HotbarSlotCount && remaining > 0; i++) {
            if (!hotbar[i]) {
                const toAdd = Math.min(maxStack, remaining);
                hotbar[i] = {
                    id: item.id,
                    type,
                    iconIndex: item.iconIndex,
                    name: item.name,
                    count: toAdd
                };

                // ブロックアイテムであれば、追加メタ情報を付加
                if (hotbar[i].type === "block") {
                    const meta = $gameSystem.rsthgetBlockMetaByItemId(item.id);

                    if (RSTH_DEBUG_LOG) console.warn(`[gainItemToHotbar] item.id`, item.id);
                    if (meta) {
                        hotbar[i].blockName = String(item.blockName || "");
                        hotbar[i].tileId = isNaN(Number(meta.tileId)) ? 0 : Number(meta.tileId);
                        hotbar[i].size = (meta.size && Array.isArray(meta.size)) ? meta.size : [1, 1];
                        hotbar[i].tileset = meta.tileset || "IconSet";

                        // tileOffsets1 の安全な代入
                        try {
                            hotbar[i].tileOffsets1 = Array.isArray(meta.tileOffsets1) ? meta.tileOffsets1 : item._tileOffsets1Parsed || [];
                        } catch (e) {
                            if (RSTH_DEBUG_LOG) console.error("[gainItemToHotbar] tileOffsets1 parse error:", e, meta.tileOffsets1);
                            hotbar[i].tileOffsets1 = [];
                        }

                        // tileOffsets2 の安全な代入
                        try {
                            hotbar[i].tileOffsets2 = Array.isArray(meta.tileOffsets2) ? meta.tileOffsets2 : item._tileOffsets2Parsed || [];
                        } catch (e) {
                            if (RSTH_DEBUG_LOG) console.error("[gainItemToHotbar] tileOffsets2 parse error:", e, meta.tileOffsets2);
                            hotbar[i].tileOffsets2 = [];
                        }

                        hotbar[i].growthTime = meta.growthTime;
                        hotbar[i].dropItems1 = meta.dropItems1;
                        hotbar[i].dropItems2 = meta.dropItems2;
                    }
                }


                if (RSTH_DEBUG_LOG) console.log(`[gainItemToHotbar] スロット${i}に新規追加: ${item.name} × ${toAdd}`);
                if (RSTH_DEBUG_LOG) console.log(`[gainItemToHotbar] item`, item);

                remaining -= toAdd;
            }
        }

        // ③ システムに反映
        $gameSystem._customHotbarItems = hotbar;

        // ④ シーンに表示中なら再反映
        const win = SceneManager._scene?._hotbarWindow;
        if (win) {
            win.setItems(hotbar);
            win.items = hotbar;
            win.refresh();
        }

        // アイテム追加後に再描画を強制
        if (SceneManager._scene && SceneManager._scene._hotbarWindow) {
            SceneManager._scene._hotbarWindow.refresh();
        }

        if (remaining > 0) {
            if (RSTH_DEBUG_LOG) console.warn("[gainItemToHotbar] ホットバーに追加できませんでした:", item.name);
            if (RSTH_DEBUG_LOG) console.warn("[gainItemToHotbar] 全スロット数:", window.RSTH_IH.HotbarSlotCount, "使用中:", hotbar.filter(e => e != null).length);
            if (RSTH_DEBUG_LOG) console.log(`[gainItemToHotbar] HotbarSlots=${window.RSTH_IH.HotbarSlotCount}, window.RSTH_IH.StackSize=${window.RSTH_IH.StackSize}`);
        }

        return remaining;
    };

    // 共通化したコア関数
    window.RSTH_IH._gainItemToHotbarCore = function (item, amount) {
        const hot = $gameSystem._customHotbarItems ||= Array(window.RSTH_IH.HotbarSlotCount).fill(null);
        const type = window.RSTH_IH.getItemType(item);
        //console.log("item", item);

        let targetSlot = -1;

        if (item.wtypeId) {
            if (item.wtypeId === 2) targetSlot = 3; // 剣
            else if (item.wtypeId === 3 || item.wtypeId === 6) targetSlot = 4; // 飛輪、散弾銃
            else if (item.wtypeId === 8) targetSlot = 5; // 宝珠
            else if (item.wtypeId === 1 || item.wtypeId === 9 || item.wtypeId === 14) targetSlot = 6; // 短剣、銃、鉄球
            else if (item.wtypeId === 10) targetSlot = 0; // スキルA
            else if (item.wtypeId === 11) targetSlot = 1; // スキルB
            else if (item.wtypeId === 12) targetSlot = 2; // スキルC
        } else if (item.itypeId) {
            if (item.id === 7) targetSlot = 7; // 低級ポーション
            else if (item.id === 8) targetSlot = 8; // 中級ポーション
            else if (item.id === 9) targetSlot = 9; // 上級ポーション
        }

        let remaining = amount;
        let seichouCount = 0;

        while (remaining > 0 && targetSlot >= 0) {
            let maxStack = ["weapon", "armor", "tool"].includes(type) ? 1 : window.RSTH_IH.StackSize;

            const slot = hot[targetSlot];

            // 剣の進化Lv1~
            if (targetSlot === 3 && item.id === 10) {
                if (slot) {
                    if (slot.id === 1) { slot.id = 2; slot.name = $dataWeapons[2].name; seichouCount++; remaining--; continue; }
                    else if (slot.id === 2) { slot.id = 3; slot.name = $dataWeapons[3].name; seichouCount++; remaining--; continue; }
                    else if (slot.id === 3) { slot.id = 4; slot.name = $dataWeapons[4].name; seichouCount++; remaining--; continue; }
                    else if (slot.id === 4) { slot.id = 5; slot.name = $dataWeapons[5].name; seichouCount++; remaining--; continue; }
                    else { break; }
                } else {
                    hot[targetSlot] = {
                        id: 1, type,
                        iconIndex: $dataWeapons[1].iconIndex,
                        name: $dataWeapons[1].name,
                        count: 1
                    };
                    remaining--;
                    continue;
                }
            }
            // 剣の進化Lv6~
            else if (targetSlot === 3 && item.id === 11) {
                if (slot) {
                    if (slot.id === 1 || slot.id === 2 || slot.id === 3 || slot.id === 4) {
                        slot.id = 5; slot.name = $dataWeapons[5].name; seichouCount++; remaining--; continue;
                    }
                    else if (slot.id === 5) { slot.id = 6; slot.name = $dataWeapons[6].name; seichouCount++; remaining--; continue; }
                    else if (slot.id === 6) { slot.id = 7; slot.name = $dataWeapons[7].name; seichouCount++; remaining--; continue; }
                    else if (slot.id === 7) { slot.id = 8; slot.name = $dataWeapons[8].name; seichouCount++; remaining--; continue; }
                    else if (slot.id === 8) { slot.id = 9; slot.name = $dataWeapons[9].name; seichouCount++; remaining--; continue; }
                    else { break; }
                } else {
                    hot[targetSlot] = {
                        id: 5, type,
                        iconIndex: $dataWeapons[5].iconIndex,
                        name: $dataWeapons[5].name,
                        count: 1
                    };
                    remaining--;
                    continue;
                }
            }
            // 円月輪の進化
            else if (targetSlot === 4 && item.id === 13) {
                if (slot) {
                    if (slot.id === 13) { slot.id = 14; slot.name = $dataWeapons[14].name; seichouCount++; remaining--; continue; }
                    else if (slot.id === 14) { slot.id = 15; slot.name = $dataWeapons[15].name; seichouCount++; remaining--; continue; }
                    else if (slot.id === 15) { slot.id = 16; slot.name = $dataWeapons[16].name; seichouCount++; remaining--; continue; }
                    else if (slot.id === 16) { slot.id = 17; slot.name = $dataWeapons[17].name; seichouCount++; remaining--; continue; }
                    else if (slot.id === 17) { slot.id = 18; slot.name = $dataWeapons[18].name; seichouCount++; remaining--; continue; }
                    else if (slot.id === 18) { slot.id = 19; slot.name = $dataWeapons[19].name; seichouCount++; remaining--; continue; }
                    else if (slot.id === 19) { slot.id = 20; slot.name = $dataWeapons[20].name; seichouCount++; remaining--; continue; }
                    else if (slot.id === 20) { slot.id = 21; slot.name = $dataWeapons[21].name; seichouCount++; remaining--; continue; }
                    else { break; }
                } else {
                    hot[targetSlot] = {
                        id: 13, type,
                        iconIndex: $dataWeapons[13].iconIndex,
                        name: $dataWeapons[13].name,
                        count: 1
                    };
                    remaining--;
                    continue;
                }
            }
            //ぺちんｘ２ Lv.1~
            else if (targetSlot === 3 && item.id === 31) {//slotにitem.idがある場合
                if (slot) {//所持済みの場合
                    if (slot.id === 22) { slot.id = 23; slot.name = $dataWeapons[23].name; seichouCount++; remaining--; continue; }
                    else if (slot.id === 23) { slot.id = 24; slot.name = $dataWeapons[24].name; seichouCount++; remaining--; continue; }
                    else if (slot.id === 24) { slot.id = 25; slot.name = $dataWeapons[25].name; seichouCount++; remaining--; continue; }
                    else if (slot.id === 25) { slot.id = 26; slot.name = $dataWeapons[26].name; seichouCount++; remaining--; continue; }
                    else { break; }
                } else {//未所持の場合
                    hot[targetSlot] = {
                        id: 22, type,
                        iconIndex: $dataWeapons[22].iconIndex,
                        name: $dataWeapons[22].name,
                        count: 1
                    };
                    remaining--;
                    continue;
                }
            }
            //ぺちんｘ２ Lv.6~
            else if (targetSlot === 3 && item.id === 32) {//slotにitem.idがある場合
                if (slot) {//所持済みの場合
                    if (slot.id === 22 || slot.id === 23 || slot.id === 24 || slot.id === 25) {
                        slot.id = 26; slot.name = $dataWeapons[26].name; seichouCount++; remaining--; continue;
                    }
                    else if (slot.id === 26) { slot.id = 27; slot.name = $dataWeapons[27].name; seichouCount++; remaining--; continue; }
                    else if (slot.id === 27) { slot.id = 28; slot.name = $dataWeapons[28].name; seichouCount++; remaining--; continue; }
                    else if (slot.id === 28) { slot.id = 29; slot.name = $dataWeapons[29].name; seichouCount++; remaining--; continue; }
                    else if (slot.id === 29) { slot.id = 30; slot.name = $dataWeapons[30].name; seichouCount++; remaining--; continue; }
                    else { break; }
                } else {
                    hot[targetSlot] = {
                        id: 26, type,
                        iconIndex: $dataWeapons[26].iconIndex,
                        name: $dataWeapons[26].name,
                        count: 1
                    };
                    remaining--;
                    continue;
                }
            }
            //天使の輪
            else if (targetSlot === 4 && item.id === 50) {//slotにitem.idがある場合
                if (slot) {//所持済みの場合
                    if (slot.id === 50) { slot.id = 51; slot.name = $dataWeapons[51].name; seichouCount++; remaining--; continue; }
                    else if (slot.id === 51) { slot.id = 52; slot.name = $dataWeapons[52].name; seichouCount++; remaining--; continue; }
                    else if (slot.id === 52) { slot.id = 53; slot.name = $dataWeapons[53].name; seichouCount++; remaining--; continue; }
                    else if (slot.id === 53) { slot.id = 54; slot.name = $dataWeapons[54].name; seichouCount++; remaining--; continue; }
                    else if (slot.id === 54) { slot.id = 55; slot.name = $dataWeapons[55].name; seichouCount++; remaining--; continue; }
                    else if (slot.id === 55) { slot.id = 56; slot.name = $dataWeapons[56].name; seichouCount++; remaining--; continue; }
                    else if (slot.id === 56) { slot.id = 57; slot.name = $dataWeapons[57].name; seichouCount++; remaining--; continue; }
                    else if (slot.id === 57) { slot.id = 58; slot.name = $dataWeapons[58].name; seichouCount++; remaining--; continue; }
                    else { break; }
                } else {//未所持の場合
                    hot[targetSlot] = {
                        id: 50, type,
                        iconIndex: $dataWeapons[50].iconIndex,
                        name: $dataWeapons[50].name,
                        count: 1
                    };
                    remaining--;
                    continue;
                }
            }
            //スターファイア
            else if (targetSlot === 4 && item.id === 90) {
                const iid = item.id;
                if (slot) {
                    const offset = slot.id - iid;
                    if (offset >= 0 && offset < 4) {
                        const nextId = iid + offset + 1;
                        slot.id = nextId;
                        slot.name = $dataWeapons[nextId].name;
                        seichouCount++;
                        remaining--;
                        continue;
                    } else {
                        break;
                    }
                } else {
                    hot[targetSlot] = {
                        id: iid, type,
                        iconIndex: $dataWeapons[iid].iconIndex,
                        name: $dataWeapons[iid].name,
                        count: 1
                    };
                    remaining--;
                    continue;
                }
            }

            //イチワーリ
            else if (targetSlot === 6 && item.id === 38) {//slotにitem.idがある場合
                if (slot) {//所持済みの場合
                    if (slot.id === 38) { slot.id = 39; slot.name = $dataWeapons[39].name; seichouCount++; remaining--; continue; }
                    else if (slot.id === 39) { slot.id = 40; slot.name = $dataWeapons[40].name; seichouCount++; remaining--; continue; }
                    else if (slot.id === 40) { slot.id = 41; slot.name = $dataWeapons[41].name; seichouCount++; remaining--; continue; }
                    else if (slot.id === 41) { slot.id = 42; slot.name = $dataWeapons[42].name; seichouCount++; remaining--; continue; }
                    else { break; }
                } else {//未所持の場合
                    hot[targetSlot] = {
                        id: 38, type,
                        iconIndex: $dataWeapons[38].iconIndex,
                        name: $dataWeapons[38].name,
                        count: 1
                    };
                    remaining--;
                    continue;
                }
            }
            //投げナイフ
            else if (targetSlot === 6 && item.id === 43) {//slotにitem.idがある場合
                if (slot) {//所持済みの場合
                    if (slot.id === 43) { slot.id = 67; slot.name = $dataWeapons[67].name; seichouCount++; remaining--; continue; }
                    else if (slot.id === 67) { slot.id = 68; slot.name = $dataWeapons[68].name; seichouCount++; remaining--; continue; }
                    else if (slot.id === 68) { slot.id = 69; slot.name = $dataWeapons[69].name; seichouCount++; remaining--; continue; }
                    else if (slot.id === 69) { slot.id = 72; slot.name = $dataWeapons[72].name; seichouCount++; remaining--; continue; }
                    else { break; }
                } else {//未所持の場合
                    hot[targetSlot] = {
                        id: 43, type,
                        iconIndex: $dataWeapons[43].iconIndex,
                        name: $dataWeapons[43].name,
                        count: 1
                    };
                    remaining--;
                    continue;
                }
            }
            //紅葉
            else if (targetSlot === 6 && item.id === 73) {//slotにitem.idがある場合
                if (slot) {//所持済みの場合
                    if (slot.id === 73) { slot.id = 74; slot.name = $dataWeapons[74].name; seichouCount++; remaining--; continue; }
                    else if (slot.id === 74) { slot.id = 75; slot.name = $dataWeapons[75].name; seichouCount++; remaining--; continue; }
                    else if (slot.id === 75) { slot.id = 76; slot.name = $dataWeapons[76].name; seichouCount++; remaining--; continue; }
                    else if (slot.id === 76) { slot.id = 77; slot.name = $dataWeapons[77].name; seichouCount++; remaining--; continue; }
                    else { break; }
                } else {//未所持の場合
                    hot[targetSlot] = {
                        id: 73, type,
                        iconIndex: $dataWeapons[73].iconIndex,
                        name: $dataWeapons[73].name,
                        count: 1
                    };
                    remaining--;
                    continue;
                }
            }
            //【宝珠】ベルベラトス
            else if (targetSlot === 5 && item.id === 12) {//slotにitem.idがある場合
                if (slot) {//所持済みの場合
                    if (slot.id === 12) { slot.id = 59; slot.name = $dataWeapons[59].name; seichouCount++; remaining--; continue; }
                    else if (slot.id === 59) { slot.id = 60; slot.name = $dataWeapons[60].name; seichouCount++; remaining--; continue; }
                    else if (slot.id === 60) { slot.id = 61; slot.name = $dataWeapons[61].name; seichouCount++; remaining--; continue; }
                    else if (slot.id === 61) { slot.id = 62; slot.name = $dataWeapons[62].name; seichouCount++; remaining--; continue; }
                    else { break; }
                } else {//未所持の場合
                    hot[targetSlot] = {
                        id: 12, type,
                        iconIndex: $dataWeapons[12].iconIndex,
                        name: $dataWeapons[12].name,
                        count: 1
                    };
                    remaining--;
                    continue;
                }
            }
            //天使の羽
            else if (targetSlot === 5 && item.id === 33) {//slotにitem.idがある場合
                if (slot) {//所持済みの場合
                    if (slot.id === 33) { slot.id = 63; slot.name = $dataWeapons[63].name; seichouCount++; remaining--; continue; }
                    else if (slot.id === 63) { slot.id = 64; slot.name = $dataWeapons[64].name; seichouCount++; remaining--; continue; }
                    else if (slot.id === 64) { slot.id = 65; slot.name = $dataWeapons[65].name; seichouCount++; remaining--; continue; }
                    else if (slot.id === 65) { slot.id = 66; slot.name = $dataWeapons[66].name; seichouCount++; remaining--; continue; }
                    else { break; }
                } else {//未所持の場合
                    hot[targetSlot] = {
                        id: 33, type,
                        iconIndex: $dataWeapons[33].iconIndex,
                        name: $dataWeapons[33].name,
                        count: 1
                    };
                    remaining--;
                    continue;
                }
            }
            // 爪の進化Lv1~
            else if (targetSlot === 3 && item.id === 109) {
                const iid = 100;
                if (slot) {
                    const offset = slot.id - iid;
                    if (offset >= 0 && offset < 4) {
                        const nextId = iid + offset + 1;
                        slot.id = nextId;
                        slot.name = $dataWeapons[nextId].name;
                        seichouCount++;
                        remaining--;
                        continue;
                    } else {
                        break;
                    }
                } else {
                    hot[targetSlot] = {
                        id: iid, type,
                        iconIndex: $dataWeapons[iid].iconIndex,
                        name: $dataWeapons[iid].name,
                        count: 1
                    };
                    remaining--;
                    continue;
                }
            }
            // 爪の進化Lv6~
            else if (targetSlot === 3 && item.id === 110) {
                const iid = 104;
                if (slot) {
                    const offset = slot.id - iid;
                    if (offset >= 0 && offset < 4) {
                        const nextId = iid + offset + 1;
                        slot.id = nextId;
                        slot.name = $dataWeapons[nextId].name;
                        seichouCount++;
                        remaining--;
                        continue;
                    }
                    else if (offset < 0) {
                        hot[targetSlot] = {
                            id: iid, type,
                            iconIndex: $dataWeapons[iid].iconIndex,
                            name: $dataWeapons[iid].name,
                            count: 1
                        };
                        remaining--;
                        continue;
                    }
                    else {
                        break;
                    }
                } else {
                    hot[targetSlot] = {
                        id: iid, type,
                        iconIndex: $dataWeapons[iid].iconIndex,
                        name: $dataWeapons[iid].name,
                        count: 1
                    };
                    remaining--;
                    continue;
                }
            }
            // 指弾の進化Lv1~
            else if (targetSlot === 6 && item.id === 113) {
                const iid = item.id;
                if (slot) {
                    const offset = slot.id - iid;
                    if (offset >= 0 && offset < 4) {
                        const nextId = iid + offset + 1;
                        slot.id = nextId;
                        slot.name = $dataWeapons[nextId].name;
                        seichouCount++;
                        remaining--;
                        continue;
                    } else {
                        break;
                    }
                } else {
                    hot[targetSlot] = {
                        id: iid, type,
                        iconIndex: $dataWeapons[iid].iconIndex,
                        name: $dataWeapons[iid].name,
                        count: 1
                    };
                    remaining--;
                    continue;
                }
            }
            // 通常アイテム追加
            else {
                if (slot && slot.id === item.id && slot.type === type) {
                    const space = maxStack - slot.count;
                    if (space > 0) {
                        const add = Math.min(space, remaining);
                        slot.count += add;
                        remaining -= add;
                    } else {
                        break;
                    }
                } else {
                    hot[targetSlot] = {
                        id: item.id, type,
                        iconIndex: item.iconIndex,
                        name: item.name,
                        count: 1
                    };
                    remaining -= 1;
                }
                continue;
            }
        }
        //console.log("$gameSystem._customHotbarItems", $gameSystem._customHotbarItems);
        const used = amount - remaining;

        if (seichouCount > 0) {
            const slot = hot[targetSlot];
            const displayName = slot ? slot.name : "???";
            window.RSTH_IH.LogWindowManager.addLog(`${displayName}が進化した！`);
        }

        if (used > 0 && seichouCount === 0) {
            const displayName = item.name || "???";
            window.RSTH_IH.LogWindowManager.addLog(`${displayName}を${used}個入手した！`);
        }

        if (remaining > 0) {
            const refund = Math.floor((item.price || 0) / 5);
            if (refund > 0) {
                const totalRefund = refund * remaining;
                $gameParty.gainGold(totalRefund);
                const displayName = item.name || "???";
                window.RSTH_IH.LogWindowManager.addLog(`所持限界数を超えた為、${displayName}を${remaining}個売却！`);
            }
            // ⚡ 拾ったドロップアイテムを減らすために「全て売却済み扱い」にする
            remaining = 0;
        }

        // UI更新
        if (SceneManager._scene?.updateInventoryAndHotbar) {
            SceneManager._scene.updateInventoryAndHotbar();
        }
        const invWindow = SceneManager._scene?._inventoryWindow;
        const hotWindow = SceneManager._scene?._hotbarWindow;
        if (invWindow) {
            invWindow.setItems($gameSystem._customInventoryItems);
            invWindow.refresh();
        }
        if (hotWindow) {
            hotWindow.setItems($gameSystem._customHotbarItems);
            hotWindow.refresh();
        }

        return remaining; // ← 0になっていれば拾ったドロップから個数を差し引ける
    };

    // 外部からアイテム入手時、ホットバーへ格納
    window.RSTH_IH.gainItemToHotbarThenInventory = function (item, amount = 1) {
        if (SceneManager._scene instanceof window.RSTH_IH.Scene_Shop) {
            if (window.RSTH_IH.isInventoryOrHotbarFull()) {
                //console.warn("[ショップ] インベントリとホットバーが満杯なので購入できません");
                return 0;
            }
        }

        let remaining = window.RSTH_IH._gainItemToHotbarCore(item, amount);

        const used = amount - remaining;

        return used;
    };




    // 装備解除で使う安全なインベントリ格納関数（インスタンスを追加せず count+1）
    window.RSTH_IH.insertOrStackToInventory = function (item) {
        if (!item) return false;

        const inv = $gameSystem._customInventoryItems || [];
        const type = window.RSTH_IH.getItemType(item);
        const maxSlots = window.RSTH_IH.InventoryCols * window.RSTH_IH.InventoryRows;
        let maxStack = ["weapon", "armor", "tool"].includes(type) ? 1 : window.RSTH_IH.StackSize;

        //console.log("item", item);

        if (RSTH_DEBUG_LOG) console.log("[insertOrStackToInventory] インベントリへの追加処理開始。", item.name);
        //if (RSTH_DEBUG_LOG) console.log("[insertOrStackToInventory] 現在のインベントリ:", JSON.stringify(inv));


        // ① スタック可能なスロットを探して加算（cloneして上書き）
        for (let i = 0; i < maxSlots; i++) {
            const slot = inv[i];
            if (slot && slot.id === item.id && slot.type === type && slot.count < maxStack) {
                if (RSTH_DEBUG_LOG) console.log(`[insertOrStackToInventory][CHECK] slot.id=${slot.id}, item.id=${item.id}, slot.count=${slot.count}, window.RSTH_IH.StackSize=${maxStack}`);

                const newSlot = { ...slot, count: slot.count + 1 };
                inv[i] = newSlot;

                $gameSystem._customInventoryItems = inv;
                if (RSTH_DEBUG_LOG) console.log(`[insertOrStackToInventory] スロット${i}にスタック +1:`, newSlot);
                if (SceneManager._scene?._inventoryWindow) {
                    SceneManager._scene._inventoryWindow.setItems(inv);
                    SceneManager._scene._inventoryWindow.refresh();
                }
                return true;
            }
        }

        // ② 空きスロットに新規追加
        for (let i = 0; i < maxSlots; i++) {
            if (!inv[i]) {
                if (RSTH_DEBUG_LOG) console.log(`[insertOrStackToInventory][新規追加] スロット${i}が空いています`);
                inv[i] = {
                    id: item.id,
                    name: item.name,
                    iconIndex: item.iconIndex,
                    tileset: "IconSet",
                    tileIndex: [item.iconIndex],
                    type,
                    tileId: Number(item.meta?.tileId || 0),
                    blockName: String(item.meta?.blockName || ""),
                    count: 1
                };
                if (RSTH_DEBUG_LOG) console.log(`[insertOrStackToInventory] スロット${i}に新規追加:`, inv[i]);

                $gameSystem._customInventoryItems = inv;

                if (SceneManager._scene?._inventoryWindow) {
                    SceneManager._scene._inventoryWindow.setItems(inv);
                    SceneManager._scene._inventoryWindow.refresh();
                }
                return true;
            } else {
                //if (RSTH_DEBUG_LOG) console.log(`[insertOrStackToInventory][使用不可] スロット${i} → id=${inv[i].id}, name=${inv[i].name}, count=${inv[i].count}`);
            }
        }
        // ③ どこにも格納できなかった
        if (RSTH_DEBUG_LOG) console.warn("[insertOrStackToInventory] インベントリに追加できませんでした:", item.name);
        if (RSTH_DEBUG_LOG) console.warn("[insertOrStackToInventory] 全スロット数:", maxSlots, "使用中:", inv.filter(e => e != null).length);
        if (RSTH_DEBUG_LOG) console.log(`[insertOrStackToInventory] InventorySlots=${window.RSTH_IH.InventoryCols * window.RSTH_IH.InventoryRows}, window.RSTH_IH.StackSize=${window.RSTH_IH.StackSize}`);

        return false;
    };

    // 指定したアイテムをインベントリまたはホットバーから1個削除
    window.RSTH_IH.removeItemFromInventoryOrHotbar = function (item, amount = 1) {
        if (!item || amount <= 0) return;

        const type = window.RSTH_IH.getItemType(item);
        const inv = $gameSystem._customInventoryItems || [];
        const hot = $gameSystem._customHotbarItems || [];

        let remaining = amount;

        // インベントリから削除
        for (let i = 0; i < inv.length && remaining > 0; i++) {
            const slot = inv[i];
            if (slot && slot.id === item.id && slot.type === type) {
                const toRemove = Math.min(slot.count, remaining);
                slot.count -= toRemove;
                remaining -= toRemove;
                if (slot.count <= 0) inv[i] = null;
            }
        }

        // ホットバーから削除
        for (let i = 0; i < hot.length && remaining > 0; i++) {
            const slot = hot[i];
            if (slot && slot.id === item.id && slot.type === type) {
                const toRemove = Math.min(slot.count, remaining);
                slot.count -= toRemove;
                remaining -= toRemove;
                if (slot.count <= 0) hot[i] = null;
            }
        }

        $gameSystem._customInventoryItems = inv;
        $gameSystem._customHotbarItems = hot;

        if (SceneManager._scene?.updateInventoryAndHotbar) {
            SceneManager._scene.updateInventoryAndHotbar();
        }

        return amount - remaining; // 実際に削除できた数
    };

    // インベントリのアイテムを外部から削除する場合
    window.RSTH_IH.loseItemFromInventory = function (item, amount = 1) {
        if (!item || amount <= 0) return false;

        const inv = $gameSystem._customInventoryItems || [];
        const type = (() => {
            if (DataManager.isItem(item)) return "item";
            if (DataManager.isWeapon(item)) return "weapon";
            if (DataManager.isArmor(item)) return "armor";
            return "unknown";
        })();

        let remaining = amount;

        for (let i = 0; i < inv.length; i++) {
            const slot = inv[i];
            if (slot && slot.id === item.id && slot.type === type) {
                const toRemove = Math.min(slot.count, remaining);
                slot.count -= toRemove;
                remaining -= toRemove;

                if (slot.count <= 0) {
                    inv.splice(i, 1);
                    i--; // 削除したので index 調整
                    inv[i] = null;
                }

                if (remaining <= 0) break;
            }
        }

        // 書き戻し
        $gameSystem._customInventoryItems = inv;

        if (SceneManager._scene?.updateInventoryAndHotbar) {
            SceneManager._scene.updateInventoryAndHotbar();
        }

        if (remaining > 0) {
            if (RSTH_DEBUG_LOG) console.warn("[loseItemFromInventory]インベントリに十分な個数がないため一部しか消費できなかった:", item.name, "x", amount - remaining);
        }

        return true;
    }

    // 一度だけ元の gainItem を保存する
    if (!Game_Party.prototype.gainItem.__RSTH_Original) {
        Game_Party.prototype.gainItem.__RSTH_Original = Game_Party.prototype.gainItem;
    }
    const _Game_Party_gainItem = Game_Party.prototype.gainItem.__RSTH_Original;
    // 通常のgainitemの処理を呼ばれた場合はまずこの処理をする
    Game_Party.prototype.gainItem = function (item, amount, includeEquip = false) {
        if (!item || amount <= 0) return;

        //console.log("item", item);
        // オーバーライドする前のgainitem処理を呼び出す
        if (this._suppressRSTH) {
            return _Game_Party_gainItem.call(this, item, amount, includeEquip);
        }

        if (RSTH_DEBUG_LOG) console.log(`[gainItem] item.name ${item.name}`);
        const gameItem = (() => {
            if (DataManager.isItem(item)) return $dataItems[item.id];
            if (DataManager.isWeapon(item)) return $dataWeapons[item.id];
            if (DataManager.isArmor(item)) return $dataArmors[item.id];
            return null;
        })();

        if (!gameItem) return;
        //console.log("item", item);
        if (item.itypeId) {
            //console.log("amount", amount);
            const stupitem = window.RSTH_IH.StatusUPItems(item, amount);
            if (stupitem) return;
        }

        if (item.atypeId) {
            if (window.RSTH_IH.tryAutoEquipArmor(item, amount)) return;
        }
        //ここからの処理で通常のインベントリ、ホットバーにアイテム追加と$gamepartyのアイテム削除処理が完結
        //この処理でホットバーにアイテムが追加される

        if (RSTH_DEBUG_LOG) console.log(`[gainItem] ${gameItem.name} を ホットバーに ${amount}個追加`);
        window.RSTH_IH.gainItemToHotbarThenInventory(gameItem, amount);


        // 必ず vanilla 側の gainItem によって追加されているので、強制削除する
        this._suppressRSTH = true;
        _Game_Party_gainItem.call(this, gameItem, -amount, includeEquip);
        this._suppressRSTH = false;

        if (RSTH_DEBUG_LOG) console.warn(`[gainItem] ${gameItem.name} を $gameParty から ${amount}個強制削除`);
        //ここまで
    };

    window.RSTH_IH.isInventoryOrHotbarFull = function () {
        const inv = $gameSystem._customInventoryItems || [];
        const hot = $gameSystem._customHotbarItems || [];
        const invFull = inv.every(slot => slot !== null);
        const hotFull = hot.every(slot => slot !== null);
        return invFull && hotFull;
    };

    window.RSTH_IH.StatusUPItems = function (item, amount) {
        if (!item) return false;

        //console.log("amount", amount);
        const actor = $gameParty.leader();
        if (!actor) return false;

        const scene = SceneManager._scene;
        let hpup = Number(item.meta?.mhp || 0);
        let spup = Number(item.meta?.msp || 0);
        let strup = Number(item.meta?.str || 0);
        let vitup = Number(item.meta?.vit || 0);
        let intup = Number(item.meta?.int || 0);
        let dexup = Number(item.meta?.dex || 0);
        let agiup = Number(item.meta?.agi || 0);
        let lukup = Number(item.meta?.luk || 0);
        let stup = 0;

        for (let i = 0; i < amount; i++) {
            if (hpup > 0) {
                actor._paramPlus[0] += hpup;
                window.RSTH_IH.logStatusUP("最大HP", hpup);

                if (SceneManager._scene instanceof Scene_Map && SceneManager._scene._statusHUD) {
                    SceneManager._scene._statusHUD.refresh();
                }
                stup += 1;
            }
            if (spup > 0) {
                actor._paramPlus[1] += spup;
                window.RSTH_IH.logStatusUP("最大SP", spup);

                if (SceneManager._scene instanceof Scene_Map && SceneManager._scene._statusHUD) {
                    SceneManager._scene._statusHUD.refresh();
                }

                stup += 1;
            }
            if (strup > 0) {
                actor._paramPlus[2] += strup;
                window.RSTH_IH.logStatusUP("Str", strup);
                stup += 1;
            }
            if (vitup > 0) {
                actor._paramPlus[3] += vitup;
                actor._paramPlus[0] += vitup * 2;
                window.RSTH_IH.logStatusUP("Vit", vitup);
                window.RSTH_IH.logStatusUP("最大HP", hpup);
                stup += 1;
            }
            if (intup > 0) {
                actor._paramPlus[4] += intup;
                window.RSTH_IH.logStatusUP("Int", intup);
                stup += 1;
            }
            if (dexup > 0) {
                actor._paramPlus[5] += dexup;
                window.RSTH_IH.logStatusUP("Dex", dexup);
                stup += 1;
            }
            if (agiup > 0) {
                actor._paramPlus[6] += agiup;
                window.RSTH_IH.logStatusUP("Agi", agiup);
                stup += 1;
            }
            if (lukup > 0) {
                actor._paramPlus[7] += lukup;
                window.RSTH_IH.logStatusUP("Luk", lukup);
                stup += 1;
            }
        }

        if (stup > 0) {
            return true;
        } else {
            return false;

        }
    }




})();