/*:
 * @target MZ
 * @plugindesc RSTH_IH: サバイバルゲームシステムプラグイン
 * @author © 2025 ReSera_りせら（@MOBIUS1001）
 *
 * このソースコードは無断での転載、複製、改変、再配布、商用利用を固く禁じます。
 * 禁止事項の例：
 * - 本ファイルの全部または一部を許可なくコピー、再配布すること
 * - 本ファイルを改変して配布すること
 * - 商用目的での利用
 */

(() => {
    "use strict";

    // ログ出力制御フラグ（trueでログ出力、falseで抑制）
    //const RSTH_DEBUG_LOG = true;
    const RSTH_DEBUG_LOG = false;

    // ホットバーで現在選択されているツールを取得
    window.RSTH_IH.getCurrentTool = function () {
        const scene = SceneManager._scene;
        const hotbar = scene && scene._hotbarWindow;
        if (!window.RSTH_IH.HobarSlotsIndex) window.RSTH_IH.HobarSlotsIndex = 0;

        if (RSTH_DEBUG_LOG) console.warn("[getCurrentTool]window.RSTH_IH.HobarSlotsIndex", window.RSTH_IH.HobarSlotsIndex);

        const index = window.RSTH_IH.HobarSlotsIndex;
        const itemsid = hotbar.items[index].id;
        const items = $dataWeapons[itemsid] // この処理を呼び出すときはツールであることが確定しているため
        if (RSTH_DEBUG_LOG) console.warn("[getCurrentTool]items", items);

        return items;

    }

    // チェストの位置を設定
    window.RSTH_IH.calculateChestPosition = function (hotbarX, hotbarY, chestWidth, chestHeight) {
        const gw = Graphics.boxWidth;
        const gh = Graphics.boxHeight;

        const below = window.RSTH_IH.HotbarPosition.startsWith("top");

        const invX = hotbarX + (window.RSTH_IH.Hotbarwidth - window.RSTH_IH.Inventorywidth) / 2;
        const invY = below
            ? hotbarY + window.RSTH_IH.Hotbarheight
            : hotbarY - window.RSTH_IH.Inventoryheight;

        const chestX = hotbarX + (window.RSTH_IH.Hotbarwidth - chestWidth) / 2;

        const chestY = below
            ? invY + window.RSTH_IH.Inventoryheight + 20   // インベントリの下 + 余白
            : invY - chestHeight - 20;                     // インベントリの上 - 余白

        return {
            x: Math.max(0, Math.min(chestX, gw - chestWidth)),
            y: Math.max(0, Math.min(chestY, gh - chestHeight))
        };
    };

    // 作業台ウィンドウの位置を計算
    window.RSTH_IH.calculateWorkbenchPosition = function (hotbarX, hotbarY) {
        const scene = SceneManager._scene;
        const gw = Graphics.boxWidth;
        const gh = Graphics.boxHeight;

        const below = window.RSTH_IH.HotbarPosition.startsWith("top"); // 上にあるホットバーなら下に表示
        const invX = hotbarX + (window.RSTH_IH.Hotbarwidth - window.RSTH_IH.Inventorywidth) / 2;
        const invY = below
            ? hotbarY + window.RSTH_IH.Hotbarheight + 10
            : hotbarY - window.RSTH_IH.Inventoryheight - 10;

        const wbX = hotbarX + (window.RSTH_IH.Hotbarwidth - window.RSTH_IH.Inventorywidth) / 2;
        const wbY = below
            ? invY + window.RSTH_IH.Inventoryheight + 10 + 32  // インベントリの下 + 余白
            : invY - window.RSTH_IH.Inventoryheight - 10 - 32;                     // インベントリの上 - 余白

        return {
            x: Math.max(0, Math.min(wbX, gw - window.RSTH_IH.Inventorywidth)),
            y: Math.max(0, Math.min(wbY, gh - wbY))
        };
    };


    // ウィンドウ内のD&D共通処理
    window.RSTH_IH.handleDragDropfromto = function (item, from, target, fromIndex) {
        if (RSTH_DEBUG_LOG) console.log(`[handleDragDropfromto]start`);
        //console.log("item", item);
        //console.log("from", from);
        //console.log("target", target);
        const scene = SceneManager._scene;
        const hotbar = scene._hotbarWindow;
        const inv = scene._inventoryWindow;
        const chest = scene._chestWindow;
        inv.name = "inv";
        hotbar.name = "hotbar";
        chest.name = "chest";

        const invX = inv.canvasToLocalX(TouchInput.x);
        const invY = inv.canvasToLocalY(TouchInput.y);
        const invIndex = inv.hitTest(invX, invY);

        const hotbarX = hotbar.canvasToLocalX(TouchInput.x);
        const hotbarY = hotbar.canvasToLocalY(TouchInput.y);
        const hotbarIndex = hotbar.hitTest(hotbarX, hotbarY);

        const chestX = chest.canvasToLocalX(TouchInput.x);
        const chestY = chest.canvasToLocalY(TouchInput.y);
        const chestIndex = chest.hitTest(chestX, chestY);

        const shift = Input.isPressed("shift");
        const amount = shift ? (item.count || 1) : 1;

        const nonStackableTypes = ["weapon", "armor", "tool"];
        let moved = 0;
        let fromwindow = null;
        let targetwindow = null;

        if (from === "inventory") fromwindow = inv;
        if (from === "hotbar") fromwindow = hotbar;
        if (from === "chest") fromwindow = chest;

        if (target === "inventory") targetwindow = inv;
        if (target === "hotbar") targetwindow = hotbar;
        if (target === "chest") targetwindow = chest;

        const targetindexMap = {
            inv: invIndex,
            hotbar: hotbarIndex,
            chest: chestIndex
        };

        const fromSlot = fromwindow.items[fromIndex];
        const targetIndex = targetindexMap[targetwindow.name];
        const targetSlot = targetwindow.items[targetIndex];

        if (targetSlot &&
            targetSlot.id === item.id &&
            targetSlot.type === item.type &&
            targetSlot.count < window.RSTH_IH.StackSize &&
            !nonStackableTypes.includes(targetSlot.type)
        ) {
            const space = window.RSTH_IH.StackSize - targetSlot.count;
            const toAdd = Math.min(space, amount);
            targetSlot.count += toAdd;
            moved = toAdd;

            if (fromSlot.count > moved) {
                fromSlot.count -= moved;
            } else {
                fromwindow.items[fromIndex] = null;
            }

        } else if (!targetSlot) {
            const toAdd = Math.min(window.RSTH_IH.StackSize, amount);
            const newItem = Object.assign({}, item);
            newItem.count = toAdd;
            targetwindow.items[targetIndex] = newItem;
            moved = toAdd;
            if (!fromSlot) {
                fromwindow.items[fromIndex] = null;
            } else if (fromSlot.count > moved) {
                fromSlot.count -= moved;
            } else {
                fromwindow.items[fromIndex] = null;
            }

        } else {
            const tmp = targetwindow.items[targetIndex];
            targetwindow.items[targetIndex] = fromwindow.items[fromIndex];
            fromwindow.items[fromIndex] = tmp;
        }

        // 現在開いているチェストの位置を取得
        const chestPos = scene._openedChestPos;

        $gameSystem._customInventoryItems = inv.items;
        $gameSystem._customHotbarItems = hotbar.items;

        if (chestPos) {
            const chestObj = window.RSTH_IH.ChestManager.getChestAt(chestPos.x, chestPos.y);
            if (chestObj) {
                chestObj.items = chest.items.map(item => item ? JSON.parse(JSON.stringify(item)) : null);
            }
        }

        inv.refresh();
        hotbar.refresh();
        chest.refresh();
        if (RSTH_DEBUG_LOG) console.log(`[handleDragDropfromto]window.RSTH_IH.ChestManager._chests`, window.RSTH_IH.ChestManager._chests);
        if (RSTH_DEBUG_LOG) console.log(`[handleDragDropfromto]end`);
        return window.RSTH_IH.resetDragging();
    }

    // 作業台ウィンドウ用のグリッド描画処理
    window.RSTH_IH.drawItemSlotGridCrafting = function (win, items, cols, rows, tileSize, margin, selectedIndex, offsetY = 0) {
        const contents = win.contents;
        contents.clearRect(0, offsetY, contents.width, contents.height - offsetY);

        const max = cols * rows;
        if (!Array.isArray(items)) return;

        for (let i = 0; i < max; i++) {
            const item = items[i];
            const col = i % cols;
            const row = Math.floor(i / cols);

            const rect = new Rectangle(
                ((contents.width - (cols * tileSize + (cols - 1) * margin)) / 2) + col * (tileSize + margin),
                offsetY + row * (tileSize + margin),
                tileSize,
                tileSize
            );

            contents.paintOpacity = 128;
            contents.fillRect(rect.x, rect.y, rect.width, rect.height, "#8888ff");
            contents.paintOpacity = 255;

            if (item) {
                if (RSTH_DEBUG_LOG) console.warn("[drawItemSlotGridCrafting]item", item);
                const iconIndex = item.iconIndex || 0;
                const name = item.name || "???";

                const isCraftable = window.RSTH_IH.canCraft(item._recipe, $gameSystem._customInventoryItems, $gameSystem._customHotbarItems);
                win.changePaintOpacity(isCraftable);

                const pw = 32, ph = 32;
                const sx = (iconIndex % 16) * pw;
                const sy = Math.floor(iconIndex / 16) * ph;
                const bitmap = ImageManager.loadSystem("IconSet");

                contents.blt(bitmap, sx, sy, pw, ph, rect.x, rect.y, rect.width, rect.height);

                contents.fontSize = 16;
                contents.textColor = "#ffffff";
                contents.outlineColor = "#000000";
                contents.outlineWidth = 3;
                contents.drawText(name, rect.x + 38, rect.y + 4, rect.width - 38, tileSize - 8, "left");

                win.changePaintOpacity(true);
            }

            if (i === selectedIndex) {
                contents.strokeRect(rect.x, rect.y, rect.width, rect.height, "#ffffff", 5);
            }
        }
    };

    // ウィンドウを閉じる共通処理
    window.RSTH_IH.hideWindows = function () {
        const scene = SceneManager._scene;

        scene._inventoryWindow.hide();
        scene._inventoryWindow.deactivate();

        scene._chestWindow.hide();
        scene._chestWindow.deactivate();

        scene._workbenchWindow.hide();
        scene._workbenchWindow.deactivate();

        scene._equipmentWindow.hide();
        scene._equipmentWindow.deactivate();

        //カーソルをホットバーのインデックスへ
        if (scene._hotbarWindow && window.RSTH_IH.HobarSlotsIndex != null) {
            if (window.RSTH_IH.HobarSlotsIndex === -1) window.RSTH_IH.HobarSlotsIndex = 0;
            scene.updateCursorForSlot(window.RSTH_IH.HobarSlotsIndex, scene._hotbarWindow);
        }


        if (window.RSTH_IH.__popupOwner === scene._inventoryWindow) {
            const popup = scene._hoverTextSprite;
            if (popup) {
                popup.setText("");
            }
            window.RSTH_IH.__popupOwner = null;
        }

    };

    /*
    // 自動でオートタイル用shape画像を生成する処理
    // ゲーム配布時には不要。
    window.RSTH_IH.autotileGen = function (object) {
        const fs = require('fs');
        const path = require('path');

        for (const item of object) {
            if (!item || !item.meta) continue;
            if (item.meta.autoTile !== "true") continue;

            const tileType = (Number(item.meta.tileType) === 1) ? "wall" : "floor";
            const tileset = item.meta.tileset ?? "Outside_A2";
            const tileId = Number(item.meta.tileId ?? 1);
            const floorCache = window.RSTH_IH.FloorAutotileBitmaskToShape;
            const wallCache = window.RSTH_IH.WallAutotileBitmaskToShape;

            const cache = (tileType === "floor") ? floorCache : wallCache;
            const autotileTable = (tileType === "floor") ? Tilemap.FLOOR_AUTOTILE_TABLE : Tilemap.WALL_AUTOTILE_TABLE;
            const shapeMax = autotileTable.length;

            const tileCols = 16;
            const tileWidth = 48;
            const tileHeight = 48;
            const halfWidth = tileWidth / 2;
            const halfHeight = tileHeight / 2;

            const baseTileId = tileId - 1;
            const tx = baseTileId % tileCols;
            const ty = Math.floor(baseTileId / tileCols);
            const autotileCol = Math.floor(tx / 2) * 2;
            const autotileRow = ty;

            const srcPath = `img/tilesets/${tileset}`;
            const bitmap = ImageManager.loadBitmap('', srcPath);

            bitmap.addLoadListener(() => {
                const atlasCols = 16;
                const atlasRows = Math.ceil(shapeMax / atlasCols);
                const atlasBitmap = new Bitmap(tileWidth * atlasCols, tileHeight * atlasRows);

                const entries = Array.from(cache.entries());

                for (const [bitmask, shape] of entries) {
                    if (shape >= shapeMax) continue;
                    const table = autotileTable[shape];
                    const sxOffset = autotileCol * tileWidth;
                    const syOffset = autotileRow * tileHeight;

                    const partBitmap = new Bitmap(tileWidth, tileHeight);

                    for (let i = 0; i < 4; i++) {
                        const [qsx, qsy] = table[i];
                        const sx = sxOffset + qsx * halfWidth;
                        const sy = syOffset + qsy * halfHeight;
                        const dx = (i % 2) * halfWidth;
                        const dy = Math.floor(i / 2) * halfHeight;
                        partBitmap.blt(bitmap, sx, sy, halfWidth, halfHeight, dx, dy);
                    }

                    const cx = (shape % atlasCols) * tileWidth;
                    const cy = Math.floor(shape / atlasCols) * tileHeight;
                    atlasBitmap.blt(partBitmap, 0, 0, tileWidth, tileHeight, cx, cy);
                }
                const dataUrl = atlasBitmap._canvas.toDataURL('image/png');
                const base64Data = dataUrl.replace(/^data:image\/png;base64,/, '');
                const buffer = Buffer.from(base64Data, 'base64');

                const outDir = path.join(process.cwd(), 'img', 'tilesets');
                if (!fs.existsSync(outDir)) fs.mkdirSync(outDir, { recursive: true });

                const fileName = `${tileType}_tileId${tileId}_${tileset}.png`;
                const outPath = path.join(outDir, fileName);
                fs.writeFileSync(outPath, buffer);
                if (RSTH_DEBUG_LOG) console.log(`保存完了: ${outPath}`);
            });
        }
    };
    */

    window.RSTH_IH.doorRotation = function () {
        //console.log(`[doorRotation]start`);
        if (!(SceneManager._scene instanceof Scene_Map)) return;
        if ($gameMessage.isBusy()) return;


        const scene = SceneManager._scene;
        const hotbar = scene && scene._hotbarWindow;
        // ホットバー座標からindexを取得
        if (!window.RSTH_IH.HobarSlotsIndex) window.RSTH_IH.HobarSlotsIndex = 0;
        const index = window.RSTH_IH.HobarSlotsIndex;
        const hotbaritem = hotbar.items[index];
        if (!hotbaritem) return;

        let item = $dataItems[hotbaritem.id];

        if (window.RSTH_IH.DirectedDoor > 0) {
            item = $dataItems[window.RSTH_IH.DirectedDoor];
        }

        if (!item || !item.meta) return;
        const meta = item.meta;

        if (meta.blockType === 'door') {
            // アイテムの blockName と blockType を取得
            const targetBlockName = meta.blockName;
            const targetBlockType = meta.blockType;
            if (meta.doorDirection === 'front') {
                // データベースから条件に一致するアイテムを検索
                for (const dbItem of $dataItems) {
                    if (!dbItem || !dbItem.meta) continue;
                    const m = dbItem.meta;

                    if (
                        m.blockName === targetBlockName &&
                        m.blockType === targetBlockType &&
                        m.doorDirection === 'side' &&
                        Number(m.doorOpen ?? 0) === 0
                    ) {
                        window.RSTH_IH.DirectedDoor = dbItem.id;
                        //console.log(`対象アイテムID(side): ${dbItem.id} をDirectedDoorに格納`);
                        break;
                    }
                }
            } else if (meta.doorDirection === 'side') {
                // データベースから条件に一致するアイテムを検索
                for (const dbItem of $dataItems) {
                    if (!dbItem || !dbItem.meta) continue;
                    const m = dbItem.meta;

                    if (
                        m.blockName === targetBlockName &&
                        m.blockType === targetBlockType &&
                        m.doorDirection === 'front' &&
                        Number(m.doorOpen ?? 0) === 0
                    ) {
                        window.RSTH_IH.DirectedDoor = dbItem.id;
                        //console.log(`対象アイテムID(front): ${dbItem.id} をDirectedDoorに格納`);
                        break;
                    }
                }
            }
        }


    };

    // ■ ElapsedTimeSprite クラス
    window.RSTH_IH.ElapsedTimeSprite = class extends Sprite {
        constructor(intro) {
            const gh = Graphics.boxHeight;
            super(new Bitmap(600, gh));
            this._baseX = Graphics.width / 2 - 300;
            this._baseY = 32;
            this.x = this._baseX;
            this.y = this._baseY;
            this.bitmap.fontSize = 32;

            // 拡大演出するか
            this._introDuration = 90;
            this._introFrame = 0;
            this._introPlaying = intro;
            this._baseScale = 1;

            if (this._introPlaying) {
                window.RSTH_IH.setElapsedTimeEnabled(false);
                if (RSTH_DEBUG_LOG) console.log("[ElapsedTimeSprite] 拡大演出開始 → タイマー停止");
            } else {
                window.RSTH_IH.setElapsedTimeEnabled(true);
            }
        }

        update() {
            super.update();

            const leader = $gameParty.leader();

            if (this._introPlaying) {
                this._introFrame++;
                const progress = this._introFrame / this._introDuration;

                // スケールは0.1から1.0へ補間
                const scale = 0.3 + 0.6 * progress;
                this.scale.set(scale, scale);

                // 中央座標（中央揃え）
                const centerX = Graphics.width / 2 - (this.bitmap.width * scale) / 2;
                const centerY = Graphics.height / 2 - (this.bitmap.height * scale) / 2;

                // 定位置座標（左上揃え）
                const targetX = this._baseX;
                const targetY = this._baseY;

                // X,Yも中央から定位置へ移動（線形補間）
                this.x = centerX + (targetX - centerX) * progress;
                this.y = centerY + (targetY - centerY) * progress;

                if (progress >= 1) {
                    this._introPlaying = false;
                    this.scale.set(this._baseScale, this._baseScale);
                    this.x = this._baseX;
                    this.y = this._baseY;

                    window.RSTH_IH.setElapsedTimeEnabled(true);
                    if (RSTH_DEBUG_LOG) console.log("[ElapsedTimeSprite] 拡大演出終了 → タイマー開始");
                }
            }

            const totalSeconds = window.RSTH_IH.TimeCount || 0;
            const minutes = Math.floor(totalSeconds / 60);
            const remainSec = totalSeconds % 60;
            const text = `経過時間: ${minutes}分${remainSec.toString().padStart(2, '0')}秒`;

            const gw = Graphics.boxWidth;
            const gh = Graphics.boxHeight;
            const bw = this.bitmap.width;

            this.bitmap.clear();

            const mainFontSize = 32;
            this.bitmap.fontSize = mainFontSize;

            const barWidth = 400;
            const barHeight = 30;
            const barX = (bw - barWidth) / 2;
            const barY = mainFontSize + 12;

            const goalTime = window.RSTH_IH._progressGoalTime || 60;
            const barProgress = Math.min(1, totalSeconds / goalTime);
            const fillWidth = Math.floor(barWidth * barProgress);
            const remainingTime = Math.max(0, goalTime - totalSeconds);

            // 黒縁
            this.bitmap.textColor = "#000000";
            for (let dx = -1; dx <= 1; dx++) {
                for (let dy = -1; dy <= 1; dy++) {
                    if (dx === 0 && dy === 0) continue;
                    this.bitmap.drawText(text, dx, dy, bw, mainFontSize + 8, 'center');
                }
            }

            // 白文字
            this.bitmap.textColor = "#ffffff";
            this.bitmap.drawText(text, 0, 0, bw, mainFontSize + 8, 'center');

            // 変数: ピッチ変更済みフラグ
            this._pitchChanged = this._pitchChanged || false;

            if (window.RSTH_IH._timerNum === 0) {

                // 120秒以下になったらBGMピッチを120%に変更（1回だけ）
                if (!this._pitchChanged && remainingTime <= 120) {
                    if (AudioManager._currentBgm) {
                        const bgm = JsonEx.makeDeepCopy(AudioManager._currentBgm);
                        bgm.pitch = 115;
                        AudioManager.playBgm(bgm);
                        this._pitchChanged = true;
                        if (RSTH_DEBUG_LOG) console.log("[Timer] BGMピッチを120%に変更");
                    }
                }

                // 進捗バー
                this.bitmap.fillRect(barX, barY, barWidth, barHeight, "#000000ff");

                if (fillWidth > 0) {
                    this.bitmap.fillRect(barX, barY, fillWidth, barHeight, "#7700ffff");
                }

                // ▼ Timerゲージの目盛り線（10%ごと、50%は長く）← 下辺に沿わせる
                for (let i = 1; i < 10; i++) {
                    const memX = barX + Math.floor(barWidth * i / 10);
                    const isMid = (i === 5);
                    const memLength = isMid ? barHeight : Math.floor(barHeight / 2);
                    const memY = barY + barHeight - memLength; // ← 下辺揃え
                    this.bitmap.fillRect(memX, memY, 2, memLength, "#ffffffff");
                }

                // ラベル
                this.bitmap.fontSize = 18;
                this.bitmap.textColor = "#ffffff";
                this.bitmap.drawText("start", barX - 16, barY + 24, 32, barHeight, 'left');
                this.bitmap.drawText("goal", barX + barWidth - 16, barY + 24, 32, barHeight, 'left');

            }
            else if (window.RSTH_IH._timerNum === 1) {
                let mob = window.RSTH_IH._bossMob || null;

                if (mob) {
                    if (mob._hp <= 0) {
                        mob._hp = 0;
                        mob = null;
                        window.RSTH_IH._bossMob = null;

                        leader.clearStates();
                        window.RSTH_IH._mobManager.clearAllMobs();
                        SceneManager.push(window.RSTH_IH.Scene_BeforeResultDestroyed);
                    }
                }
                else if (!mob) {
                    if (window.RSTH_IH._mobManager._mobs) {
                        const mobs = window.RSTH_IH._mobManager._mobs;
                        const mobArray = Object.values(mobs);
                        mob = mobArray.filter(e => e._databaseData.id === 63);
                        window.RSTH_IH._bossMob = mob[0];
                        //console.log("mob[0]", mob[0]);
                    }
                }

                //console.log("window.RSTH_IH._bossMob", window.RSTH_IH._bossMob);
                // ▼ 右から左へ減少するタイマーゲージ
                const barX2 = barX;
                const barY2 = gh - 100;
                const reverseProgress = 1 - Math.min(1, remainingTime / goalTime);
                const reverseFill = Math.floor(barWidth * reverseProgress);

                this.bitmap.fillRect(barX2, barY2, barWidth, barHeight, "#ff9900ff"); // 背景
                if (reverseFill > 0) {
                    const reversedX = barX2 + barWidth - reverseFill;
                    this.bitmap.fillRect(reversedX, barY2, reverseFill, barHeight, "#000000"); // シアン色
                }

                // ▼ Timerゲージの目盛り線（10%ごと、50%は長く）← 下辺に沿わせる
                for (let i = 1; i < 10; i++) {
                    const memX = barX2 + Math.floor(barWidth * i / 10);
                    const isMid = (i === 5);
                    const memLength = isMid ? barHeight : Math.floor(barHeight / 2);
                    const memY = barY2 + barHeight - memLength; // ← 下辺揃え
                    this.bitmap.fillRect(memX, memY, 2, memLength, "#000000ff");
                }





                this.bitmap.fontSize = 18;
                this.bitmap.textColor = "#ffffff";
                this.bitmap.drawText("Timer", barX2 + barWidth + 8, barY2 - 2, 100, barHeight, 'left');

                // ▼ Mob HPバー
                let mobMaxHp = 0;
                let mobHp = 0;
                let mobHpRate = 0;
                if (mob) {
                    const mMHp = mob._maxhp;
                    mobMaxHp = mob._maxhp;
                    mobHp = mob._hp;
                    mobHpRate = mobHp / mobMaxHp;
                    //console.log("mobHpRate", mobHpRate);

                    // 120秒以下もしくはmobのhpが20%になったらBGMピッチを120%に変更（1回だけ）
                    if (!this._pitchChanged && remainingTime <= 120) {
                        if (AudioManager._currentBgm) {
                            const bgm = JsonEx.makeDeepCopy(AudioManager._currentBgm);
                            bgm.pitch = 115;
                            AudioManager.playBgm(bgm);
                            this._pitchChanged = true;
                            if (RSTH_DEBUG_LOG) console.log("[Timer] BGMピッチを120%に変更");
                        }
                    }
                    if (mobHpRate <= 0.2 && mob._databaseData.id === 63) {
                        if (AudioManager._currentBgm) {
                            if (!this._pitchChanged) {
                                const bgm = JsonEx.makeDeepCopy(AudioManager._currentBgm);
                                bgm.pitch = 115;
                                AudioManager.playBgm(bgm);
                                this._pitchChanged = true;
                                if (RSTH_DEBUG_LOG) console.log("[Timer] BGMピッチを120%に変更");
                            }

                            // レイドボスだけ回復
                            if (mob._healed === false) {
                                $gameScreen.startShake(5, 5, 20);
                                $gameScreen.startFlash([255, 255, 255, 170], 10);
                                AudioManager.playSe({ name: "Devil2", pan: 0, pitch: 70, volume: 25 });
                                mob._hp = mMHp * 2; //HP100%回復
                                mob._healed = true;
                            }

                        }
                    }
                }


                const barY3 = barY2 - 40;

                this.bitmap.fillRect(barX2, barY3, barWidth, barHeight, "#000000"); // 背景
                const mobFill = Math.floor(barWidth * mobHpRate);
                if (mobFill > 0) {
                    this.bitmap.fillRect(barX2, barY3, mobFill, barHeight, "#51ff00ff"); // 緑ゲージ
                }

                // ▼ HPゲージの目盛り線（10%ごと、50%は長く）← 下辺に沿わせる
                for (let i = 1; i < 10; i++) {
                    const memX = barX2 + Math.floor(barWidth * i / 10);
                    const isMid = (i === 5);
                    const memLength = isMid ? barHeight : Math.floor(barHeight / 2);
                    const memY = barY3 + barHeight - memLength; // ← 下辺揃え
                    this.bitmap.fillRect(memX, memY, 2, memLength, "#000000ff");
                }





                this.bitmap.fontSize = 18;
                this.bitmap.textColor = "#ffffff";
                this.bitmap.drawText("Boss HP", barX2 + barWidth + 8, barY3 - 2, 100, barHeight, 'left');
            }


        }
    };

    // ■ リセット関数
    window.RSTH_IH.resetElapsedTime = function () {
        window.RSTH_IH.TimeCount = 0;
        window.RSTH_IH._timeFrameCounter = 0;
        if (RSTH_DEBUG_LOG) console.log("[resetElapsedTime] 経過時間をリセットしました");
    };

    // ■ カウントON/OFF
    window.RSTH_IH.setElapsedTimeEnabled = function (enabled) {
        window.RSTH_IH._elapsedTimeEnabled = enabled;
        if (enabled) {
            if (RSTH_DEBUG_LOG) console.log("[Timer] カウント開始");
        } else {
            if (RSTH_DEBUG_LOG) console.log("[Timer] カウント停止");
        }
    };

    // ■ イベントから呼び出すスタート関数
    window.RSTH_IH.startElapsedTime = function (goalTimeSec) {
        if (!SceneManager._scene || !(SceneManager._scene instanceof Scene_Map)) return;
        window.RSTH_IH.TimeCount = 0;
        window.RSTH_IH._elapsedLimit = goalTimeSec;

        window.RSTH_IH._elapsedTimeActive = true;

        if (SceneManager._scene._elapsedTimeSprite) {
            SceneManager._scene.removeChild(SceneManager._scene._elapsedTimeSprite);
        }

        const sprite = new window.RSTH_IH.ElapsedTimeSprite(true);
        SceneManager._scene._elapsedTimeSprite = sprite;
        SceneManager._scene.addChild(sprite);

        window.RSTH_IH._progressGoalTime = goalTimeSec || 60;
        window.RSTH_IH.resetElapsedTime();
        window.RSTH_IH.setElapsedTimeEnabled(false);
        window.RSTH_IH._bossMob = null;
        if (RSTH_DEBUG_LOG) console.log("[startElapsedTime] タイマー演出開始");
    };

    window.RSTH_IH.stopElapsedTime = function () {
        window.RSTH_IH._elapsedTimeActive = false;
        window.RSTH_IH.setElapsedTimeEnabled(false);
        if (SceneManager._scene && SceneManager._scene._elapsedTimeSprite) {
            SceneManager._scene.removeChild(SceneManager._scene._elapsedTimeSprite);
        }
        if (RSTH_DEBUG_LOG) console.log("[stopElapsedTime] タイマー停止");
    };

    const _Scene_Map_createAllWindows = Scene_Map.prototype.createAllWindows;
    Scene_Map.prototype.createAllWindows = function () {
        _Scene_Map_createAllWindows.call(this);

        if (window.RSTH_IH._elapsedTimeActive) {
            const sprite = new window.RSTH_IH.ElapsedTimeSprite(false); // 演出なし
            this._elapsedTimeSprite = sprite;
            this.addChild(sprite);
        }
    };


    // タイトルシーン
    window.RSTH_IH.Scene_TitleCustom = class extends Scene_Base {
        initialize() {
            super.initialize();
            this._titleX = -Graphics.width;
            this._commandY = Graphics.height + 100;
            this._particles = [];

            //初期化
            window.RSTH_IH.TimeCount = 0;
            window.RSTH_IH.KilledMobCount = 0;
            window.RSTH_IH.MapName = "イテルスペ廃道";
        }

        create() {
            super.create();
            this.createBackground();
            this.createForeground();
            this.createWindowLayer();
            this.createCommandWindow();
        }

        start() {
            super.start();
            SceneManager.clearStack();
            this.adjustBackground();
            this.playTitleMusic();
            this.startFadeIn(this.fadeSpeed(), false);
        }

        update() {
            super.update();

            this._stripe.x -= 2;
            if (this._stripe.x < -40) this._stripe.x = 0;
            if (!this.isBusy()) {
                this._commandWindow.open();
            }
        }

        isBusy() {
            return this._commandWindow.isClosing() || super.isBusy();
        }

        terminate() {
            super.terminate();
            SceneManager.snapForBackground();
        }

        createBackground() {
            this._backSprite1 = new Sprite(ImageManager.loadTitle1($dataSystem.title1Name));
            this._backSprite2 = new Sprite(ImageManager.loadTitle2($dataSystem.title2Name));
            this.addChild(this._backSprite1);
            this.addChild(this._backSprite2);

            const stripeBitmap = new Bitmap(Graphics.width, Graphics.height);
            const ctx = stripeBitmap.context;
            ctx.strokeStyle = "rgba(255,255,255,0.1)";
            ctx.lineWidth = 4;

            for (let i = -Graphics.height; i < Graphics.width * 2; i += 40) {
                ctx.beginPath();
                ctx.moveTo(i, 0);
                ctx.lineTo(i - Graphics.height, Graphics.height);
                ctx.stroke();
            }


            this._stripe = new TilingSprite(stripeBitmap);
            this._stripe.move(0, 0, Graphics.width, Graphics.height);
            this._stripe.opacity = 150;
            this.addChild(this._stripe);
        }


        createForeground() {
            for (let i = 0; i < 50; i++) {
                this._particles.push({
                    x: Graphics.width / 2,
                    y: Graphics.height / 3,
                    vx: (Math.random() - 0.5) * 4,
                    vy: (Math.random() - 0.5) * 4,
                    alpha: 1.0
                });
            }
        }

        adjustBackground() {
            this._backSprite1.anchor.set(0, 0);
            this._backSprite2.anchor.set(0, 0);

            this._backSprite1.scale.set(1, 1);
            this._backSprite2.scale.set(1, 1);

            this._backSprite1.x = 0;
            this._backSprite2.x = 0;
        }




        createCommandWindow() {
            //const background = $dataSystem.titleCommandWindow.background;
            const rect = this.commandWindowRect();
            this._commandWindow = new window.RSTH_IH.Window_TitleCommand_Custom(rect);
            //this._commandWindow.setBackgroundType(background);
            this._commandWindow.setHandler("newGame", this.commandNewGame.bind(this));
            this._commandWindow.setHandler("tutorial", this.commandTutorial.bind(this));
            this._commandWindow.setHandler("achievements", this.commandAchievements.bind(this));
            this._commandWindow.setHandler("option", this.commandOption.bind(this));
            this._commandWindow.setHandler("cregit", this.commandCregit.bind(this));
            this.addChild(this._commandWindow);
        }


        commandWindowRect() {
            const ww = 300;
            const wh = this.calcWindowHeight(5, true);

            const wx = 12;
            const wy = Graphics.height - wh - 12;
            return new Rectangle(wx, wy, ww, wh);
        }


        commandNewGame() {
            window.RSTH_IH.slideScene(this, window.RSTH_IH.Scene_SelectEquipment, "left", 30);
            //window.RSTH_IH.slideScene(this, window.RSTH_IH.Scene_SelectCharacter, "left", 30);
            //window.RSTH_IH.slideScene(this, window.RSTH_IH.Scene_SelectMap, "left", 30);
        }

        commandTutorial() {
            SceneManager.push(window.RSTH_IH.Scene_Tutorial);
        }

        commandAchievements() {
            SceneManager.push(window.RSTH_IH.Scene_Achievements);
        }

        commandOption() {
            window.RSTH_IH._calledFromTitleScene = true; // ← フラグ立て
            SceneManager.push(window.RSTH_IH.Scene_OptionsCustom);
        }

        commandCregit() {
            window.RSTH_IH.slideScene(this, window.RSTH_IH.Scene_Cregit, "left", 30);
        }

        playTitleMusic() {
            AudioManager.playBgm($dataSystem.titleBgm);
            AudioManager.stopBgs();
            AudioManager.stopMe();
        }
    };


    // Boot差し替え
    const _Scene_Boot_start = Scene_Boot.prototype.start;
    Scene_Boot.prototype.start = function () {
        _Scene_Boot_start.call(this);
        ConfigManager.load();
        //console.log(`ConfigManager["achi_HP300"]`, ConfigManager["achi_HP300"]);
        window.RSTH_IH.preloadAchievementImages();
        if (!ConfigManager.InitEquip) {
            //window.RSTH_IH.makeInitOtomoList();
            window.RSTH_IH.makeInitEquipmentList();
            window.RSTH_IH.makeInitEquipmentListreleased();
        }
        SceneManager.goto(window.RSTH_IH.Scene_TitleCustom);
    };

    window.RSTH_IH.Window_TitleCommand_Custom = class extends Window_Command {
        constructor(rect) {
            super(rect);
            this._flashCounter = 0;
        }

        makeCommandList() {
            this.addCommand("GameStart", "newGame");
            this.addCommand("Tutorial", "tutorial");
            this.addCommand("Achievements", "achievements");
            this.addCommand("Option", "option");
            this.addCommand("Cregit", "cregit");
        }

        maxItems() {
            return this._list.length; // ← これを追加
        }

        select(index) {
            super.select(index);
            this.opacity = 255;
            this.contentsOpacity = 255;
            this._flashCounter = 10;
        }

        update() {
            super.update();
            if (this._flashCounter > 0) {
                this.opacity = 255;
                this._flashCounter--;
            }
        }
    };

    Scene_Gameover.prototype.gotoTitle = function () {
        SceneManager.goto(window.RSTH_IH.Scene_TitleCustom);
    };

    window.RSTH_IH.slideScene = function (fromScene, toSceneClass, direction = "left", duration = 30) {
        // すでにスライド進行中なら無視
        if (window.RSTH_IH._slideSceneLock) {
            return;
        }
        window.RSTH_IH._slideSceneLock = true;

        // 古いシーンをスナップしておく（表示用）
        const snap1 = SceneManager.snap();

        // スナップに失敗した場合は即 push にフォールバック
        if (!snap1) {
            window.RSTH_IH._slideSceneLock = false;
            SceneManager.push(toSceneClass);
            return;
        }

        // スライド用の黒背景スプライトを生成
        const blackBitmap = new Bitmap(Graphics.width, Graphics.height);
        blackBitmap.fillAll("#000000");
        const blackSprite = new Sprite(blackBitmap);

        // スライド用コンテナ
        const fromSprite = new Sprite(snap1);

        const container = new Sprite();
        container.addChild(fromSprite);   // 現在のシーンが背面
        container.addChild(blackSprite);  // 黒背景が前面

        // windowLayerの上に追加できるように保険
        if (fromScene._windowLayer && fromScene._windowLayer.parent) {
            fromScene._windowLayer.parent.addChild(container);
        } else {
            fromScene.addChild(container);
        }

        fromSprite.x = 0;
        blackSprite.x = direction === "left" ? Graphics.width : -Graphics.width;

        Graphics._updateCanvas();

        let frame = 0;
        const slide = () => {
            // 親が null なら安全に抜ける
            if (!container.parent) {
                window.RSTH_IH._slideSceneLock = false;
                SceneManager.push(toSceneClass);
                return;
            }

            frame++;
            const t = Math.min(frame / duration, 1);

            if (direction === "left") {
                blackSprite.x = Graphics.width * (1 - t);
            } else {
                blackSprite.x = -Graphics.width * (1 - t);
            }

            if (frame < duration) {
                requestAnimationFrame(slide);
            } else {
                // スライド完了後に SceneManager.goto
                window.RSTH_IH._slideSceneLock = false;
                SceneManager.push(toSceneClass);
            }
        };

        slide();
    };





})();
