/*:
 * @target MZ
 * @plugindesc RSTH_IH: サバイバルゲームシステムプラグイン
 * @author © 2025 ReSera_りせら（@MOBIUS1001）
 *
 * このソースコードは無断での転載、複製、改変、再配布、商用利用を固く禁じます。
 * 禁止事項の例：
 * - 本ファイルの全部または一部を許可なくコピー、再配布すること
 * - 本ファイルを改変して配布すること
 * - 商用目的での利用
 */

(() => {
    "use strict";

    // ログ出力制御フラグ（trueでログ出力、falseで抑制）
    //const RSTH_DEBUG_LOG = true;
    const RSTH_DEBUG_LOG = false;


    //=============================================================================================================
    // マウスポインタ関連===============================================================================================
    //=============================================================================================================
    const POINTER_IMAGE_NAME = "MousePoints";
    const POINTER_SPEED = 1.0; // 値が大きいほど高速（即時なら1.0）



    Scene_Map.prototype.createMousePointerSprite = function () {
        /*
        const sprite = new Sprite();
        sprite.anchor.set(0.5);
        sprite.z = 999;
        sprite._mode = null;
        */

        this._mousePointerSprite = new Sprite();
        this._mousePointerSprite.anchor.x = 0.5;
        this._mousePointerSprite.anchor.y = 0.5;
        this.addChild(this._mousePointerSprite);

        // クールタイム円専用スプライトを子として追加
        this._mousePointerCooldown = new Sprite(new Bitmap(48, 48));
        this._mousePointerCooldown.anchor.x = 0.5;
        this._mousePointerCooldown.anchor.y = 0.5;
        this._mousePointerSprite.addChild(this._mousePointerCooldown);
    };

    const _Scene_Map_terminate = Scene_Map.prototype.terminate;
    Scene_Map.prototype.terminate = function () {
        _Scene_Map_terminate.call(this);
        document.body.style.cursor = 'auto'; // マウスカーソル再表示
    };

    Scene_Map.prototype.convertMapToCanvasX = function (mapX) {
        return (mapX - $gameMap.displayX()) * $gameMap.tileWidth();
    };

    Scene_Map.prototype.convertMapToCanvasY = function (mapY) {
        return (mapY - $gameMap.displayY()) * $gameMap.tileHeight();
    };


    Scene_Map.prototype.updateMousePointerSprite = function () {
        const sprite = this._mousePointerSprite;
        if (!sprite) return;

        const cooldownSprite = this._mousePointerCooldown;

        const targetX = TouchInput.x;
        const targetY = TouchInput.y;

        sprite.x += (targetX - sprite.x) * POINTER_SPEED;
        sprite.y += (targetY - sprite.y) * POINTER_SPEED;

        sprite.visible =
            TouchInput.x >= 0 && TouchInput.x < Graphics.boxWidth &&
            TouchInput.y >= 0 && TouchInput.y < Graphics.boxHeight;

        const scene = SceneManager._scene;
        const index = window.RSTH_IH.HobarSlotsIndex;
        const shift = Input.isPressed("shift");
        const slot = $gameSystem._customHotbarItems?.[index];


        const cd = window.RSTH_IH._cooldownMap?.[index];

        if (cd && cd.remaining > 0 && cd.duration > 0) {
            const progress = cd.remaining / cd.duration;

            const cdBitmap = cooldownSprite.bitmap;
            cdBitmap.clear();

            const ctx = cdBitmap.context;
            ctx.save();
            ctx.beginPath();
            ctx.moveTo(24, 24); // 中心
            ctx.arc(
                24, 24,
                20,
                -Math.PI / 2,
                -Math.PI / 2 + Math.PI * 2 * progress,
                false
            );
            ctx.closePath();
            ctx.fillStyle = "rgba(0, 0, 0, 0.5)";
            ctx.fill();
            ctx.restore();

            cdBitmap._baseTexture.update();
            cooldownSprite.visible = true;
        } else {
            cooldownSprite.visible = false;
        }

        let doorBlockId = null;
        let doorBlock = null;
        if (window.RSTH_IH.DirectedDoor > 0) {
            doorBlockId = window.RSTH_IH.DirectedDoor;
            doorBlock = $dataItems[doorBlockId];
        }

        // ▼ 1. ドラッグ中のアイテムがあるか？
        if (RSTH_DEBUG_LOG) console.log("window.RSTH_IH.__draggingItem", window.RSTH_IH.__draggingItem);

        const draggingItem = window.RSTH_IH.__draggingItem;
        if (draggingItem?.iconIndex > 0) {
            const draggingAmount = shift ? (draggingItem.count || 1) : 1;
            const iconIndex = draggingItem.iconIndex;
            if (sprite._mode !== `drag${iconIndex}_${draggingAmount}`) {
                const iconBitmap = this.createIconBitmap(iconIndex);
                const w = iconBitmap.width;
                const h = iconBitmap.height;

                const finalBitmap = new Bitmap(w, h);
                finalBitmap.blt(iconBitmap, 0, 0, w, h, 0, 0);

                if (draggingAmount > 1) {
                    finalBitmap.fontSize = 14;
                    finalBitmap.textColor = "#ffffff";
                    finalBitmap.outlineColor = "#000000";
                    finalBitmap.outlineWidth = 3;
                    finalBitmap.drawText(`${draggingAmount}`, 0, h - 20, w - 4, 20, "right");
                }

                sprite.bitmap = finalBitmap;
                sprite._mode = `drag${iconIndex}_${draggingAmount}`;
                sprite.visible = true;
            }
            return;
        }

        // ▼ 2. ウィンドウ内なら通常カーソル画像（tile 0）
        const isInWindow =
            window.RSTH_IH.isInsideWindow(scene._inventoryWindow, targetX, targetY) ||
            window.RSTH_IH.isInsideWindow(scene._hotbarWindow, targetX, targetY) ||
            window.RSTH_IH.isInsideWindow(scene._chestWindow, targetX, targetY) ||
            window.RSTH_IH.isInsideWindow(scene._workbenchWindow, targetX, targetY) ||
            window.RSTH_IH.isInsideWindow(scene._equipmentWindow, targetX, targetY);

        if (isInWindow) {
            if (sprite._mode !== "default") {
                sprite.bitmap = this.createPointerBitmap(0);
                sprite._mode = "default";
                sprite.visible = true;
                if (this._rsthGhostSprite) {
                    this._rsthGhostSprite.visible = false;
                }
            }
            return;
        }

        // ▼ 3. マウス下のマップ座標からイベントを検索
        const mx = $gameMap.canvasToMapX(targetX);
        const my = $gameMap.canvasToMapY(targetY);

        const existChest = window.RSTH_IH.tryOpenChestToNearby(mx, my, "chest");
        const existWorkbench = window.RSTH_IH.tryOpenChestToNearby(mx, my, "workbench");
        const existDoor = window.RSTH_IH.tryOpenChestToNearby(mx, my, "door");

        const distance = $gameMap.distance($gamePlayer.x, $gamePlayer.y, mx, my);

        const events = $gameMap.eventsXy(mx, my);
        const nearEvent = events.find(e =>
            e instanceof Game_Event &&
            e.isNormalPriority() &&
            $gameMap.distance($gamePlayer.x, $gamePlayer.y, e.x, e.y) <= 3
        );

        if (nearEvent || existChest || existWorkbench || existDoor) {
            if (sprite._mode !== "talk") {
                sprite.bitmap = this.createPointerBitmap(1);
                sprite._mode = "talk";
                sprite.visible = true;
            }
            // ゴースト描画をキャンセルするため return を追加
            if (this._rsthGhostSprite) {
                this._rsthGhostSprite.visible = false;
                this._ghostTextSprite.visible = false;
            }
            return;
        }
        const ghost = this._rsthGhostSprite;
        if (slot) {
            // ブロック設置可能なアイテムを選択中ならゴースト表示
            if (slot.type === "block") {
                let slot2 = null;
                let slot2offset1 = null;
                let slot2meta = false;
                if (doorBlock) {
                    slot2 = doorBlock;
                    slot2offset1 = JSON.parse(slot2.meta.tileOffsets1);
                    slot2meta = true;
                } else {
                    slot2 = slot;
                }
                if (slot2) {
                    if (distance <= 3 &&
                        (slot2.type === "block" || slot2meta === true) &&
                        (Array.isArray(slot2.tileOffsets1) || Array.isArray(slot2offset1))) {

                        const tileset = slot2.tileset || slot2.meta.tileset;
                        const bitmap = ImageManager.loadTileset(tileset);
                        const offsets = slot2.tileOffsets1 || slot2offset1;


                        bitmap.addLoadListener(() => {
                            const ghost = this._rsthGhostSprite;

                            // tilesetConfigsRawの解析と安全な処理
                            let tilesetConfigs = [];

                            if (Array.isArray(window.RSTH_IH.tilesetConfigsRaw)) {
                                tilesetConfigs = window.RSTH_IH.tilesetConfigsRaw.map(json => {
                                    try {
                                        return JSON.parse(json);
                                    } catch (e) {
                                        if (RSTH_DEBUG_LOG) console.warn("JSON parse error in tilesetConfigsRaw:", json);
                                        return null;
                                    }
                                }).filter(cfg => cfg);
                            } else if (typeof window.RSTH_IH.tilesetConfigsRaw === "string") {
                                try {
                                    const parsed = JSON.parse(window.RSTH_IH.tilesetConfigsRaw);
                                    if (Array.isArray(parsed)) {
                                        tilesetConfigs = parsed.map(json => {
                                            try {
                                                return JSON.parse(json);
                                            } catch (e) {
                                                if (RSTH_DEBUG_LOG) console.warn("Nested JSON parse error:", json);
                                                return null;
                                            }
                                        }).filter(cfg => cfg);
                                    }
                                } catch (e) {
                                    if (RSTH_DEBUG_LOG) console.warn("tilesetConfigsRaw is not a valid JSON string array:", e);
                                }
                            }

                            if (RSTH_DEBUG_LOG) console.warn("tilesetConfigs", tilesetConfigs);
                            const set = tilesetConfigs.find(cfg => cfg?.name === tileset);
                            const tw = Number(set?.tileSize) || 48;
                            const th = Number(set?.tileSize) || 48;
                            const cols = Number(set?.cols) || 8;
                            if (RSTH_DEBUG_LOG) console.warn(`set`, set);
                            if (RSTH_DEBUG_LOG) console.warn(`tw${tw},th${th},cols${cols}`);

                            // 事前に最大幅・高さを tileOffsets1 から計算
                            const maxDx = Math.max(...offsets.map(o => o.dx));
                            const maxDy = Math.max(...offsets.map(o => o.dy));
                            const width = (maxDx + 1) * tw;
                            const height = (maxDy + 1) * th;

                            // ghost用ビットマップを新規生成
                            ghost.bitmap = new Bitmap(width, height);
                            ghost.bitmap.clear();

                            // 各タイルを描画
                            for (const offset of offsets) {
                                const rawTileId = Number(offset.tileId);
                                const tileId = isNaN(rawTileId) ? 0 : rawTileId - 1;
                                const dx = offset.dx ?? 0;
                                const dy = offset.dy ?? 0;

                                const sx = (tileId % cols) * tw;
                                const sy = Math.floor(tileId / cols) * th;

                                if (RSTH_DEBUG_LOG) console.log("offset", offset, "tileId", tileId);
                                ghost.bitmap.blt(bitmap, sx, sy, tw, th, dx * tw, dy * th);
                            }

                            // ゴーストスプライトの位置設定
                            ghost.x = scene.convertMapToCanvasX($gameMap.canvasToMapX(targetX));
                            ghost.y = scene.convertMapToCanvasY($gameMap.canvasToMapY(targetY));
                            ghost.opacity = 200;
                            ghost.visible = true;

                            if (RSTH_DEBUG_LOG) console.log(ghost.bitmap.width, ghost.bitmap.height, offsets);

                            if ($dataItems[slot.id].meta.blockType === "door") {
                                this._ghostTextSprite.x = ghost.x + ghost.bitmap.width / 2;
                                this._ghostTextSprite.y = ghost.y - 10;
                                this._ghostTextSprite.bitmap.clear();
                                this._ghostTextSprite.bitmap.drawText("Rキーで切替可", 0, 0, 200, 32, "center");
                                this._ghostTextSprite.visible = true;
                            } else {
                                this._ghostTextSprite.visible = false;
                            }
                        });

                        //return;
                    } else if (this._rsthGhostSprite) {
                        this._rsthGhostSprite.visible = false;
                        this._ghostTextSprite.visible = false;

                    }

                }
            }
            // 武器の場合
            else if (slot.type === "weapon") {
                let wTypeBow = false;
                let orbit = false;
                let boomerang = false;
                let banana = false;
                let areaAttack = false;
                let skillAttack = false;
                let skillState = false;
                let noghost = false;
                if ($dataWeapons[slot.id]?.wtypeId === 7) wTypeBow = true;
                if ($dataWeapons[slot.id]?.meta?.orbit) orbit = true;
                if ($dataWeapons[slot.id]?.meta?.boomerang) boomerang = true;
                if ($dataWeapons[slot.id]?.meta?.banana) banana = true;
                if ($dataWeapons[slot.id]?.meta?.areaAttack) areaAttack = true;
                if ($dataWeapons[slot.id]?.meta?.skill) skillAttack = true;
                if ($dataWeapons[slot.id]?.meta?.state) skillState = true;
                if ($dataWeapons[slot.id]?.meta?.noghost) noghost = true;
                // ▼ 弓武器時の射線ゴースト表示
                if (wTypeBow) {
                    const ghost = this._rsthGhostSprite;
                    const tw = $gameMap.tileWidth();
                    const th = $gameMap.tileHeight();

                    // プレイヤー位置
                    const playerX = $gamePlayer.x;
                    const playerY = $gamePlayer.y;

                    // マウスのマップ座標
                    const targetMapX = $gameMap.canvasToMapX(targetX);
                    const targetMapY = $gameMap.canvasToMapY(targetY);

                    const dx = targetMapX - playerX;
                    const dy = targetMapY - playerY;
                    const distance = Math.sqrt(dx * dx + dy * dy);
                    const dirX = dx / distance;
                    const dirY = dy / distance;

                    // 仮に5マス先まで表示
                    const maxRange = 3;
                    const endX = playerX + dirX * maxRange;
                    const endY = playerY + dirY * maxRange;

                    const startScreenX = (playerX - $gameMap.displayX()) * tw + tw / 2;
                    const startScreenY = (playerY - $gameMap.displayY()) * th + th / 2;
                    const endScreenX = (endX - $gameMap.displayX()) * tw + tw / 2;
                    const endScreenY = (endY - $gameMap.displayY()) * th + th / 2;

                    const width = Graphics.width;
                    const height = Graphics.height;
                    if (!ghost.bitmap || ghost.bitmap.width !== width || ghost.bitmap.height !== height) {
                        ghost.bitmap = new Bitmap(width, height);
                    }
                    ghost.bitmap.clear();

                    ghost.bitmap.context.strokeStyle = "rgba(255, 255, 0, 0.2)";
                    ghost.bitmap.context.lineWidth = 8;
                    ghost.bitmap.context.beginPath();
                    ghost.bitmap.context.moveTo(startScreenX, startScreenY);
                    ghost.bitmap.context.lineTo(endScreenX, endScreenY);
                    ghost.bitmap.context.stroke();

                    ghost.x = 0;
                    ghost.y = 0;
                    ghost.visible = true;

                    this._ghostTextSprite.visible = false;
                }
                /*
                // プレイヤー周囲攻撃の武器装備時
                else if (!wTypeBow && !orbit && !boomerang && areaAttack) {

                    const tw = $gameMap.tileWidth();
                    const th = $gameMap.tileHeight();

                    // 攻撃範囲サイズ (+1範囲なら 3x3)
                    const dataItem = $dataWeapons[slot.id];

                    let range = 1;
                    range = parseInt(dataItem.meta.areaAttack);
                    const shape = dataItem.meta?.shape ?? "box";
                    const size = (range * 2 + 1);
                    const width = size * tw;
                    const height = size * th;

                    if (!ghost.bitmap || ghost.bitmap.width !== width || ghost.bitmap.height !== height) {
                        ghost.bitmap = new Bitmap(width, height);
                    }
                    ghost.bitmap.clear();

                    ghost.bitmap.paintOpacity = 160;
                    for (let dx = -range; dx <= range; dx++) {
                        for (let dy = -range; dy <= range; dy++) {
                            let inRange = false;

                            if (shape === "circle") {
                                inRange = (Math.abs(dx) + Math.abs(dy) <= range);
                            } else {  // 四角形（デフォルト）
                                inRange = true;
                            }

                            if (inRange) {
                                const px = (dx + range) * tw;
                                const py = (dy + range) * th;
                                ghost.bitmap.fillRect(px, py, tw, th, "rgba(255, 0, 0, 0.2)");
                            }
                        }
                    }

                    // プレイヤーの画面座標を取得
                    const playerScreenX = scene.convertMapToCanvasX($gamePlayer.x);
                    const playerScreenY = scene.convertMapToCanvasY($gamePlayer.y);

                    ghost.x = playerScreenX - range * tw;
                    ghost.y = playerScreenY - range * th;

                    ghost.visible = true;

                    this._ghostTextSprite.visible = false;

                    // ここでreturnしない → 通常マウスアイコンも重ねて表示
                }
                */
                // ▼ 武器装備時の攻撃範囲ゴースト表示
                else if (skillAttack && !wTypeBow && !orbit && !boomerang && !banana && !areaAttack && !skillState && !noghost) {
                    //else if (distance <= 3 && !wTypeBow && !orbit && !boomerang && !areaAttack) {

                    const tw = $gameMap.tileWidth();
                    const th = $gameMap.tileHeight();

                    // 攻撃範囲サイズ (+1範囲なら 3x3)
                    const dataItem = $dataWeapons[slot.id];
                    const shape = dataItem.meta?.shape ?? "box";

                    let range = 1;
                    range = window.RSTH_IH.getWeaponRange(dataItem);
                    const size = (range * 2 + 1);
                    const width = size * tw;
                    const height = size * th;

                    if (!ghost.bitmap || ghost.bitmap.width !== width || ghost.bitmap.height !== height) {
                        ghost.bitmap = new Bitmap(width, height);
                    }
                    ghost.bitmap.clear();

                    ghost.bitmap.paintOpacity = 160;
                    for (let dx = -range; dx <= range; dx++) {
                        for (let dy = -range; dy <= range; dy++) {
                            let inRange = false;

                            if (shape === "circle") {
                                inRange = (Math.abs(dx) + Math.abs(dy) <= range);
                            } else {  // 四角形（デフォルト）
                                inRange = true;
                            }

                            if (inRange) {
                                const px = (dx + range) * tw;
                                const py = (dy + range) * th;
                                ghost.bitmap.fillRect(px, py, tw, th, "rgba(255, 0, 0, 0.2)");
                            }
                        }
                    }

                    if ($dataWeapons[slot.id]?.meta?.areaAttack !== undefined) {
                        // プレイヤーの画面座標を取得
                        const playerScreenX = scene.convertMapToCanvasX($gamePlayer.x);
                        const playerScreenY = scene.convertMapToCanvasY($gamePlayer.y);

                        ghost.x = playerScreenX - range * tw;
                        ghost.y = playerScreenY - range * th;
                    } else {
                        // ゴーストの中心をマウスに合わせる
                        ghost.x = scene.convertMapToCanvasX($gameMap.canvasToMapX(targetX)) - range * tw;
                        ghost.y = scene.convertMapToCanvasY($gameMap.canvasToMapY(targetY)) - range * th;
                    }

                    ghost.visible = true;

                    this._ghostTextSprite.visible = false;

                    // ここでreturnしない → 通常マウスアイコンも重ねて表示
                } else {
                    ghost.visible = false;
                }
            }
            else {

                this._rsthGhostSprite.visible = false;
                this._ghostTextSprite.visible = false;
                ghost.visible = false;
            }
        } else {

            this._rsthGhostSprite.visible = false;
            this._ghostTextSprite.visible = false;
            ghost.visible = false;
        }

        // ▼ 5. 通常時はホットバーアイコン
        const iconIndex = slot?.iconIndex ?? 0;
        const itemCount = slot?.count ?? 0;

        if (slot?.type === "tool" && distance <= 3 && iconIndex > 0) {
            this.setSpriteToItemIcon(sprite, iconIndex, itemCount);

        } else if (slot?.type === "tool" && distance > 3) {
            sprite.bitmap = this.createPointerBitmap(0);
            sprite._mode = "default";
            sprite.visible = true;

        } else if (iconIndex > 0) {
            this.setSpriteToItemIcon(sprite, iconIndex, itemCount);
        }



        else {
            sprite.bitmap = this.createPointerBitmap(0);
            sprite._mode = "default";
            sprite.visible = true;
        }

    };

    Scene_Map.prototype.updateBowGhost = function () {
        const scene = SceneManager._scene;
        const index = window.RSTH_IH.HobarSlotsIndex;
        const slot = $gameSystem._customHotbarItems?.[index];
        const ghost = this._rsthGhostSprite;

        // 弓を選択中のみ表示
        if (!slot || slot.type !== "weapon") {
            ghost.visible = false;
            return;
        }
        const dataItem = window.RSTH_IH.getGameItem(slot);
        if (!dataItem?.meta?.bow) {
            ghost.visible = false;
            return;
        }

        const mapX = $gameMap.canvasToMapX(TouchInput.x);
        const mapY = $gameMap.canvasToMapY(TouchInput.y);
        const playerX = $gamePlayer.x;
        const playerY = $gamePlayer.y;

        const dx = mapX - playerX;
        const dy = mapY - playerY;
        const len = Math.sqrt(dx * dx + dy * dy);
        const dirX = dx / len;
        const dirY = dy / len;

        // 先端までを表示する位置を決定（仮に5マス先まで表示）
        const endX = playerX + dirX * 5;
        const endY = playerY + dirY * 5;

        const tw = $gameMap.tileWidth();
        const th = $gameMap.tileHeight();
        const dispX = (endX - $gameMap.displayX()) * tw;
        const dispY = (endY - $gameMap.displayY()) * th;

        // ゴースト用ビットマップ生成
        if (!ghost.bitmap) {
            ghost.bitmap = new Bitmap(200, 200); // 仮サイズ
        }
        ghost.bitmap.clear();
        ghost.bitmap.context.strokeStyle = "rgba(255,255,255,0.5)";
        ghost.bitmap.context.lineWidth = 2;
        ghost.bitmap.context.beginPath();
        ghost.bitmap.context.moveTo(ghost.width / 2, ghost.height / 2);
        ghost.bitmap.context.lineTo(dispX, dispY);
        ghost.bitmap.context.stroke();

        ghost.x = (playerX - $gameMap.displayX()) * tw;
        ghost.y = (playerY - $gameMap.displayY()) * th;
        ghost.visible = true;
        ghost.bitmap._setDirty();
    };


    Scene_Map.prototype.setSpriteToItemIcon = function (sprite, iconIndex, itemCount) {
        const modeKey = `icon${iconIndex}_${itemCount}`;
        if (sprite._mode !== modeKey) {
            const iconBitmap = this.createIconBitmap(iconIndex);
            const w = iconBitmap.width;
            const h = iconBitmap.height;

            const finalBitmap = new Bitmap(w, h);
            finalBitmap.blt(iconBitmap, 0, 0, w, h, 0, 0);

            if (itemCount > 1) {
                finalBitmap.fontSize = 14;
                finalBitmap.textColor = "#ffffff";
                finalBitmap.outlineColor = "#000000";
                finalBitmap.outlineWidth = 3;
                finalBitmap.drawText(`${itemCount}`, 0, h - 20, w, 20, "right");
            }
            sprite.bitmap = finalBitmap;
            sprite._mode = modeKey;
            sprite.visible = true;
        }
    };



    Scene_Map.prototype.createPointerBitmap = function (tileIndex) {
        const tw = 48, th = 48;
        const bitmap = new Bitmap(tw, th);
        const source = ImageManager.loadSystem(POINTER_IMAGE_NAME);
        const sx = tileIndex * tw;
        const sy = 0;

        if (source.width > 0) {
            bitmap.blt(source, sx, sy, tw, th, 0, 0);
        } else {
            source.addLoadListener(() => {
                bitmap.blt(source, sx, sy, tw, th, 0, 0);
            });
        }

        return bitmap;
    };

    Scene_Map.prototype.createIconBitmap = function (iconIndex) {
        const pw = 32, ph = 32;
        const sx = (iconIndex % 16) * pw;
        const sy = Math.floor(iconIndex / 16) * ph;
        const bitmap = new Bitmap(pw, ph);

        const iconSet = ImageManager.loadSystem("IconSet");
        if (iconSet.width > 0) {
            bitmap.blt(iconSet, sx, sy, pw, ph, 0, 0);
        } else {
            iconSet.addLoadListener(() => {
                bitmap.blt(iconSet, sx, sy, pw, ph, 0, 0);
            });
        }

        return bitmap;
    };

    // Scene_Map.prototype.createGhostTextSprite
    Scene_Map.prototype.createGhostTextSprite = function () {
        if (this._ghostTextSprite) return;

        const ghostText = new Sprite(new Bitmap(200, 32));
        ghostText.bitmap.fontSize = 20;
        ghostText.bitmap.textColor = "#ffffff";
        ghostText.bitmap.outlineColor = "#000000";
        ghostText.bitmap.outlineWidth = 4;
        ghostText.anchor.x = 0.5;
        ghostText.anchor.y = 1;
        ghostText.visible = false;

        this.addChild(ghostText);
        //this._spriteset._tilemap.addChild(ghostText);
        this._ghostTextSprite = ghostText;
    };

    //=============================================================================================================
    // ウィンドウ生成処理等===============================================================================================
    //=============================================================================================================
    const _Scene_Map_createAllWindows = Scene_Map.prototype.createAllWindows;
    Scene_Map.prototype.createAllWindows = function () {
        if (RSTH_DEBUG_LOG) console.warn("[createAllWindows]start");
        _Scene_Map_createAllWindows.call(this);

        const hotbarPos = window.RSTH_IH.calculateHotbarPosition();
        const invPos = window.RSTH_IH.calculateInventoryPosition(hotbarPos.x, hotbarPos.y);
        const chestPos = window.RSTH_IH.calculateChestPosition(hotbarPos.x, hotbarPos.y);
        const wbPos = window.RSTH_IH.calculateWorkbenchPosition(hotbarPos.x, hotbarPos.y);
        const eqPos = window.RSTH_IH.calculateEquipmentWindowPosition();

        if (RSTH_DEBUG_LOG) console.log("[createAllWindows]hotbarPos ", hotbarPos);
        if (RSTH_DEBUG_LOG) console.log("[createAllWindows]invPos ", invPos);
        if (RSTH_DEBUG_LOG) console.log("[createAllWindows]chestPos ", chestPos);
        if (RSTH_DEBUG_LOG) console.log("[createAllWindows]wbPos ", wbPos);
        // ホットバー
        if (typeof window.RSTH_IH.Window_Hotbar !== "undefined" && !this._hotbarWindow) {
            const rect = new Rectangle(hotbarPos.x, hotbarPos.y, window.RSTH_IH.Hotbarwidth, window.RSTH_IH.Hotbarheight);
            this._hotbarWindow = new window.RSTH_IH.Window_Hotbar(rect);
            this.addWindow(this._hotbarWindow);
            this._hotbarWindow.activate();
        }

        // インベントリ
        if (typeof window.RSTH_IH.Window_Inventory !== "undefined" && !this._inventoryWindow) {
            const rect = new Rectangle(invPos.x, invPos.y, window.RSTH_IH.Inventorywidth, window.RSTH_IH.Inventoryheight);
            this._inventoryWindow = new window.RSTH_IH.Window_Inventory(rect);
            this.addWindow(this._inventoryWindow);
            this._inventoryWindow.hide();
            this._inventoryWindow.deactivate();
        }

        // 装備ウィンドウ
        if (typeof window.RSTH_IH.Window_EquipmentSlots !== "undefined" && !this._equipmentWindow) {

            const slotCount = $gameParty.leader().equipSlots()
                .map((etypeId, i) => ({ etypeId, index: i }))
                .filter(obj => obj.etypeId !== 1).length;

            const bw = window.RSTH_IH.EQUIP_SLOT_SIZE * slotCount + (slotCount - 1) * window.RSTH_IH.Eqslotmargin;
            const w = bw + window.RSTH_IH.Inventorypadding * 2 + window.RSTH_IH.Eqslotmargin;
            const bh = window.RSTH_IH.EQUIP_SLOT_SIZE + window.RSTH_IH.Inventorypadding * 2;
            const h = bh + window.RSTH_IH.Eqslotmargin;
            const rect = new Rectangle(eqPos.x, eqPos.y, w, h);
            this._equipmentWindow = new window.RSTH_IH.Window_EquipmentSlots(rect);
            this.addWindow(this._equipmentWindow);
            this._equipmentWindow.hide();
            this._equipmentWindow.deactivate();
        }

        // チェスト
        if (typeof window.RSTH_IH.Window_Chest !== "undefined" && !this._chestWindow) {
            const rect = new Rectangle(chestPos.x, chestPos.y, window.RSTH_IH.Inventorywidth, window.RSTH_IH.Inventoryheight);
            this._chestWindow = new window.RSTH_IH.Window_Chest(rect);
            this.addWindow(this._chestWindow);
            this._chestWindow.hide();
            this._chestWindow.deactivate();
        }

        // 作業台ウィンドウ
        if (typeof window.RSTH_IH.Window_Workbench !== "undefined" && !this._workbenchWindow) {
            const rect = new Rectangle(wbPos.x, wbPos.y, window.RSTH_IH.Inventorywidth, window.RSTH_IH.Inventoryheight + 28);
            this._workbenchWindow = new window.RSTH_IH.Window_Workbench(rect);
            this.addWindow(this._workbenchWindow);
            this._workbenchWindow.hide();
            this._workbenchWindow.deactivate();
        }

        // プレイヤーのアイテムとホットバー状態を復元
        this._inventoryWindow.refresh();

        if ($gameSystem._customHotbarItems) {
            this._hotbarWindow.setItems($gameSystem._customHotbarItems);
        }

        this._windowLayer.removeChild(this._inventoryWindow);
        this._windowLayer.removeChild(this._hotbarWindow);
        this._windowLayer.removeChild(this._chestWindow);
        this._windowLayer.removeChild(this._workbenchWindow);
        this._windowLayer.removeChild(this._equipmentWindow);

        this._windowLayer.addChildAt(this._inventoryWindow, 0);
        this._windowLayer.addChildAt(this._hotbarWindow, 0);
        this._windowLayer.addChildAt(this._chestWindow, 0);
        this._windowLayer.addChildAt(this._workbenchWindow, 0);
        this._windowLayer.addChildAt(this._equipmentWindow, 0);

        // 初回アイテム更新
        this.updateInventoryAndHotbar();

        this._rsthCursorSprite = new Sprite(new Bitmap(64, 64));
        this._rsthCursorSprite.z = 9999;
        this._rsthCursorSprite.visible = false;
        this.addChild(this._rsthCursorSprite);

        this._hoverTextSprite = new window.RSTH_IH.Sprite_PopupText();
        this.addChild(this._hoverTextSprite);

        if (RSTH_DEBUG_LOG) console.warn("[createAllWindows]end");
    };

    Scene_Map.prototype.updateInventoryAndHotbar = function () {
        if (window.RSTH_IH.__draggingItem) return;

        const inv = this._inventoryWindow;
        const hotbar = this._hotbarWindow;
        const chest = this._chestWindow;

        const inventoryItems = $gameSystem._customInventoryItems || [];
        const hotbarItems = $gameSystem._customHotbarItems || [];

        inv.setItems(inventoryItems);
        hotbar.setItems(hotbarItems);

        // チェスト：現在開いている座標に対応するチェストを取得して中身を再設定
        const chestPos = this._openedChestPos;
        if (chestPos) {
            const currentChest = window.RSTH_IH.ChestManager.getChestAt(chestPos.x, chestPos.y);
            if (currentChest) {
                chest.setItems(currentChest.items);
            }
        }
    };

    Scene_Map.prototype.RSTH_IH_updateToggleEquipmentWindow = function () {
        if (!this._equipmentWindow) return;

        // キー押下時にトグル
        if (Input.isTriggered("toggleEquipment")) {
            if (this._equipmentWindow.visible) {
                this._equipmentWindow.hide();
                this._equipmentWindow.deactivate();
            } else {
                // 表示前に位置を再計算
                const eqPos = window.RSTH_IH.calculateEquipmentWindowPosition();
                this._equipmentWindow.x = eqPos.x;
                this._equipmentWindow.y = eqPos.y;

                this._equipmentWindow.show();
                this._equipmentWindow.activate();
            }
        }
    };


    window.RSTH_IH.calculateEquipmentWindowPosition = function () {
        const gw = Graphics.boxWidth;
        const gh = Graphics.boxHeight;
        const slotCount = $gameParty.leader().equipSlots()
            .map((etypeId, i) => ({ etypeId, index: i }))
            .filter(obj => obj.etypeId !== 1).length;

        const bw = window.RSTH_IH.EQUIP_SLOT_SIZE * slotCount + (slotCount - 1) * window.RSTH_IH.Eqslotmargin;
        const w = bw + window.RSTH_IH.Inventorypadding * 2 + window.RSTH_IH.Eqslotmargin;
        const bh = window.RSTH_IH.EQUIP_SLOT_SIZE + window.RSTH_IH.Inventorypadding * 2;
        const h = bh + window.RSTH_IH.Eqslotmargin;
        const swheight = window.RSTH_IH.StatusWindowHeight;
        const swsubheight = window.RSTH_IH.StatusSubWindowHeight;
        let x = 0;
        let y = 0;
        let pmargin = 6;
        const scene = SceneManager._scene;

        switch (window.RSTH_IH.EQUIP_POSITION) {
            case "topleft":
                x = pmargin;
                y = pmargin;
                break;
            case "topright":
                x = gw - w - pmargin;
                y = pmargin;
                break;
            case "bottomleft":
                x = pmargin;
                y = gh - h - pmargin;
                break;
            case "bottomright":
                x = gw - w - pmargin;
                y = gh - h - pmargin;
                break;
            case "ori":
                x = pmargin;

                const subHUD = scene._statusSubHUD;
                const mainHUD = scene._statusHUD;
                const mainY = mainHUD ? mainHUD.y + mainHUD.height : 0;

                if (subHUD && subHUD.visible) {
                    y = subHUD.y + subHUD.height + 10;
                } else if (mainHUD) {
                    y = mainY + 10;
                } else {
                    y = pmargin;
                }
                break;

        }

        return { x, y };
    };

    //=============================================================================================================
    // ブロック情報関連===============================================================================================
    //=============================================================================================================
    window.RSTH_IH.parseDropItems = function (tag) {
        if (!tag) return [];
        return tag.split(";").map(entry => {
            const m = /itemId:(\d+),amount:(\d+)/.exec(entry);
            if (m) return { itemId: Number(m[1]), amount: Number(m[2]) };
            return null;
        }).filter(Boolean);
    }

    // 全アイテムのメモ欄を解析し、blockMetaList に保存
    Game_System.prototype.rsthLoadBlockDataFromDatabase = function () {
        if (!this._blockMetaList) this._blockMetaList = [];


        for (const item of $dataItems) {
            if (!item || !item.meta["block"]) continue;

            if (RSTH_DEBUG_LOG) console.log(`[rsthLoadBlockDataFromDatabase] item`, item.id, item.meta);
            const meta = item.meta;

            // tileOffsets1
            let tileOffsets1 = [];
            try {
                tileOffsets1 = item._tileOffsets1Parsed || [];
            } catch (e) {
                if (RSTH_DEBUG_LOG) console.error("[rsthLoadBlockDataFromDatabase] tileOffsets1 JSON parse error:", e, meta.tileOffsets1);
            }

            // tileOffsets2
            let tileOffsets2 = [];
            try {
                tileOffsets2 = item._tileOffsets2Parsed || [];
            } catch (e) {
                if (RSTH_DEBUG_LOG) console.error("[rsthLoadBlockDataFromDatabase] tileOffsets2 JSON parse error:", e, meta.tileOffsets2);
            }

            const data = {
                itemId: item.id,
                name: meta.blockName || item.name,
                tileId: Number(meta.tileId || 0),
                size: JSON.parse(meta.size || "[1,1]"),
                tileset: meta.tileset || "Inside_C",
                growthTime: Number(meta.growthTime || 0),
                tileOffsets1: tileOffsets1,
                tileOffsets2: tileOffsets2,
                dropItems1: window.RSTH_IH.parseDropItems(meta.dropItems1),
                dropItems2: window.RSTH_IH.parseDropItems(meta.dropItems2),
                meta: meta // 全メタを保存（後でブロックへコピー用）
            };

            this._blockMetaList.push(data);

            if (RSTH_DEBUG_LOG) console.log(`[rsthLoadBlockDataFromDatabase] this._blockMetaList`, this._blockMetaList);
        }
    };


    Game_System.prototype.rsthgetBlockMetaByItemId = function (itemId) {
        if (!Array.isArray(this._blockMetaList)) return null;
        return this._blockMetaList.find(b => b.itemId === itemId);
    };

    // MZ標準の地形通行チェック（mobや独自ブロックを除外）
    window.RSTH_IH.isVanillaMapPassable = function (x, y, d = 0) {
        return _Game_Map_isPassable.call($gameMap, x, y, d);
    };

    // ブロックが通行可能、不可能か判定する（重ね置き対応版）
    const _Game_Map_isPassable = Game_Map.prototype.isPassable;
    Game_Map.prototype.isPassable = function (x, y, d = 0) {

        // ここでmobがいるか確認
        if (window.RSTH_IH._mobManager) {
            const hasMob = Object.values(window.RSTH_IH._mobManager._mobs).some(mob => mob._x === x && mob._y === y);
            if (hasMob) {
                return false;
            }
        }
        if (window.RSTH_IH._npcManager) {
            const hasNpc = Object.values(window.RSTH_IH._npcManager._npcs).some(npc => npc._x === x && npc._y === y);
            if (hasNpc) {
                return false;
            }
        }
        /*
        const blocks = window.RSTH_IH.SurvivalBlockManager.getAll(x, y);
        if (blocks && blocks.length > 0) {
            // 最後に設置されたブロック（＝最上層）を取得
            const topBlock = blocks[blocks.length - 1];

            if (topBlock.passable === undefined) {
                if (RSTH_DEBUG_LOG) console.warn("[isPassable] passable が undefined のブロックを検出:", topBlock);
            }

            if (RSTH_DEBUG_LOG) console.warn(`[isPassable] topBlock`, topBlock);
            return topBlock.passable === true;
        }
        */

        return _Game_Map_isPassable.call(this, x, y, d);
    };








})();
