/*:
 * @target MZ
 * @plugindesc RSTH_IH: サバイバルゲームシステムプラグイン
 * @author © 2025 ReSera_りせら（@MOBIUS1001）
 *
 * このソースコードは無断での転載、複製、改変、再配布、商用利用を固く禁じます。
 * 禁止事項の例：
 * - 本ファイルの全部または一部を許可なくコピー、再配布すること
 * - 本ファイルを改変して配布すること
 * - 商用目的での利用
 */

(() => {
    "use strict";

    // ログ出力制御フラグ（trueでログ出力、falseで抑制）
    //const RSTH_DEBUG_LOG = true;
    const RSTH_DEBUG_LOG = false;

    // プレイヤーの周囲にイベントがあるかの判定
    window.RSTH_IH.tryTalkToNearbyEvent = function (targetX, targetY) {
        const playerX = $gamePlayer.x;
        const playerY = $gamePlayer.y;

        const dx = targetX - playerX;
        const dy = targetY - playerY;
        const distance = Math.abs(dx) + Math.abs(dy); // マンハッタン距離

        if (distance > 3) return false; // 距離が3マス超えてたら無視

        const events = $gameMap.eventsXy(targetX, targetY);
        if (events.length === 0) return false;

        const event = events[0];
        if (!event || !event.event()) return false;

        // プレイヤーの向きをそのイベントに向ける
        $gamePlayer.turnTowardCharacter(event);

        // 強制的にそのイベントを開始
        event.start();
    };

    // プレイヤーの周囲にチェストや作業台があるかの判定
    window.RSTH_IH.tryOpenChestToNearby = function (targetX, targetY, blocktype) {
        const playerX = $gamePlayer.x;
        const playerY = $gamePlayer.y;

        const dx = targetX - playerX;
        const dy = targetY - playerY;
        const distance = Math.abs(dx) + Math.abs(dy);

        if (distance > 3) return false; // 距離が3マス超えてたら無視

        const mapX = $gameMap.canvasToMapX(TouchInput.x);
        const mapY = $gameMap.canvasToMapY(TouchInput.y);


        if (RSTH_DEBUG_LOG) console.log(`[tryOpenChestToNearby]mapX ${mapX} mapY ${mapY}`);

        /*
        const block = window.RSTH_IH.SurvivalBlockManager.get(mapX, mapY);
        if (!block) return false;
        if (RSTH_DEBUG_LOG) console.log(`[tryOpenChestToNearby]block`, block);
        if (block.blockType === blocktype) {
            return true;
        } else {
            return false;

        }
        */
    };



    // 右クリックでアイテム使用かイベントと会話か判定して実行
    TouchInput._onRightButtonDown = function (event) {
        if (!(SceneManager._scene instanceof Scene_Map)) return;

        if ($gameMessage.isBusy()) return;
        const x = Graphics.pageToCanvasX(event.pageX);
        const y = Graphics.pageToCanvasY(event.pageY);

        const scene = SceneManager._scene;
        // 以下のウィンドウ内かどうか判定
        const isInWindow =
            window.RSTH_IH.isInsideWindow(scene._inventoryWindow, x, y) ||
            window.RSTH_IH.isInsideWindow(scene._hotbarWindow, x, y) ||
            window.RSTH_IH.isInsideWindow(scene._chestWindow, x, y) ||
            window.RSTH_IH.isInsideWindow(scene._equipmentWindow, x, y);


        if (!isInWindow && Graphics.isInsideCanvas(x, y)) {

            const tileX = $gameMap.canvasToMapX(x);
            const tileY = $gameMap.canvasToMapY(y);

            let noneevents = window.RSTH_IH.tryTalkToNearbyEvent(tileX, tileY);
            noneevents = noneevents ?? true;
            if (RSTH_DEBUG_LOG) console.log("noneevents", noneevents);

            // 右クリックした位置がイベントではない場合
            if (!noneevents) {
                //const existChest = window.RSTH_IH.tryOpenChestToNearby(tileX, tileY, "chest");
                const existChest = false;
                if (RSTH_DEBUG_LOG) console.log("existChest", existChest);

                //const existWorkbench = window.RSTH_IH.tryOpenChestToNearby(tileX, tileY, "workbench");
                const existWorkbench = false;
                if (RSTH_DEBUG_LOG) console.log("tileX", tileX, "tileY", tileY);

                // チェストブロックを右クリックした場合
                if (existChest === true) {
                    if (!scene._chestWindow.visible) {
                        const chest = window.RSTH_IH.ChestManager.getChestAt(tileX, tileY);
                        if (chest) {
                            const cols = chest.cols;
                            const rows = chest.rows;
                            const slotSize = window.RSTH_IH.InventorySlotSize;
                            const margin = window.RSTH_IH.Inventorymargin;
                            const padding = 12; // 通常のWindow_Selectableのpaddingと同等

                            const contentswidth = cols * slotSize + (cols - 1) * margin;
                            const contentsheight = rows * slotSize + (rows - 1) * margin;
                            const width = contentswidth + padding * 2 + margin;
                            const height = contentsheight + padding * 2 + margin;

                            scene._openedChestPos = { x: tileX, y: tileY };

                            // サイズ更新
                            const hotbarPos = window.RSTH_IH.calculateHotbarPosition();
                            const chestPos = window.RSTH_IH.calculateChestPosition(hotbarPos.x, hotbarPos.y, width, height);
                            scene._chestWindow.move(chestPos.x, chestPos.y, width, height);

                            scene._chestWindow.setSize(cols, rows);
                            scene._chestWindow.setItems(chest.items);

                            if (!scene._inventoryWindow.visible) {
                                scene._inventoryWindow.show();
                                scene._inventoryWindow.select(0);
                                scene._inventoryWindow.refresh();
                            }

                            scene._chestWindow.show();
                            scene._chestWindow.activate();
                        }
                    } else {
                        //カーソルをホットバーのインデックスへ
                        if (scene._hotbarWindow && window.RSTH_IH.HobarSlotsIndex != null) {
                            if (window.RSTH_IH.HobarSlotsIndex === -1) window.RSTH_IH.HobarSlotsIndex = 0;
                            scene.updateCursorForSlot(window.RSTH_IH.HobarSlotsIndex, scene._hotbarWindow);
                        }

                        scene._chestWindow.hide();
                        scene._chestWindow.deactivate();
                    }

                } else if (existChest === false) {
                    if (scene._chestWindow.visible) {

                        //カーソルをホットバーのインデックスへ
                        if (scene._hotbarWindow && window.RSTH_IH.HobarSlotsIndex != null) {
                            if (window.RSTH_IH.HobarSlotsIndex === -1) window.RSTH_IH.HobarSlotsIndex = 0;
                            scene.updateCursorForSlot(window.RSTH_IH.HobarSlotsIndex, scene._hotbarWindow);
                        }
                        scene._chestWindow.hide();
                        scene._chestWindow.deactivate();
                    }
                    // 作業台ブロックを右クリックした場合
                    if (existWorkbench === true) {

                        if (!scene._inventoryWindow.visible) {
                            scene._inventoryWindow.show();
                            scene._inventoryWindow.select(0);
                            scene._inventoryWindow.refresh();
                        }


                        if (scene._chestWindow.visible) {
                            scene._chestWindow.hide();
                            scene._chestWindow.deactivate();

                        }

                        if (scene && scene.showWorkbench) {
                            scene.showWorkbench();
                        }
                    } else {

                        //カーソルをホットバーのインデックスへ
                        if (scene._hotbarWindow && window.RSTH_IH.HobarSlotsIndex != null) {
                            if (window.RSTH_IH.HobarSlotsIndex === -1) window.RSTH_IH.HobarSlotsIndex = 0;
                            scene.updateCursorForSlot(window.RSTH_IH.HobarSlotsIndex, scene._hotbarWindow);
                        }
                        if (scene._workbenchWindow.visible) {
                            scene._workbenchWindow.hide();
                            scene._workbenchWindow.deactivate();
                        }
                        // ホットバーで選択されているアイテムを使用する
                        const hotbar = scene && scene._hotbarWindow;
                        if (hotbar && hotbar.visible && SceneManager._scene instanceof Scene_Map) {
                            // ホットバー座標からindexを取得
                            if (!window.RSTH_IH.HobarSlotsIndex) window.RSTH_IH.HobarSlotsIndex = 0;
                            const index = window.RSTH_IH.HobarSlotsIndex;
                            const items = hotbar.items[index];
                            if (RSTH_DEBUG_LOG) console.log("右クリックでホットバー使用を試行");

                            if (items) {
                                if (items.type === "block") {

                                    const distance = $gameMap.distance($gamePlayer.x, $gamePlayer.y, tileX, tileY);
                                    if (distance <= 3) {

                                        if (RSTH_DEBUG_LOG) console.log(`ホットバーのカーソル index ${index} のブロックアイテムを使用:`, items);
                                        window.RSTH_IH.useInventoryItem(items, "hotbar", index, { x: tileX, y: tileY });
                                        return;
                                    } else {
                                        if (RSTH_DEBUG_LOG) console.warn("設置不可な位置または距離超過_distance=", distance);
                                    }

                                } else if (items.type === "item") {
                                    if (RSTH_DEBUG_LOG) console.log(`ホットバーのカーソル index ${index} のアイテムを使用:`, items);
                                    window.RSTH_IH.useInventoryItem(items, "hotbar", index);
                                    return;
                                }
                            } else {
                                if (RSTH_DEBUG_LOG) console.log(`カーソル index ${index} にアイテムが存在しません`);
                            }
                        }
                    }

                }
                const canplace = window.RSTH_IH.noitemcanPlaceBlockAt(tileX, tileY,)
                const existDoor = window.RSTH_IH.tryOpenChestToNearby(tileX, tileY, "door");
                if (existDoor === true && canplace === true) {
                    window.RSTH_IH.SurvivalBlockManager.replace(tileX, tileY);
                }

            }

        }

        event.preventDefault?.();
        event.stopPropagation?.();
    };


    // ウィンドウの矩形範囲内かをチェック（画面座標基準）
    window.RSTH_IH.isInsideWindow = function (win, screenX, screenY) {
        if (!win || !win.visible || win.openness <= 0) return false;

        const wx = win.x;
        const wy = win.y;
        const ww = win.width;
        const wh = win.height;

        return (
            screenX >= wx &&
            screenX < wx + ww &&
            screenY >= wy &&
            screenY < wy + wh
        );
    };


    // 左クリック検出
    window.RSTH_IH.onLeftButtonDown = function (key = false) {
        if (TouchInput.isTriggered() || key) {

            if ($gameMessage.isBusy()) return;

            const x = TouchInput.x;
            const y = TouchInput.y;
            if (RSTH_DEBUG_LOG) console.log("左クリック！ x:", x, "y:", y);

            // 画面内のクリックか判定（Graphicsクラスで）
            if (Graphics.isInsideCanvas(x, y)) {
                if (RSTH_DEBUG_LOG) console.log("キャンバス内を左クリック：", x, y);

                const scene = SceneManager._scene;

                // 以下のウィンドウ内かどうか判定
                const isInWindow =
                    window.RSTH_IH.isInsideWindow(scene._inventoryWindow, x, y) ||
                    window.RSTH_IH.isInsideWindow(scene._hotbarWindow, x, y) ||
                    window.RSTH_IH.isInsideWindow(scene._chestWindow, x, y) ||
                    window.RSTH_IH.isInsideWindow(scene._equipmentWindow, x, y);

                const hotbar = scene && scene._hotbarWindow;
                if (RSTH_DEBUG_LOG) console.log("isInWindow", isInWindow);

                if (!isInWindow && hotbar && hotbar.visible && SceneManager._scene instanceof Scene_Map) {
                    // ホットバー座標からindexを取得
                    if (!window.RSTH_IH.HobarSlotsIndex) window.RSTH_IH.HobarSlotsIndex = 0;

                    const mapX = $gameMap.canvasToMapX(TouchInput.x);
                    const mapY = $gameMap.canvasToMapY(TouchInput.y);
                    const index = window.RSTH_IH.HobarSlotsIndex;
                    const items = hotbar.items[index];
                    if (!items) return;

                    const distance = $gameMap.distance($gamePlayer.x, $gamePlayer.y, mapX, mapY);

                    //武器かツールで区別
                    if (items.type === "weapon") {

                        const leader = $gameParty.leader();
                        if (leader && leader.hasState(11)) return;

                        let wTypeBow = false;
                        let orbit = false;
                        let boomerang = false;
                        let knife = false;
                        let areaAttack = false;
                        let skillAttack = false;
                        let skillState = false;
                        let skillA = false;
                        let skillB = false;
                        let skillC = false;
                        if ($dataWeapons[items.id]?.wtypeId === 7) wTypeBow = true;
                        if ($dataWeapons[items.id]?.meta?.orbit) orbit = true;
                        if ($dataWeapons[items.id]?.meta?.boomerang) boomerang = true;
                        if ($dataWeapons[items.id]?.meta?.knife) knife = true;
                        if ($dataWeapons[items.id]?.meta?.areaAttack) areaAttack = true;
                        if ($dataWeapons[items.id]?.meta?.skill) skillAttack = true;
                        if ($dataWeapons[items.id]?.meta?.state) skillState = true;
                        if ($dataWeapons[items.id]?.meta?.skill === "A") skillA = true;
                        if ($dataWeapons[items.id]?.meta?.skill === "B") skillB = true;
                        if ($dataWeapons[items.id]?.meta?.skill === "C") skillC = true;

                        //const canAttack = wTypeBow || orbit || boomerang || knife || areaAttack || (distance <= 3);
                        const canAttack = wTypeBow || orbit || boomerang || knife || areaAttack || skillAttack || skillState;

                        if (canAttack) {
                            if (window.RSTH_IH._skillA_Cooldown <= 0 && skillA) {
                                if (items.id === 44) { // バニシングストライク
                                    AudioManager.playSe({ name: "Magic10", pan: 0, pitch: 100, volume: 10 });
                                }
                                else if (items.id === 78) { // ソードレイン
                                    AudioManager.playSe({ name: "Magic6", pan: 0, pitch: 100, volume: 15 });
                                }
                                else if (items.id === 71) { // グラビトンウェーブ
                                    AudioManager.playSe({ name: "Magic7", pan: 0, pitch: 100, volume: 5 });
                                }
                                else if (items.id === 118) { // サザンクロス
                                    AudioManager.playSe({ name: "Wind9", pan: 0, pitch: 100, volume: 15 });
                                }
                                else if (items.id === 121) { // わっしょい
                                    AudioManager.playSe({ name: "washoi", pan: 0, pitch: (Math.random() * 20 + 100), volume: 90 });
                                }
                                else {
                                    AudioManager.playSe({ name: "Float1", pan: 0, pitch: 100, volume: 10 });
                                }

                                //AudioManager.playSe($dataSystem.sounds[23]);
                                if (skillState) {
                                    window.RSTH_IH.useSkillState(items);

                                } else {
                                    window.RSTH_IH.useWeapon(items, index, mapX, mapY);

                                }

                                const cooltime = window.RSTH_IH.atkCooltime(items);
                                window.RSTH_IH._skillA_Cooldown = cooltime;

                                window.RSTH_IH._cooldownMap = window.RSTH_IH._cooldownMap || {};
                                window.RSTH_IH._cooldownMap[index] = {
                                    skillType: "A",
                                    duration: cooltime,
                                    remaining: cooltime
                                };
                            }
                            else if (window.RSTH_IH._skillB_Cooldown <= 0 && skillB) {


                                //console.log(`$dataWeapons[items.id]`, $dataWeapons[items.id]);
                                if (items.id === 119) {
                                    AudioManager.playSe($dataSystem.sounds[8]);
                                    //console.log(`$dataWeapons[items.id]2`, $dataWeapons[items.id]);
                                    window.RSTH_IH.useSkillState(items);
                                    //console.log(`$dataWeapons[items.id]3`, $dataWeapons[items.id]);
                                    window.RSTH_IH.useWeapon(items, index, mapX, mapY);
                                } else {
                                    AudioManager.playSe({ name: "Particles1", pan: 0, pitch: 100, volume: 15 });
                                    //AudioManager.playSe($dataSystem.sounds[23]);
                                    if (skillState) {
                                        window.RSTH_IH.useSkillState(items);
                                    } else {
                                        window.RSTH_IH.useWeapon(items, index, mapX, mapY);

                                    }
                                }


                                const cooltime = window.RSTH_IH.atkCooltime(items);
                                window.RSTH_IH._skillB_Cooldown = cooltime;

                                window.RSTH_IH._cooldownMap = window.RSTH_IH._cooldownMap || {};
                                window.RSTH_IH._cooldownMap[index] = {
                                    skillType: "B",
                                    duration: cooltime,
                                    remaining: cooltime
                                };

                            }
                            else if (window.RSTH_IH._skillC_Cooldown <= 0 && skillC) {

                                //AudioManager.playSe($dataSystem.sounds[23]);
                                if (items.id === 49) {
                                    AudioManager.playSe({ name: "Laser2", pan: 0, pitch: 80, volume: 20 });
                                } else {
                                    AudioManager.playSe({ name: "Up6", pan: 0, pitch: 100, volume: 20 });
                                }

                                if (skillState) {
                                    window.RSTH_IH.useSkillState(items);

                                } else {
                                    window.RSTH_IH.useWeapon(items, index, mapX, mapY);

                                }

                                const cooltime = window.RSTH_IH.atkCooltime(items);
                                window.RSTH_IH._skillC_Cooldown = cooltime;

                                window.RSTH_IH._cooldownMap = window.RSTH_IH._cooldownMap || {};
                                window.RSTH_IH._cooldownMap[index] = {
                                    skillType: "C",
                                    duration: cooltime,
                                    remaining: cooltime
                                };
                            }
                            /*
                            else if (window.RSTH_IH._weaponCooldown <= 0) {
                                if (skillState) {
                                    window.RSTH_IH.useSkillState(items);

                                } else {
                                    window.RSTH_IH.useWeapon(items, index, mapX, mapY);

                                }
                                const cooltime = window.RSTH_IH.atkCooltime(items);
                                window.RSTH_IH._weaponCooldown = cooltime;  // 1秒クールタイム発動

                                window.RSTH_IH._cooldownMap = window.RSTH_IH._cooldownMap || {};
                                for (let i = 0; i < 10; i++) {
                                    if (hotbar.items[i]) {
                                        const wtype = hotbar.items[i]?.type ?? "undifined";
                                        if (wtype === "weapon") {
                                            window.RSTH_IH._cooldownMap[i] = {
                                                duration: cooltime,
                                                remaining: cooltime
                                            };
                                        } else {
                                            continue;
                                        }
                                    }
                                }
                            }
                                */
                            else {
                                if (RSTH_DEBUG_LOG) console.log("クールタイム中で使用不可");
                            }
                            return;
                        }
                    } else if (items.type === "tool" && distance <= 3) {

                        if (RSTH_DEBUG_LOG) console.log(`ホットバーのカーソル index ${index} のアイテムを使用:`, items);
                        window.RSTH_IH.useInventoryItem(items, "hotbar", index);
                        return;
                    } else {
                        if (RSTH_DEBUG_LOG) console.log(`カーソル index ${index} にアイテムが存在しません`);
                        return;
                    }
                }
            } else {
                if (RSTH_DEBUG_LOG) console.log(`クリック位置が範囲外`);
                return;
            }
        }
    }

    // 左クリック長押しで連続攻撃
    window.RSTH_IH.updateWeaponHold = function () {
        if ($gameMessage.isBusy()) return;

        const leader = $gameParty.leader();
        if (leader && leader.hasState(11)) return;

        const scene = SceneManager._scene;
        const hotbar = scene && scene._hotbarWindow;
        if (!hotbar || !hotbar.visible || !(SceneManager._scene instanceof Scene_Map)) return;

        const index = window.RSTH_IH.HobarSlotsIndex;
        const items = hotbar.items[index];

        if (!items || items.type !== "weapon") {
            return;
        }

        let wTypeBow = false;
        let orbit = false;
        let boomerang = false;
        let knife = false;
        let areaAttack = false;
        let skillAttack = false;
        let skillState = false;
        let skillA = false;
        let skillB = false;
        let skillC = false;
        if ($dataWeapons[items.id]?.wtypeId === 7) wTypeBow = true;
        if ($dataWeapons[items.id]?.meta?.orbit) orbit = true;
        if ($dataWeapons[items.id]?.meta?.boomerang) boomerang = true;
        if ($dataWeapons[items.id]?.meta?.knife) knife = true;
        if ($dataWeapons[items.id]?.meta?.areaAttack) areaAttack = true;
        if ($dataWeapons[items.id]?.meta?.skill) skillAttack = true;
        if ($dataWeapons[items.id]?.meta?.state) skillState = true;
        if ($dataWeapons[items.id]?.meta?.skill === "A") skillA = true;
        if ($dataWeapons[items.id]?.meta?.skill === "B") skillB = true;
        if ($dataWeapons[items.id]?.meta?.skill === "C") skillC = true;

        if (TouchInput.isPressed()) {
            if (window.RSTH_IH._weaponCooldown <= 0) {
                const mapX = $gameMap.canvasToMapX(TouchInput.x);
                const mapY = $gameMap.canvasToMapY(TouchInput.y);
                const distance = $gameMap.distance($gamePlayer.x, $gamePlayer.y, mapX, mapY);

                //const canAttack = wTypeBow || orbit || boomerang || knife || areaAttack || (distance <= 3);
                const canAttack = wTypeBow || orbit || boomerang || knife || areaAttack || skillAttack;

                if (canAttack) {
                    if (window.RSTH_IH._skillA_Cooldown <= 0 && skillA) {
                        if (items.id === 44) { // バニシングストライク
                            AudioManager.playSe({ name: "Magic10", pan: 0, pitch: 100, volume: 10 });
                        }
                        else if (items.id === 78) { // ソードレイン
                            AudioManager.playSe({ name: "Magic6", pan: 0, pitch: 100, volume: 15 });
                        }
                        else if (items.id === 71) { // グラビトンウェーブ
                            AudioManager.playSe({ name: "Magic7", pan: 0, pitch: 100, volume: 5 });
                        }
                        else if (items.id === 118) { // サザンクロス
                            AudioManager.playSe({ name: "Wind9", pan: 0, pitch: 100, volume: 15 });
                        }
                        else if (items.id === 121) { // わっしょい
                            AudioManager.playSe({ name: "washoi", pan: 0, pitch: (Math.random() * 20 + 100), volume: 90 });
                        }
                        else {
                            AudioManager.playSe({ name: "Float1", pan: 0, pitch: 100, volume: 10 });
                        }

                        if (skillState) {
                            window.RSTH_IH.useSkillState(items);

                        } else {
                            window.RSTH_IH.useWeapon(items, index, mapX, mapY);

                        }

                        const cooltime = window.RSTH_IH.atkCooltime(items);
                        window.RSTH_IH._skillA_Cooldown = cooltime;

                        window.RSTH_IH._cooldownMap = window.RSTH_IH._cooldownMap || {};
                        window.RSTH_IH._cooldownMap[index] = {
                            skillType: "A",
                            duration: cooltime,
                            remaining: cooltime
                        };
                    }
                    else if (window.RSTH_IH._skillB_Cooldown <= 0 && skillB) {

                        if (items.id === 119) {
                            AudioManager.playSe($dataSystem.sounds[8]);
                            window.RSTH_IH.useSkillState(items);
                            window.RSTH_IH.useWeapon(items, index, mapX, mapY);
                        } else {
                            AudioManager.playSe({ name: "Particles1", pan: 0, pitch: 100, volume: 15 });

                            //AudioManager.playSe($dataSystem.sounds[23]);
                            if (skillState) {
                                window.RSTH_IH.useSkillState(items);
                            } else {
                                window.RSTH_IH.useWeapon(items, index, mapX, mapY);

                            }
                        }


                        const cooltime = window.RSTH_IH.atkCooltime(items);
                        window.RSTH_IH._skillB_Cooldown = cooltime;

                        window.RSTH_IH._cooldownMap = window.RSTH_IH._cooldownMap || {};
                        window.RSTH_IH._cooldownMap[index] = {
                            skillType: "B",
                            duration: cooltime,
                            remaining: cooltime
                        };

                    }
                    else if (window.RSTH_IH._skillC_Cooldown <= 0 && skillC) {

                        //AudioManager.playSe($dataSystem.sounds[23]);
                        if (items.id === 49) {
                            AudioManager.playSe({ name: "Laser2", pan: 0, pitch: 80, volume: 20 });
                        } else {
                            AudioManager.playSe({ name: "Up6", pan: 0, pitch: 100, volume: 20 });
                        }

                        if (skillState) {
                            window.RSTH_IH.useSkillState(items);

                        } else {
                            window.RSTH_IH.useWeapon(items, index, mapX, mapY);

                        }

                        const cooltime = window.RSTH_IH.atkCooltime(items);
                        window.RSTH_IH._skillC_Cooldown = cooltime;

                        window.RSTH_IH._cooldownMap = window.RSTH_IH._cooldownMap || {};
                        window.RSTH_IH._cooldownMap[index] = {
                            skillType: "C",
                            duration: cooltime,
                            remaining: cooltime
                        };
                    }
                    /*
                    else if (window.RSTH_IH._weaponCooldown <= 0) {
                        if (skillState) {
                            window.RSTH_IH.useSkillState(items);

                        } else {
                            window.RSTH_IH.useWeapon(items, index, mapX, mapY);

                        }
                        const cooltime = window.RSTH_IH.atkCooltime(items);
                        window.RSTH_IH._weaponCooldown = cooltime;  // 1秒クールタイム発動

                        window.RSTH_IH._cooldownMap = window.RSTH_IH._cooldownMap || {};
                        for (let i = 0; i < 10; i++) {
                            if (hotbar.items[i]) {
                                const wtype = hotbar.items[i]?.type ?? "undifined";
                                if (wtype === "weapon") {
                                    window.RSTH_IH._cooldownMap[i] = {
                                        duration: cooltime,
                                        remaining: cooltime
                                    };
                                } else {
                                    continue;
                                }
                            }
                        }
                    }
                        */
                    else {
                        if (RSTH_DEBUG_LOG) console.log("クールタイム中で使用不可");
                    }
                    return;
                }
            }
        }
    };

    // 武器のエフェクト
    // 1枚の共通テクスチャを生成して使い回す
    window.RSTH_IH.WeaponAreaEffectTexture = null;

    window.RSTH_IH.getWeaponAreaEffectTexture = function (tileSize) {
        if (window.RSTH_IH.WeaponAreaEffectTexture) return window.RSTH_IH.WeaponAreaEffectTexture;

        const graphics = new PIXI.Graphics();
        graphics.beginFill(0xffff80, 0.5); // 半透明黄色
        graphics.drawRect(-tileSize / 2, -tileSize / 2, tileSize, tileSize);
        graphics.endFill();

        // Graphics → Texture化
        const texture = Graphics.app.renderer.generateTexture(graphics);
        window.RSTH_IH.WeaponAreaEffectTexture = texture;

        return texture;
    };

    window.RSTH_IH.createWeaponAreaEffectSprite = function (txList) {
        const tw = $gameMap.tileWidth();
        const th = $gameMap.tileHeight();
        const dx = $gameMap.displayX();
        const dy = $gameMap.displayY();

        // 範囲の左上基準点を決める
        const xs = txList.map(p => p.x);
        const ys = txList.map(p => p.y);
        const minX = Math.min(...xs);
        const minY = Math.min(...ys);

        // Graphics で描く範囲サイズ
        const width = (Math.max(...xs) - minX + 1) * tw;
        const height = (Math.max(...ys) - minY + 1) * th;

        const graphics = new PIXI.Graphics();
        graphics.beginFill(0xffff80, 0.5);

        // 各タイルをローカル座標で描く
        txList.forEach(pos => {
            const localX = (pos.x - minX) * tw;
            const localY = (pos.y - minY) * th;
            graphics.drawRect(localX, localY, tw, th);
        });

        graphics.endFill();

        const texture = Graphics.app.renderer.generateTexture(graphics);
        const sprite = new PIXI.Sprite(texture);

        sprite.anchor.set(0, 0);

        // ワールド座標に変換して位置セット
        sprite.x = Math.round((minX - dx) * tw);
        sprite.y = Math.round((minY - dy) * th) - 32;

        sprite.alpha = 1;
        sprite._frameCount = 0;
        sprite._lifespan = 20;

        sprite.update = function () {
            this._frameCount++;
            this.alpha -= 1 / this._lifespan;
            if (this._frameCount >= this._lifespan) {
                if (this.parent) this.parent.removeChild(this);
                this.destroy({ children: true, texture: true, baseTexture: true });
            }
        };

        return sprite;
    };



    // Spriteクラス
    window.RSTH_IH.Sprite_WeaponAreaEffect = class extends PIXI.Sprite {
        constructor(x, y, tileSize, range) {
            //console.log("window.RSTH_IH.Sprite_WeaponAreaEffect");

            super(window.RSTH_IH.getWeaponAreaEffectTexture(tileSize));

            this.anchor.set(0.5, 0.5);

            this.x = x;
            this.y = y - 32;

            this._frameCount = 0;
            this._lifespan = 30;

            this.scale.set(range);
            this.z = 10;
        }

        update() {
            this._frameCount++;
            this.alpha -= 1 / this._lifespan; // opacity 相当

            if (this._frameCount >= this._lifespan) {
                if (this.parent) this.parent.removeChild(this);
                this.destroy({ children: true });
            }
        }
    };



    // Spriteset_Map にレイヤーを追加する
    Spriteset_Map.prototype.createRSTHEffectLayer = function () {
        if (!this._rsthEffectLayer) {
            this._rsthEffectLayer = new Sprite();
            this._rsthEffectLayer.z = 10;
            this._tilemap.addChild(this._rsthEffectLayer);
            //console.log("[RSTH] EffectLayer created");
        }
    };

    // 既存の createLowerLayer に必ず組み込む
    const _Spriteset_Map_createLowerLayer = Spriteset_Map.prototype.createLowerLayer;
    Spriteset_Map.prototype.createLowerLayer = function () {
        _Spriteset_Map_createLowerLayer.call(this);
        this.createRSTHEffectLayer();
    };




    // ドラッグをリセット
    window.RSTH_IH.resetDragging = function () {
        window.RSTH_IH.__draggingItem = null;
        window.RSTH_IH.__draggingFrom = null;
        window.RSTH_IH.__draggingIndex = null;
    }


    // キー入力でインベントリの開閉
    document.addEventListener("keydown", (event) => {
        const scene = SceneManager._scene;

        // シーンとインベントリウィンドウの存在確認
        if (!(scene instanceof Scene_Map) || !scene._inventoryWindow) return;

        const inventoryWindow = scene._inventoryWindow;

        if (window.RSTH_IH.toggleInventoryKey) {
            if (event.key === "e" || event.key === "E") {
                if (inventoryWindow.visible) {
                    window.RSTH_IH.hideWindows();
                } else {
                    inventoryWindow.show();

                    inventoryWindow.select(0);
                    inventoryWindow.activate();
                    inventoryWindow.refresh(); // ウィンドウ表示時にリフレッシュ
                }
            }
        }
    });

    // アイテムを挿入できるスロット位置（index）を返す関数
    window.RSTH_IH.findInsertSlot = function (slots, item, count = 1) {
        const type = window.RSTH_IH.getItemType(item);
        let maxStack = ["weapon", "armor", "tool"].includes(type) ? 1 : window.RSTH_IH.StackSize;

        //console.log("item", item);

        // スタック可能なスロットを探す
        for (let i = 0; i < slots.length; i++) {
            const slot = slots[i];
            if (slot && slot.id === item.id && slot.type === type && slot.count + count <= maxStack) {
                return i;
            }
        }

        // 空きスロットを探す
        for (let i = 0; i < slots.length; i++) {
            if (!slots[i]) return i;
        }

        return -1; // 見つからなかった場合
    };

    // インベントリに空きが1以上あるかどうか
    window.RSTH_IH.canInsertToInventory = function (item, count = 1) {
        const slots = $gameSystem._customInventoryItems || [];
        return window.RSTH_IH.findInsertSlot(slots, item, count) >= 0;
    };

    // ホットバーに空きが1以上あるかどうか
    window.RSTH_IH.canInsertToHotbar = function (item, count = 1) {
        const slots = $gameSystem._customHotbarItems || [];
        return window.RSTH_IH.findInsertSlot(slots, item, count) >= 0;
    };

    // インベントリ、ホットバーが満杯の時に、メニューの装備欄から防具を外した場合の処理
    const _Game_Actor_changeEquip = Game_Actor.prototype.changeEquip;
    Game_Actor.prototype.changeEquip = function (slotId, item, auto = 0) {
        const oldItem = this.equips()[slotId];

        // RSTH制御：装備を外す場合のみ（item == null）
        if (!item && oldItem && typeof window.RSTH_IH !== "undefined") {
            const canAddToInv = window.RSTH_IH.canInsertToInventory(oldItem, 1);
            const canAddToHotbar = window.RSTH_IH.canInsertToHotbar(oldItem, 1);
            if (!canAddToInv && !canAddToHotbar) {
                if (RSTH_DEBUG_LOG) console.warn("[_Game_Actor_changeEquip] 装備を外せません：インベントリとホットバーが満杯");
                SoundManager.playBuzzer(); // 任意：音を鳴らす
                return; // 装備解除キャンセル
            }
        }

        // 通常の処理へ
        _Game_Actor_changeEquip.call(this, slotId, item);
    };

    // 指定アイテムがインベントリまたはホットバーに存在するか
    window.RSTH_IH.hasItem = function (item) {
        if (!item) return false;
        const type = window.RSTH_IH.getItemType(item);
        const inv = $gameSystem._customInventoryItems || [];
        const hot = $gameSystem._customHotbarItems || [];

        const existsInInv = inv.some(slot => slot && slot.id === item.id && slot.type === type);
        const existsInHot = hot.some(slot => slot && slot.id === item.id && slot.type === type);

        return existsInInv || existsInHot;
    };

    // ブロックを置けるかチェック
    window.RSTH_IH.canPlaceBlockAt = function (x, y, item) {
        if (RSTH_DEBUG_LOG) console.log(`[canPlaceBlockAt]item`, item, `item.meta`, item.meta);

        if (!item || !item.meta || !item.meta.tileOffsets1) return false;
        const placingType = item.meta.blockType;
        if (!placingType) return false;

        try {
            const tileOffsets = JSON.parse(item.meta.tileOffsets1);
            if (!Array.isArray(tileOffsets)) return false;

            for (const offset of tileOffsets) {
                const dx = Number(offset.dx || 0);
                const dy = Number(offset.dy || 0);
                const px = x + dx;
                const py = y + dy;

                if (RSTH_DEBUG_LOG) console.warn(`[canPlaceBlockAt]offset`, offset);

                // マップ外チェック
                if (px < 0 || py < 0 || px >= $gameMap.width() || py >= $gameMap.height()) {
                    if (RSTH_DEBUG_LOG) console.warn(`[canPlaceBlockAt] (${px},${py})がマップ外。設置不可`);
                    return false;
                }

                // 通行不可タイルチェック
                if (!$gameMap.checkPassage(px, py, 0x0f)) {
                    if (RSTH_DEBUG_LOG) console.warn(`[canPlaceBlockAt] (${px}, ${py}) は通行不可タイル。設置不可`);
                    return false;
                }

                // イベント存在チェック
                if ($gameMap.eventsXy(px, py).length > 0) {
                    if (RSTH_DEBUG_LOG) console.warn(`[canPlaceBlockAt] (${px}, ${py}) にイベントが存在。設置不可`);
                    return false;
                }

                // プレイヤー座標チェック
                if ($gamePlayer.x === px && $gamePlayer.y === py) {
                    if (RSTH_DEBUG_LOG) console.warn(`[canPlaceBlockAt] (${px}, ${py}) はプレイヤーの位置。設置不可`);
                    return false;
                }

                // 既存ブロックとの blockType 互換性チェック
                const existingBlock = window.RSTH_IH.SurvivalBlockManager.get(px, py);
                if (existingBlock) {
                    const existingItem = $dataItems[existingBlock.itemId];
                    const baseType = existingItem?.meta?.blockType;
                    if (!baseType) return false;

                    const allowed = (
                        (baseType === "ground" && ["floor", "wall", "furniture", "door", "plant", "chest", "workbench"].includes(placingType)) ||
                        (baseType === "floor" && ["wall", "furniture", "door", "plant", "chest", "workbench"].includes(placingType))
                    );
                    if (!allowed) {
                        if (RSTH_DEBUG_LOG) console.warn(`[canPlaceBlockAt] blockType incompatibility: cannot place ${placingType} on ${baseType}`);
                        return false;
                    }
                }
            }

            return true;
        } catch (e) {
            if (RSTH_DEBUG_LOG) console.warn(`[canPlaceBlockAt] JSON解析エラー`, e);
            return false;
        }
    };

    // ブロックを置けるかチェック(item無しverでそのマスのみ判定)
    window.RSTH_IH.noitemcanPlaceBlockAt = function (x, y) {
        if (RSTH_DEBUG_LOG) console.log(`[noitemcanPlaceBlockAt]start`);

        // マップ外チェック
        if (x < 0 || y < 0 || x >= $gameMap.width() || y >= $gameMap.height()) {
            if (RSTH_DEBUG_LOG) console.warn(`[noitemcanPlaceBlockAt] (${x},${y})がマップ外。設置不可`);
            return false;
        }

        // 通行不可タイルチェック
        if (!$gameMap.checkPassage(x, y, 0x0f)) {
            if (RSTH_DEBUG_LOG) console.warn(`[noitemcanPlaceBlockAt] (${x}, ${y}) は通行不可タイル。設置不可`);
            return false;
        }

        // イベント存在チェック
        if ($gameMap.eventsXy(x, y).length > 0) {
            if (RSTH_DEBUG_LOG) console.warn(`[noitemcanPlaceBlockAt] (${x}, ${y}) にイベントが存在。設置不可`);
            return false;
        }

        // プレイヤー座標チェック
        if ($gamePlayer.x === x && $gamePlayer.y === y) {
            if (RSTH_DEBUG_LOG) console.warn(`[noitemcanPlaceBlockAt] (${x}, ${y}) はプレイヤーの位置。設置不可`);
            return false;
        }
        return true;
    };


    // 独自のカーソルの描画
    Scene_Map.prototype.updateCursorForSlot = function (index, windowInstance) {
        if (!this._rsthCursorSprite) return;

        const sprite = this._rsthCursorSprite;

        // メッセージ表示中なら非表示にする
        if ($gameMessage.isBusy()) {
            sprite.visible = false;
            sprite.bitmap.clear();
            return;
        }

        const rect = windowInstance.itemRect(index);
        const padding = 4; // 外側に広げる余白
        const borderWidth = 4; // 線の太さ
        const color = "#ffff44"; // 線の色

        // サイズ変更
        const w = rect.width + padding * 2;
        const h = rect.height + padding * 2;

        if (sprite.bitmap.width !== w || sprite.bitmap.height !== h) {
            sprite.bitmap = new Bitmap(w, h);
        } else {
            sprite.bitmap.clear();
        }

        const bmp = sprite.bitmap;

        // 四辺に太線を描く
        bmp.fillRect(0, 0, w, borderWidth, color); // 上
        bmp.fillRect(0, h - borderWidth, w, borderWidth, color); // 下
        bmp.fillRect(0, 0, borderWidth, h, color); // 左
        bmp.fillRect(w - borderWidth, 0, borderWidth, h, color); // 右

        // 表示位置（スロットの画面座標に補正）
        sprite.x = windowInstance.x + rect.x + windowInstance.padding;
        sprite.y = windowInstance.y + rect.y + windowInstance.padding;

        sprite.visible = true;
    };





})();