/*
 * Copyright (c) 2013-2017 Chukong Technologies Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

//
// cocos2d ui constants
//
// This helper file should be required after jsb_cocos2d.js
//

var ccui = ccui || {};


cc.EditBox = ccui.EditBox;
delete ccui.EditBox;

/**
 * @constant
 * @type Number
 */
cc.KEYBOARD_RETURNTYPE_DEFAULT = 0;

/**
 * @constant
 * @type Number
 */
cc.KEYBOARD_RETURNTYPE_DONE = 1;

/**
 * @constant
 * @type Number
 */
cc.KEYBOARD_RETURNTYPE_SEND = 2;

/**
 * @constant
 * @type Number
 */
cc.KEYBOARD_RETURNTYPE_SEARCH = 3;

/**
 * @constant
 * @type Number
 */
cc.KEYBOARD_RETURNTYPE_GO = 4;

/**
 * The EditBox::InputMode defines the type of text that the user is allowed * to enter.
 * @constant
 * @type Number
 */
cc.EDITBOX_INPUT_MODE_ANY = 0;

/**
 * The user is allowed to enter an e-mail address.
 * @constant
 * @type Number
 */
cc.EDITBOX_INPUT_MODE_EMAILADDR = 1;

/**
 * The user is allowed to enter an integer value.
 * @constant
 * @type Number
 */
cc.EDITBOX_INPUT_MODE_NUMERIC = 2;

/**
 * The user is allowed to enter a phone number.
 * @constant
 * @type Number
 */
cc.EDITBOX_INPUT_MODE_PHONENUMBER = 3;

/**
 * The user is allowed to enter a URL.
 * @constant
 * @type Number
 */
cc.EDITBOX_INPUT_MODE_URL = 4;

/**
 * The user is allowed to enter a real number value.
 * This extends kEditBoxInputModeNumeric by allowing a decimal point.
 * @constant
 * @type Number
 */
cc.EDITBOX_INPUT_MODE_DECIMAL = 5;

/**
 * The user is allowed to enter any text, except for line breaks.
 * @constant
 * @type Number
 */
cc.EDITBOX_INPUT_MODE_SINGLELINE = 6;

/**
 * Indicates that the text entered is confidential data that should be
 * obscured whenever possible. This implies EDIT_BOX_INPUT_FLAG_SENSITIVE.
 * @constant
 * @type Number
 */
cc.EDITBOX_INPUT_FLAG_PASSWORD = 0;

/**
 * Indicates that the text entered is sensitive data that the
 * implementation must never store into a dictionary or table for use
 * in predictive, auto-completing, or other accelerated input schemes.
 * A credit card number is an example of sensitive data.
 * @constant
 * @type Number
 */
cc.EDITBOX_INPUT_FLAG_SENSITIVE = 1;

/**
 * This flag is a hint to the implementation that during text editing,
 * the initial letter of each word should be capitalized.
 * @constant
 * @type Number
 */
cc.EDITBOX_INPUT_FLAG_INITIAL_CAPS_WORD = 2;

/**
 * This flag is a hint to the implementation that during text editing,
 * the initial letter of each sentence should be capitalized.
 * @constant
 * @type Number
 */
cc.EDITBOX_INPUT_FLAG_INITIAL_CAPS_SENTENCE = 3;

/**
 * Capitalize all characters automatically.
 * @constant
 * @type Number
 */
cc.EDITBOX_INPUT_FLAG_INITIAL_CAPS_ALL_CHARACTERS = 4;

var _p = cc.EditBox.prototype;

_p._setMaxLength = _p.setMaxLength;
_p.setMaxLength = function(maxLength) {
    if (maxLength < 0) {
        maxLength = 65535;
    }
    this._setMaxLength(maxLength);
};
_p.setLineHeight = function () {};
_p.setTabIndex = function () {};
_p.getTabIndex = function () { return -1; };
_p.setFocus = function () {};
_p.isFocused = function () { return false; };
_p.stayOnTop = function () {};


cc.Scale9Sprite = ccui.Scale9Sprite;

// GUI
/**
 * @type {Object}
 * UI Helper
 */
ccui.helper = ccui.Helper;

// =====================Constants=====================

/*
 * UILayout
 */
//layoutBackGround color type
ccui.Layout.BG_COLOR_NONE = 0;
ccui.Layout.BG_COLOR_SOLID = 1;
ccui.Layout.BG_COLOR_GRADIENT = 2;

//Layout type
ccui.Layout.ABSOLUTE = 0;
ccui.Layout.LINEAR_VERTICAL = 1;
ccui.Layout.LINEAR_HORIZONTAL = 2;
ccui.Layout.RELATIVE = 3;

//Layout clipping type
ccui.Layout.CLIPPING_STENCIL = 0;
ccui.Layout.CLIPPING_SCISSOR = 1;

ccui.Layout.BACKGROUND_IMAGE_ZORDER = -1;
ccui.Layout.BACKGROUND_RENDERER_ZORDER = -2;

/*
 * UILayoutDefine
 */
//LinearGravity
//old
ccui.LINEAR_GRAVITY_NONE = 0;
ccui.LINEAR_GRAVITY_LEFT = 1;
ccui.LINEAR_GRAVITY_TOP = 2;
ccui.LINEAR_GRAVITY_RIGHT = 3;
ccui.LINEAR_GRAVITY_BOTTOM = 4;
ccui.LINEAR_GRAVITY_CENTER_VERTICAL = 5;
ccui.LINEAR_GRAVITY_CENTER_HORIZONTAL = 6;
//new
ccui.LinearLayoutParameter.NONE = 0;
ccui.LinearLayoutParameter.LEFT = 1;
ccui.LinearLayoutParameter.TOP = 2;
ccui.LinearLayoutParameter.RIGHT = 3;
ccui.LinearLayoutParameter.BOTTOM = 4;
ccui.LinearLayoutParameter.CENTER_VERTICAL = 5;
ccui.LinearLayoutParameter.CENTER_HORIZONTAL = 6;

//RelativeAlign
//old
ccui.RELATIVE_ALIGN_NONE = 0;
ccui.RELATIVE_ALIGN_PARENT_TOP_LEFT = 1;
ccui.RELATIVE_ALIGN_PARENT_TOP_CENTER_HORIZONTAL = 2;
ccui.RELATIVE_ALIGN_PARENT_TOP_RIGHT = 3;
ccui.RELATIVE_ALIGN_PARENT_LEFT_CENTER_VERTICAL = 4;
ccui.RELATIVE_ALIGN_PARENT_CENTER = 5;
ccui.RELATIVE_ALIGN_PARENT_RIGHT_CENTER_VERTICAL = 6;
ccui.RELATIVE_ALIGN_PARENT_LEFT_BOTTOM = 7;
ccui.RELATIVE_ALIGN_PARENT_BOTTOM_CENTER_HORIZONTAL = 8;
ccui.RELATIVE_ALIGN_PARENT_RIGHT_BOTTOM = 9;

ccui.RELATIVE_ALIGN_LOCATION_ABOVE_LEFT = 10;
ccui.RELATIVE_ALIGN_LOCATION_ABOVE_CENTER = 11;
ccui.RELATIVE_ALIGN_LOCATION_ABOVE_RIGHT = 12;

ccui.RELATIVE_ALIGN_LOCATION_LEFT_TOP = 13;
ccui.RELATIVE_ALIGN_LOCATION_LEFT_CENTER = 14;
ccui.RELATIVE_ALIGN_LOCATION_LEFT_BOTTOM = 15;

ccui.RELATIVE_ALIGN_LOCATION_RIGHT_TOP = 16;
ccui.RELATIVE_ALIGN_LOCATION_RIGHT_CENTER = 17;
ccui.RELATIVE_ALIGN_LOCATION_RIGHT_BOTTOM = 18;

ccui.RELATIVE_ALIGN_LOCATION_BELOW_TOP = 19;
ccui.RELATIVE_ALIGN_LOCATION_BELOW_CENTER = 20;
ccui.RELATIVE_ALIGN_LOCATION_BELOW_BOTTOM = 21;

//new
ccui.RelativeLayoutParameter.NONE = 0;
ccui.RelativeLayoutParameter.PARENT_TOP_LEFT = 1;
ccui.RelativeLayoutParameter.PARENT_TOP_CENTER_HORIZONTAL = 2;
ccui.RelativeLayoutParameter.PARENT_TOP_RIGHT = 3;
ccui.RelativeLayoutParameter.PARENT_LEFT_CENTER_VERTICAL = 4;

ccui.RelativeLayoutParameter.CENTER_IN_PARENT = 5;

ccui.RelativeLayoutParameter.PARENT_RIGHT_CENTER_VERTICAL = 6;
ccui.RelativeLayoutParameter.PARENT_LEFT_BOTTOM = 7;
ccui.RelativeLayoutParameter.PARENT_BOTTOM_CENTER_HORIZONTAL = 8;
ccui.RelativeLayoutParameter.PARENT_RIGHT_BOTTOM = 9;

ccui.RelativeLayoutParameter.LOCATION_ABOVE_LEFTALIGN = 10;
ccui.RelativeLayoutParameter.LOCATION_ABOVE_CENTER = 11;
ccui.RelativeLayoutParameter.LOCATION_ABOVE_RIGHTALIGN = 12;
ccui.RelativeLayoutParameter.LOCATION_LEFT_OF_TOPALIGN = 13;
ccui.RelativeLayoutParameter.LOCATION_LEFT_OF_CENTER = 14;
ccui.RelativeLayoutParameter.LOCATION_LEFT_OF_BOTTOMALIGN = 15;
ccui.RelativeLayoutParameter.LOCATION_RIGHT_OF_TOPALIGN = 16;
ccui.RelativeLayoutParameter.LOCATION_RIGHT_OF_CENTER = 17;
ccui.RelativeLayoutParameter.LOCATION_RIGHT_OF_BOTTOMALIGN = 18;
ccui.RelativeLayoutParameter.LOCATION_BELOW_LEFTALIGN = 19;
ccui.RelativeLayoutParameter.LOCATION_BELOW_CENTER = 20;
ccui.RelativeLayoutParameter.LOCATION_BELOW_RIGHTALIGN = 21;

/*
 * LayoutParameter
 */
//layout parameter type
ccui.LayoutParameter.NONE = 0;
ccui.LayoutParameter.LINEAR = 1;
ccui.LayoutParameter.RELATIVE = 2;

//LayoutComponent
ccui.LayoutComponent.horizontalEdge = {};
ccui.LayoutComponent.horizontalEdge.NONE = 0;
ccui.LayoutComponent.horizontalEdge.LEFT = 1;
ccui.LayoutComponent.horizontalEdge.RIGHT = 2;
ccui.LayoutComponent.horizontalEdge.CENTER = 3;

ccui.LayoutComponent.verticalEdge = {};
ccui.LayoutComponent.verticalEdge.NONE = 0;
ccui.LayoutComponent.verticalEdge.BOTTOM = 1;
ccui.LayoutComponent.verticalEdge.TOP = 2;
ccui.LayoutComponent.verticalEdge.CENTER = 3;
/*
 * UIWidget
 */
//bright style
ccui.Widget.BRIGHT_STYLE_NONE = -1;
ccui.Widget.BRIGHT_STYLE_NORMAL = 0;
ccui.Widget.BRIGHT_STYLE_HIGH_LIGHT = 1;

//widget type
ccui.Widget.TYPE_WIDGET = 0;
ccui.Widget.TYPE_CONTAINER = 1;

//texture resource type
ccui.Widget.LOCAL_TEXTURE = 0;
ccui.Widget.PLIST_TEXTURE = 1;

//touch event type
ccui.Widget.TOUCH_BEGAN = 0;
ccui.Widget.TOUCH_MOVED = 1;
ccui.Widget.TOUCH_ENDED = 2;
ccui.Widget.TOUCH_CANCELED = 3;

//size type
ccui.Widget.SIZE_ABSOLUTE = 0;
ccui.Widget.SIZE_PERCENT = 1;

//position type
ccui.Widget.POSITION_ABSOLUTE = 0;
ccui.Widget.POSITION_PERCENT = 1;

//focus direction
ccui.Widget.LEFT = 0;
ccui.Widget.RIGHT = 1;
ccui.Widget.UP = 2;
ccui.Widget.DOWN = 3;

/*
 * UIListView
 */
//listView event type
ccui.ListView.EVENT_SELECTED_ITEM = 0;
ccui.ListView.ON_SELECTED_ITEM_START = 0;
ccui.ListView.ON_SELECTED_ITEM_END = 1;

//listView gravity
ccui.ListView.GRAVITY_LEFT = 0;
ccui.ListView.GRAVITY_RIGHT = 1;
ccui.ListView.GRAVITY_CENTER_HORIZONTAL = 2;
ccui.ListView.GRAVITY_TOP = 3;
ccui.ListView.GRAVITY_BOTTOM = 4;
ccui.ListView.GRAVITY_CENTER_VERTICAL = 5;

//list view magnetic type
ccui.ListView.MAGNETIC_NONE = 0;
ccui.ListView.MAGNETIC_CENTER = 1;
ccui.ListView.MAGNETIC_BOTH_END = 2;
ccui.ListView.MAGNETIC_LEFT = 3;
ccui.ListView.MAGNETIC_RIGHT = 4;
ccui.ListView.MAGNETIC_TOP = 5;
ccui.ListView.MAGNETIC_BOTTOM = 6;

/*
 * UIScrollView
 */
//ScrollView direction
ccui.ScrollView.DIR_NONE = 0;
ccui.ScrollView.DIR_VERTICAL = 1;
ccui.ScrollView.DIR_HORIZONTAL = 2;
ccui.ScrollView.DIR_BOTH = 3;

//ScrollView event
ccui.ScrollView.EVENT_SCROLL_TO_TOP = 0;
ccui.ScrollView.EVENT_SCROLL_TO_BOTTOM = 1;
ccui.ScrollView.EVENT_SCROLL_TO_LEFT = 2;
ccui.ScrollView.EVENT_SCROLL_TO_RIGHT = 3;
ccui.ScrollView.EVENT_SCROLLING = 4;
ccui.ScrollView.EVENT_BOUNCE_TOP = 5;
ccui.ScrollView.EVENT_BOUNCE_BOTTOM = 6;
ccui.ScrollView.EVENT_BOUNCE_LEFT = 7;
ccui.ScrollView.EVENT_BOUNCE_RIGHT = 8;
ccui.ScrollView.EVENT_CONTAINER_MOVED = 9;
ccui.ScrollView.EVENT_AUTOSCROLL_ENDED = 10;

ccui.ScrollView.MOVEDIR_TOP = 0;
ccui.ScrollView.MOVEDIR_BOTTOM = 1;
ccui.ScrollView.MOVEDIR_LEFT = 2;
ccui.ScrollView.MOVEDIR_RIGHT = 3;

/*
 * UIPageView
 */
//PageView event
ccui.PageView.EVENT_TURNING = 0;

//PageView touch direction
ccui.PageView.TOUCH_DIR_LEFT = 0;
ccui.PageView.TOUCH_DIR_RIGHT = 1;
ccui.PageView.TOUCH_DIR_UP = 2;
ccui.PageView.TOUCH_DIR_DOWN = 3;

//PageView direction
ccui.PageView.DIRECTION_LEFT = 0;
ccui.PageView.DIRECTION_RIGHT = 1;

/*
 * UIButton
 */
ccui.NORMAL_RENDERER_ZORDER = -2;
ccui.PRESSED_RENDERER_ZORDER = -2;
ccui.DISABLED_RENDERER_ZORDER = -2;
ccui.TITLE_RENDERER_ZORDER = -1;

ccui.Scale9Sprite.POSITIONS_CENTRE = 0;                //CCScale9Sprite.js
ccui.Scale9Sprite.POSITIONS_TOP = 1;
ccui.Scale9Sprite.POSITIONS_LEFT = 2;
ccui.Scale9Sprite.POSITIONS_RIGHT = 3;
ccui.Scale9Sprite.POSITIONS_BOTTOM = 4;
ccui.Scale9Sprite.POSITIONS_TOPRIGHT = 5;
ccui.Scale9Sprite.POSITIONS_TOPLEFT = 6;
ccui.Scale9Sprite.POSITIONS_BOTTOMRIGHT = 7;
ccui.Scale9Sprite.POSITIONS_BOTTOMLEFT = 8;

/*
 * UICheckBox
 */
//CheckBoxEvent type
ccui.CheckBox.EVENT_SELECTED = 0;
ccui.CheckBox.EVENT_UNSELECTED = 1;

//Render zorder
ccui.CheckBox.BOX_RENDERER_ZORDER = -1;
ccui.CheckBox.BOX_SELECTED_RENDERER_ZORDER = -1;
ccui.CheckBox.BOX_DISABLED_RENDERER_ZORDER = -1;
ccui.CheckBox.FRONT_CROSS_RENDERER_ZORDER = -1;
ccui.CheckBox.FRONT_CROSS_DISABLED_RENDERER_ZORDER = -1;

/*
 * UIImageView
 */
ccui.ImageView.RENDERER_ZORDER = -1;

/*
 * UILoadingBar
 */
//loadingBar Type
ccui.LoadingBar.TYPE_LEFT = 0;
ccui.LoadingBar.TYPE_RIGHT = 1;

ccui.LoadingBar.RENDERER_ZORDER = -1;

/*
 * UIRichElement
 */
//Rich element type
//ccui.RichElement.TYPE_TEXT = 0;
//ccui.RichElement.TYPE_IMAGE = 1;
//ccui.RichElement.TYPE_CUSTOM = 2;

/*
 * UISlider
 */
//Slider event type
ccui.Slider.EVENT_PERCENT_CHANGED = 0;
ccui.Slider.EVENT_SLIDEBALL_DOWN = 1;
ccui.Slider.EVENT_SLIDEBALL_UP = 2;
ccui.Slider.EVENT_SLIDEBALL_CANCEL = 3;

//Render zorder
ccui.Slider.BASEBAR_RENDERER_ZORDER = -3;
ccui.Slider.PROGRESSBAR_RENDERER_ZORDER = -2;
ccui.Slider.BALL_RENDERER_ZORDER = -1;

/*
 * UIText
 */
ccui.Text.RENDERER_ZORDER = -1;

/*
 * UITextAtlas
 */
ccui.TextAtlas.RENDERER_ZORDER = -1;

/*
 * UITextBMFont
 */
ccui.TextBMFont.RENDERER_ZORDER = -1;

/*
 * UITextField
 */
//TextField event
ccui.TextField.EVENT_ATTACH_WITH_IME = 0;
ccui.TextField.EVENT_DETACH_WITH_IME = 1;
ccui.TextField.EVENT_INSERT_TEXT = 2;
ccui.TextField.EVENT_DELETE_BACKWARD = 3;

ccui.TextField.RENDERER_ZORDER = -1;

/*
 * UIRadioButton
 */
ccui.RadioButton.EVENT_SELECTED = 0;
ccui.RadioButton.EVENT_UNSELECTED = 1;
ccui.RadioButtonGroup.EVENT_SELECT_CHANGED = 0;

/*
 * UIMargin
 */
ccui.Margin = cc.Class.extend({
    left: 0,
    top: 0,
    right: 0,
    bottom: 0,
    ctor: function () {
        if (arguments.length == 1) {
            var uiMargin = arguments[0];
            this.left = uiMargin.left;
            this.top = uiMargin.top;
            this.right = uiMargin.right;
            this.bottom = uiMargin.bottom;
        }
        if (arguments.length == 4) {
            this.left = arguments[0];
            this.top = arguments[1];
            this.right = arguments[2];
            this.bottom = arguments[3];
        }
    },
    setMargin: function (l, t, r, b) {
        this.left = l;
        this.top = t;
        this.right = r;
        this.bottom = b;
    },
    equals: function (target) {
        return (this.left == target.left && this.top == target.top && this.right == target.right && this.bottom == target.bottom);
    }
});

ccui.MarginZero = function(){
    return new ccui.Margin(0,0,0,0);
};

// updateWithBatchNode deprecated in JSB
ccui.Scale9Sprite.prototype.updateWithBatchNode = function (batchNode, originalRect, rotated, capInsets) {
    var sprite = new cc.Sprite(batchNode.getTexture());
    this.updateWithSprite(sprite, originalRect, rotated, cc.p(0, 0), cc.size(originalRect.width, originalRect.height), capInsets);
};


if (ccui.WebView)
{
    /**
     * The WebView support list of events
     * @type {{LOADING: string, LOADED: string, ERROR: string}}
     */
    ccui.WebView.EventType = {
        LOADING: "loading",
        LOADED: "load",
        ERROR: "error",
        JS_EVALUATED: "js"
    };

    ccui.WebView.prototype._loadURL = ccui.WebView.prototype.loadURL;
    ccui.WebView.prototype.loadURL = function (url) {
        if (url.indexOf("http://") >= 0)
        {
            this._loadURL(url);
        }
        else
        {
            this.loadFile(url);
        }
    };

    ccui.WebView.prototype.setEventListener = function(event, callback){
        switch(event)
        {
            case ccui.WebView.EventType.LOADING:
                this.setOnShouldStartLoading(callback);
                break;
            case ccui.WebView.EventType.LOADED:
                this.setOnDidFinishLoading(callback);
                break;
            case ccui.WebView.EventType.ERROR:
                this.setOnDidFailLoading(callback);
                break;
            case ccui.WebView.EventType.JS_EVALUATED:
                //this.setOnJSCallback(callback);
                cc.log("unsupport web event:" + event);
                break;
            default:
                cc.log("unsupport web event:" + event);
                break;
        }
    };
}
if (ccui.VideoPlayer)
{
    /**
     * The VideoPlayer support list of events
     * @type {{PLAYING: string, PAUSED: string, STOPPED: string, COMPLETED: string}}
     */
    ccui.VideoPlayer.EventType = {
        PLAYING: "play",
        PAUSED: "pause",
        STOPPED: "stop",
        COMPLETED: "complete"
    };

    ccui.VideoPlayer.prototype._setURL = ccui.VideoPlayer.prototype.setURL;
    ccui.VideoPlayer.prototype.setURL = function (url) {
        if (url.indexOf("http://") >= 0)
        {
            this._setURL(url);
        }
        else
        {
            this.setFileName(url);
        }
    };

    ccui.VideoPlayer.prototype.setEventListener = function(event, callback){
        if (!this.videoPlayerCallback)
        {
            this.videoPlayerCallback = function(sender, eventType){
                cc.log("videoEventCallback eventType:" + eventType);
                switch (eventType) {
                    case 0:
                        this["VideoPlayer_"+ccui.VideoPlayer.EventType.PLAYING] && this["VideoPlayer_"+ccui.VideoPlayer.EventType.PLAYING](sender);
                        break;
                    case 1:
                        this["VideoPlayer_"+ccui.VideoPlayer.EventType.PAUSED] && this["VideoPlayer_"+ccui.VideoPlayer.EventType.PAUSED](sender);
                        break;
                    case 2:
                        this["VideoPlayer_"+ccui.VideoPlayer.EventType.STOPPED] && this["VideoPlayer_"+ccui.VideoPlayer.EventType.STOPPED](sender);
                        break;
                    case 3:
                        this["VideoPlayer_"+ccui.VideoPlayer.EventType.COMPLETED] && this["VideoPlayer_"+ccui.VideoPlayer.EventType.COMPLETED](sender);
                        break;
                    default:
                        break;
                }
            };
            this.addEventListener(this.videoPlayerCallback);
        }
        this["VideoPlayer_"+event] = callback;
    };
}
/*
 * UIWidget temporary solution to addChild
 * addNode and addChild function should be merged in ccui.Widget
 */
ccui.Widget.prototype.addNode = ccui.Widget.prototype.addChild;
ccui.Widget.prototype.getSize = ccui.Widget.prototype.getContentSize;
ccui.Widget.prototype.setSize = ccui.Widget.prototype.setContentSize;

/*
 * UIWidget's event listeners wrapper
 */
ccui.Widget.prototype._addTouchEventListener = ccui.Widget.prototype.addTouchEventListener;
ccui.Widget.prototype.addTouchEventListener = function (selector, target) {
    if (target === undefined)
        this._addTouchEventListener(selector);
    else
        this._addTouchEventListener(selector.bind(target));
};

function _ui_addEventListener(selector, target) {
    if (target === undefined)
        this._addEventListener(selector);
    else
        this._addEventListener(selector.bind(target));
}
function _ui_applyEventListener(ctor) {
    var proto = ctor.prototype;
    proto._addEventListener = proto.addEventListener;
    proto.addEventListener = _ui_addEventListener;
}

_ui_applyEventListener(ccui.CheckBox);
_ui_applyEventListener(ccui.Slider);
_ui_applyEventListener(ccui.TextField);
_ui_applyEventListener(ccui.PageView);
_ui_applyEventListener(ccui.ScrollView);
_ui_applyEventListener(ccui.ListView);
